<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_characteristics extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->modal_name = "characteristics_model";
		$this->load->model($this->modal_name);
		$this->page ='admin/manage_characteristics/';
		$this->current_url = base_url()."admin/manage_characteristics/";
		$this->table_id = "tblmng_characteristics";
	}
	
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}

	public function index()
	{
		$this->grid_resorces();
		$text = "Manage Characterisitcs";
		$this->output->set_title(lang($text));
		$this->page_name = lang($text);
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->data['tbl_id']		=	$this->table_id;
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_characteristics();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$array = array('edit'=>$editurl,'delete'=>$deleteurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		$this->datatables->select('c.id,c.name,cg.char_group_name,c.image,c.status',false)
		->join('characteristics_group as cg','cg.id = c.group_id')
		->edit_column('status', '$1', 'get_status(status,id,"")')
		->edit_column('image', '$1', 'display_image(id,image,"characteristics",null,100,type)') 
		->add_column('operation',get_operation_btn('$1',$array),'id')			
		->from('characteristics as c');
		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}

	public function add()
	{
		$data = array();
		if($this->input->post())
		{	
			$name_post = $this->input->post('name');
			$group_id = $this->input->post('group_id');
			$exist_check = $this->{$this->modal_name}->get_by("name",$name_post);
			if(!empty($exist_check))
			{
				$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
				redirect($this->current_url."add");	
			}
			else{
				$data = array(
					'name' => $name_post,
					'group_id' => $group_id
					);
				$insert_id = $this->{$this->modal_name}->insert($data);
				if(is_numeric($insert_id) && $insert_id > 0)
				{
					$this->session->set_flashdata('success',lang(MSG_REC_ADD));
					redirect($this->current_url);				
				}else{
					$msg = (isset($insert_id["msg"]) && is_array($insert_id)) ? $insert_id["msg"] : validation_errors();
					$this->session->set_flashdata('error',$msg);
					redirect($this->current_url."add");	
				}
			}
		}
		if(!$this->input->post())
		{
			$this->load->helper(array('url','language'));
			$this->load->js("plugins/ckeditor/ckeditor.js");
			$this->page_type = 'add';
			$text = "Add Characteristics";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."add";
			$this->load->model("characteristics_groups_model");
			$this->data["groups"] = $this->characteristics_groups_model->get_many_by('status','y');
			$this->view = $this->page."add_edit";
		}
	}


	public function edit($id=NULL){
		if($id != NULL && $id > 0){
			$data = array();
			if($this->input->post())
			{
				$name_post = $this->input->post('name');
				$group_id = $this->input->post('group_id');
				
				$where_ar[] = array("name = '".$name_post."' AND id != '".$id."'",null,null);
				$exist_check = $this->{$this->modal_name}->get_by($where_ar);
				if(!empty($exist_check))
				{
					$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
					redirect($this->current_url."edit/".$id);	
				}
				else{
					$data = array(
						'name' => $name_post,
						'group_id' => $group_id,
						'id'=>$id
						);
					if(!empty($data))
					{
						$update_status = $this->{$this->modal_name}->update($id,$data);
						if(!empty($update_status)) 
						{
							$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
							redirect($this->current_url,"refresh");
						}else{
							$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));
							redirect($this->current_url.'edit/'.$id,"refresh");
						}
					}
				}
			}
			else if(!$this->input->post()){
				$this->data["characteristics_data"] = $this->{$this->modal_name}->as_array()->get($id);
				if($this->data["characteristics_data"])
				{
					$text = "Edit Characteristics - ".$this->data["characteristics_data"]["name"];
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->data["form_url"] = $this->current_url.'edit/'.$id;	
					$this->load->model("characteristics_groups_model");
					$this->data["groups"] = $this->characteristics_groups_model->get_many_by('status','y');
					$this->data["group_id"] = $this->data["characteristics_data"]["group_id"];

					$exist_check_path = FCPATH."assets/upload/characteristics/".$this->data["characteristics_data"]["image"];			
					if(file_exists($exist_check_path) && $exist_check_path!=""){
						$this->data["image_url"] = base_url()."assets/upload/characteristics/".$this->data["characteristics_data"]["image"];
					}
					else{
						$this->data["image_url"] = base_url()."assets/images/no_available_image.gif";
					}
					$this->data["action"] = "edit";
					$this->view = $this->page."add_edit";
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}


	

	public function change_status()
	{

		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$characteristic_id = $this->input->post('characteristic_id');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			if($characteristic_id > 0){
				$this->status_data = $this->{$this->modal_name}->set_fields("id,status")->as_array()->get($characteristic_id);
				if(!empty($this->status_data))
				{
					if($this->status_data['status'] == 'n'){
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$response = $this->{$this->modal_name}->update($characteristic_id,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}
		}
	}

	public function delete($id){
		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->{$this->modal_name}->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = $this->table_id;
			}
		}
	}
}
