<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_cars extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->modal_name = "cars_model";
		$this->load->model($this->modal_name);
		$this->page ='admin/manage_cars/';
		$this->current_url = base_url()."admin/manage_cars/";
		$this->table_id = "tblmng_cars";
	}
	
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}

	public function index()
	{
		$this->grid_resorces();
		$text = "Manage Cars";
		$this->output->set_title(lang($text));
		$this->page_name = lang($text);
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->data['tbl_id']		=	$this->table_id;
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_cars();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$array = array('edit'=>$editurl,'delete'=>$deleteurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');		
		$this->datatables->select('c.id,c.name,c.image,cg.group_name,cat.category,c.quantity,c.status',false)
		->join('car_groups as cg','cg.id = c.groupId')
		->join('categories as cat','cat.id = c.categoryId')
		->edit_column('status', '$1', 'get_status(status,id,"")')
		->edit_column('image', '$1', 'display_image(id,image,"cars",null,100,type)') 
		->add_column('operation',get_operation_btn('$1',$array),'id')			
		->from('cars as c');
		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}

	public function add()
	{

		$data = array();
		if($this->input->post())
		{

			$name_post = $this->input->post('name');
			$groupId = $this->input->post('groupId');
			$categoryId = $this->input->post('categoryId');
			$biggerId = $this->input->post('biggerId');
			$quantity = $this->input->post('quantity');
			$description = $this->input->post('description');
			

			$where_ar = array("name"=>$name_post,'groupId'=>$groupId,'categoryId'=>$categoryId);
			$exist_check = $this->{$this->modal_name}->get_by($where_ar);
			if(!empty($exist_check))
			{
				$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
				redirect($this->current_url."add");	
			}
			else{
				$data = array(
					'name' => $name_post,
					'groupId' => $groupId,
					'categoryId' => $categoryId,
					'biggerId' => $biggerId,
					'quantity' => $quantity,
					'description' => $description
					);
				$status = $this->{$this->modal_name}->insert($data);
				/*printr($status);
				exit();*/
				if($status)
				{
					$this->session->set_flashdata('success',lang(MSG_REC_ADD));
					redirect($this->current_url);				
				}else{
					$this->session->set_flashdata('error',lang(validation_errors()));
					redirect($this->current_url."add");	
				}
			}
		}
		if(!$this->input->post())
		{
			$this->load->helper(array('url','language'));
			$this->load->js("plugins/ckeditor/ckeditor.js");
			$this->load->model("car_groups_model");
			/*$this->load->model("categories_model");*/
			$this->load->model("car_facilities_model");
			$this->load->model("characteristics_model");
			$this->load->model("locations_model");
			$this->page_type = 'add';
			$text = "Add Car";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."add";
			$this->data["groups"] = $this->car_groups_model->get_many_by('status','y');
			$this->data["categories"] = array();
			$this->data["facilities"] = $this->car_facilities_model->get_many_by('status','y');
			$this->data["characteristics"] = $this->characteristics_model->get_many_by('status','y');
			$this->data["pickup_location"] = $this->locations_model->get_many_by('status','y');
			$this->data["cars"] = $this->cars_model->get_many_by('status','y');

			$this->load->start_inline_scripting();
			echo "Appad.init_common_methods();";
			$this->load->end_inline_scripting(false,false);
			
			$this->view = $this->page."add_edit";
		}
	}


	public function edit($id=NULL){
		if($id != NULL && $id > 0){
			$data = array();
			$animeties_array = array("db_sel_facilities","db_sel_characteristics","db_sel_pickuplocation");
			$this->data["car_data"] = $this->{$this->modal_name}->as_array()->get($id);

			if(!empty($animeties_array))
			{
				foreach ($animeties_array as $key => $value) 
				{
					if(!empty($this->data["car_data"][$value]))
					{
						$this->data["car_data"][$value."_ids"] = array();
						foreach ($this->data["car_data"][$value] as $key => $value1) 
						{
							$this->data["car_data"][$value."_ids"][] = $value1["id"];
						}
						unset($this->data["car_data"][$value]);
					}	
				}
			}

			if($this->input->post())
			{
				$name_post = $this->input->post('name');
				$groupId = $this->input->post('groupId');
				$categoryId = $this->input->post('categoryId');
				$quantity = $this->input->post('quantity');
				$description = $this->input->post('description');
				$biggerId = $this->input->post('biggerId');
				$where_ar[] = array("name = '".$name_post."' AND groupId ='".$groupId."' AND categoryId = '".$categoryId."' AND id != '".$id."'",null,null);
				$exist_check = $this->{$this->modal_name}->get_by($where_ar);
				if(!empty($exist_check))
				{
					$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
					redirect($this->current_url."edit/".$id);	
				}
				else{					
					$data = array(
						'name' => $name_post,
						'groupId' => $groupId,
						'categoryId' => $categoryId,
						'biggerId' => $biggerId,
						'quantity' => $quantity,
						'description' => $description,
						'db_sel_facilities' => $this->data["car_data"]["db_sel_facilities_ids"],
						'db_sel_characteristics' => $this->data["car_data"]["db_sel_characteristics_ids"],
						'db_sel_pickuplocation' => $this->data["car_data"]["db_sel_pickuplocation_ids"],
						'id'=>$id
						);

					if(!empty($data))
					{
						$update_status = $this->{$this->modal_name}->update($id,$data);
						
						if(!empty($update_status)) 
						{
							$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
							redirect($this->current_url,"refresh");
						}else{
							$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));
							redirect($this->current_url.'edit/'.$id,"refresh");
						}
					}
				}
			}
			else if(!$this->input->post()){
				$this->load->model("insurance_group_model");
				$this->load->helper(array('url','language'));
				$this->load->js("plugins/ckeditor/ckeditor.js");
				$this->load->model("car_groups_model");
				$this->load->model("car_facilities_model");
				$this->load->model("characteristics_model");
				$this->load->model("locations_model");
				$this->load->model("categories_model");
				
				if($this->data["car_data"])
				{
					$text = "Edit Car - ".$this->data["car_data"]["name"];
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->data["form_url"] = $this->current_url.'edit/'.$id;	
					$this->data["facilities"] = $this->car_facilities_model->set_fields("id,facility_name")->get_many_by('status','y');
					$this->data["characteristics"] = $this->characteristics_model->set_fields("id,name,group_id")->get_many_by('status','y');
					$this->data["pickup_location"] = $this->locations_model->set_fields("id,location_name")->get_many_by('status','y');
					$this->data["groups"] = $this->car_groups_model->set_fields("id,group_name")->get_many_by('status','y');
					$where_cat_ar = array('status'=>'y','groupId'=>$this->data["car_data"]["groupId"]);
					$this->data["categories"] = $this->categories_model->set_fields("id,category")->get_many_by($where_cat_ar);

					$path = 'assets/upload/cars/'.$id.'/'.$this->data["car_data"]["image"];
					if(!file_exists(FCPATH.$path) && $path!="")
					{
						$this->data["image_url"]  = base_url()."assets/images/no_available_image.gif"; 
					}
					else{
						$this->data["image_url"] = base_url().$path; 
					}	
					$this->data["cars"] = $this->cars_model->get_many_by('status','y');
					$this->load->start_inline_scripting();
					echo "Appad.init_common_methods();";
					$this->load->end_inline_scripting(false,false);
					$this->data["action"] = "edit";
					$this->view = $this->page."add_edit";
					/*printr($this->data);
					exit();*/
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}


	public function change_status()
	{
		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$car_id = $this->input->post('car_id');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			if($car_id > 0){
				$this->status_data = $this->{$this->modal_name}->set_fields("id,status")->as_array()->get($car_id);
				if(!empty($this->status_data))
				{
					if($this->status_data['status'] == 'n'){
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$response = $this->{$this->modal_name}->update($car_id,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}
		}
	}

	public function delete($id){

		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->{$this->modal_name}->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = $this->table_id;
			}
		}
	}
}
