<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once(FCPATH."application/controllers/booking.php");
class Manage_booking extends booking
{
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		$this->from_admin = "true";
		parent::__construct();
		$this->_init();		
		$this->page ='admin/manage_booking/';
		$this->current_url = base_url()."admin/manage_booking/";
	}

	private function _init()
	{
		$admin  =   $this->session->userdata(ADMIN_SESS_NM);
		if(!isset($admin) || empty($admin))
		{
			$this->session->set_flashdata("error",lang("INVALID_REQUEST"));
			redirect(base_url()."admin");
			exit();
		}
		
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';
		$this->load->model("bookings_model");
		$this->load->model("locations_model");
		$this->load->model("categories_model");
	}
	public function index()
	{	
		$this->load->js('js/components-date-time-pickers.js');
		
		$this->grid_resorces();
		$this->page_name = lang("Manage Booking");
		$this->output->set_title(lang("Manage Booking"));
		$this->load->js('plugins/datatables/jquery.dataTables.min.js');
		$this->data['page_url']	=	'manage_booking';
		$this->data['tbl_id']		=	'tblmng_booking';
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_boooking_list();";
		$this->load->end_inline_scripting(false,false);
		
		$this->data["categories"] = $this->categories_model->get_many_by('status','y');

		$this->locations_model->after_get_allow = false;
		$this->data["locations"] = $this->locations_model->get_many_by('status','y');
		$this->locations_model->after_get_allow = true;
		
		$this->data["booking_page"] = true;
		$this->data["export_button_href"] = base_url()."admin/manage_booking/export_booking_details";

		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$sendurl = $this->current_url."send";
		$cancelurl = $this->current_url."cancel";
		
		$array = array('edit'=>$editurl,'delete'=>$deleteurl,"send"=>$sendurl,"cancel"=>$cancelurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');		
		$this->datatables->select('b.id,b.booking_no,IF(b.refferal_id > 0,rl.name,"N/A") as refferal_id,IF(b.firstname IS NOT NULL,concat(b.firstName," ",b.lastName),concat(u.firstName," ",u.lastName)) as firstname,b.address,c.name,p.location_name as pickup_location_name,d.location_name as dropoff_location_name,b.pickup_date,b.dropoff_date,b.booking_date,b.booking_status,b.booking_price,api_reservation_id,pickup_time,dropoff_time',false)
		->join('users as u','u.id = b.user_id')
		->join('cars as c','c.id = b.car_id')
		->join('locations as p','p.id = b.pickup_location')
		->join('locations as d','d.id = b.dropoff_location')
		->join('refferal_list as rl','rl.id = b.refferal_id','left')
		->edit_column('address', '$1', 'get_booking_address(address)')
		->edit_column('pickup_date', '$1', 'get_booking_datetime(pickup_date,pickup_time)')
		->edit_column('dropoff_date', '$1', 'get_booking_datetime(dropoff_date,dropoff_time)')
		->edit_column('booking_status', '$1', 'get_booking_status(booking_status,id,"")')
		->edit_column('refferal_id', '$1', 'get_refferal_name(refferal_id)')
		->add_column('operation',get_operation_btn('$1',$array,null,null,null,null,'$2'),'id,api_reservation_id')	
		->unset_column("api_reservation_id")
		->unset_column("pickup_time")
		->unset_column("dropoff_time")
		->from('bookings as b');
		$minDate = $this->input->get("min_date");
		$max_date = $this->input->get("max_date");
		$pickup_location = $this->input->get("pickup_location");
		$category = $this->input->get("category");
		if($minDate != NULL && $max_date != NULL){
			$this->datatables->where('b.pickup_date >=', $minDate);
			$this->datatables->where('b.pickup_date <=', $max_date);
		}elseif($minDate != NULL && $max_date == NULL){
			$this->datatables->where('b.pickup_date >=', $minDate);
		}elseif($minDate == NULL && $max_date != NULL){
			$this->datatables->where('b.pickup_date <=', $max_date);
		}
		if($pickup_location > 0){
			$this->datatables->where('b.pickup_location =', $pickup_location);
		}
		if($category > 0){
			$this->datatables->where('b.car_category =', $category);
		}	
		$this->load->start_inline_scripting();
		echo "Appad.init_booking_operation();";
		$this->load->end_inline_scripting(false,false);
		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}
	
	public function add()
	{	
		$this->load->css("plugins/icheck/skins/line/red.css");	
		$this->load->js("plugins/intl-tel-input-master/build/js/intlTelInput.js");
		$this->load->css("plugins/intl-tel-input-master/build/css/intlTelInput.css");
		$this->load->js('plugins/bootstrap-editable/bootstrap-editable/js/bootstrap-editable.js');
		$this->load->css('plugins/bootstrap-editable/bootstrap-editable/css/bootstrap-editable.css');

		$this->load->helper(array('url','language'));
		$this->load->js("plugins/ckeditor/ckeditor.js");
		$this->page_type = 'add';
		$this->page_name = lang("Add Booking");
		$this->output->set_title(lang("Add Booking"));
		$this->data['countries'] =	$this->countries_model->get_many_by('status','y');
		$this->locations_model->after_get_allow = false;
		$this->data['locations'] =	$this->locations_model->get_many_by('status','y');
		$this->locations_model->after_get_allow = true;
		$this->data['page_url']				=	'manage_contents/add';
		$this->data['form_url']	= $this->current_url.'booking_confirm';	
		$this->data["dispAllfield"] = true;
		$this->data["type"] = "add";

		$this->load->start_inline_scripting();
		echo "Appad.init_booking_operation();";
		$this->load->end_inline_scripting(false,false);
		
		$this->view = $this->page."add_edit";		
	}

	public function edit($id)
	{
		$where = array('id'=>$id);
		$this->bookings_model->after_get_user_info_allow = true;
		$booking_data = $this->bookings_model->get_by($where);
		$this->bookings_model->after_get_user_info_allow = false;	

		if(!empty($booking_data))
		{
			$this->load->css("plugins/icheck/skins/line/red.css");	
			$this->load->js("plugins/intl-tel-input-master/build/js/intlTelInput.js");
			$this->load->css("plugins/intl-tel-input-master/build/css/intlTelInput.css");
			$this->load->js('plugins/bootstrap-editable/bootstrap-editable/js/bootstrap-editable.js');
			$this->load->css('plugins/bootstrap-editable/bootstrap-editable/css/bootstrap-editable.css');
			
			/*$car_data = $this->cars_model->get($booking_data["car_id"]);*/
			$car_data = $booking_data["car_info"];
			$this->load->start_inline_scripting();
			echo "Appad.init_booking_operation();";
			$this->load->end_inline_scripting(false,false);
			$facility_post = array();
			if(!empty($booking_data["booking_selected_facilities"]))
			{
				foreach ($booking_data["booking_selected_facilities"] as $key => $value) 
				{
					if($value > 0)
					{
						$facility_post[] = $key;	
					}
				}
			}

			$this->data["formurl"] = base_url().'admin/manage_booking/booking_confirm/'.$car_data["id"];
			$this->data["pickup_location"] = $booking_data["pickup_location"];
			$this->data["dropoff_location"] = $booking_data["dropoff_location"];
			$pickup_location_ar = $this->locations_model->get($booking_data["pickup_location"]);
			$dropoff_location_ar = $this->locations_model->get($booking_data["dropoff_location"]);
			$this->data["pickup_location_nm"] = $pickup_location_ar["location_name"];
			$this->data["dropoff_location_nm"] = $dropoff_location_ar["location_name"];
			$this->data["pickup_date"] = $booking_data["pickup_date"];
			$this->data["dropoff_date"] = $booking_data["dropoff_date"];
			$this->data["pickup_time"] = $booking_data["pickup_time"];
			$this->data["dropoff_time"] = $booking_data["dropoff_time"];
			$this->data["car_data"] = $car_data;
			$this->data["booking_data"] = $booking_data;
			
			/*$start_date = $booking_data["pickup_date"]." ".$booking_data["pickup_time"].":00";
			$end_date = $booking_data["dropoff_date"]." ".$booking_data["dropoff_time"].":00";*/

			$pickup_time_ar = explode(":",$booking_data["pickup_time"]);
			$start_date = (count($pickup_time_ar) == 3) ? $booking_data["pickup_date"]." ".$booking_data["pickup_time"] : $booking_data["pickup_date"]." ".$booking_data["pickup_time"].":00";

			$dropoff_time_ar = explode(":",$booking_data["dropoff_time"]);	
			$end_date = (count($dropoff_time_ar) == 3) ? $booking_data["dropoff_date"]." ".$booking_data["dropoff_time"] : $booking_data["dropoff_date"]." ".$booking_data["dropoff_time"].":00";

			$booking_days =  date_difference($start_date,$end_date);
			$this->data["insuranceGroupId"] = ($booking_data["insurance"] > 0) ? $booking_data["insurance"] : 0;
			$this->data["booking_selected_facilities"] = (!empty($booking_data["booking_selected_facilities"])) ? $booking_data["booking_selected_facilities"] : '';
			$this->data["booking_selected_facilities_price"] = (!empty($booking_data["booking_selected_facilities_price"])) ? $booking_data["booking_selected_facilities_price"] : '';
			$this->data["country"] = ($this->current_session["country"] > 0) ? $this->current_session["country"] : 0;
			$this->pricing_ar_set($car_data,$booking_data["pickup_date"],$booking_data["pickup_time"],$booking_data["dropoff_date"],$booking_data["dropoff_time"],$facility_post,$booking_data["insuranceGroupId"],$booking_data["pickup_location"],$booking_data["dropoff_location"],$booking_data["discount_coupon"],json_decode($booking_data["pricingDetails"],true),$booking_data["driverage"],true);
			$this->data["pickup_location_time"] = $this->get_opening_time_from_location($booking_data["pickup_location"]);	
			if($booking_data["pickup_location"] == $booking_data["dropoff_location"])
			{
				$this->data["dropoff_location_time"] = $this->data["pickup_location_time"];
			}
			else
			{
				$this->data["dropoff_location_time"] = $this->get_opening_time_from_location($booking_data["dropoff_location"]);
			}

			$this->data["booking_id"] = $booking_data["id"];
			/*insurance_group_items*/

			/*facilities_price_render*/			
			
			/*$this->facility_price_render($facility_post,$booking_days,$booking_data["pickup_date"],$booking_data["dropoff_date"],$booking_data["car_id"]);*/

			$this->edit_booking_facility_price_render($facility_post,$booking_days,$booking_data["pickup_date"],$booking_data["pickup_date"],$booking_data["car_id"],$booking_data);
			$this->locations_model->after_get_allow = false;
			$this->data["locations"] = $this->locations_model->set_fields("id,location_name")->get_many_by("status",'y');
			$this->locations_model->after_get_allow = true;

			$this->data["countries"] = $this->countries_model->set_fields("id,country_name")->get_many_by("status",'y');

			$this->data["cars"] = $this->get_cars_from_location($booking_data["pickup_location"]);

			/*$this->data["picup_location_time_ar"] = $this->get_opening_time_from_location($booking_data["pickup_location"]);
			$this->data["dropoff_location_time_ar"] = $this->get_opening_time_from_location($booking_data["dropoff_location"]);
			*/
			
			$this->get_insurance_items_data();

			/*insurance_group_items*/
			$this->get_insurance_groups_data($car_data,$booking_days,$this->data["data_insurance_group_items"]);
			/*Get insurance groups*/
			
			$this->car_facilities_render($booking_data["car_id"]);
			$this->insurance_render($booking_data["car_id"],$booking_data);

			$this->price_change_render($booking_data["car_id"],$id);
			$this->data['form_url']	= $this->current_url.'booking_confirm';	
			$this->output->set_title(lang("Book a car".$car_data["name"]));	
			$this->data["type"] = "edit";

			$this->data["price_view_render"] = $this->load->view("admin/manage_booking/price_detail",$this->data,true);
		}
		else
		{
			$this->session->set_flashdata("error",lang("INVLID_BOOKING_ID"));
			redirect(base_url()."bookings","refresh");
		}
		$this->view = $this->page."add_edit";		
	}

	public function car_facilities_render($carid)
	{
		if($this->isAjax)
		{
			$this->view = false;
			$this->layout = false;
			$this->json = true;
		}
		$this->load->model("cars_model");
		$pickup_date = ($this->input->post("pickup_date") != '') ?  $this->input->post("pickup_date") : "";
		$dropoff_date = ($this->input->post("dropoff_date") != '') ?  $this->input->post("dropoff_date") : "";
		$this->cars_model->facility_pickup_date = $pickup_date;
		$this->cars_model->facility_dropoff_date = $dropoff_date;
		
		$car_data =  $this->cars_model->get($carid);

		$this->data["car_data"] = $car_data;
		$this->data["facilities_render_html"] = $this->load->view("admin/manage_booking/car_facilities",$this->data,true);
		/*printr($car_data);*/
	}

	public function insurance_render($carid,$booking_data = array())
	{
		$pickup_date = ($this->input->post('pickup_date') != '') ? $this->input->post('pickup_date') : $booking_data["pickup_date"];
		$dropoff_date = ($this->input->post('dropoff_date') != '') ? $this->input->post('dropoff_date') : $booking_data["dropoff_date"];

		/*G*/
		$pickup_time = ($this->input->post('pickup_time') != '') ? $this->input->post('pickup_time') : $booking_data["pickup_time"];
		$dropoff_time = ($this->input->post('dropoff_time') != '') ? $this->input->post('dropoff_time') : $booking_data["dropoff_time"];
		$exploded_pickup_time = explode(":",$pickup_time); 
		$exploded_dropff_time = explode(":",$dropoff_time);
		if(count($exploded_pickup_time) == 3)
		{
			array_pop($exploded_pickup_time);
			$pickup_time = implode(":",$exploded_pickup_time);
		}
		if(count($exploded_dropff_time) == 3)
		{
			array_pop($exploded_dropff_time);
			$dropoff_time = implode(":",$exploded_dropff_time);
		}
		$start_date = $pickup_date." ".$pickup_time;
		$end_date = $dropoff_date." ".$dropoff_time;
		$booking_days =  date_difference($start_date,$end_date);
		/*G*/

		/*$booking_days =  date_difference($pickup_date,$dropoff_date);*/
		if($this->isAjax)
		{
			$this->view = false;
			$this->layout = false;
			$this->json = true;
		}
		$this->data["car_data"] = $this->cars_model->get($carid);
		$this->get_insurance_items_data();
		$this->get_insurance_groups_data($this->data["car_data"],$booking_days,$this->data["data_insurance_group_items"]);	
		$this->data["insurance_render_html"] = $this->load->view("admin/manage_booking/insurance_detail",$this->data,true);
	}

	public function price_change_render($id,$bookingid = 0)
	{
		$pickup_location = ($this->input->post('pickup_location') > 0) ? $this->input->post('pickup_location') : 0;
		$dropoff_location = ($this->input->post('dropoff_location') > 0) ? $this->input->post('dropoff_location') : 0;
		$pickup_date = ($this->input->post('pickup_date') != "") ? $this->input->post('pickup_date') : "";
		$dropoff_date = ($this->input->post('dropoff_date') != "") ? $this->input->post('dropoff_date') : "";
		$pickup_time = ($this->input->post('pickup_time') != "") ? $this->input->post('pickup_time') : "";
		$dropoff_time = ($this->input->post('dropoff_time') != "") ? $this->input->post('dropoff_time') : "";
		$type = ($this->input->post('type') != "") ? $this->input->post('type') : "";
		$offer_id = ($this->input->post('offer_id') != "") ? $this->input->post('offer_id') : "";
		$facilities = ($this->input->post('car_facilities') != "") ? $this->input->post('car_facilities') : "";
		$driveragenumber = ($this->input->post('driveragenumber') != "") ? $this->input->post('driveragenumber') : "";
		$driveragenumber = (date('Y') - date('Y',strtotime($driveragenumber)));

		$facility_post = array();
		if(!empty($facilities))
		{
			foreach ($facilities as $key => $value) 
			{
				if($value > 0)
				{
					$facility_post[] = $key;	
				}
			}
		}

		$insuranceGroupId = ($this->input->post('insuranceGroupId') > 0) ? $this->input->post('insuranceGroupId') : "";

		if(($driveragenumber < DRIVER_MINIMUM_AGE || $driveragenumber > DRIVER_MAXIMUM_AGE) && $driveragenumber >= USER_MINIMUM_AGE)
		{
			$insuranceGroupId = DEFAULT_INSURANCE;
			$this->data["lock_id"] = DEFAULT_INSURANCE;
		}
		else
		{
			$this->data["lock_id"] = "";	
		}

		$car_data = $this->cars_model->get($id);	

		$start_date = $pickup_date." ".$pickup_time.":00";
		$end_date = $dropoff_date." ".$dropoff_time.":00";

		$booking_days =  date_difference($start_date,$end_date);
		$this->data["booking_msg"] = "";
		$two_month_status = $this->booking_check_maximum_two_month($pickup_date);
		if($two_month_status === false)
		{
			$this->data["booking_msg"] = lang("MAXIMUM_TWO_MONTH_BOOKING_ALLOWED");
			$this->data["booking_msg_classnm"] = "error";
			$this->data["booking_btn_disabled"] = true;
		}
		/*Check for booking lies in upcoming two months*/

		/*Check for stop sale period change*/
		$stop_sale_records = $this->stop_sale_period_check($pickup_date,$dropoff_date,$pickup_location,$car_data['categoryId']);
		if(!empty($stop_sale_records))
		{
			$this->data["booking_msg"] = lang("STOP_SALE_PERIOD_NOW");
			$this->data["booking_msg_classnm"] = "error";
			$this->data["booking_btn_disabled"] = true;
		}
		/*Check for stop sale period change*/

		/*check for minimum rental days check*/
		$minimum_rental_records = $this->minimum_rental_check($pickup_date,$dropoff_date,$pickup_location,$booking_days);
		if(!empty($minimum_rental_records))
		{
			$this->data["booking_msg"] = lang("PLEASE_SELECT_MINIMUM_RENTAL_DAYS");
			$this->data["booking_msg_classnm"] = "error";
			$this->data["booking_btn_disabled"] = true;
		}
		/*check for minimum rental days check*/
		$this->data["car_data"] = $car_data;

		$booking_id = $this->data["booking_id"] = ($this->input->post("booking_id") > 0) ? $this->input->post("booking_id") : (($bookingid > 0) ? $bookingid : 0);
		if($booking_id  > 0)
		{
			$booking_db_data = $this->bookings_model->get($booking_id);
		}

		$discount_coupon_val = (isset($booking_db_data) && $booking_db_data["discount_coupon"] != '') ? $booking_db_data["discount_coupon"] : 0;
		
		$pricingDetails_val = (isset($booking_db_data) && $booking_db_data["pricingDetails"] != '' && $id == $booking_db_data["car_id"]) ? $booking_db_data["pricingDetails"] : array();

		$driveragenumber = ($driveragenumber > 0) ? $driveragenumber : $booking_db_data["driverage"];
		$price_ar = json_decode($pricingDetails_val,true);
		$this->pricing_ar_set($car_data,$pickup_date,$pickup_time,$dropoff_date,$dropoff_time,$facility_post,$insuranceGroupId,$pickup_location,$dropoff_location,$discount_coupon_val,$price_ar,$driveragenumber,false,true,$booking_db_data);
		$this->data["pickup_location_time"] = $this->get_opening_time_from_location($pickup_location);
		$this->data["dropoff_location_time"] = $this->get_opening_time_from_location($dropoff_location);

		self::edit_booking_facility_price_render($facility_post,$booking_days,$pickup_date,$dropoff_date,$id,$booking_db_data);		
		$this->data["price_view_render"] = $this->load->view("admin/manage_booking/price_detail",$this->data,true);
		if($this->isAjax)
		{
			$this->view = false;
			$this->layout = false;
			$this->json = true;
		}
	}

	public function booking_confirm()
	{
		$this->load->model("cars_model");
		$this->load->model("bookings_model");

		$first_name = ($this->input->post('first_name') != '') ? $this->input->post('first_name') : '';
		$last_name = ($this->input->post('last_name') != '') ? $this->input->post('last_name') : '';
		$driving_licence = ($this->input->post('driving_licence') != '') ? $this->input->post('driving_licence') : '';
		$email = ($this->input->post('email') != '') ? $this->input->post('email') : '';
		$contact_number = ($this->input->post('contact_no') != '') ? $this->input->post('contact_no') : '';
		$country = ($this->input->post('country') > 0) ? $this->input->post('country') : 0;
		$note = ($this->input->post('note') != '') ? $this->input->post('note') : '';
		$pickup_location = ($this->input->post('pickup_location') > 0) ? $this->input->post('pickup_location') : 0;
		$dropoff_location = ($this->input->post('dropoff_location') > 0) ? $this->input->post('dropoff_location') : 0;
		$pickup_date = ($this->input->post('pickup_date') != "") ? $this->input->post('pickup_date') : "";
		$dropoff_date = ($this->input->post('dropoff_date') != "") ? $this->input->post('dropoff_date') : "";
		$pickup_time = ($this->input->post('pickup_time') != "") ? $this->input->post('pickup_time') : "";
		$dropoff_time = ($this->input->post('dropoff_time') != "") ? $this->input->post('dropoff_time') : "";
		$type = ($this->input->post('type') != "") ? $this->input->post('type') : "";
		$status = ($this->input->post('status') != "") ? $this->input->post('status') : "";
		$offer_id = ($this->input->post('offer_id') != "") ? $this->input->post('offer_id') : "";
		$facilities = ($this->input->post('car_facilities') != "") ? $this->input->post('car_facilities') : "";
		$insuranceGroupId = ($this->input->post('insuranceGroupId') > 0) ? $this->input->post('insuranceGroupId') : "";
		$flight_no = ($this->input->post('flight_no') != '') ? $this->input->post('flight_no') : "";
		$user_note = ($this->input->post('user_note') != '') ? $this->input->post('user_note') : "";
		$car_id = ($this->input->post('car_id') > 0) ? $this->input->post('car_id') : 0;
		$carid = ($this->input->post('carid') > 0) ? $this->input->post('carid') : 0;
		$booking_id = ($this->input->post("booking_id") > 0) ? $this->input->post("booking_id") : 0;

		if($booking_id > 0)
		{
			$booking_data = $this->bookings_model->get($booking_id);
		}
		$facilities = array_filter($facilities);

		/*if($carid != $booking_data["car_id"])
		{
			$facilities = array();
		}*/

		$facility_post = array();
		if(!empty($facilities))
		{
			foreach ($facilities as $key => $value) 
			{
				if($value > 0)
				{
					$facility_post[] = $key;	
				}
			}
		}

		
		if($carid != $booking_data["car_id"])
		{
			$car_data = $this->cars_model->get($carid);	
		}
		else
		{
			$car_data = $this->cars_model->get($car_id);	
		}

		$start_date = $pickup_date." ".$pickup_time.":00";
		$end_date = $dropoff_date." ".$dropoff_time.":00";

		$booking_days =  date_difference($start_date,$end_date);

		
		$driveragenumber = ($this->input->post("driveragenumber") != '') ? $this->input->post("driveragenumber") : '';
		$date_of_birth = date('Y-m-d',strtotime($driveragenumber));

		if($driveragenumber == '0000-00-00' || $driveragenumber == '0001-11-30')
		{	
			$this->session->set_flashdata("error","Invalid date of birth.Please select date of birth by click.");
			redirect(base_url()."search");
			exit();
		}

		$date_of_birth_year = date('Y',strtotime($driveragenumber));
		$date_of_birth_month = date('m',strtotime($driveragenumber));
		$date_of_birth_day = date('d',strtotime($driveragenumber));
		$age = count_age($date_of_birth_day,$date_of_birth_month,$date_of_birth_year);
		/*$date_of_birth = date("Y-m-d",strtotime($driveragenumber)); 
		$age = (date('Y') - date('Y',strtotime($driveragenumber)));*/
		if($age > 0)
		{
			$driveragenumber = $age;	
		}
		else
		{
			$driveragenumber = DRIVER_MINIMUM_AGE." - ".DRIVER_MAXIMUM_AGE;
		}

		$note = ($this->input->post("note") != '') ? $this->input->post("note") : '';
		$address = ($this->input->post("address") != '') ? $this->input->post("address") : '';

		if($car_id > 0 && $pickup_location > 0 && $dropoff_location > 0 && $pickup_time != "" && $dropoff_time != "" && $pickup_date != "" && $dropoff_date != "" && !empty($car_data))
		{
			
			$two_month_status = $this->booking_check_maximum_two_month($pickup_date);
			$stop_sale_status = false;
			$stop_sale_records = $this->stop_sale_period_check($pickup_date,$dropoff_date,$pickup_location,$car_data['categoryId']);

			if(!empty($stop_sale_records))
			{
				$stop_sale_status = true;
			}
			/*Check for stop sale period change*/

			/*check for minimum rental days check*/
			$minimum_rental_records = $this->minimum_rental_check($pickup_date,$dropoff_date,$pickup_location,$booking_days);
			$minimum_rental_check_status = false;
			if(!empty($minimum_rental_records))
			{
				$minimum_rental_check_status = true;
			}
			/*check for minimum rental days check*/

			if($stop_sale_status == true || $two_month_status == false || $minimum_rental_check_status == true)
			{
				$this->session->set_flashdata("error",lang("INVALID_REQUEST"));
				redirect($this->current_url);
			}
			else
			{
				$this->pricing_model->car_category = $car_data["categoryId"];
				$this->pricing_model->pickup_location = $pickup_location;
				$this->pricing_model->dropoff_location = $dropoff_location;
				$this->pricing_model->pickup_date = $pickup_date;
				$this->pricing_model->pickup_time = $pickup_time;
				$this->pricing_model->dropoff_date = $dropoff_date;
				$this->pricing_model->dropoff_time = $dropoff_time;
				$this->pricing_model->car_id = $car_data["id"];
				$this->pricing_model->booking_selected_facilities = $facility_post;
				$this->pricing_model->insuranceGroupId = $insuranceGroupId;
				$this->pricing_model->booking_user_driveragenumber = $driveragenumber;
				if($booking_data["discount_coupon"] > 0 && $booking_data["pricingDetails"] != '')
				{
					$price_ar = $this->pricing_model->get_car_price(array(),$booking_data["discount_coupon"],json_decode($booking_data["pricingDetails"],true));
					$coupon_id = $booking_data["discount_coupon"];
				}
				else
				{
					if($carid != $booking_data["car_id"])
					{
						$price_ar = $this->pricing_model->get_car_price();
					}
					else
					{
						$pricingDetailsArray = json_decode($booking_data["pricingDetails"],true); 
						$price_ar = $this->pricing_model->get_car_price(array(),0,$pricingDetailsArray,true,$booking_data);
					}					
					$coupon_id = $this->session->userdata("coupon_id");
				}
				
				/*$new_booking_id 	= date("dmYHis").random_string('nozero',6);*/
				$booking_insert_ar = array(
					'pickup_location' => $pickup_location,
					'dropoff_location' => $dropoff_location,
					'pickup_date' => $pickup_date,
					'dropoff_date' => $dropoff_date,
					'pickup_time' => $pickup_time,
					'dropoff_time' => $dropoff_time,					
					'car_category' => $car_data["categoryId"],
					'discount_coupon' => $coupon_id,
					'insurance' => $insuranceGroupId,
					'special_offer' => '',
					'note' => $user_note,
					'sub_total' => $price_ar["original_price"],
					'booking_price' => $price_ar["total"],
					'currency_code' => '',
					'flight_no' => $flight_no,
					'api_reservation_id' => '',
					'email' => $email,
					'contactNo' => $contact_number,
					'country' => $country,
					'note' => $note,
					"pricingDetails" => json_encode($price_ar),
					'booking_type'=>'a',
					'booking_status'=>$status,
					'note'=>$note,
					'address'=>$address,
					"date_of_birth"=>$date_of_birth
				);
				$booking_insert_ar["driving_licence"] = $driving_licence;
				$booking_insert_ar["driverage"] = $driveragenumber;	
				$booking_insert_ar["firstname"] = $first_name;
				$booking_insert_ar["lastname"] = $last_name;
				if($booking_id > 0)
				{
					/*$booking_data = $this->bookings_model->get($booking_id);*/
					$booking_insert_ar["user_id"] = $booking_data["user_id"];
					$booking_insert_ar["booking_id"] = $booking_data["id"];
					
					$booking_insert_ar["new_booking_days"] = $booking_days;
					$pricing_array = json_decode($booking_data["pricingDetails"],true);
					$booking_insert_ar["current_booking_days"] = $pricing_array["booking_total_days"];

					if($carid != $booking_data["car_id"])
					{
						$booking_insert_ar["car_id"] = $car_id;
					}

					$update_status = $this->bookings_model->update($booking_id,$booking_insert_ar,true);

					$this->session->set_flashdata("success",lang("MSG_REC_EDIT"));
					redirect(base_url()."admin/manage_booking","refresh");
				}
				else
				{
					$booking_insert_ar["car_id"] = $car_id;
					
					$booking_insert_ar["booking_status"] = $status;
					
					/*$booking_insert_ar["booking_no"] = $new_booking_id;*/
					$booking_insert_ar["booking_no"] = '';

					$booking_insert_ar["ip_address"] = $this->input->ip_address();
					$booking_insert_ar["booking_date"] = date('Y-m-d');
					$booking_id = $this->bookings_model->insert($booking_insert_ar);
					$this->session->set_flashdata("success",lang("MSG_SUCC_CONF_BOOKING"));
					redirect($this->current_url,"refresh");
				}
			}
		}
		else{
			/*$this->session->set_flashdata("error",lang(""));
			redirect(base_url()."fleetguide","refresh");*/
		}
	}

	public function export_booking_details()
	{
		$this->load->library('excel');
		$pickup_location = $this->input->post("pickup_location");
		$start_date = $this->input->post("start_date");
		$end_date = $this->input->post("end_date");
		$categories = $this->input->post("categories");
		$review_export = $this->input->post("review_export");


		$boookings_where[] = array('booking_status IN("p","a","c")',null,false);
		$booking_export_array = array();
		if($pickup_location > 0)
		{
			$boookings_where[] = array('bookings.pickup_location = "'.$pickup_location.'"',null,false);
		}

		if($start_date != "" && $end_date != "")
		{	
			$boookings_where[] = array('bookings.pickup_date >= "'.$start_date.'" AND bookings.dropoff_date <= "'.$end_date.'"',null,false);
		}	
		if($categories > 0)
		{
			$boookings_where[] = array('bookings.car_category = "'.$categories.'"',null,false);
		}	

		$this->bookings_model->after_get_user_info_allow = true;
		$booking_records = $this->bookings_model->order_by("id","desc")->get_many_by($boookings_where);
		$this->bookings_model->after_get_user_info_allow = false;
		$booking_total_amount = 0;

		if(!empty($booking_records))
		{
			$i = 1;

			if($review_export == "review_export")
			{
				$booking_export_array[0] = array("Name","Email","Booking date","Desciption","Order Ref","Product search code","Feedback Date","Customer Ref","Amount","Currency","Product link","Category","Logon");

				foreach ($booking_records as $key => $booking_data) 
				{

					$booking_export_array[$i][]	= 	$booking_data["user_info"]["firstname"]." ".$booking_data["user_info"]["lastname"];

					$booking_export_array[$i][]	= 	$booking_data["user_info"]["email"];

					$booking_export_array[$i][]	= 	$booking_data["booking_date"];
					$booking_export_array[$i][]	= 	strip_tags($booking_data["car_info"]["description"]);
					$booking_export_array[$i][]	= 	$booking_data["booking_no"];
					$booking_export_array[$i][]	= 	"";
					$booking_export_array[$i][]	= 	"";
					$booking_export_array[$i][]	= 	"";
					$booking_export_array[$i][]	= 	$booking_data["booking_price"];
					$booking_export_array[$i][]	= 	"eur";
					$booking_export_array[$i][]	= 	base_url()."car/".$booking_data["car_id"];;
					$booking_export_array[$i][]	= 	$booking_data["car_info"]['category'];
					$booking_export_array[$i][]	= 	"";
					$i++;
				}

				$filename = 'review_details.xls'; 
				$file_title = "Review";
			}
			else
			{
				$filename = 'booking_details.xls'; 
				$file_title = "Bookings";
				$booking_export_array[0] = array("booking_no","Refferal","User Name","User Phone No","User Driving Licence No","Pickup Location","Pickup Date","Pickup Time","Dropoff Location","Dropoff Date","Dropoff Time","Car Name","Car Category","Booking Price","");
				foreach ($booking_records as $key => $booking_data) 
				{

					$booking_export_array[$i][]	= 	$booking_data["booking_no"];

					$booking_export_array[$i][]	= 	(isset($booking_data["refferal_name"]) && $booking_data["refferal_name"] != '') ? $booking_data["refferal_name"] : 'N/A';

					$booking_export_array[$i][]	= 	$booking_data["user_info"]["firstname"]." ".$booking_data["user_info"]["lastname"];
					$booking_export_array[$i][]	= 	$booking_data["user_info"]["contactNo"];
					$booking_export_array[$i][]	= 	$booking_data["user_info"]["drivinglicence_no"];
					$booking_export_array[$i][]	= 	$booking_data["pickup_location_ar"]["location_name"];
					$booking_export_array[$i][]	= 	$booking_data["pickup_date"];
					$booking_export_array[$i][]	= 	$booking_data["pickup_time"];
					$booking_export_array[$i][]	= 	$booking_data["dropoff_location_ar"]["location_name"];
					$booking_export_array[$i][]	= 	$booking_data["dropoff_date"];
					$booking_export_array[$i][]	= 	$booking_data["dropoff_time"];
					$booking_export_array[$i][]	= 	$booking_data["car_info"]["name"];
					$booking_export_array[$i][]	= 	$booking_data["car_info"]["category"];
					$booking_export_array[$i][]	= 	$booking_data["booking_price"];
					$booking_total_amount += $booking_data["booking_price"];
					$i++;
				}
			}


			$this->excel->setActiveSheetIndex(0);
			$this->excel->getActiveSheet()->setTitle($file_title );
			foreach(range('A','N') as $columnID) {
				$this->excel->getActiveSheet()->getColumnDimension($columnID)
				->setAutoSize(true);
			}
			$this->excel->getActiveSheet()->getStyle('A1:M1')->getFont()->setBold(true);
			$this->excel->getActiveSheet()->getProtection()->setSheet(true);
			$this->excel->getActiveSheet()->fromArray($booking_export_array);


			if($review_export == "review_export")
			{
				foreach (range('E', $this->excel->getActiveSheet()->getHighestDataRow()) as $col) 
				{
					$this->excel->getActiveSheet()->getStyle('E'.$col)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER);
				}
			}
			else
			{
				foreach (range('A', $this->excel->getActiveSheet()->getHighestDataRow()) as $col) 
				{
					$this->excel->getActiveSheet()->getStyle('A'.$col)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER);
				}

				foreach (range('D', $this->excel->getActiveSheet()->getHighestDataRow()) as $col) 
				{
					$this->excel->getActiveSheet()->getStyle('D'.$col)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER);
				}
			}


			header('Content-Type: application/vnd.ms-excel'); 
			header('Content-Disposition: attachment;filename="'.$filename.'"'); 
			header('Cache-Control: max-age=0'); 
			$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
			$objWriter->save('php://output');
		}
		else{
			$this->session->set_flashdata("error",lang("NO_BOOKING_REC_FOUND"));
			redirect($this->current_url);
		}
	}


	public function check_coupon_exist()
	{
		if($this->isAjax)
		{
			$this->view = false;
			$this->layout = false;
			$this->json = true;
			$this->load->model("coupons_model");
			$coupon_code = $this->input->post("coupon_code");
			$today_date = date('Y-m-d');
			$this->data["status"] = "success";
			$this->data["msg"] = "";
			$exist_where_ar[] = array("('".$today_date."' BETWEEN start_date AND end_date) AND code = '".$coupon_code."'",null,false);
			$coupon_exist_ar = $this->coupons_model->get_by($exist_where_ar);
			if(!empty($coupon_exist_ar))
			{
				if($coupon_exist_ar["used"] < $coupon_exist_ar["max_usage"])
				{
					$this->session->set_userdata("coupon_id",$coupon_exist_ar["id"]);
					$this->data["msg"] = lang("COUPON_APPLIED_SUCCESSFULLY");
				}
				else{
					$this->data["status"] = "error";
					$this->data["msg"] = lang("COUPON_CODE_MAXIMUM_LIMIT_REACHED");	
				}
			}
			else{
				$this->data["status"] = "error";
				$this->data["msg"] = lang("INVALID_COUPON_CODE");
			}
		}	
		else
		{
			redirect(base_url(),"refresh");
			exit();
		}			
	}


	public function send($id)
	{
		
		if($this->isAjax)
		{
			$this->view = false;
			$this->layout = false;
			$this->json = true;	
			
			$this->load->model("countries_model");
			$this->load->model("states_model");
			$this->load->model("cities_model");

			$this->bookings_model->after_get_user_info_allow = true;
			$booking_data = $this->bookings_model->get($id);
			$this->bookings_model->after_get_user_info_allow = false;
			
			if(!empty($booking_data))
			{

				$user_address=NULL;	
				if(!empty($booking_data["user_info"]['address'])){
					$user_address = $booking_data["user_info"]['address'];
					$user_address .= !empty($booking_data["user_info"]['city'])?', '.$booking_data["user_info"]['city']:'';
					$user_address .= !empty($booking_data["user_info"]['zipcode'])?', '.$booking_data["user_info"]['zipcode']:'';

					$user_country_name_ar = $this->countries_model->set_fields("country_name")->get($booking_data["user_info"]['country']);
					$user_state_name_ar = $this->states_model->set_fields("state_name")->get($booking_data["user_info"]['state']);;


					$user_address .= !empty($user_state_name_ar["state_name"])?', '.$user_state_name_ar["state_name"]:'';
					$user_address .= !empty($user_country_name_ar["country_name"])?', '.$user_country_name_ar["country_name"]:'';
				}

				$api_key=RESERVATION_KEY;

				$data=array();
				$data['kategorija'] = $booking_data["car_info"]['category'];
				$data['broj_broker']='';
				$data['date1']=date('Y-m-d H:i:s',strtotime($booking_data['pickup_date'].' '.$booking_data['pickup_time']));
				$data['date2']=date('Y-m-d H:i:s',strtotime($booking_data['dropoff_date'].' '.$booking_data['dropoff_time']));
				$data['poslovnica1']="";

				$pickup_location_country_name_ar = $this->countries_model->set_fields("country_name")->get($booking_data["pickup_location_ar"]['country']);

				$pickup_location_state_name_ar = $this->states_model->set_fields("state_name")->get($booking_data["pickup_location_ar"]['state']);;
				
				$pickup_location_city_name_ar = $this->cities_model->set_fields("city_name")->get($booking_data["pickup_location_ar"]['city']);;


				$pickup_country = $pickup_location_country_name_ar["country_name"];
				$pickup_state = $pickup_location_state_name_ar["state_name"];
				$pickup_city = $pickup_location_city_name_ar["city_name"];
				

				/*Dropoff */
				$dropoff_location_country_name_ar = $this->countries_model->set_fields("country_name")->get($booking_data["dropoff_location_ar"]['country']);

				$dropoff_location_state_name_ar = $this->states_model->set_fields("state_name")->get($booking_data["dropoff_location_ar"]['state']);;
				
				$dropoff_location_city_name_ar = $this->cities_model->set_fields("city_name")->get($booking_data["dropoff_location_ar"]['city']);;


				$dropoff_country = $dropoff_location_country_name_ar["country_name"];
				$dropoff_state = $dropoff_location_state_name_ar["state_name"];
				$dropoff_city = $dropoff_location_city_name_ar["city_name"];
				/*Dropoff */


				$data['mjesto_1'] = $booking_data["pickup_location_ar"]["address"].' '.$pickup_city.', '.$booking_data["pickup_location_ar"]["zip_code"].', '.$pickup_state.', '.$pickup_country;
				
				$data['poslovnica2']="";

				$data['mjesto_2'] = $booking_data["dropoff_location_ar"]["address"].' '.$dropoff_city.', '.$booking_data["dropoff_location_ar"]["zip_code"].', '.$dropoff_state.', '.$dropoff_country;

				$data['ime'] = $booking_data["user_info"]["firstname"].' '.$booking_data["user_info"]['lastname'];
				
				$data['adresa'] = $booking_data["user_info"]['address'];
				
				$data['email'] = $booking_data["user_info"]['email'];
				
				$data['dob']="";
				$booking_price_ar = (array)json_decode($data["pricingDetails"]);
				$data['vozacka'] = $booking_data["user_info"]['drivinglicence_no'];
				$data['vozacka_datum'] = '';
				$data['vozacka_mjesto'] = "";
				$data['putovnica'] = "";
				$data['telefon'] = $booking_data['contactNo'];
				$data['voucher'] = NULL;
				$data['agencija_id'] = NULL; 
				$data['cjena'] = $booking_price_ar["per_day_price"];
				$data['cjena_total'] = $booking_price_ar["total"];
				$data['placanje'] = 'Paypal';
				$data['napomena'] = 'Payment for car booking number #'.$id;
				$data['trziste'] = 'Internet prodaja';
				$data['chkkey'] = md5($api_key.$data['date1'].$data['date2']);
				$query_string=http_build_query($data);
				$end_point="www.vinis.hr/rcm-demo/api/web-reservations.php?".$query_string;

				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL,$end_point); 
				curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
				curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);   
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				$result = curl_exec($ch);
				$reservation_id=NULL;
				if(!empty($result))
				{
					$xmlObj=simplexml_load_string($result);
					if(!empty($xmlObj->reservationNumber))
					{
						$reservation_id = $xmlObj->reservationNumber;
						$update_ar = array("api_reservation_id"=>$reservation_id); 
						$this->bookings_model->update($id,$update_ar,true);
						$success=true;
						$this->data["status"] = "success";
						$this->data["msg"] = lang("MSG_RESERVATION_SENT_SUCCESSFULLY").' Reservation Number:
						'.$reservation_id;
					}
					else
					{
						$this->data["status"] = "error";
						$this->data["msg"] = lang("MSG_API_ERROR");							
					}
				}
			}
			else
			{
				$this->data["status"] = "error";
				$this->data["msg"] = lang("INVALID_BOOKING_ID");
			}
		}

	}

	public function cancel($id)
	{
		$this->load->model("bookings_model");
		$this->data["status"] = "fail";
		$this->data["msg"] = lang("PLEASE_TRY_AGAIN");
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0)
		{
			$get_details = $this->bookings_model->get($id);
			if(!empty($get_details))
			{
				$update_ar = array("booking_status"=>"c");
				$this->bookings_model->usercancel_by_admin = true;
				$del_status = $this->bookings_model->update($id,$update_ar,true);
				$this->bookings_model->usercancel_by_admin = false;
				if($del_status)
				{
					$this->data["status"] = "success";
					$this->data["msg"] = lang("MSG_BOOKING_CANCELLED_SUCCESSFULLY");
					$this->data["table"] = "tblmng_booking";
				}
			}
			/*else if($get_details["booking_status"] == 'a')
			{
				$this->data["status"] = "error";
				$this->data["msg"] = lang("ACCEPTED_BOOKING_CAN_NOT_CANCELLED");
			}*/
		}
	}	

	public function delete($id)
	{
		$this->load->model("bookings_model");
		$this->data["status"] = "fail";
		$this->data["msg"] = lang("PLEASE_TRY_AGAIN");
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0)
		{
			$del_status = $this->bookings_model->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang("MSG_REC_DELETE");
				$this->data["table"] = "tblmng_booking";
			}
		}
	}
	/* end of the delete user code */

	public function edit_booking_facility_price_render($facility_post,$booking_days,$pickup_date,$dropoff_date = '',$car_id = '',$booking_db_data = array())
	{
		if(!empty($facility_post))
		{

			$this->car_facilities_model->pickup_date = $pickup_date;
			$this->car_facilities_model->dropoff_date = $dropoff_date;
			$this->car_facilities_model->car_id = $car_id;

			$pricingDetails = json_decode($booking_db_data["pricingDetails"],true);

			$facilities_where[] = array('car_facilities.id IN ('.implode(",",$facility_post).')',null,false);
			$get_facilities_data = $this->car_facilities_model->set_fields("car_facilities.*")->get_many_by($facilities_where);
			foreach ($get_facilities_data as $key => $value) 
			{
				$temp_text = '';

				if($value["type"] == "m")
				{
					$post_value_check_quantity = $this->input->post("car_facilities")[$value['id']];
				}

				if((($value["type"] == "s" && $pricingDetails["booking_total_days"] == $booking_days) || ($value["type"] == "m"  && $pricingDetails["booking_total_days"] == $booking_days && $post_value_check_quantity == $booking_db_data["booking_selected_facilities"][$value["id"]])) && array_key_exists($value["id"], $booking_db_data["booking_selected_facilities"]))
				{
					$price_dis = $booking_db_data["booking_selected_facilities_price"][$value["id"]];
					if($booking_db_data["booking_selected_facilities"][$value["id"]] > 1)
					{
						$temp_text = $booking_db_data["booking_selected_facilities"][$value["id"]];
					}					
				}
				else
				{
					if(isset($value["is_promo_code"]) && $value["is_promo_code"] == "yes")
					{
						if($value["promo_code_type"] == 'a')
						{
							$price_dis =  $booking_days * $value["promo_code_price"];
						}
						else
						{
							$price_dis = 0;
						}
					}
					else
					{
						if($value["type"] == "m")
						{
							$post_value_check_quantity = $this->input->post("car_facilities")[$value['id']];

							if($post_value_check_quantity != $booking_db_data["booking_selected_facilities"][$value["id"]] && array_key_exists($value["id"], $booking_db_data["booking_selected_facilities"]))
							{
								if($value["daily_cost"] == 0)
								{
									$value["price"] = $booking_db_data["booking_selected_facilities_price"][$value["id"]] / $booking_db_data["booking_selected_facilities"][$value["id"]];
								}
								else
								{
									$value["price"] = ($booking_db_data["booking_selected_facilities_price"][$value["id"]] / $booking_db_data["booking_selected_facilities"][$value["id"]]) / $booking_days;	
								}
							}

							if($value["daily_cost"] == 0)
							{
								$price_dis  = ($post_value_check_quantity * $value["price"]);
							}	
							else{
								$all_days_facilities_price = $booking_days*($post_value_check_quantity * $value["price"]);
								if($all_days_facilities_price > $value['maximum_cost']){
									$price_dis = $value['maximum_cost'];
								}
								else{
									$price_dis = $all_days_facilities_price;
								}
							}
							$temp_text = $post_value_check_quantity;
						}
						else
						{
							if($value["daily_cost"] == 0)
							{
								$price_dis = $value["price"];
							}	
							else{
								$all_days_facilities_price = $booking_days*$value["price"];
								if($all_days_facilities_price > $value['maximum_cost']){
									$price_dis = $value['maximum_cost'];
								}
								else{
									$price_dis =  $all_days_facilities_price;
								}
							}	
						}
					}
				}

				$fac_name = $value["facility_name"];
				if(isset($temp_text) && $temp_text != '')
				{
					$fac_name .= " X ".$temp_text."  ";
				}

				$temp_array = array(
					"facility_id"=>$value['id'],
					"facility_name"=>$fac_name,
					"facility_price"=>number_format($price_dis, 2)
				);

				$this->data["facilities_price_render"][] =  $temp_array;
			}
		}
		return true;
	}

	public function change_booking_price($booking_id = 0)
	{
		if($this->isAjax)
		{
			$this->layout = false;
			$this->view = false;
			$this->json = true;

			$bookingid = $this->input->post("bookingid");
			$facilityid = $this->input->post("facilityid");
			$price_change_type = $this->input->post("pk");
			$new_price = $this->input->post("value");
			$new_price = (float)$new_price;
			
			$this->load->model("bookings_model");
			if($price_change_type != "facility_price")
			{
				$this->bookings_model->after_get_allow = false;
				$booking_data = $this->bookings_model->get($bookingid);
				$this->bookings_model->after_get_allow = true;
			}
			else
			{
				$booking_data = $this->bookings_model->get($bookingid);
			}

			$update_booking_ar = array();
			if(!empty($booking_data))
			{
				$pricing_details_ar = json_decode($booking_data["pricingDetails"],true);
				if($price_change_type == "original_price")
				{
					$price_difference = ($new_price > $booking_data["sub_total"]) ? $new_price - $booking_data["sub_total"] : $booking_data["sub_total"] - $new_price;	

					$final_booking_price = ($new_price > $booking_data["sub_total"]) ? $booking_data["booking_price"] + $price_difference : $booking_data["booking_price"] - $price_difference;	


					if($pricing_details_ar['is_special_offer'] == true && $pricing_details_ar['special_offer_original_price'] != '')
					{
						
						if($pricing_details_ar["special_offer_original_type"] == "p")
						{
							$new_special_offer_price = ($new_price * $pricing_details_ar["special_offer_original_price"])/100;
							if($new_special_offer_price > $pricing_details_ar['special_offer_price'])
							{
								$diff = $new_special_offer_price - $pricing_details_ar['special_offer_price'];
								$final_booking_price -= $diff;	
							}
							else if($new_special_offer_price < $pricing_details_ar['special_offer_price'])
							{
								$diff = $pricing_details_ar['special_offer_price'] - $new_special_offer_price;
								$final_booking_price += $diff;	
							}
							$pricing_details_ar["special_offer_price"] = $new_special_offer_price;
							$pricing_details_ar["per_day_special_offer_price"] = ($new_price - $new_special_offer_price) / $pricing_details_ar['booking_total_days'];
						}
					}
					/*Update json elements*/
					$new_per_day_price = $new_price / $pricing_details_ar['booking_total_days'];
					$pricing_details_ar["per_day_price"] = $new_per_day_price;
					$pricing_details_ar["original_price"] = $new_price;
					$pricing_details_ar["total"] = $final_booking_price;
					/*Update json elements ends*/

					$update_booking_ar = array(
						"sub_total"=>$new_price,
						"booking_price"=>$final_booking_price,
						"pricingDetails"=>json_encode($pricing_details_ar)
					);
					
					/*update sub total  per_day_price total booking_total_days json fields*/
					/*update sub total and booking_price column also */
				}
				else if($price_change_type == "driver_age_price")
				{		
					$price_difference = ($new_price > $pricing_details_ar['driver_age_price']) ? $new_price - $pricing_details_ar['driver_age_price'] :  $pricing_details_ar['driver_age_price'] - $new_price;	

					$final_booking_price = ($new_price > $pricing_details_ar['driver_age_price']) ? $booking_data["booking_price"] + $price_difference :  $booking_data["booking_price"] - $price_difference;	
					/*Update json elements*/
					$pricing_details_ar["driver_age_price"] = $new_price;
					$pricing_details_ar["total"] = $final_booking_price;
					/*Update json elements ends*/

					$update_booking_ar = array(
						"booking_price"=>$final_booking_price,
						"pricingDetails"=>json_encode($pricing_details_ar)
					);

				}
				else if($price_change_type == "from_time_surcharge_price")
				{	
					$price_difference = ($new_price > $pricing_details_ar['from_time_surcharge_price']) ? $new_price - $pricing_details_ar['from_time_surcharge_price'] :  $pricing_details_ar['from_time_surcharge_price'] - $new_price;	
					
					$final_booking_price = ($new_price > $pricing_details_ar['from_time_surcharge_price']) ? $booking_data["booking_price"] + $price_difference :  $booking_data["booking_price"] - $price_difference;

					/*Update json elements*/
					$pricing_details_ar["from_time_surcharge_price"] = $new_price;
					$pricing_details_ar["total"] = $final_booking_price;
					/*Update json elements ends*/

					$update_booking_ar = array(
						"booking_price"=>$final_booking_price,
						"pricingDetails"=>json_encode($pricing_details_ar)
					);
				}
				else if($price_change_type == "to_time_surcharge_price")
				{			
					$price_difference = ($new_price > $pricing_details_ar['to_time_surcharge_price']) ? $new_price - $pricing_details_ar['to_time_surcharge_price'] :  $pricing_details_ar['to_time_surcharge_price'] - $new_price;	

					$final_booking_price = ($new_price > $pricing_details_ar['to_time_surcharge_price']) ? $booking_data["booking_price"] + $price_difference :  $booking_data["booking_price"] - $price_difference;

					/*Update json elements*/
					$pricing_details_ar["to_time_surcharge_price"] = $new_price;
					$pricing_details_ar["total"] = $final_booking_price;
					/*Update json elements ends*/

					$update_booking_ar = array(
						"booking_price"=>$final_booking_price,
						"pricingDetails"=>json_encode($pricing_details_ar)
					);
				}
				else if($price_change_type == "insurance_price")
				{		
					$price_difference = ($new_price > $pricing_details_ar['insurance_price']) ? $new_price - $pricing_details_ar['insurance_price'] :  $pricing_details_ar['insurance_price'] - $new_price;	
					$final_booking_price = ($new_price > $pricing_details_ar['insurance_price']) ? $booking_data["booking_price"] + $price_difference :  $booking_data["booking_price"] - $price_difference;
					/*Update json elements*/
					$pricing_details_ar["insurance_price"] = $new_price;
					$pricing_details_ar["total"] = $final_booking_price;
					/*Update json elements ends*/

					$update_booking_ar = array(
						"booking_price"=>$final_booking_price,
						"pricingDetails"=>json_encode($pricing_details_ar)
					);
				}	
				else if($price_change_type == "facility_price")
				{
					/*update booking_extras table price */

					$price_difference = ($new_price > $booking_data['booking_selected_facilities_price'][$facilityid]) ? $new_price - $booking_data['booking_selected_facilities_price'][$facilityid] :  $booking_data['booking_selected_facilities_price'][$facilityid] - $new_price;	

					$final_booking_price = ($new_price > $booking_data['booking_selected_facilities_price'][$facilityid]) ? $booking_data["booking_price"] + $price_difference :  $booking_data["booking_price"] - $price_difference;

					/*Update json elements*/
					$pricing_details_ar["total"] = $final_booking_price;
					/*Update json elements ends*/

					/*Update to booking_extras table*/
					$update_where_ar = array();
					$update_where_ar[] = array("booking_id = '".$bookingid."' AND facility_id = '".$facilityid."'",null,false);
					$update_data = array(
						"price"=>$new_price
					);
					$this->load->model("booking_extras_model");
					$this->booking_extras_model->update_by($update_where_ar,$update_data);
					/*Update to booking_extras table ends*/

					$update_booking_ar = array(
						"booking_price"=>$final_booking_price,
						"pricingDetails"=>json_encode($pricing_details_ar)
					);
				}
				else if($price_change_type == "dropoff_price")
				{				
					$price_difference = ($new_price > $pricing_details_ar['dropoff_price']) ? $new_price - $pricing_details_ar['dropoff_price'] :  $pricing_details_ar['dropoff_price'] - $new_price;	

					$final_booking_price = ($new_price > $pricing_details_ar['dropoff_price']) ? $booking_data["booking_price"] + $price_difference :  $booking_data["booking_price"] - $price_difference;	
					
					$pricing_details_ar["dropoff_price"] = $new_price;
					$pricing_details_ar["total"] = $final_booking_price;
					
					$update_booking_ar = array(
						"booking_price"=>$final_booking_price,
						"pricingDetails"=>json_encode($pricing_details_ar)
					);
				}				
				
				if(!empty($update_booking_ar))
				{
					$this->bookings_model->after_update_allow = false;
					$this->bookings_model->before_update_allow = false;
					$price_update_status = $this->bookings_model->update($bookingid,$update_booking_ar,true);
					$this->bookings_model->after_update_allow = true;
					$this->bookings_model->before_update_allow = true;

					if($price_update_status)
					{
						$this->data["status"] = "success";
						$this->data["booking_price"] = $final_booking_price;
						$this->data["price_change_type"] = $price_change_type;
						$this->data["new_price"] = $new_price;
						$this->data["msg"] = "Price updated successfully.";	
					}
				}
				else
				{
					$this->data["status"] = "error";				
					$this->data["msg"] = "Something went wrong";				
				}
			}
		}
	}
}
