<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Account extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
	}
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';	
		$this->current_url = base_url()."admin/account/";	
	}
	public function index(){
		if(!$this->input->post()){
			$this->page_name = lang("Change Password");
			$this->body_class = 'login';
			$this->data['form_url']=$this->current_url."index";
			$this->output->set_title(lang("Change Password"));
		}

		if($this->input->post())
		{
			$this->load->model("admin_model");
			$this->admin_model->validate = array(
				'old'  => array(
					'field' => 'old',
					'label' => 'Name',
					'rules' => 'trim|required|xss_clean',
					'error_msg' => array(
						'required'  => 'lang:CURRENT_PASSWORD_REQUIRED'
						),
					),
				'new'  => array(
					'field' => 'new',
					'label' => 'Password',
					'rules' => 'required|min_length[4]|matches[new_confirm]',
					'error_msg' => array(
						'required'  => "lang:PASSWORD_REQUIRED",
						'min_length' => "lang:PASSWORD_MINIMUM_LENGTH",
						'matches' => "lang:MSG_PASSWORD_NOTMATCH"
						),
					),
				'new_confirm'  => array(
					'field' => 'new_confirm',
					'label' => 'Confirm Password',
					'rules' => 'required',
					'error_msg' => array(
						'required'  => "lang:PASSWORD_REQUIRED"						
						),
					)
				);
			$password = md5($this->input->post("new"));
			$old = md5($this->input->post("old"));


			$update_array = array('password'=>$password,"old"=>$old,"change_password"=>true);
			$upd_status = $this->admin_model->update($this->current_session["id"],$update_array);
			if(parseBool($upd_status) == true)
			{			
				$success=true;
				$msg=lang(MSG_SUCC_CHANGEPASS);
			}
			else{				
				$success=false;
				$msg=(validation_errors()) ? validation_errors() : $upd_status["msg"];
			}
			if($success==true)
			{
				$this->session->set_flashdata('success',$msg);
				redirect(base_url()."admin/dashboard");
			}
			else{
				$this->session->set_flashdata('error',$msg);
				redirect($this->current_url."index");	
			}
		}		
	}
}
