<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There area two reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router what URI segments to use if those provided
| in the URL cannot be matched to a valid route.
|
*/

$route['default_controller'] = "home";
$route['404_override'] = 'error_404';
$route['reset/(:any)'] = "forgot/reset/$1";
$route['activate/(:any)'] = "activate/index/$1";
$route['cron/(:any)'] 	= 	"cron/$1";

// URI like '/en/about' -> use controller 'about'
$route['^(en|de|fr|nl)/(.+)$'] = "$2";

// '/en', '/de', '/fr' and '/nl' URIs -> use default controller
$route['^(en|de|fr|nl)$'] = $route['default_controller']; 

/*Image timthum's urls*/
$route['image/(:any)/(:any)/(:any)/(:any)/(:any)'] = "getimage/getimg/$1/$2/$3/$4/$5";
$route['image/(:any)/(:any)/(:any)/(:any)'] = "getimage/index/$1/$2/$3/$4";
$route['image/(:any)/(:any)'] = "getimage/index/$1/$2";

/*$route['search'] = "explore/explore_search_result";*/

/*Image timthum's urls ends*/

$route['logout'] = "logout";
$route['resetpassword/(:any)'] = "resetpassword/index/$1";


/*$route['change_password'] = "auth/change_password";*/
$route['profile/(:num)'] = "profile/index/$1";
$route['booking/(:num)'] = "booking/index/$1";
$route['bookingdetail/(:num)'] = "bookingdetail/index/$1";

/*$route['account'] = "auth/edit_profile";*/

$route['social'] 	= 	"social/session/";
$route['social/success'] 	= 	"social/success";
$route['social/error'] 	= 	"social/error";
$route['social/deauthorize_facebook'] 	= 	"social/deauthorize_facebook";
$route['social/(:any)'] 	= 	"social/session/$1";

/*$route['cms/(:any)'] 	= 	"cms/index/$1";*/
$route['car-hire-city/(:any)'] 	= 	"city/index/$1";
$route['car-hire-location/(:any)'] 	= 	"location/index/$1";
$route['referral_booking/(:any)'] 	= 	"referral_booking/index/$1";
$route['sitemap.xml'] = "sitemap/index/xml";
/*$route['simplyportscan/hosts/add'] = "simplyportscan/add";*/

/*Admin url's*/
$route['admin'] = "admin/login/index";
$route['admin/logout'] = "logout/index/admin";
/*$route['admin/account/changepassword'] = "logout/index/admin";*/
$route['admin/profile'] = "profile/index";
$route['admin/profile/change_password'] = "profile/change_password";
$route['admin/resetpassword/(:any)'] = "admin/resetpassword/index/$1";

/*$route['admin/manage_pricing/advanced/(:num)'] = "admin/manage_pricing/index/a/$1";*/


$route['admin/manage_pricing/view_advance_pricing/(:any)'] = "admin/manage_pricing/view_advance_pricing/$1";


$route['admin/manage_pricing/advanced'] = "admin/manage_pricing/index/a";
$route['admin/manage_pricing/basic'] = "admin/manage_pricing/index/b";
$route['admin/(:any)'] = "admin/$1";
/*Admin url's ends*/

/*Agency urls*/
$route['agency'] = "agency/login/index";
$route['agency/logout'] = "logout/index/agency";
/*Agency urls ends*/


/*Front URLS*/
$route['car/(:num)'] = "detail/index/$1";

$route['temp'] = "temp";
/*$route['pages/(:any)'] = "content/index/$1";*/
$route['cms/(:any)'] = "content/index/$1";

/* End of file routes.php */
/* Location: ./application/config/routes.php */