var adv_fld_id = 0;
var requests = {};
var Appad = {
  config: {
    siteUrl: 'http://localhost/nova/',
    AssetUrl: 'http://localhost/nova/assets/',
    userlistTimestamp:Math.round(+new Date()/1000),
    conversationMessageTimestamp:0,    
  },
  init: function(config) {
    _this = this;
    $.extend(_this.config, config);
    _this.initCommonPlugins();
    _this.init_message_methods();
    adv_fld_id = (config.adv_fld_id_js > 0) ? config.adv_fld_id_js : adv_fld_id;
  },
  delete_row:function($elm){
    var row = $elm.closest("tr").get(0);
    var dataTbl = $elm.parents('.dataTable').data("tbl");
    if ($.fn.DataTable.fnIsDataTable( dataTbl ) ) {
      var index = dataTbl.fnGetPosition(row); 
      dataTbl.fnDeleteRow(index, function (dtSettings, row) {
        dataTbl.fnDraw(false);        
      }, true);
    }
  },
  /*refresh_table:function($dataTblElement){
    var dataTbl = $dataTblElement.data("tbl");
    if ($.fn.DataTable.fnIsDataTable( dataTbl ) ) {
      dataTbl.fnDraw();
    }
  },*/
  displayMsg:function(msgText){
    $(".disp-js-msg").show();
    $(".js-msg-text").html(msgText);
    setTimeout(function(){ $(".disp-js-msg").hide(); }, 3000);
  },
  ajax: function(objConfig) {
    return $.ajax({
      type: objConfig.type, 
      url: objConfig.url,
      context:(objConfig.context != undefined)?objConfig.context:{},
      beforeSend:function(xhr,settings){
        if (settings.context != undefined && !jQuery.isEmptyObject(settings.context)  && settings.context.hasClass('btn_loading')) {
          settings.context.button('loading');
        }
        (objConfig.beforeSend != undefined)?objConfig.beforeSend(xhr,settings):'';
      }, 
      headers: (objConfig.headers != undefined)?objConfig.headers:{}, 
      async: (objConfig.async != undefined)?objConfig.async:true,
      data : (objConfig.data != undefined)?objConfig.data:{},
      dataType : (objConfig.dataType != undefined)?objConfig.dataType:'json',
      cache: (objConfig.cache != undefined)?objConfig.cache:true,
      contentType: (objConfig.contentType != undefined)?objConfig.contentType:'application/x-www-form-urlencoded',
      success: function(data) {
        objConfig.success(data);
      },
      error: function(data, textStatus, jqXHR) {
        objConfig.error(data, textStatus, jqXHR)   
      },
      complete:function(){
        if(typeof this.button != "undefined"){
          this.button('reset');  
        }
      }
    });
  },
  abortajax:function(name){
    if(typeof(requests[name])!="undefined"){
      $.each(requests[name],function(k,v){
        v.abort();
      });
    }
  },
  addAjaxArray:function(name,req){
    if(typeof requests[name] == "undefined")
    {
      requests[name] = [];
    }
    requests[name].push(req);
  },
  initExtraHeightSet:function(){
    var maxHeight = 0;
    $('.facility_select .extrabox')
    .each(function() { maxHeight = Math.max(maxHeight, $(this).height()); })
    .height(maxHeight).css("min-height",maxHeight);
    var maxwidth = 0;
  },
  initCommonPlugins:function(){
    $("body").on('click','.delete_data',function(e){
      e.preventDefault();
      var dataTbl = $(this).parents('.dataTable').data("tbl");
      var  url = $(this).attr('href');
      var r = confirm("Are you sure to delete");
      var $this=$(this);
      if (r == true) {  
        $.ajax({
          url: url,
          type: 'GET',
          dataType: 'json',
          data: {},
          success:function(response){
           $("#"+response.table).DataTable().ajax.reload();
         },
         error:function(){
         }
       })
      } else {}      
    });

  },
  init_mng_email_templates:function(){
   var a = new Datatable;
   a.init({
    src: $("#tblmng_email_templates"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id"},
     { "data": "types","title":"Template Name","searchable":true},
     { "data": "description","title":"Description"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_email_templates"
    }
  }
});
 },
 init_mng_constant:function(){
  var a = new Datatable;
  a.init({
    src: $("#tblmng_constant"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id"},
     { "data": "constantName","title":"Name","name":"constantName"},
     { "data": "constantValue","title":"Value"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_constants/index"
    }
  }
});
},
init_mng_slider:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_slider .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var slider_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_slider/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'slider_id':slider_id
      },
      success: function(response) {     
        $("#tblmng_slider").DataTable().ajax.reload();
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_slider"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id"},
     { "data": "image","title":"Image","searchable":true},
     { "data": "caption","title":"Caption"},
     { "data": "status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_slider"
    }
  },
  
});
},
init_mng_abuse_word:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_abuse_word .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var keyword_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_abuse_list/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'keyword_id':keyword_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_abuse_word").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_abuse_word"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     
     { "title": "#","data": "id" },
     { "data": "abuseKeyword","title":"Abuse Keyword","searchable":true},
     { "data": "status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_abuse_list/"
    }
  }
});
},
init_mng_content_operations:function(){
  /*CKEDITOR.replace( 'page_description');*/
  CKEDITOR.replace( 'page_description', {
    filebrowserUploadUrl: Appad.config.siteUrl+"admin/manage_contents/imageupload" 
  });
  $("body").on('change','.page_type_content',function(){
   val = $('.page_type_content:checked', '#content_form').val();
   if(val == 'c')
   {
    $("#external_link_cont").addClass("hide");
    $(".external_page_data").addClass("hide");    
    $(".cms_page_data").removeClass('hide');
  }else{
    $("#external_link_cont").removeClass("hide");
    $(".external_page_data").removeClass("hide");
    $(".cms_page_data").addClass('hide');
  }
}); 

  $("body").on('change','.allow_booking_type',function(){
   val = $('.allow_booking_type:checked', '#content_form').val();
   if(val == 'y')
   {

    $(".booking_form_page_data").removeClass('hide');
  }else{

    $(".booking_form_page_data").addClass('hide');
  }
});

  
  $("body").on('change','#display_position',function(){
   val = $('#display_position option:selected', '#content_form').val();
   if(val != "footer")
   {
    $(".footer_category_cont").hide();
  }
  else{
    $(".footer_category_cont").show();
  }
});

  $('body').on('keyup','#page_title',function() {
    /*var title = $('#page_title').val().toLowerCase().replace(/[^a-z0-9\s]/gi, '').replace(/[_\s]/g, '-');
    $('#slug').val(title).addClass('edited');*/
    var page_title = $('#page_title').val();
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_contents/get_slug",
      type: 'POST',
      dataType: 'json',
      data: {
        'page_title':page_title
      },
      success: function(response) 
      {
        if(response.status == "success")
        {
          $('#slug').val(response.slug).addClass('edited');
        }
        else
        {
          $("#js_message").removeClass("hide").addClass("alert-error"); 
          $("#js_message").append(response.msg);   
        }        
      },
      error: function() {
      }
    });

  });



},
init_mng_content_list:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_content_list .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var content_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_contents/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'content_id':content_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_content_list").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_content_list"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "data": "id","title":"#" },
     { "data": "page_title","title":"Title"},
     { "data": "display_position","title":"Position"},
     { "data": "status"},
     { "data": "sort_order"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_contents"
    }
  }
});
},
init_mng_users:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_users .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var user_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_users/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'user_id':user_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_users").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_users"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "firstName","title":"First Name"},
     { "data": "lastName","title":"Last Name"},
     { "data": "email","title":"Email"},
     { "data": "status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_users"
    }
  }
});
},
init_mng_subadmin:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_subadmin .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var user_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_subadmin/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'user_id':user_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_subadmin").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_subadmin"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "username","title":"Name"},
     { "data": "email","title":"Email"},
     { "data": "status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_subadmin"
    }
  }
});
},
init_mng_countires:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_countires .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var country_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_countries/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'country_id':country_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_countires").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_countires"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "country_name","title":"Name"},
     { "data": "phonecode","title":"Code"},
     { "data": "status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_countries"
    }
  }
});
},
init_mng_states:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_states .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var state_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_states/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'state_id':state_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_states").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_states"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "state_name","title":"Name"},
     { "data": "country_name","title":"Country"},
     { "data": "status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_states"
    }
  }
});
},
init_initialize_map:function(latitude, longitude){
  var haightAshbury = new google.maps.LatLng(latitude, longitude);
  var mapOptions = {
    zoom: 4,
    types:'address',
    center: haightAshbury,
    mapTypeId: google.maps.MapTypeId.ROADMAP
  }; 
  map = new google.maps.Map(document.getElementById('gmap3'),
    mapOptions);
  geocoder = new google.maps.Geocoder;
  marker = new google.maps.Marker({
    map: map
  });
  input = document.getElementById('pac-input');
  autocomplete = new google.maps.places.Autocomplete(input);
  autocomplete.bindTo('bounds', map);
  map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);
  infowindow=new google.maps.InfoWindow();
  autocomplete.addListener('place_changed', function() {
    infowindow.close();
    var place = autocomplete.getPlace();
    if (!place.geometry) {
      return;
    }
    if (place.geometry.viewport) {
      map.fitBounds(place.geometry.viewport);
    } else {
      map.setCenter(place.geometry.location);
      map.setZoom(17);
    }
    marker.setPlace({
      placeId: place.place_id,
      location: place.geometry.location
    });
    marker.setVisible(true);
    _this.init_save_data(place);
    infowindow.setContent('<div><strong>' + place.name + '</strong><br>' +
      'Place ID: ' + place.place_id + '<br>' +
      place.formatted_address);
    infowindow.open(map, marker);
  });
},
init_save_data:function(place)
{
  var  place_name   ='';
  var  street_number  ='';
  var  address1   ='';
  var  address2   ='';
  var  city1      ='';
  var  city2      ='';
  var  state      ='';
  var  country    ='';
  var  postal_code  ='';
  var google_place_id = place.place_id;
  var latitude = place.geometry.location.lat();
  var longtitude = place.geometry.location.lng();
  place_name=place.name;
  var arrAddress =place.address_components;
  $("#latitude").val(latitude);
  $("#longitude").val(longtitude);
  $("#google_place_id").val(google_place_id);
  $.each(arrAddress, function (i, address_component) {
    /*console.log(address_component);*/
    if (address_component.types[0] == "street_number"){
      street_number = address_component.long_name;
    }
    if (address_component.types[0] == "route"){
      address1 = address_component.long_name;
    } 
    if (address_component.types[0] == "sublocality"){
      address2 = address_component.long_name;
    }         
    if (address_component.types[0] == "locality"){
      city1 = address_component.long_name;
    }   
    if (address_component.types[0] == "administrative_area_level_2"){
      city2 = address_component.long_name;
    } 
    if (address_component.types[0] == "administrative_area_level_1"){
      state = address_component.long_name;
    }
    if (address_component.types[0] == "country"){
      country = address_component.long_name;
    }
    if (address_component.types[0] == "postal_code" ){ 
      postal_code= address_component.long_name;
    }
  });
  if(street_number!=''){
    address1=street_number+','+address1;
  }
  if(place_name!=''){
    address1=place_name+','+address1;
  }
  if(address1!='' && address2=='')
  {
    $("#address").val(address1);
  }
  else if(address2!='' && address1=='')
  {
    $("#address").val(address2);          
  }
  else if(address1!='' && address2!='' )
  {
    if(address1!=address2)
    {
      $("#address").val(address1 + address2);
    }
    else{
      $("#address2").val(address1);
    }
  }             
  if(city1!='' && city2=='')
  {
    city=city1;
  }
  else if(city2!='' && city1=='')
  {
    city=city2;
  }
  else if(city1!='' && city2!='' )
  {
    if(city1!=city2)
    {
      city=city1+','+city2;
    }
    else{
      city=city1;
    }             
  }
  if(country!='')
  {
    $("#country").val($("#country option").filter(function() {
      return this.text.toLowerCase() == country.toLowerCase() 
    }).val());
    
    $("#country").trigger('change',[state,city]);
  }
  
  if(postal_code!='')
  {
    $("#zip_code").val(postal_code);
  }
},
init_mng_cities_operation:function(){
  var latitude    =36.125452238770954;
  var longitude     =-115.00854531250008;
  var map,input,autocomplete,marker,geocoder;
  $(document).on('click','#map_link', function(e){    
    $("#pac-input").fadeIn();
    $("#gmap3").fadeIn(); 
    _this.init_initialize_map(latitude,longitude);  
  });
},
init_mng_cities:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_cities .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var city_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_cities/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'city_id':city_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_cities").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_cities"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "city_name","title":"Name"},
     { "data": "state_name","title":"State"},
     { "data": "country_name","title":"Country"},
     { "data": "latitude","title":"Latitude"},
     { "data": "longitude","title":"Longitude"},
     { "data": "status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_cities"
    }
  }
});
},
init_mng_pickup_locations:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_pickup_location .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var location_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_pickup_locations/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'location_id':location_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_pickup_location").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_pickup_location"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "location_name","title":"Name"},
     { "data": "location_short_name","title":"Short Name","sClass":"hide"},     
     { "data": "email","title":"Email"}, 
     { "data": "phone","title":"Phone"}, 
     { "data": "city_name","title":"City"},
     { "data": "state_name","title":"State"},
     { "data": "country_name","title":"Country"},
     { "data": "address","title":"Address"},
     { "data": "zip_code","title":"Zip Code"},
     { "data": "status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_pickup_locations"
    }
  }
});
},
init_mng_pickup_locations_fee:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_pickup_location_fee .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var location_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_pickup_locations_fee/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'location_id':location_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_pickup_location_fee").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_pickup_location_fee"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "fromname","title":"From"},
     { "data": "toname","title":"To"},
     { "data": "minimum_days","title":"Minimum Days"},
     { "data": "price","title":"price"},
     { "data": "status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_pickup_locations_fee"
    }
  }
});
},
init_pickup_location_fee_operation:function(){
  $("body").on('change', '#location_from_sel', function() {
    locaiton_from_html = $("#location_from_sel option").clone();
    $("#location_to_sel").html(locaiton_from_html);
    $val = $(this).val();
    /*$("#location_to_sel").filter('[value=' + $val + ']').remove();*/
    /*$("#location_to_sel >option[value=" + $val + "]").remove();*/
  }); 
  $("body").on('click','#is_reversible',function(){
    if($('#is_reversible').is(":checked"))
    {
     $("#price_rev_field").removeClass("hide");
   }
   else{
    $("#price_rev_field").addClass("hide");
  }
});
},
init_mng_car_facilities_operations:function(){
  $("body").on('change','.facilitytype',function(){
   val = $('.facilitytype:checked', '#facility_add_form').val();
   if(val == 'm')
   {
    $("#multiple_maximum_cont").removeClass('hide');
  }else{
    $("#multiple_maximum_cont").addClass('hide');
  }
});
},
init_mng_car_facilities:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_car_facilities .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var facility_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_car_facilities/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'facility_id':facility_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_car_facilities").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_car_facilities"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "facility_name","title":"Name"},
     { "data": "price","title":"Price"},
     { "data": "daily_cost","title":"Daily Cost"},
     { "data": "maximum_cost","title":"Maximum Cost"},
     { "data": "status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_car_facilities"
    }
  }
});
},
init_mng_car_groups:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_mng_car_groups .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var group_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_car_groups/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'group_id':group_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_mng_car_groups").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_mng_car_groups"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "group_name","title":"Name"},
     { "data": "status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_car_groups"
    }
  }
});
},
init_mng_characteristics_groups:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_mng_characteristics_groups .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var group_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_characteristics_groups/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'group_id':group_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_mng_characteristics_groups").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_mng_characteristics_groups"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "char_group_name","title":"Name"},
     { "data": "status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_characteristics_groups"
    }
  }
});
},
init_mng_characteristics:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_characteristics .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var characteristic_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_characteristics/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'characteristic_id':characteristic_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_characteristics").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_characteristics"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "name","title":"Name"},
     { "data": "char_group_name","title":"Group Name"},
     { "data": "image","title":"Image"},
     { "data": "status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_characteristics"
    }
  }
});
},
init_mng_insurance_items:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_insurance_items .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var characteristic_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_insurance_items/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'characteristic_id':characteristic_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_insurance_items").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_insurance_items"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "name","title":"Name"},
     { "data": "description","title":"Description"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_insurance_items"
    }
  }
});
},
init_mng_insurance_groups:function(){
 var a = new Datatable;
 a.init({
  src: $("#tblmng_insurance_groups"),
  onSuccess: function(a, e) {},
  onError: function(a) {},
  onDataLoad: function(a) {},
  loadingMessage: "Loading...",
  dataTable: {
   "bSortCellsTop": true,
   "autoWidth": false,
   "filter": true,
   "aoColumns": [
   { "title": "#","data": "id" },
   { "data": "name","title":"Name"},
   { "data": "operation","searchable": false,"sortable":false}
   ],
   ajax: {
    url: config.siteUrl+"admin/manage_insurance_groups"
  }
}
});
},
init_mng_catagories:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_categories .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var category_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_categories/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'category_id':category_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_categories").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_categories"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "category","title":"Name"},
     { "data": "group_name","title":"Group Name"},
     { "data": "status","title":"Status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_categories"
    }
  }
});
},
init_mng_season_operations:function(){
  /*$('#start_date').datepicker({
    format: "mm/dd",
    "autoclose":true,
    startDate: "today"}).on("changeDate", function(selected){
      startDate = new Date(selected.date.valueOf());
      startDate.setDate(startDate.getDate(new Date(selected.date.valueOf())));
      $("#end_date").datepicker("setStartDate", startDate);
    }); 
    $('#end_date').datepicker({ 
      format: "mm/dd",
      "autoclose":true,
      startDate: "today"
    }).on("changeDate", function(selected){
      FromEndDate = new Date(selected.date.valueOf());
      FromEndDate.setDate(FromEndDate.getDate(new Date(selected.date.valueOf())));
      $("#start_date").datepicker("setEndDate", FromEndDate);
    });*/
  },
  init_mng_season:function(){
    $(document).on('switchChange.bootstrapSwitch', '#tblmng_season .make-switch', function() {
      var status = $(this).find(".status_change_js").attr('data-status');
      var season_id = $(this).attr('data-id');
      $.ajax({
        url: Appad.config.siteUrl + "admin/manage_season/change_status",
        type: 'POST',
        dataType: 'json',
        data: {
          'season_id':season_id
        },
        success: function(response) {
          if ($.fn.DataTable.fnIsDataTable()) {
            $("#tblmng_season").fnDraw(false);
          }
        },
        error: function() {
        }
      })
    });
    var a = new Datatable;
    a.init({
      src: $("#tblmng_season"),
      onSuccess: function(a, e) {},
      onError: function(a) {},
      onDataLoad: function(a) {},
      loadingMessage: "Loading...",
      dataTable: {
       "bSortCellsTop": true,
       "autoWidth": false,
       "filter": true,
       "aoColumns": [
       { "title": "#","data": "id" },
       { "data": "season_name","title":"Name"},
       { "data": "start_date","title":"From (mm/dd)"},
       { "data": "end_date","title":"To (mm/dd)"},
       { "data": "status","title":"Status"},
       { "data": "operation","searchable": false,"sortable":false}
       ],
       ajax: {
        url: config.siteUrl+"admin/manage_season"
      }
    }
  });
  },
  init_coupon_oprations:function(){
    $("#all_cars").change(function (e) 
    {  
      e.preventDefault();
      var my = $(this);
      if(my. prop("checked") == true)
      {
        $('.coupon_avail_cars').find('option').each(function() {
          if($(this).val() > 0)
          {
            $(this).prop( "selected", true );
          }
        });  
      }
      else{
        $('.coupon_avail_cars').find('option').each(function() {
         $(this).prop( "selected", false );       
       });  
      } 

    });
  },
  init_mng_cars:function(){
    $(document).on('switchChange.bootstrapSwitch', '#tblmng_cars .make-switch', function() {
      var status = $(this).find(".status_change_js").attr('data-status');
      var car_id = $(this).attr('data-id');
      $.ajax({
        url: Appad.config.siteUrl + "admin/manage_cars/change_status",
        type: 'POST',
        dataType: 'json',
        data: {
          'car_id':car_id
        },
        success: function(response) {
          if ($.fn.DataTable.fnIsDataTable()) {
            $("#tblmng_cars").fnDraw(false);
          }
        },
        error: function() {
        }
      })
    });
    var a = new Datatable;
    a.init({
      src: $("#tblmng_cars"),
      onSuccess: function(a, e) {},
      onError: function(a) {},
      onDataLoad: function(a) {},
      loadingMessage: "Loading...",
      dataTable: {
       "bSortCellsTop": true,
       "autoWidth": false,
       "filter": true,
       "aoColumns": [
       { "title": "#","data": "id" },
       { "data": "name","title":"Name"},
       { "data": "image","title":"Image"},
       { "data": "group_name","title":"Group"},
       { "data": "category","title":"Category"},
       { "data": "quantity","title":"Quantity"},
       { "data": "status","title":"Status"},
       { "data": "operation","searchable": false,"sortable":false}
       ],
       ajax: {
        url: config.siteUrl+"admin/manage_cars"
      }
    }
  });
  },
  init_mng_high_period_notifications:function(){
    $(document).on('switchChange.bootstrapSwitch', '#tblmng_hpn_notification .make-switch', function() {
      var status = $(this).find(".status_change_js").attr('data-status');
      var message_id = $(this).attr('data-id');
      $.ajax({
        url: Appad.config.siteUrl + "admin/manage_high_period_notification/change_status",
        type: 'POST',
        dataType: 'json',
        data: {
          'message_id':message_id
        },
        success: function(response) {
          if ($.fn.DataTable.fnIsDataTable()) {
            $("#tblmng_hpn_notification").fnDraw(false);
          }
        },
        error: function() {
        }
      })
    });
    var a = new Datatable;
    a.init({
      src: $("#tblmng_hpn_notification"),
      onSuccess: function(a, e) {},
      onError: function(a) {},
      onDataLoad: function(a) {},
      loadingMessage: "Loading...",
      dataTable: {
       "bSortCellsTop": true,
       "autoWidth": false,
       "filter": true,
       "aoColumns": [
       { "title": "#","data": "id" },
       { "data": "name","title":"Name"},
       { "data": "location_name","title":"Location Name"},
       { "data": "message","title":"Message"},
       { "data": "start_date","title":"Start Date"},
       { "data": "end_date","title":"End Date"},
       { "data": "status","title":"Status"},
       { "data": "operation","searchable": false,"sortable":false}
       ],
       ajax: {
        url: config.siteUrl+"admin/manage_high_period_notification"
      }
    }
  });
  },
  init_mng_rental_days:function(){
    $(document).on('switchChange.bootstrapSwitch', '#tblmng_rental_days .make-switch', function() {
      var status = $(this).find(".status_change_js").attr('data-status');
      var day_id = $(this).attr('data-id');
      $.ajax({
        url: Appad.config.siteUrl + "admin/manage_rental_days/change_status",
        type: 'POST',
        dataType: 'json',
        data: {
          'day_id':day_id
        },
        success: function(response) {
          if ($.fn.DataTable.fnIsDataTable()) {
            $("#tblmng_rental_days").fnDraw(false);
          }
        },
        error: function() {
        }
      })
    });
    var a = new Datatable;
    a.init({
      src: $("#tblmng_rental_days"),
      onSuccess: function(a, e) {},
      onError: function(a) {},
      onDataLoad: function(a) {},
      loadingMessage: "Loading...",
      dataTable: {
       "bSortCellsTop": true,
       "autoWidth": false,
       "filter": true,
       "aoColumns": [
       { "title": "#","data": "id" },
       { "data": "day","title":"Day"},
       { "data": "status","title":"Status"},
       { "data": "operation","searchable": false,"sortable":false}
       ],
       ajax: {
        url: config.siteUrl+"admin/manage_rental_days"
      }
    }
  });
  },
  init_mng_stop_sale_period:function()
  {
    $(document).on('switchChange.bootstrapSwitch', '#tblmng_stop_sale_period .make-switch', function() {
      var status = $(this).find(".status_change_js").attr('data-status');
      var stop_sale_id = $(this).attr('data-id');
      $.ajax({
        url: Appad.config.siteUrl + "admin/manage_stop_sale_period/change_status",
        type: 'POST',
        dataType: 'json',
        data: {
          'stop_sale_id':stop_sale_id
        },
        success: function(response) {
          if ($.fn.DataTable.fnIsDataTable()) {
            $("#tblmng_stop_sale_period").fnDraw(false);
          }
        },
        error: function() {
        }
      })
    });

  /*{ "data": "location_name","title":"Location Name"},
  {"data": "category","title":"Category Name"},*/

  var a = new Datatable;
  a.init({
    src: $("#tblmng_stop_sale_period"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },     
     { "data": "start_date","title":"Start Date"},
     { "data": "end_date","title":"End Date"},
     { "data": "carid","title":"Cars"},
     { "data": "locationsid","title":"Locations"},
     { "data": "status","title":"Status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_stop_sale_period"
    }
  }
});
},
init_mng_currencies:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_currencies .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var cid = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_currencies/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'cid':cid
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_currencies").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_currencies"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "code","title":"Code"},
     { "data": "symbol","title":"Symbol"},    
     { "data": "status","title":"Status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_currencies"
    }
  }
});
},
init_mng_coupons:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_coupons .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var cid = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_coupons/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'cid':cid
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_coupons").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_coupons"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "code","title":"Code"},
     { "data": "type","title":"Type"},    
     { "data": "value","title":"Value"},    
     { "data": "all_cars","title":"All Cars"},  
     { "data": "max_usage","title":"Max Usage"},  
     { "data": "start_date","title":"Start Date"},  
     { "data": "end_date","title":"End Date"},  
     { "data": "minimum_total","title":"Minimum Total"}, 
     { "data": "status","title":"Status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_coupons"
    }
  }
});
},
init_mng_offers:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_offers .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var offer_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_special_offers/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'offer_id':offer_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_offers").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_offers"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "title","title":"Title"},
     { "data": "group_name","title":"Group Name"},    
     { "data": "cars","title":"cars"},    
     { "data": "location","title":"Location"},  
     { "data": "start_date","title":"Start Date"},  
     { "data": "end_date","title":"End Date"},  
     { "data": "type","title":"Type"}, 
     { "data": "price","title":"Price"},
     { "data": "status","title":"Status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_special_offers"
    }
  }
});
},
init_mng_special_offers_opposite:function(){
 $(document).on('switchChange.bootstrapSwitch', '#tblmng_special_offers_opposite .make-switch', function() {
  var status = $(this).find(".status_change_js").attr('data-status');
  var offer_id = $(this).attr('data-id');
  $.ajax({
    url: Appad.config.siteUrl + "admin/manage_special_offers_opposite/change_status",
    type: 'POST',
    dataType: 'json',
    data: {
      'offer_id':offer_id
    },
    success: function(response) {
      if ($.fn.DataTable.fnIsDataTable()) {
        $("#tblmng_special_offers_opposite").fnDraw(false);
      }
    },
    error: function() {
    }
  })
});
 var a = new Datatable;
 a.init({
  src: $("#tblmng_special_offers_opposite"),
  onSuccess: function(a, e) {},
  onError: function(a) {},
  onDataLoad: function(a) {},
  loadingMessage: "Loading...",
  dataTable: {
   "bSortCellsTop": true,
   "autoWidth": false,
   "filter": true,
   "aoColumns": [
   { "title": "#","data": "id" },
   { "data": "start_date","title":"Start Date"},  
   { "data": "end_date","title":"End Date"},  
   { "data": "cars","title":"Cars"},  
   { "data": "locations","title":"Locations"},  
   { "data": "type","title":"Type"}, 
   { "data": "price","title":"Price"},
   { "data": "status","title":"Status"},
   { "data": "operation","searchable": false,"sortable":false}
   ],
   ajax: {
    url: config.siteUrl+"admin/manage_special_offers_opposite"
  }
}
});
},
init_mng_minimum_rental_days:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_minimum_rental_days .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var rental_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_minimum_rental_days/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'rental_id':rental_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_minimum_rental_days").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_minimum_rental_days"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "name","title":"Name"},  
     { "data": "location_name","title":"Location Name"},
     { "data": "category","title":"Category Name"},
     { "data": "start_date","title":"Start Date"},
     { "data": "end_date","title":"End Date"},
     { "data": "days","title":"Days"},
     { "data": "status","title":"Status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_minimum_rental_days",
    }
  }
});
},
init_mng_pricing:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_pricing .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var pricing_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_pricing/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'pricing_id':pricing_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_pricing").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.setAjaxParam("type",$("#pricingtype").val());
  a.setAjaxParam("advance_id",adv_fld_id);
  a.init({
    src: $("#tblmng_pricing"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "category","title":"Category"},  
     { "data": "season_name","title":"Season"},  
     { "data": "price","title":"Price","searchable": false,"sortable":false},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_pricing"/*,
      data:{"type":$("#pricingtype").val(),"advance_id":adv_fld_id}*/
    }
  }
});
  $("#tblmng_pricing").data("a",a);
},
init_mng_facility_promo_code_operations:function(){
  $("#all_cars").change(function (e) 
  {  
    e.preventDefault();
    var my = $(this);
    if(my. prop("checked") == true)
    {
      $('.coupon_avail_cars').find('option').each(function() {
        if($(this).val() > 0)
        {
          $(this).prop( "selected", true );
        }
      });  
    }
    else{
      $('.coupon_avail_cars').find('option').each(function() {
       $(this).prop( "selected", false );       
     });  
    } 
    
  });
  $("body").on('change','.facilitytype',function(){
   val = $('.facilitytype:checked', '#facility_promo_code').val();
   if(val == 'a')
   {
    $(".amount_cont").removeClass('hide');
  }
  else
  {
    $(".amount_cont").addClass('hide');
  }
});
},
init_mng_facility_promo_code:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_facility_promo_code .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var facility_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_facilities_promo_code/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'facility_id':facility_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_pricing").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_facility_promo_code"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "facility_name","title":"Facility name"},  
     { "data": "start_date","title":"Start Date"},  
     { "data": "end_date","title":"End Date"},  
     { "data": "type","title":"Type"}, 
     { "data": "amount","title":"Amount"},
     { "data": "status","title":"Status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_facilities_promo_code"/*,
      data:{"type":$("#pricingtype").val(),"advance_id":adv_fld_id}*/
    }
  }
});
  $("#tblmng_pricing").data("a",a);
},
init_mng_faq_operations:function()
{
  $("body").on('change','#sectionId',function(){
    sectionId = $(this).val();
    _this.ajax({
      type: 'POST',
      url: _this.config.siteUrl+"admin/manage_faq/get_faq_category/"+sectionId,
      data: '',
      success: function(response)
      {
        if(response.status == "success")
        {
          $("#categoryId").html(response.html);
        }
      },
      error: function () {     
      },
      dataType: 'json'
    });  


  });
},
init_mng_faq:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_faq .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var faq_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_faq/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'faq_id':faq_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_faq").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_faq"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "name" ,"title": "Section Name"},
     { "data": "cat_name" ,"title": "Category Name"},
     { "data": "question","title":"Question"},  
     { "data": "solution","title":"solution"},  
     { "data": "status","title":"Status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_faq"
    }
  }
});
  $("#manage_faq").data("a",a);
},
init_mng_faq_categories:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_faq_categories .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var faq_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_faq_categories/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'faq_id':faq_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_faq_categories").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_faq_categories"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "cat_name","title":"Category"},  
     { "data": "name" ,"title": "Section Name"},     
     { "data": "status","title":"Status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_faq_categories"
    }
  }
});
  $("#tblmng_faq_categories").data("a",a);
},
init_mng_newsletter_users:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_newsletter_users .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var user_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_newsletter_users/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'user_id':user_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_newsletter_users").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_newsletter_users"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "email" ,"title": "Section Name"},
     { "data": "status","title":"Status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_newsletter_users"
    }
  }
});
  $("#tblmng_newsletter_users").data("a",a);
},
init_mng_newsletter_templates:function(){


  $('body').on('click','.send_newsletter_req', function(event){
    event.preventDefault();
    url = $(this).attr("href");
    $.ajax({
      url: url,
      type: "POST",
      data: {},
      dataType: "JSON",
      async: true,
      success: function(response) {
        $("#js_message").html("");
        if(response.status == "success")
        {
          $("#js_message").removeClass("hide").addClass("alert-success");
        }
        else
        {
         $("#js_message").removeClass("hide").addClass("alert-error"); 
       }
       $("#js_message").append(response.msg);       
     }
   });
  });  

  $(document).on('switchChange.bootstrapSwitch', '#tblmng_newsletter_template .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var template_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_newsletter_template/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'template_id':template_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_newsletter_template").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_newsletter_template"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "subject" ,"title": "Subject"},
     { "data": "message" ,"title": "Message"},
     { "data": "status","title":"Status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_newsletter_template"
    }
  }
});
  $("#tblmng_newsletter_template").data("a",a);
},
initGetPrice:function()
{
  car_id = $("#car_id").val();
  carid = $("#carid").val();
  pickup_date = $("#pickup_date").val();
  dropoff_date = $("#dropoff_date").val();  
  if(carid=="" || pickup_date=="" || dropoff_date=="")
  {
    return;
  }

  if (typeof(booking_change_request) != 'undefined') 
  {
    _this.abortajax("pricerequest");
  }

  booking_change_request = _this.ajax({
    type: 'POST',
    url: _this.config.siteUrl+"admin/manage_booking/price_change_render/"+car_id,
    data: $("#booking_form").serialize(),
    beforeSend:function(){
      App.blockUI({
        target: "#price_view_render_cont",
        animate: !0,
      });
    },
    success: function(response)
    {
      App.unblockUI("#price_view_render_cont");
      if(response.lock_id != '')
      {
        $("#groupcheck_radio_"+response.lock_id).iCheck('check'); 
        $('.groupcheck_radio:not(#groupcheck_radio_'+response.lock_id+')').iCheck('disable');     
        $('input[name=insuranceGroupId]:not(#groupcheck_radio_'+response.lock_id+')').attr("disabled",true);
      }
      else
      {
        $('input[name=insuranceGroupId]').attr("disabled",false);
        $('.groupcheck_radio').iCheck('enable');
      }

      $("#price_view_render_cont").removeClass("hide").html(response.price_view_render);
      if(response.booking_msg == "")
      {
        $("#booking_notification").remove();
      }
      else if(response.booking_msg != "")
      {
       if($("#booking_notification").size()==0)
       {
         var not_html = '<div id="booking_notification"><div class="alert alert-'+response.booking_msg_classnm+'">'+response.booking_msg+'</div></div>';
         $("#booking_not_cont").append(not_html);
       } 
     }
     _this.init_booking_price_change_operation();
   },
   error: function () {     
   },
   dataType: 'json'
 });  


  _this.addAjaxArray("pricerequest",booking_change_request);


},
init_booking_insurance_render:function(pickup_date,dropoff_date)
{ 
  carid = $("#car_id").val();

  car_id = (car_id > 0) ? car_id : $("#carid").val();

  if(car_id > 0 && pickup_date != "" && dropoff_date != "")
  {
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_booking/insurance_render/"+carid,
      type: "POST",
      data: $("#booking_form").serialize(),
      dataType: "JSON",
      async: true,
      success: function(data) {
        $("#insurance_cont").html(data.insurance_render_html);
        $(".icheck").iCheck({checkboxClass: 'icheckbox_square-red',radioClass: 'iradio_line-red'});    
        
      }
    });
  }
  
},  
init_booking_price_change_operation:function(){
  if($(".price_edit_js").size() > 0)
  {
    $('.price_edit_js').editable({
      url: Appad.config.siteUrl+"admin/manage_booking/change_booking_price",
      send: 'always',
      inputclass: 'form-control',
      params: function (params) {  
        params.bookingid = $(this).editable().data('bookingid');
        if(typeof $(this).editable().data('facilityid') != "undefined")
        {
          params.facilityid = $(this).editable().data('facilityid');  
        }
        return params;
      },
      success:function(response, newValue) 
      {
        _this.initGetPrice();  
      },
      display: function(value, sourceData) 
      {
        if(typeof sourceData != 'undefined')
        {
          console.log(sourceData);
          console.log(value);
          var colors = {
            "": "gray",
            1: "green",
            2: "blue"
          },
          elem = $.grep(sourceData, function(o) {
            return o.value == value;
          });
          if (elem.length) {
            $(this).text(elem[0].text).css("color", colors[value]);
          } else {
            $(this).empty();
          }
        }     
      }
    });
  }
},
init_booking_operation:function(){

  _this.init_booking_price_change_operation();

  /*$("body").on('change','#driveragenumber',function(){
    _this.initGetPrice();
  });*/

  var dates = $('#driveragenumber').datepicker({
    "autoclose":true,
    "todayHighlight":true,
    startDate: '-'+config.birth_start_year+'y',
    endDate: '-'+config.birth_end_year+'y',
    maxDate: "-18Y",
    nextText: "",
    prevText: "",   
  }).on("changeDate", function(selected){
    var pickup_date_val = $("#pickup_date").val();
    var pickup_time_val = $("#pickup_time").val();
    var dropoff_location_val = $("#dropoff_location").val();
    var dropoff_time_val = $("#dropoff_time").val();
    if(pickup_date_val != '' && pickup_time_val != '' && dropoff_location_val != '' && dropoff_time_val != '')
    {
      _this.initGetPrice();  
    }
  }); 

  $('body').on('click','.send_api_req', function(event){
    event.preventDefault();
    url = $(this).attr("href");
    $.ajax({
      url: url,
      type: "POST",
      data: {},
      dataType: "JSON",
      async: true,
      success: function(response) {
        $("#js_message").html("");
        if(response.status == "success")
        {
          $("#js_message").removeClass("hide").addClass("alert-success");
          $(this).remove();
        }
        else
        {
         $("#js_message").removeClass("hide").addClass("alert-error"); 
       }
       $("#js_message").append(response.msg);

     }
   });
  });


  $('body').on('click','.cancel_booking', function(event){
    event.preventDefault();

    if(confirm("Are you sure want to cancel booking?"))
    {
      url = $(this).attr("href");
      $.ajax({
        url: url,
        type: "POST",
        data: {},
        dataType: "JSON",
        async: true,
        success: function(response) {
          $("#js_message").html("");
          if(response.status == "success")
          {
            $("#js_message").removeClass("hide").addClass("alert-success");
            $(this).remove();
          }
          else
          {
           $("#js_message").removeClass("hide").addClass("alert-error"); 
         }
         $("#js_message").append(response.msg);

         _this.refresh_table(response.table);

       }
     });
    }


  });




  $('body').on('click','#apply_coupon_btn', function(event){
    coupon_code = $("#coupon_code").val();;
    if(coupon_code != '')
    {
      _this.ajax({
        type: 'POST',
        url: Appad.config.siteUrl+"admin/manage_booking/check_coupon_exist",
        data: { 
          "coupon_code":coupon_code,      
        },
        success: function (response){
          $("#js_message").html("");
          if(response.status == "success")
          {
            $("#js_message").removeClass("hide").addClass("alert-success");
          }
          else
          {
           $("#js_message").removeClass("hide").addClass("alert-error"); 
         }
         $("#js_message").append(response.msg);
       },
       error: function () {    
       },
       dataType: 'json'
     });
    }
    else
    {
      $("#js_message").html("");
      $("#js_message").removeClass("hide").addClass("alert-error");
      $("#js_message").append("Please insert coupon code.");
    }  
  });
  $('body').on('ifChecked','.groupcheck', function(event){
    event.preventDefault();
    var temp = _this.initGetPrice();
    if(temp == false){
      $(this).iCheck('uncheck');        
    }
    else{
      $(this).iCheck('check');    
    }
    $(this).parents(".extracol").addClass("active");
  });
  $('body').on('ifUnchecked','.groupcheck', function(event){
    temp2 = _this.initGetPrice()
    if(temp2 == false){
    }
    $(this).parents(".extracol").removeClass("active");
  });
  $('.groupcheck_redio').each(function() {
    if($(this).attr("checked") !== undefined) {
      $(this).iCheck('check');
      _this.initGetPrice();
    }
  });
  $('body').on("click", '.clear_insurance', function() {
    $(".groupcheck_redio").iCheck('uncheck');
    $(".clear_insurance").hide();
    _this.initGetPrice();
  });
  $('body').on('ifChecked', '.groupcheck_redio', function(event) {
    event.preventDefault();
    _this.initGetPrice();
    $(".clear_insurance").show();
  });
  $('body').on('click','.qtyplus',function(e){
    e.preventDefault();
    fieldName = $(this).attr('field');
    /* max_value = $(this).attr('max');*/
    var currentVal = parseInt($('input[name='+'"'+fieldName+'"'+']').val());
    var max_value = parseInt($('input[name='+'"'+fieldName+'"'+']').attr("max"));
    if (!isNaN(currentVal) && (max_value != 'undefined' && currentVal < max_value)) 
    {
      $('input[name='+'"'+fieldName+'"'+']').val(currentVal + 1);
    } 
    else 
    {
      /*$('input[name='+'"'+fieldName+'"'+']').val(0);*/
    }
    _this.initGetPrice();
  });
  $('body').on('click','.qtyminus',function(e){
    e.preventDefault();
    fieldName = $(this).attr('field');
    var currentVal = parseInt($('input[name='+'"'+fieldName+'"'+']').val());
    if (!isNaN(currentVal) && currentVal > 0) {
      $('input[name='+'"'+fieldName+'"'+']').val(currentVal - 1);
    } else {
      $('input[name='+'"'+fieldName+'"'+']').val(0);
    }
    _this.initGetPrice();
  });

  $("body").on("click", "#facilities_extra_disp", function(e) {

    if($(".extra_hidden_cont").hasClass("hide"))
    {
      html_text = $(this).attr("data-less");
      btn_class = "lessbtn";
    } 
    else
    {
      html_text = $(this).attr("data-more");
      btn_class = "morebtn";
    }
    $(".extra_hidden_cont").toggleClass("hide");
    $("#extra_operation_btns").html(html_text);
    $("#extra_operation_btns").removeClass().addClass(btn_class);
    _this.initExtraHeightSet();

  });

  $("body").on("change", "#carid", function(e) {
    e.preventDefault();
    carid = $(this).val();
    $("#car_id").val(carid);
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_booking/car_facilities_render/"+carid,
      type: "POST",
      data: $("#booking_form").serialize(),
      dataType: "JSON",
      async: true,
      success: function(data) {
        $("#car_facilities_cont").html(data.facilities_render_html);
        $(".icheck").iCheck({checkboxClass: 'icheckbox_square-red',radioClass: 'iradio_line-red'});

        if ($(".selectcheck").length > 0) {
         $('.selectcheck').each(function() {
          $(this).iCheck('check');

        });
       }
       _this.initGetPrice();
       _this.init_booking_insurance_render($("#pickup_date").val(),$("#dropoff_date").val());

     }
   });
  });
  $("body").on("change", "#pickup_location", function(e) {
    e.preventDefault();
    $.ajax({
      url: Appad.config.siteUrl + "common_methods/get_cars_from_location",
      type: "POST",
      data: {
        'location_id': $(this).val()
      },
      dataType: "JSON",
      async: true,
      success: function(data) {
        $("#carid").html(data.html);
      }
    });
  });
  $("body").on("change", "#pickup_location,#dropoff_location", function(e) {
    e.preventDefault();
    var type = $(this).attr('name');
    var same_as = $(this).attr("data-sameas");
    $.ajax({
      url: Appad.config.siteUrl + "common_methods/get_opening_time_from_location",
      type: "POST",
      data: {
        'type': type,
        'location_id': $(this).val()
      },
      dataType: "JSON",
      async: true,
      success: function(data) {
        if (type == 'pickup_location') {
          $("#pickup").html(data.time_data);
        } else {
          $("#dropoff").html(data.time_data);
        }
      /*if (!$("#same_as").is(':checked') && same_as != "false") {
        temp = $("#pickup_time").html();
        $("#dropoff_time").html(temp);
        var tmp = $("#pickup_location option:selected").val();
        $("#dropoff_location option[value=" + tmp + "]").attr("selected", "selected");
      }*/
    }
  });
  });
  var dates = $('#pickup_date').datepicker({
    "autoclose":true,
    "todayHighlight":true,
    startDate: "today",
    maxDate: "+2Y",
    nextText: "",
    prevText: "",
    numberOfMonths: 2
  }).on("changeDate", function(selected){
    startDate = new Date(selected.date.valueOf());
    startDate.setDate(startDate.getDate(new Date(selected.date.valueOf())));
    $("#dropoff_date").datepicker("setStartDate", startDate);
    _this.initGetPrice();
    _this.init_booking_insurance_render($("#pickup_date").val(),$("#dropoff_date").val());
  }); 
  $("#dropoff_date").datepicker({
    "autoclose":true,
    "todayHighlight":true,
    startDate: "today",
    maxDate: "+2Y",
    nextText: "",
    prevText: "",
    numberOfMonths: 3
  }).on("changeDate", function(selected){
    _this.initGetPrice();
    _this.init_booking_insurance_render($("#pickup_date").val(),$("#dropoff_date").val());
  });


  if ($(".selectcheck").length > 0) {
   $('.selectcheck').each(function() {
    $(this).iCheck('check'); 
    _this.initGetPrice();   
  });
 }

},
init_mng_boooking_list:function(){
  $("body").on('change','.booking_export_filter',function()
  {
    _this.refresh_table('tblmng_booking');
  });
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_booking .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var faq_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_faq/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'faq_id':faq_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_faq").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.setAjaxParam("min_date",$("#start_date").val());
  a.setAjaxParam("max_date",$("#end_date").val());
  a.setAjaxParam("pickup_location",$("#pickup_location").val());
  a.setAjaxParam("category",$("#categories").val());
  a.init({
    src: $("#tblmng_booking"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "order": [ 0, "desc" ],
     "aoColumns": [
     { "title": "#","data": "id" },     
     { "data": "booking_no","title":"No"},  
     { "data": "refferal_id","title":"Refferal","width": 25},  
     { "data": "firstname","title":"Name"},  
     { "data": "address","title":"Address"},       
     { "data": "name","title":"Car"},     
     { "data": "pickup_location_name","title":"Pickup"},
     { "data": "dropoff_location_name","title":"Dropoff"},
     { "data": "pickup_date","title":"Pickup Date Time"},
     { "data": "dropoff_date","title":"Dropoff Date Time"},
     { "data": "booking_date","title":"Booking Date"},
     { "data": "booking_status","title":"Status"},
     { "data": "booking_price","title":"Price"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_booking"
    }
  }
});
  $("#tblmng_booking").data("a",a);
},
init_dashboard_boooking_list:function(){
  var a = new Datatable;
  a.init({
    src: $("#tblmng_booking_dashboard"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },     
     { "data": "booking_no","title":"No"},  
     { "data": "firstname","title":"Name"},  
     { "data": "name","title":"Car"},
     { "data": "booking_price","title":"Price"},
     { "data": "pickup_location_name","title":"Pickup"},
     { "data": "dropoff_location_name","title":"Dropoff"},
     { "data": "pickup_date","title":"Pickup Date"},
     { "data": "dropoff_date","title":"Dropoff Date"},
     { "data": "booking_date","title":"Booking Date"},
     { "data": "driverage","title":"Driver Age"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/dashboard"
    }
  }
});
  $("#tblmng_booking_dashboard").data("a",a);
},
init_mng_refferal_boooking_list:function(){
  $(document).on('switchChange.bootstrapSwitch', '#tblmng_refferal_booking .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var booking_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_refferal_booking/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'booking_id':booking_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_refferal_booking").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.init({
    src: $("#tblmng_refferal_booking"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },     
     /*{ "data": "email","title":"Email"},  */
     { "data": "name","title":"Name"},  
     { "data": "url","title":"Url"},  
     { "data": "bookings","title":"Bookings"},  
     { "data": "code","title":"Code"},
     { "data": "share_url","title":"Share Url"},
     { "data": "createdDate","title":"Date"},
     { "data": "status","title":"Status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_refferal_booking"
    }
  }
});
  $("#tblmng_refferal_booking").data("a",a);
},
refresh_table:function(table_name){
  var a=$("#"+table_name).data("a");
  var dataTbl = a.getDataTable();
  if(table_name == "tblmng_pricing")
  {
    a.setAjaxParam("type",$("#pricingtype").val());
    a.setAjaxParam("advance_id",adv_fld_id);
  }
  else if(table_name == "tblmng_booking")
  {
    a.setAjaxParam("min_date",$("#start_date").val());
    a.setAjaxParam("max_date",$("#end_date").val());
    a.setAjaxParam("pickup_location",$("#pickup_location").val());
    a.setAjaxParam("category",$("#categories").val());
  }
  else if(table_name == "tblmng_outofhoursfee")
  {
    a.setAjaxParam("location",$("#location").val());
  }

  if(dataTbl) 
  {
    dataTbl.ajax.reload();
  }
},
init_manage_pricing_operations:function()
{ 
  $("body").on('change','#pricingtype',function(){
    var page_href ='';
    if($(this).val() == 'a'){
      page_href = Appad.config.siteUrl+'admin/manage_pricing/advanced';
      
    }else{
      page_href = Appad.config.siteUrl+'admin/manage_pricing/basic';
    }
    location.href = page_href;    
  });
  $("body").on('click','.adv_btn',function(){
    adv_fld_id = $(this).attr('data-id');
    var tbl_m_day_id = $(this).attr('data-m_id');
    var page_href ='';
    page_href = Appad.config.siteUrl+'admin/manage_pricing/add_advanced_pricing';
    $("#btn_add").attr('href',page_href);
    $("#pricingtype").val('a');
    _this.refresh_table("tblmng_pricing");
    $.ajax({
      type: "POST", 
      url: Appad.config.siteUrl+'admin/manage_pricing/view_advance_pricing', 
      data: {'field_id':tbl_m_day_id,'adv_fld_id':adv_fld_id},
      cache: false,
      async:true,
      dataType:'json',
      beforeSend:function(){},
      success:function(status){
        $('.disp_advance_table').append(status.html);        
      },
      error:function(){       
      }
    });
    
  });
},
init_mng_quotes:function(){
 var a = new Datatable;
 a.init({
  src: $("#tblmng_quotes"),
  onSuccess: function(a, e) {},
  onError: function(a) {},
  onDataLoad: function(a) {},
  loadingMessage: "Loading...",
  dataTable: {
   "bSortCellsTop": true,
   "autoWidth": false,
   "filter": true,
   "aoColumns": [
   { "title": "#","data": "id" },
   { "data": "user_email","title":"Email"},
   { "data": "pickup","title":"Pickup Location"},
   { "data": "dropoff","title":"Dropoff Location"},
   { "data": "name","title":"Car Name"},
   { "data": "total_price","title":"Total Price"},
   { "data": "per_day_price","title":"Per Day Price"},
   { "data": "pickup_date","title":"Pickup Date"},
   { "data": "dropoff_date","title":"Dropoff Date"},
   { "data": "date","title":"Date"},
   { "data": "operation","searchable": false,"sortable":false}
   ],
   ajax: {
    url: config.siteUrl+"admin/manage_quotes"
  }
}
});
},

init_mng_today_drooffs:function()
{
 var a = new Datatable;
 a.init({
  src: $("#tblmng_mng_statistics_dropoffs"),
  onSuccess: function(a, e) {},
  onError: function(a) {},
  onDataLoad: function(a) {},
  loadingMessage: "Loading...",
  dataTable: {
   "bSortCellsTop": true,
   "autoWidth": false,
   "filter": true,
   "order": [[ 0, "desc" ]],
   "aoColumns": [
   { "title": "#","data": "id" },
   { "data": "name","title":"Car Name"},
   { "data": "pickup_location_name","title":"Pickup Location"},
   { "data": "pickup_date","title":"Pickup Date"},
   { "data": "dropoff_location_name","title":"Dropoff Location"},
   { "data": "traveller_name","title":"Traveller Name"}
   ],
   ajax: {
    url: config.siteUrl+"admin/manage_statistics/today_drop_off"
  }
}
});
},

init_mng_today_pickups:function()
{
 var a = new Datatable;
 a.init({
  src: $("#tblmng_mng_statistics_pickup"),
  onSuccess: function(a, e) {},
  onError: function(a) {},
  onDataLoad: function(a) {},
  loadingMessage: "Loading...",
  dataTable: {
   "bSortCellsTop": true,
   "autoWidth": false,
   "filter": true,
   "order": [[ 0, "desc" ]],
   "aoColumns": [
   { "title": "#","data": "id" },
   { "data": "name","title":"Car Name"},
   { "data": "pickup_location_name","title":"Pickup Location"},
   { "data": "dropoff_date","title":"Dropoff Date"},
   { "data": "dropoff_location_name","title":"Dropoff Location"},
   { "data": "traveller_name","title":"Traveller Name"}
   ],
   ajax: {
    url: config.siteUrl+"admin/manage_statistics/today_pick_ups"
  }
}
});
},
init_mng_out_of_hours_fee:function(){

  $("body").on('change','.out_of_hour_filter_js',function()
  {
    _this.refresh_table('tblmng_outofhoursfee');
  });


  $(document).on('switchChange.bootstrapSwitch', '#tblmng_outofhoursfee .make-switch', function() {
    var status = $(this).find(".status_change_js").attr('data-status');
    var offer_id = $(this).attr('data-id');
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_out_of_hours_fee/change_status",
      type: 'POST',
      dataType: 'json',
      data: {
        'offer_id':offer_id
      },
      success: function(response) {
        if ($.fn.DataTable.fnIsDataTable()) {
          $("#tblmng_outofhoursfee").fnDraw(false);
        }
      },
      error: function() {
      }
    })
  });
  var a = new Datatable;
  a.setAjaxParam("location",$("#location").val());
  a.init({
    src: $("#tblmng_outofhoursfee"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "order": [[ 0, "desc" ]],
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "from_location","title":"Location"},
     /*{ "data": "locations","title":"To Locations"},*/
     { "data": "start_date","title":"Start Date"},  
     { "data": "end_date","title":"End Date"}, 
     { "data": "from_time","title":"From Time"}, 
     { "data": "to_time","title":"To Time"}, 
     { "data": "out_of_hour_fee","title":"Fee"},      
     { "data": "status","title":"Status"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"admin/manage_out_of_hours_fee"
    }
  }
});

  $("#tblmng_outofhoursfee").data("a",a);
},
init_mng_out_of_hours_fee_operations:function()
{



  $("body").on('click','.delete_fee_item_empty',function(e){
    e.preventDefault();
    var id = $(this).attr("data-id");
    if(confirm("Are you sure? want to delete?"))
    {
      $("#fee_container_"+id).fadeOut();  
    }
  });

  $("body").on('click','.delete_fee_item',function(e){
    e.preventDefault();
    var id = $(this).attr("data-id");
    if(confirm("Are you sure? want to delete?"))
    {
      $.ajax({
        url: Appad.config.siteUrl + "admin/manage_out_of_hours_fee/delete/"+id,
        type: "POST",
        data: {},
        dataType: "JSON",
        async: true,
        success: function(data) 
        {
          $("#fee_container_"+id).fadeOut();          
        }
      });  
    }
  });

  $("body").on('click','.add_new_fee',function(e){
    e.preventDefault();
    var location_id = $("#locationId").val();

    if(location_id > 0)
    {
      var timestamp = new Date().getUTCMilliseconds();
      var html = '';
      $.ajax({
        url: Appad.config.siteUrl + "admin/manage_out_of_hours_fee/get_html",
        type: "POST",
        data: {
          'timestamp': timestamp,
          'location_id': location_id
        },
        dataType: "JSON",
        async: true,
        success: function(data) 
        {
          $("#out_of_hour_cont").append(data.feehtml);
          $('.date-picker').datepicker('update');
        }
      });
    }
    else
    {
      alert("Please select out of hour fee.");
    }

    /*    
    var controlForm = $(this).parents(".questions_form").find(".questions_cont");;
    controlForm.append(html);
    $('input').iCheck({checkboxClass: 'icheckbox_flat-blue',radioClass: 'iradio_flat-blue'});*/

  });

  $("body").on("change", "#locationId", function(e) {
    e.preventDefault();
    var vartype = $("#out_of_hours_fee_form input[type='radio']:checked").val();
    $.ajax({
      url: Appad.config.siteUrl + "admin/manage_out_of_hours_fee/get_opening_time_from_location",
      type: "POST",
      data: {
        'type': (vartype == 'p') ? 'pickup_location' : 'dropoff_location',
        'location_id': $(this).val()
      },
      dataType: "JSON",
      async: true,
      success: function(data) 
      {
        $(".time_dropdown_js").html(data.time_data);
      }
    });
  });

},
scansLoadMore:function(){
  var scanLoadMore = ($('.loadmore').size() > 0) ? $('.loadmore') : $('.scan-load-more');
  var page = scanLoadMore.attr("data-page");
  var loadmoreurl = scanLoadMore.attr("data-loadmoreurl");
  var loadmoreelm = scanLoadMore.attr("data-elm");
  var loadenable = scanLoadMore.attr("data-loadenable");
  if(String(loadenable)=="false"){
    return;
  }
  scansLoadMore_req = _this.ajax({
    type: 'POST',
    url: loadmoreurl,
    async:false,
    data: { 
      "page":page,      
    },
    beforeSend:function(){
      App.blockUI({
        target: "#"+loadmoreelm,
        animate: !0,
      });
    },
    success: function (data){
      if(data.status == "success")
      {
        App.unblockUI("#"+loadmoreelm);
        $("#"+loadmoreelm).append(data.output);
        scanLoadMore.attr('data-page',data.page);
        scanLoadMore.attr('data-id','');
        if(data.last_page<data.page){
          scanLoadMore.attr('data-loadenable',false);                
        }
      }
    },
    error: function () {    
      App.unblockUI("#"+loadmoreelm); 
    },
    dataType: 'json'
  });
},
initDashboard:function(){
  var dispData ='';
  var dispDataforGraph ='';
  $(document).on('change','.change_graph_data',function(){
    dispDataforGraph = $(this).attr('data-type');
    dispData    = $(this).val();
    _this.initgetChartData(dispData,dispDataforGraph);
  });
  _this.initgetChartData(dispData,dispDataforGraph);
},
change_chart_view:function(inputname,chartDivname){
  jQuery('.'+inputname).off().on('input change',function() {
    var property    = jQuery(this).data('property');
    var target      = chartDivname;
    chartDivname.startDuration = 0;
    if ( property == 'topRadius') {
      target = chartDivname.graphs[0];
      if ( this.value == 0 ) {
        this.value = undefined;
      }
    }
    target[property] = this.value;
    chartDivname.validateNow();
  });
},
initgetChartData:function(dispData,dispDataforGraph){
  if(dispData ==''){
    dispData = 'yearly';
  }
  chart_req = _this.ajax({
    type: 'POST',
    url: _this.config.siteUrl+'admin/dashboard/get_chart_data',
    data: {'dispData':dispData},
    success: function(data){
      var d = new Date();
      var n = d.getFullYear();
      var dispText = 'Month';
      if(dispData == 'yearly'){
        n = n+' Month wise';
      }else{
        n = n+' Month wise';
        var month = new Array();
        month[0] = "January";
        month[1] = "February";
        month[2] = "March";
        month[3] = "April";
        month[4] = "May";
        month[5] = "June";
        month[6] = "July";
        month[7] = "August";
        month[8] = "September";
        month[9] = "October";
        month[10] = "November";
        month[11] = "December";
        n = month[d.getMonth()];
        var dispText = n ;
        n = n+' Month\'s ';
      }
      var totalChartBids = $.parseJSON(data.data); 
      if(dispDataforGraph == 'booking_count' || dispDataforGraph == ''){
        var chart1 = AmCharts.makeChart("chartdiv", {
          "theme": "light",
          "type": "serial",
          "dataProvider":totalChartBids,
          "valueAxes": [{
            "stackType": "3d",
            "unit": "",
            "position": "left",
            "title": n+" Number of Booking",
          }],
          "startDuration": 1,
          "graphs": [
          {
            "balloonText": "Total Booking in [[category]] "+dispText+": <b>[[value]]</b>",
            "fillAlphas": 0.9,
            "lineAlpha": 0.2,
            "title": "Accepted Bids",
            "type": "column",
            "valueField": "total_booking"
          }],
          "plotAreaFillAlphas": 0.1,
          "depth3D": 60,
          "angle": 30,
          "categoryField": "month",
          "categoryAxis": {
            "gridPosition": "start"
          },
          "export": {
            "enabled": true
          }
        });
        _this.change_chart_view('chart_inp_count',chart1);
      }
      if(dispDataforGraph == 'booking_amount' || dispDataforGraph == ''){
        /* chart two */
        /*alert(dispDataforGraph);*/
        var chart2 = AmCharts.makeChart("chartdiv2", {
          "theme": "light",
          "type": "serial",
          "dataProvider":totalChartBids,
          "valueAxes": [{
            "stackType": "3d",
            "unit": "",
            "position": "left",
            "title": n+" Booking Amount",
          }],
          "startDuration": 1,
          "graphs": [
          {
            "balloonText": "Total Booking Amount in [[category]] "+dispText+": <b>  €[[value]]</b>",
            "fillAlphas": 0.9,
            "lineAlpha": 0.2,
            "title": "Amount",
            "type": "column",
            "valueField": "total_price"
          }],
          "plotAreaFillAlphas": 0.1,
          "depth3D": 60,
          "angle": 30,
          "categoryField": "month",
          "categoryAxis": {
            "gridPosition": "start"
          },
          "export": {
            "enabled": true
          }
        });
        _this.change_chart_view('chart_inp_amoutn',chart2);
      }
    },
    error: function () {     
    },
    dataType: 'json'
  });
  _this.addAjaxArray("chartreq",chart_req);
},
initUserlistComet:function(){
  userlistcomet_req = _this.ajax({
    type: 'POST',
    url: _this.config.siteUrl+'message/admin_user_list_comet',
    data: {'timestamp' : _this.config.userlistTimestamp},
    success: function(response){
      _this.config.userlistTimestamp=response['timestamp'];
      if($(".no_rec_found").size()>0)
      {
        $(".no_rec_found").remove();
      }
      $.each(response.output, function( key, value ) {
        if($("#conversation_"+value.key).size() > 0)
        {
          $("#conversation_"+value.key).remove();
        }
        $("#admin_chat_users_cont").prepend(value.val);
      });
      setTimeout(function(){ _this.initUserlistComet() }, 1000); 
    },
    error: function () {     
      setTimeout(function(){ _this.initUserlistComet() }, 1000);
    },
    dataType: 'json'
  });
  _this.addAjaxArray("userlistcomet",userlistcomet_req);
},
initConversationDetailComet:function(conversationId){
  conversation_detail_req = _this.ajax({
    type: 'POST',
    url: _this.config.siteUrl+'message/admin_message_comet',
    data: {'timestamp' : _this.config.conversationMessageTimestamp,'conversationId':conversationId},
    success: function(response){
      _this.config.conversationMessageTimestamp = response['timestamp'];
      $("#conversation_messages").append(response.output.val);
      /*var scrollTo_int = $('#conversation_messages').prop('scrollHeight') + 'px';*/
      /*$('#adminslimscroll').slimScroll({scrollTo : scrollTo_int });*/
     /* $('.slimScrollBar').slimScroll({
        start: 'bottom'
      });*/

   /*App.destroySlimScroll("#conversation_messages");
   $('#conversation_messages').slimScroll({scrollTo : scrollTo_int });*/
   setTimeout(function(){ _this.initConversationDetailComet(conversationId) }, 1000); 
 },
 error: function (a,b) {
  if(a.statusText != "abort"){
    setTimeout(function(){ _this.initConversationDetailComet(conversationId) }, 1000);
  }
},
dataType: 'json'
});
  _this.addAjaxArray("conversationDetailComet",conversation_detail_req);
},
init_message_methods:function(){
  _this.scansLoadMore();
  /*_this.initUserlistComet();*/
  $('#message').keypress(function (e) {
    if (e.which == 13) {
      $("#send_message_admin").click();
      return false;
    }
  });
  $("body").on('click','#send_message_admin',function(){
    conversation_id  = $(this).attr("data-id");
    toId  = $(this).attr("data-toid");
    var message = $("#message").val();
    _this.ajax({
      type: 'POST',
      url: _this.config.siteUrl+"message/add_message",
      async:false,
      data: { 
        "conversation_id":conversation_id,      
        "message":message,   
        "admin":"yes",   
        "toId":toId   
      },
      beforeSend:function(){
        App.blockUI({
          target: "#conversation_messages",
          animate: !0,
        });
      },
      success: function (data){
        if(data.status == "success")
        {
          App.unblockUI("#conversation_messages");
          $("#message").val("");
          $('#message').focus();
          /* alert("success");         */
        }
      },
      error: function () {    
        App.unblockUI("#loadmoreelm"); 
      },
      dataType: 'json'
    });
  });
  $("body").on('click','.conversation_detail',function(){
    $("#conversation_messages").html("");
    var conversation_id  = $(this).attr("data-id");
    var fromId = $(this).attr("data-fromId");
    $("#conversation_unread_count_"+conversation_id).html("");
    $("#send_message_admin").attr("data-id",conversation_id);
    $("#send_message_admin").attr("data-toid",fromId);
    _this.abortajax("conversationDetailComet");
    $('.page-quick-sidebar-wrapper').find(".page-quick-sidebar-chat").addClass("page-quick-sidebar-content-item-shown");
    _this.config.conversationMessageTimestamp = 0;
    _this.initConversationDetailComet(conversation_id);
   /* _this.ajax({
      type: 'POST',
      url: _this.config.siteUrl+"message/conversation_detail/"+conversation_id,
      async:false,
      data: { 
        "conversation_id":conversation_id,      
      },
      beforeSend:function(){
        App.blockUI({
          target: "#conversation_messages",
          animate: !0,
        });
      },
      success: function (data){
        if(data.status == "success")
        {
          App.unblockUI("#conversation_messages");
          $("#conversation_messages").html(data.output);
          $("#send_message_admin").attr("data-id",conversation_id);
          $("#send_message_admin").attr("data-toid",data.fromId);
          $('.page-quick-sidebar-wrapper').find(".page-quick-sidebar-chat").addClass("page-quick-sidebar-content-item-shown");
          _this.conversationMessageTimestamp = Math.round(+new Date()/1000);
          _this.initConversationDetailComet(conversation_id);
        }
      },
      error: function () {    
        App.unblockUI("#loadmoreelm"); 
      },
      dataType: 'json'
    });*/
  });
},
init_common_methods:function(){
  $("body").on('change','#country',function(e,state,city){
    country_id = $(this).val();
    $.ajax({
      url: Appad.config.siteUrl + "common_methods/get_states",
      type: 'POST',
      dataType: 'json',
      data: {
        'country_id':country_id
      },
      success: function(response) {
       $("#state").html(response.html);   
       
       if(state!='')
       {
        $("#state").val($("#state option").filter(function() {
          return this.text.toLowerCase() == state.toLowerCase() 
        }).val());
        $("#state").trigger('change',[city]);
      }
    },
    error: function() {
    }
  })
  });
  $("body").on('change','#state',function(e,city){
    state_id = $(this).val();
    $.ajax({
      url: Appad.config.siteUrl + "common_methods/get_cities",
      type: 'POST',
      dataType: 'json',
      data: {
        'state_id':state_id
      },
      success: function(response) {
        $("#city").html(response.html);     
        if(city!='')
        {
          if($("#city_name").length > 0)
          {
            $("#city_name").val(city);
          }

          if($("#city_dropDown").length > 0)
          {
            $("#city_dropDown").val($("#city_dropDown option").filter(function() {
              return this.text.toLowerCase() == city.toLowerCase() 
            }).val());
          }

          if($("#city").length > 0)
          {
            $("#city").val($("#city option").filter(function() {
              return this.text.toLowerCase() == city.toLowerCase() 
            }).val());
          }
        }
      },
      error: function() {
      }
    });
  });
  $("body").on('change','#groupId',function(){
    group_id = $(this).val();
    $.ajax({
      url: Appad.config.siteUrl + "common_methods/get_categories",
      type: 'POST',
      dataType: 'json',
      data: {
        'group_id':group_id
      },
      success: function(response) {
       $("#categoryId").html(response.html);       
     },
     error: function() {
     }
   });
  });
  $("body").on('change','#groupIdCars',function(){
    group_id = $(this).val();
    $.ajax({
      url: Appad.config.siteUrl + "common_methods/get_cars_from_groups",
      type: 'POST',
      dataType: 'json',
      data: {
        'group_id':group_id
      },
      success: function(response) {
       $("#cars").html(response.html);       
     },
     error: function() {
     }
   });
  });
} 
}
jQuery(document).ready(function() {
  Appad.init(config)
});