var requests = {};
var bookingmail_car_id;
var pickup_location_objects = [];
var pickup_location_map = {};

var dropoff_location_objects = [];
var dropoff_location_map = {};

var Appfd = {
  config: {
    siteUrl: 'http://localhost/nova/',
    AssetUrl: 'http://localhost/nova/assets/',
    messageTimestamp:0,
  },
  init: function(config) {
    _this = this;
    $.extend(_this.config, config);
    _this.initCommonPlugins();
    _this.initRemoteModal();
    _this.handleGoTop();    
    if(Appfd.config.isUserLoggedIn == true)
    {
      _this.initMessageComet();
    }
  },
  handleGoTop:function () {
    var offset = 300;
    var duration = 500;

    if (navigator.userAgent.match(/iPhone|iPad|iPod/i)) {  
      $(window).bind("touchend touchcancel touchleave", function(e){
       if ($(this).scrollTop() > offset) {
        $('.scroll-to-top').fadeIn(duration);
      } else {
        $('.scroll-to-top').fadeOut(duration);
      }
    });
    } else {  
      $(window).scroll(function() {
        if ($(this).scrollTop() > offset) {
          $('.scroll-to-top').fadeIn(duration);
        } else {
          $('.scroll-to-top').fadeOut(duration);
        }
      });
    }

    $('.scroll-to-top').click(function(e) {
      e.preventDefault();
      $('html, body').animate({scrollTop: 0}, duration);
      return false;
    });
  },
  displayMsg:function(msgText){
    $(".disp-js-msg").show();
    $(".js-msg-text").html(msgText);
    setTimeout(function(){ $(".disp-js-msg").hide(); }, 3000);
  },
  ajax: function(objConfig) {
    return $.ajax({
      type: objConfig.type, 
      url: objConfig.url,
      context:(objConfig.context != undefined)?objConfig.context:{},
      beforeSend:function(xhr,settings){
        if (settings.context != undefined && !jQuery.isEmptyObject(settings.context)  && settings.context.hasClass('btn_loading')) {
          settings.context.button('loading');
        }
        (objConfig.beforeSend != undefined)?objConfig.beforeSend(xhr,settings):'';
      }, 
      headers: (objConfig.headers != undefined)?objConfig.headers:{}, 
      async: (objConfig.async != undefined)?objConfig.async:true,
      data : (objConfig.data != undefined)?objConfig.data:{},
      dataType : (objConfig.dataType != undefined)?objConfig.dataType:'json',
      cache: (objConfig.cache != undefined)?objConfig.cache:true,
      contentType: (objConfig.contentType != undefined)?objConfig.contentType:'application/x-www-form-urlencoded',
      success: function(data) {
        objConfig.success(data);
      },
      error: function(data, textStatus, jqXHR) {
        objConfig.error(data, textStatus, jqXHR)   
      },
      complete:function(){
        if(typeof this.button != "undefined"){
          this.button('reset');  
        }
      }
    });
},
abortajax:function(name){

  if(typeof(requests[name])!="undefined"){
    $.each(requests[name],function(k,v){
      v.abort();
    });
  }
},
addAjaxArray:function(name,req){
  if(typeof requests[name] == "undefined")
  {
    requests[name] = [];
  }
  requests[name].push(req);
},
initMessageComet:function(){
  message_comet_req = _this.ajax({
    type: 'POST',
    url: _this.config.siteUrl+'message/user_message_comet',
    data: {'timestamp' : _this.config.messageTimestamp},
    success: function(response){
      _this.config.messageTimestamp=response['timestamp'];
      $("#conversation_messages").append(response.output.val);
      setTimeout(function(){ _this.initMessageComet() }, 1000); 
    },
    error: function () {     
      setTimeout(function(){ _this.initMessageComet() }, 1000);
    },
    dataType: 'json'
  });
},
init_mybooking_list:function()
{
  $('body').on("click",'.cancel_booking',function(e)
  {
    e.preventDefault();
    if(confirm("Are you sure want to cancel booking?"))
    {
      href = $(this).attr("href");
      _this.ajax({
        type: 'POST',
        url: href,
        data: {},
        success: function(response)
        {
          $("#js_message").html("");
          if(response.status == "success")
          {
            $("#js_message").removeClass("hide").addClass("alert-success");
          }
          else
          {
           $("#js_message").removeClass("hide").addClass("alert-danger"); 
         }
         $("#js_message").append(response.msg);
         $("#tblmng_mybooking_list").DataTable().ajax.reload();
       },
       error: function () {     
       },
       dataType: 'json'
     });
    }
  });

  var a = new Datatable;
  a.init({
    src: $("#tblmng_mybooking_list"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "aoColumns": [
     { "title": "#","data": "id" },
     { "data": "booking_status","title":"Status"},  
     { "data": "name","title":"Car Name"},
     { "data": "pickup_date","title":"Pickup Date"},
     { "data": "dropoff_date","title":"Dropoff Date"},
     { "data": "booking_price","title":"Booking Price"},
     { "data": "operation","searchable": false,"sortable":false}
     ],
     ajax: {
      url: config.siteUrl+"dashboard/mybooking"
    }
  }
});
  $("#manage_faq").data("a",a);




},
initBookingPriceUpdateCall:function()
{
  car_id = $("#car_id").val();
  var current_insurance_index=$('input[name=insuranceGroupId]:checked').parents(".commoncol").index();
  $(".commoncol").removeClass('active');
  $(".package ul").each(function(){
    $(this).find("li").eq(current_insurance_index).addClass('active');
  })


  $(".extrabox").removeClass('active');
  $(".qty").each(function(){
    if($(this).val()>0){
      $(this).parents(".extrabox").addClass('active')
    }
  });
  $('.recomm-extras .groupcheck:checked').each(function(){
   $(this).parents(".extrabox").addClass('active');
 });
  booking_change_request = _this.ajax({
    type: 'POST',
    url: _this.config.siteUrl+"booking/"+car_id,
    data: $("#booking_form").serialize(),
    beforeSend:function(){
     App.blockUI({
      target: ".totalbox",
      animate: !0,
    });
   },
   success: function(response)
   {
    App.unblockUI(".totalbox");
    $("#price_view_render_cont").html(response.price_view_render);
    $("#pickup_location_nm_disp").html(response.pickup_location_nm);
    $("#pickup_date_disp").html(response.pickup_date);
    $("#pickup_time_disp").html(response.pickup_time);
    $("#dropoff_location_nm_disp").html(response.dropoff_location_nm);
    $("#dropoff_date_disp").html(response.dropoff_date);
    $("#dropoff_time_disp").html(response.dropoff_time);

    if(response.booking_msg == "")
    {
      $("#booking_notification").remove();
    }
    else if(response.booking_msg != "")
    {
     if($("#booking_notification").size()==0)
     {
       var not_html = '<div id="booking_notification"><div class="alert alert-'+response.booking_msg_classnm+'">'+response.booking_msg+'</div></div>';
       $("#booking_not_cont").append(not_html);
     } 
   }
   /*enable disable button submit*/
   if(response.booking_btn_disabled == true)
   {
     $("#booking_btn_confirm").prop("disabled",true);
   }
   else
   {
     $("#booking_btn_confirm").prop("disabled",false);
   }
   /*enable disable button submit*/

   if(response.lock_id != '')
   {
     $("#groupcheck_radio_"+response.lock_id).iCheck('check'); 
     $('.groupcheck_radio:not(#groupcheck_radio_'+response.lock_id+')').iCheck('disable');     
     $('input[name=insuranceGroupId]:not(#groupcheck_radio_'+response.lock_id+')').attr("disabled",true);
   }
   else
   {
     $('input[name=insuranceGroupId]').attr("disabled",false);
     $('.groupcheck_radio').iCheck('enable');
   }
 },
 error: function () {     
 },
 dataType: 'json'
});  
},
initGetPrice:function()
{
  /*var ids=[]; 
  $('.groupcheck:checked').each(function(){
    ids.push($(this).val());
  });
  var insuraince_val = '';
  insuraince_val = $('input[name=insurance_detail]:checked').val();
  */


  _this.initBookingPriceUpdateCall();
},

initBookingDetail:function(){
 $("body").on("click", "#facilities_extra_disp", function(e) {
  $(".extra_hidden_cont").removeClass("hide").fadeIn();
});
},
init_editprofile:function(){
  $(".phone_no").intlTelInput({ 
    utilsScript: _this.config.siteUrl + "assets/plugins/intl-tel-input-master/build/js/utils.js"
  });
},
initChangePhoneCountry:function()
{

  if($("#contactNo").val() == '')
  {
    $(".phone_no").intlTelInput("setCountry",config.default_country_iso);  
  }
  
  $("body").on('change','#country',function()
  {
    country_iso = $(this).find("option:selected").attr("data-iso");
    $(".phone_no").intlTelInput("setCountry",country_iso);
    var getCode = $(".phone_no").intlTelInput('getSelectedCountryData').dialCode;
    $("#phone_extension").val(getCode);
  });

  $("body").on("countrychange",".phone_no", function(e, countryData) {
    console.log(countryData);
  });

  $(".phone_no").on("blur keyup change", function() {
    var getNumber = $(".phone_no").intlTelInput("getNumber");
    $("#contactNo").val(getNumber);
    $("#contact_number").val(getNumber);     
  });

  $(document).on("click","#country",function(){
    if($(this).val() == '') {
      var getCode = $(".phone_no").intlTelInput('getSelectedCountryData').dialCode;
      $("#phone_extension").val(getCode); 
    }
  });
},

initExtraHeightSet:function(){
  var maxHeight = 0;
  $('.facility_select .extrabox')
  .each(function() { maxHeight = Math.max(maxHeight, $(this).height()); })
  .height(maxHeight).css("min-height",maxHeight);
  var maxwidth = 0;
},
init_special_offer_operations:function()
{
  var maxHeight = 0;
  $('.offers .specialoffer .offerbox')
  .each(function() { maxHeight = Math.max(maxHeight, $(this).height()); })
  .height(maxHeight).css("min-height",maxHeight);
},
initBookingOperation:function()
{
  _this.initExtraHeightSet();

  $("body").on('click','.change_button_last_step_js',function(e){
    e.preventDefault();
    $("#booking_update").click();

  });

  $('#date_of_birth').datepicker({
    defaultDate: config.pickup_date_js,
    numberOfMonths: 1,
    firstDay: 1,
    dateFormat: 'yy-mm-dd',
    showAnim: '',
    changeMonth: true,
    changeYear: true,
    yearRange: config.birth_start_year+':'+config.birth_end_year,
    maxDate: "-18Y",
    beforeShow: function() {
      $('#date_of_birth').addClass('active');    
    },
    onSelect: function(dateStr) 
    {
      _this.initGetPrice();
    },
    onClose: function() {
      $('#date_of_birth').removeClass('active');
    }
  });
  

  $("body").on('click','#remove_coupon_btn',function(){

    $("#coupon_code_val").val('');
    _this.ajax({
      type: 'POST',
      url: _this.config.siteUrl+'common_methods/remove_coupon',
      data: {},
      success: function(response){
        if(response.status == "success")
        {
          $("#coupon_code").val("");
          toastr.success(response.msg);
          $("#remove_coupon_btn").attr("id","apply_coupon_btn");
          $("#apply_coupon_btn").html("Apply");
        }
        else
        {
          toastr.error(response.msg); 
        }
        _this.initGetPrice();
      },
      error: function () {     
      },
      dataType: 'json'
    });
  });

  $("body").on('click','#apply_coupon_btn',function(){
    var coupon_code = $("#coupon_code").val();
    var car_id = $("#car_id").val();
    

    if(coupon_code != '' && car_id != '')
    {
      $("#coupon_code_val").val(coupon_code);
      _this.ajax({
        type: 'POST',
        url: _this.config.siteUrl+'common_methods/check_coupon_exist/'+car_id,
        /* data: {"coupon_code":coupon_code,"pickup_date":pickup_date},*/
        data: $("#booking_form").serialize(),
        beforeSend:function(){
         App.blockUI({
          target: ".totalbox",
          animate: !0,
        });
       },
       success: function(response){
        App.unblockUI(".totalbox");
        if(response.status == "success")
        {
          toastr.success(response.msg);
          $("#apply_coupon_btn").attr("id","remove_coupon_btn");
          $("#remove_coupon_btn").html("Remove");
        }
        else
        {
          toastr.error(response.msg); 
        }
        _this.initGetPrice();
      },
      error: function () {     
      },
      dataType: 'json'
    });
    }
    else{
      toastr.error("Either coupon code or pickup date is invalid.");
    }

    
  });


$('#pickup_date').datepicker({
  defaultDate: config.pickup_date_js,
  numberOfMonths: 2,
  firstDay: 1,
  dateFormat: 'yy-mm-dd',
  minDate: '+1',
  maxDate: '+'+Appfd.config.max_date_js+'M',
  showAnim: '',
  beforeShow: function() {
    $('#pickup_date').addClass('active');    
  },
  onSelect: function(dateStr) 
  {
    var d1 = $(this).datepicker("getDate");
    d1.setDate(d1.getDate());
    $("#dropoff_date").datepicker("option", "minDate", d1);
  },
  onClose: function() {
    $('#pickup_date').removeClass('active');
  }
});

var min_d2 = $('#pickup_date').datepicker("getDate");

$('#dropoff_date').datepicker({
  defaultDate: config.dropoff_date_js,
  numberOfMonths: 2,
  firstDay: 1,
  dateFormat: 'yy-mm-dd',
  minDate: min_d2,
  maxDate: '+'+Appfd.config.max_date_js+'M',
  showAnim: '',
  beforeShow: function() {
    $('#dropoff_date').addClass('active');    
  },
  onClose: function() {
    $('#dropoff_date').removeClass('active');
  }
});

$(".phone_no").intlTelInput({ 
  utilsScript: _this.config.siteUrl + "assets/plugins/intl-tel-input-master/build/js/utils.js"
});

/*$(".phone_no").on("blur keyup change", function() {
  if($(this).val() == '') {
    var getCode = $(".phone_no").intlTelInput('getSelectedCountryData').dialCode;
    $("#phone_extension").val(getCode); 
  }
});
$(document).on("click","#country",function(){
  if($(this).val() == '') {
    var getCode = $(".phone_no").intlTelInput('getSelectedCountryData').dialCode;
    $("#phone_extension").val(getCode); 
  }
});*/

$("body").on('keyup','.phone_no',function(){
  /*var extension = $(".phone_no").intlTelInput("getExtension");*/
  /*var intlNumber = $(".phone_no").intlTelInput("getNumber");*/
  /*console.log(extension);*/
  /*$("#phone_extension").val(extension);  */
});

if ($(".selectcheck").length > 0) {
 $('.selectcheck').each(function() {
  $(this).iCheck('check'); 
  _this.initBookingPriceUpdateCall();     
});
}

 /*$('body').on("click",'.clear_insurance',function(e){
   e.preventDefault();
   $(".groupcheck_redio").iCheck('uncheck'); 
   $(".clear_insurance").hide();
   _this.initBookingPriceUpdateCall(); 
 });*/

/*$("body").on("click", "#booking_update", function(e) {
  e.preventDefault();
  _this.initBookingPriceUpdateCall(); 
  _this.addAjaxArray("bookingchangerequest",booking_change_request);  
});*/

$("body").on("change", ".qty", function(e) {
  e.preventDefault();
  _this.initBookingPriceUpdateCall(); 
  _this.addAjaxArray("bookingchangerequest",booking_change_request);  
});


$('.qtyplus').click(function(e){
  e.preventDefault();
  fieldName = $(this).attr('field');
  var currentVal = parseInt($('input[name='+'"'+fieldName+'"'+']').val());
  var max_value = parseInt($('input[name='+'"'+fieldName+'"'+']').attr("max"));
  if (!isNaN(currentVal) && (max_value != 'undefined' && currentVal < max_value)) 
  {
    $('input[name='+'"'+fieldName+'"'+']').val(currentVal + 1);
  } 
  else 
  {
    /*$('input[name='+'"'+fieldName+'"'+']').val(0);*/
  }
  _this.initGetPrice();
});

$(".qtyminus").click(function(e) {
  e.preventDefault();
  fieldName = $(this).attr('field');
  var currentVal = parseInt($('input[name='+'"'+fieldName+'"'+']').val());
  if (!isNaN(currentVal) && currentVal > 0) {
    $('input[name='+'"'+fieldName+'"'+']').val(currentVal - 1);
  } else {
    $('input[name='+'"'+fieldName+'"'+']').val(0);
  }
  _this.initGetPrice();
});

$("body").on("click", "#facilities_extra_disp", function(e) {

  if($(".extra_hidden_cont").hasClass("hide"))
  {
    html_text = $(this).attr("data-less");
    btn_class = "lessbtn";
  } 
  else
  {
    html_text = $(this).attr("data-more");
    btn_class = "morebtn";
  }
  $(".extra_hidden_cont").toggleClass("hide");
  $("#extra_operation_btns").html(html_text);
  $("#extra_operation_btns").removeClass().addClass(btn_class);
  _this.initExtraHeightSet();

});

if($(".groupcheck").length > 0)
{

  $('body').on('ifChecked','.groupcheck', function(event){
    event.preventDefault();
    var temp = _this.initGetPrice();
    if(temp == false){
      $(this).iCheck('uncheck');        
    }else{
      $(this).iCheck('check');    
    }
    $(this).parents(".extracol").addClass("active");
  });
  $('body').on('ifUnchecked','.groupcheck', function(event){
    temp2 = _this.initGetPrice()
    if(temp2 == false){
    }
    $(this).parents(".extracol").removeClass("active");
  });
}

if ($(".groupcheck_redio").length > 0) {
 $('.groupcheck_redio').each(function() {
  if($(this).attr("checked") !== undefined) {
    $(this).iCheck('check');
    _this.initGetPrice();
  }

});

 /*$('body').on("click", '.clear_insurance', function() {
  $(".groupcheck_redio").iCheck('uncheck');
  $(".clear_insurance").hide();
  _this.initGetPrice();
});*/
$('body').on('ifChecked', '.groupcheck_redio', function(event) {
  event.preventDefault();
  _this.initGetPrice();
  $(".commonpackage").removeClass('selectedpackage');
  $(this).parents(".commonpackage").addClass('selectedpackage');
  $(".clear_insurance").show();
});
}
},
initCarSearchFormCommon:function()
{
  $("body").on("click", ".loadmore", function(e) {
    _this.LoadMore();
  });

  if($("#pickup_date").length > 0 || $("#dropoff_date").length > 0 ){
    /*var dates = $('#pickup_date').datepicker({
      "autoclose":true,
      "todayHighlight":true,
      startDate: "today",
      maxDate: "+2Y",
      nextText: "",
      prevText: "",
      numberOfMonths: 2
    }).on("changeDate", function(selected){
      startDate = new Date(selected.date.valueOf());
      startDate.setDate(startDate.getDate(new Date(selected.date.valueOf())));
      $("#dropoff_date").datepicker("setStartDate", startDate);
    }); 
    $("#dropoff_date").datepicker({
      "autoclose":true,
      "todayHighlight":true,
      startDate: "today",
      maxDate: "+2Y",
      nextText: "",
      prevText: "",
      numberOfMonths: 3
    });*/



    /*$("#same_as").change(function() {
      var tmp = $("#pickup_location option:selected").val();
      $("#dropoff_location option[value=" + tmp + "]").attr("selected", "selected");
      if ($("#same_as").is(':checked')) {
        $('.dropoff_checked span').show();
        $('.dropoff_loc').hide();
        temp = $("#pickup_time").html();
        $("#dropoff_time").html(temp);
      } else {
        $('.dropoff_checked span').hide();
        $('.dropoff_loc').show();
      }
    });*/

$('#pickup_date').datepicker({
  numberOfMonths: 2,
  firstDay: 1,
  dateFormat: 'yy-mm-dd',
  minDate: '+1',
  maxDate: '+'+Appfd.config.max_date_js+'M',
  showAnim: '',
  beforeShow: function() {
    $('#pickup_date').addClass('active');    
  },
  onSelect: function(dateStr) 
  {
    var d1 = $(this).datepicker("getDate");
    d1.setDate(d1.getDate());
    $("#dropoff_date").datepicker("option", "minDate", d1);
  },
  onClose: function() {
    $('#pickup_date').removeClass('active');
  }
});

var min_d2 = $('#pickup_date').datepicker("getDate");

$('#dropoff_date').datepicker({
  defaultDate: new Date(),
  numberOfMonths: 2,
  firstDay: 1,
  dateFormat: 'yy-mm-dd',
  minDate: min_d2,
  maxDate: '+'+Appfd.config.max_date_js+'M',
  showAnim: '',
  beforeShow: function() {
    $('#dropoff_date').addClass('active');    
  },
  onClose: function() {
    $('#dropoff_date').removeClass('active');
  }
});


}

$("body").on("click", "#searchsubmit", function(e) {
  e.preventDefault();
  _this.abortajax("searchrequest");

  var search_url_p = "search/?";
  if($(this).hasClass("fleetguide_search"))
  {
    var search_url_p = "fleetlist/?";
  }

  search_request = _this.ajax({
    type: 'GET',
    url: _this.config.siteUrl+search_url_p,
    data: $("#searchfilterform").serialize(),
    beforeSend:function(){
      App.blockUI({
        animate: !0
      });
    },
    success: function(response){

     $("#search_records").html(response.output);
     App.unblockUI();  
     $("#founded_car_counter").html(" "+response.search_results_total_counter);

     if(response.high_notification_type == "" && response.high_notification_msg == "")
     {
      $("#high_period_notification").remove();
    }else if(response.high_notification_type != "" && response.high_notification_msg != ""){

     if($("#high_period_notification").size()==0)
     {
       var not_html = '<div id="high_period_notification"><div class="alert alert-'+response.high_notification_classnm+'">'+response.high_notification_msg+'</div></div>';
       $("#high_period_not_cont").append(not_html);
     } 
   }  

   if(response.search_results_total_counter == 0 || response.last_page<=response.page)
   {
    $(".loadmore").fadeOut();
  }
  else
  {
    if($(".loadmore").size() == 0)
    {
      var btn_html = '<div class="row"><div class="col-md-3"></div><div class="col-md-6"><button class="loadmore btn rednova btn-block" data-loadmoreurl="'+Appfd.config.siteUrl+"search/index"+'" data-elm="search_records" data-form="searchfilterform" data-requesttype="GET" data-loadenable="true" data-page="2">Loadmore</button></div><div class="col-md-3"></div></div>';
      $("#loadmore_cont").append(btn_html);
    }
    $(".loadmore").fadeIn().attr("data-page",2);
    $(".loadmore").attr("data-loadenable",true);
  }
  App.initAjax();


},
error: function () {     
},
dataType: 'json'
});

_this.addAjaxArray("searchrequest",search_request);



});

$("body").on("click", ".searchfilter", function(e) 
{
  if($(this).hasClass("sortingtypes"))
  {
    $("#sorting").val($(this).attr("data-val"));
    $(".sortingtypes").removeClass("active");
    $(this).addClass("active");
  }
  if($(this).hasClass("cargrouptypes"))
  {
    if($(this).hasClass('filteractivejs'))
    {
      $("#group").val(0);
      $(".inner-item").removeClass("active");
      $(this).removeClass("filteractivejs");  
    }
    else
    {
      $("#group").val($(this).attr("data-val"));
      $(".inner-item").removeClass("active");
      $(this).parents(".inner-item").addClass("active");  
      $(this).addClass("filteractivejs");  
    }


  }
  $("#searchsubmit").click();
});



$('body').on('ifChecked','.checksearch', function(event)
{
  $(this).iCheck('check'); 
  $("#searchsubmit").click();
});

$('body').on('ifUnchecked','.checksearch', function(event){
  $(this).iCheck('uncheck'); 
  $("#searchsubmit").click();
}); 



},
init_home_operations:function(){

 $( ".inline_menu li" ).each(function() {
  height = $(this).find("a").outerHeight();
  $(this).height(height);  

}); 



/* $('body').on('ifUnchecked','.driver_age_checkbox', function(event){
  $("#driver_age_field_cont").removeClass("hide").fadeIn();
  $(this).iCheck('uncheck');
  
}); */


$('body').on('ifChecked','.driver_age_checkbox', function(event){
  $("#driver_age_field_cont").fadeOut(function(){
    $(this).iCheck('check');
  });  

});

$('body').on('ifUnchecked','.driver_age_checkbox', function(event){


 $("#driver_age_field_cont").fadeIn('slow',function(){
  $(this).iCheck('uncheck'); 
});


}); 




$('body').on('click','#cancel_extra', function(event){
 $("#driver_age_field_cont").fadeOut(function(){
  $("#driver_age_checkbox_cont").fadeIn();
  $(this).addClass("hide");
  $(".driver_age_checkbox").iCheck('check'); 
});



});

 /*var dates = $('#pickup_date').datepicker({
  "autoclose":true,
  "todayHighlight":true,
  startDate: "today",
  maxDate: "+2Y",
  nextText: "",
  prevText: "",
  numberOfMonths: 2
}).on("changeDate", function(selected){
  startDate = new Date(selected.date.valueOf());
  startDate.setDate(startDate.getDate(new Date(selected.date.valueOf())));
  $("#dropoff_date").datepicker("setStartDate", startDate);
}); 
$("#dropoff_date").datepicker({
  "autoclose":true,
  "todayHighlight":true,
  startDate: "today",
  maxDate: "+2Y",
  nextText: "",
  prevText: "",
  numberOfMonths: 3
});*/


/*custom*/
$('#pickup_date').datepicker({
  defaultDate: new Date(),
  numberOfMonths: 2,
  firstDay: 1,
  dateFormat: 'yy-mm-dd',
  minDate: "+1",
  maxDate: '+'+Appfd.config.max_date_js+'M',
  showAnim: '',
  beforeShow: function() {
    $('#pickup_date').addClass('active');    
  },
  onSelect: function(dateStr) {

    var d1 = $(this).datepicker("getDate");
    d1.setDate(d1.getDate());
    $("#dropoff_date").datepicker("option", "minDate", d1);
  },
  onClose: function() {
   $('#pickup_date').removeClass('active');
 }
});
$('#dropoff_date').datepicker({
  defaultDate: new Date(),
  numberOfMonths: 2,
  firstDay: 1,
  dateFormat: 'yy-mm-dd',
  maxDate: '+'+Appfd.config.max_date_js+'M',
  showAnim: '',
  beforeShow: function() {
    $('#dropoff_date').addClass('active');    
  },
  onClose: function() {
    $('#dropoff_date').removeClass('active');
  }
});
/*custom ends*/




$('#video-part .carousel').carousel({
  interval: 7000,
  pause: false
});

$('body').on('ifChecked','#same_as', function(event)
{
  $('#dropbox').show();
  $(this).iCheck('check'); 
});

$('body').on('ifUnchecked','#same_as', function(event){
  $('#dropbox').hide();
  $(this).iCheck('uncheck'); 
  var tmp = $("#pickup_location option:selected").val();
  $('#dropoff_location').val(tmp).change();
}); 

$('body').on('ifChecked','#coupon', function(event){

  $("#coupon_apply_cont").fadeIn('slow',function(){
    $(this).iCheck('check'); 
  });
});

$('body').on('ifUnchecked','#coupon', function(event){
  $("#coupon_apply_cont").fadeOut(function(){
    $(this).iCheck('uncheck');
  });  
}); 
  /*$("body").on('change','#coupon',function(){
   val = $('#coupon:checked', '#searchform').val();
   if(val == '1')
   {
    $("#coupon_apply_cont").removeClass('hide');
  }else{
    $("#coupon_apply_cont").addClass('hide');
  } 
});*/

$("body").on('click','#apply_coupon_btn',function(){
  var coupon_code = $("#coupon_code").val();
  _this.ajax({
    type: 'POST',
    url: _this.config.siteUrl+'common_methods/check_coupon_exist',
    data: {"coupon_code":coupon_code},
    beforeSend:function(){
     App.blockUI({
      target: ".totalbox",
      animate: !0,
    });
   },
   success: function(response){
    App.unblockUI({
      target: ".totalbox",
      animate: !0,
    });
    if(response.status == "success")
    {
      toastr.success(response.msg);
    }
    else{

     toastr.error(response.msg); 
   }

 },
 error: function () {     
 },
 dataType: 'json'
});


});




},
initSearchCommon:function(){
  if($("#price_slider").size() > 0)
  {
    slider = $("#price_slider").slider();
    slider.on("slide", function(slideEvt) {
      $("#min_price").val(slideEvt.value[0]);
      $("#max_price").val(slideEvt.value[1]);  
      $("#searchsubmit").click();
    });  
  }

  if($(".vechiclesbox").size() > 0)
  {
    var owl = $("#owl-demo");
    owl.owlCarousel({
      itemsCustom : [
      [0, 2],
      [480, 3],
      [640, 4],
      [768, 3],
      [992, 5]
      ],
      navigation : true
    });  
  }

  $("body").on('click','.send_bookingmail_info_js',function(){
   bookingmail_car_id = $(this).attr("data-carid");
 });

  $("body").on("click", "#sendbookingmail", function(e) {
    e.preventDefault();

    if($("#send_booking_request").valid())
    {
      $("#sendbookingmail").attr('disabled',true);
      var email_id = $("#useremail_booking_info").val();
      var pickup_location = $("#pickup_location").val();
      var pickup_date = $("#pickup_date").val();
      var pickup_time = $("#pickup_time").val();
      var dropoff_location = $("#dropoff_location").val();
      var dropoff_date = $("#dropoff_date").val();
      var dropoff_time = $("#dropoff_time").val();
      send_booking_info_request = _this.ajax({
        type: 'POST',
        url: _this.config.siteUrl+'search/sendbookinginfo',
        data: {"car_id":bookingmail_car_id,"email_id":email_id,"pickup_location":pickup_location,"pickup_date":pickup_date,"pickup_time":pickup_time,"dropoff_location":dropoff_location,"dropoff_date":dropoff_date,"dropoff_time":dropoff_time},
        success: function(response){
          $("#js_message").html("");
          if(response.status == "success")
          {
            $("#js_message").removeClass("hide").addClass("alert-success");
          }
          else{
           $("#js_message").removeClass("hide").addClass("alert-danger"); 
         }
         $("#js_message").append(response.msg);
         $(".close").click();
         $("#sendbookingmail").attr('disabled',false);
       },
       error: function () {     
       },
       dataType: 'json'
     });
      _this.addAjaxArray("send_booking_info_request",send_booking_info_request);
    }

    
  });
},

initContentOperations:function()
{
  if($("#pickup_date").length > 0 || $("#dropoff_date").length > 0 ){

    $('#pickup_date').datepicker({
      numberOfMonths: 2,
      firstDay: 1,
      dateFormat: 'yy-mm-dd',
      minDate: '+1',
      maxDate: '+'+Appfd.config.max_date_js+'M',
      showAnim: '',
      beforeShow: function() {
        $('#pickup_date').addClass('active');    
      },
      onSelect: function(dateStr) 
      {
        var d1 = $(this).datepicker("getDate");
        d1.setDate(d1.getDate());
        $("#dropoff_date").datepicker("option", "minDate", d1);
      },
      onClose: function() {
        $('#pickup_date').removeClass('active');
      }
    });
    $('#dropoff_date').datepicker({
      defaultDate: new Date(),
      numberOfMonths: 2,
      firstDay: 1,
      dateFormat: 'yy-mm-dd',
      maxDate: '+'+Appfd.config.max_date_js+'M',
      showAnim: '',
      beforeShow: function() {
        $('#dropoff_date').addClass('active');    
      },
      onClose: function() {
        $('#dropoff_date').removeClass('active');
      }
    });


  }
},
change_dropoff_pickup_time:function(type,val){
  var same_as = $(type).attr("data-sameas");
  $.ajax({
    url: Appfd.config.siteUrl + "common_methods/get_opening_time_from_location",
    type: "POST",
    data: {
      'type': type,
      'location_id': val
    },
    dataType: "JSON",
    async: true,
    success: function(data) {
      if (type == 'pickup_location') {
        $("#pickup").html(data.time_data);
      } else {
        $("#dropoff").html(data.time_data);
      }
      if (typeof same_as != "undefined" && !$("#same_as").is(':checked') && same_as != "false") {
        temp = $("#pickup_time").html();
        $("#dropoff_time").html(temp);
        var tmp = $("#pickup_location option:selected").val();
        $("#dropoff_location").val(tmp).change();      
        /*$("#dropoff_location option[value=" + tmp + "]").attr("selected", "selected")*/   
      }
    }
  });

},
location_typeahead_suggestions:function()
{
  car_id = (typeof car_id != "undefined") ? car_id : 0; 

  $('#pickup_location_typeahead').typeahead({
    minLength: 0,
    highlight:true    
  },
  {
    limit:100,
    source: function (query, syncResult,asyncResult) 
    {
      $.get(config.siteUrl+'common_methods/get_autosuggest_list', { query: query,pickup_location:pickup_location,dropoff_location:dropoff_location,car_id:car_id }, function (data) 
      {
        pickup_location_objects = [];
        pickup_location_map = {}; 

        $.each(data.location_tags, function(i, object) {
          pickup_location_map[object.label] = object;
          pickup_location_objects.push(object.label);
        });
        asyncResult(pickup_location_objects);
      });
    },
    
  });       


  $('#pickup_location_typeahead').on('typeahead:selected', function(evt, item) {
    var val_id = pickup_location_map[item].id;
    $('#pickup_location').val(val_id);
    _this.change_dropoff_pickup_time("pickup_location",val_id);

    if (typeof same_as != "undefined" && !$("#same_as").is(':checked') && same_as != "false") {
      $('#dropoff_location').val(val_id);
      $("#dropoff_location_typeahead").val(pickup_location_map[item].label);
      temp = $("#pickup_time").html();
      $("#dropoff_time").html(temp);
    }
    return item;
  });


  $('#dropoff_location_typeahead').typeahead({
    minLength: 0,
    hint:true,
    highlight:true
  },
  {
    limit:100,
    source: function (query, syncResult,asyncResult) {
      $.get(config.siteUrl+'common_methods/get_autosuggest_list', { query: query,pickup_location:pickup_location,dropoff_location:dropoff_location,car_id:car_id }, function (data) 
      {
        /*data = $.parseJSON(data);*/
        dropoff_location_objects = [];
        dropoff_location_map = {};
        $.each(data.location_tags, function(i, object) {
          dropoff_location_map[object.label] = object;
          dropoff_location_objects.push(object.label);
        });
        asyncResult(dropoff_location_objects);
      });
    }   
  });

  $('#dropoff_location_typeahead').on('typeahead:selected', function(evt, item) {
    var val_id = dropoff_location_map[item].id;
    $('#dropoff_location').val(val_id);
    _this.change_dropoff_pickup_time("dropoff_location",val_id);
    return item;
  });

},

initCommonPlugins:function()
{

  _this.location_typeahead_suggestions();

  $("body").on('click','#pickup_location_typeahead',function(){
    $("#pickup_location_typeahead").val('');
    if($(this).val() === '')
    {
      $(this).data().ttTypeahead.input.trigger('queryChanged', '');
    }
  });


  $("body").on('click','#dropoff_location_typeahead',function(){
    $("#dropoff_location_typeahead").val('');
    if($(this).val() === '')
    {
      $(this).data().ttTypeahead.input.trigger('queryChanged', '');
    }
  });


  if($("#accept_terms").size() > 0)
  {
    $('body').on('ifChecked','#accept_terms', function(event){
      event.preventDefault();
      element = $(this).parents('div').find(".checkbox_error_message");
      element.css("display","none");
    });
    $('body').on('ifUnchecked','#accept_terms', function(event){

      element = $(this).parents('div').find(".checkbox_error_message");
      element.css("display","block");
    });
  }

  



  $(".validate_form").validate({
    highlight: function(element) {
      $(element).closest('.form-group').addClass('has-error');
    },
    unhighlight: function(element) {
      $(element).closest('.form-group').removeClass('has-error');
    },
    errorElement: 'span',
    errorClass: 'help-block',
    errorPlacement: function(error, element) 
    {

      if(element.attr("type") == "checkbox") 
      {
        error.insertAfter($(element).parents('div').find(".checkbox_error_message"));
      }
      else if(element.parent('.input-group').length) 
      {
        error.insertAfter(element.parent());
      } 
      else if(element.hasClass("phone_no"))
      {
        $(element).parent('.phone_cont').addClass("has-error");
        error.insertAfter(element.parent('.phone_cont')); 
      }
      else 
      {
        error.insertAfter(element);
      }
    }
  });
  
  $('#message').keypress(function (e) {
    if (e.which == 13) {
      $("#send_message").click();
      return false;
    }
  }); 

  $("body").on("click", "#send_message", function(e) {
   var message = $("#message").val();
   $.ajax({
    url: Appfd.config.siteUrl + "message/add_message",
    type: "POST",
    data: {
      'message': message
    },
    dataType: "JSON",
    async: true,
    success: function(data) {
      if(data.success == true)
      {
       $("#message").val("");
       $('#message').focus();
     }
   }
 });
 });


  $("body").on("click", "#newsletter_subscribe", function(e) {
   var newleter_email = $("#newleter_email").val();
   $.ajax({
    url: Appfd.config.siteUrl + "common_methods/subscribe_newsletter",
    type: "POST",
    data: {
      'email': newleter_email
    },
    dataType: "JSON",
    async: true,
    success: function(response) {
      if($("body").hasClass("home_js"))
      {
        alert(response.msg);
      }
      else{
        $("#js_message").html("");
        if(response.status == "success")
        {
          $("#js_message").removeClass("hide").addClass("alert-success");
        }
        else
        {
          $("#js_message").removeClass("hide").addClass("alert-danger"); 
        }
        $("#js_message").append(response.msg);

      }
      $("#newleter_email").html("");      
    }
  });
 });





  /*$("body").on("change", "#pickup_location,#dropoff_location", function(e) {
    e.preventDefault();
    var type = $(this).attr('name');
    var same_as = $(this).attr("data-sameas");
    $.ajax({
      url: Appfd.config.siteUrl + "common_methods/get_opening_time_from_location",
      type: "POST",
      data: {
        'type': type,
        'location_id': $(this).val()
      },
      dataType: "JSON",
      async: true,
      success: function(data) {
        if (type == 'pickup_location') {
          $("#pickup").html(data.time_data);
        } else {
          $("#dropoff").html(data.time_data);
        }
        if (typeof same_as != "undefined" && !$("#same_as").is(':checked') && same_as != "false") {
          temp = $("#pickup_time").html();
          $("#dropoff_time").html(temp);
          var tmp = $("#pickup_location option:selected").val();
          $("#dropoff_location").val(tmp).change();         
        }
      }
    });
});*/
},
initRemoteModal:function(){

  $.fn.modal.defaults.spinner = $.fn.modalmanager.defaults.spinner = '<div class="loading-spinner" style="width: 200px; margin-left: -100px;">' + '<div class="progress progress-striped active">' + '<div class="progress-bar progress-bar-info" style="width: 100%;"></div>' + '</div>' + '</div>';

  $.fn.modalmanager.defaults.resize = true;
  $("body").on("click",'a[data-remote-content=true]',function(e) {
    $("#RemoteModal").on("hidden.bs.modal",function(){
      $("body").addClass('no-hidden');
      $("#RemoteModal").removeClass('bookinginfomodal');
    });
    $('#RemoteModal').on('shown.bs.modal', function() {
      App.initAjax();
      _this.initCommonPlugins();
      $(".validate_form").validate();
      if($("#RemoteModal").find(".bookinginfomodal").length>0){
        $(".bookinginfomodal").removeClass('bookinginfomodal');
        $("#RemoteModal").addClass('bookinginfomodal');
      }
    });
    var target_modal = $(e.currentTarget).data('target');
    var $modal = $(target_modal);
    if($(target_modal).length > 0){
      var remote_url = e.currentTarget.href;
      if($(".modal .close").length>0){
        $(".modal .close").click();
      }
      $('body').modalmanager('loading');
      setTimeout(function() {
        $modal.load(remote_url, '', function() {
          $modal.modal();
        });
      }, 1000);
      return false;
    }else{
      location.href = $(this).attr("href");
      return true;
    } 
  });

  /*$("body").on("click",'a[data-remote-content=true]',function(e) {
    var target_modal = $(e.currentTarget).data('target');
    if($(target_modal).length > 0){
      var modal_dialog_class= $(e.currentTarget).data('class');
      var remote_url = e.currentTarget.href;
      var modal = $(target_modal);
      $("body").addClass('loading');
      modal.empty();
      modal.html('')
      modal.modal({
      }).load(remote_url + " .modal-dialog", function (e) {
        modal.removeClass('loading').addClass('loaded');
        $("body").removeClass('no-hidden').removeClass('loading').addClass('loaded');
        modal.find("#modelContent").show();
        _this.initCommonPlugins();
        $(".validate_form").validate();
        App.handleUniform();
      });
      return false;
    }else{
      location.href = $(this).attr("href");
      return true;
    }
  });*/
},
initCity:function()
{
  if ($("#car-hire-city").size() > 0) {
    google.maps.event.addDomListener(window, 'load', _this.initializecity);
  }
},
initializecity:function() 
{
  center1 = new google.maps.LatLng(latitude, longitude);
  var mapProp = {
    center: center1,
    zoom: 11,
    mapTypeId: google.maps.MapTypeId.TERRAIN
  };
  var map = new google.maps.Map(document.getElementById("gmap3"), mapProp);
  marker1 = Array();
  var infowindow = new google.maps.InfoWindow();
  for (i = 0; i < locations.length; i++) {
    center1 = new google.maps.LatLng(locations[i][1], locations[i][0]);
    marker1[i] = new google.maps.Marker({
      position: center1
    });
    marker1[i].setMap(map);
    google.maps.event.addListener(marker1[i], 'click', (function(marker2, i) {
      return function() {
        infowindow.setContent(locations[i][3]);
        infowindow.open(map, marker2);
      }
    })(marker1[i], i));
  }
},

initLocation:function()
{
  if ($("#car-hire-location").size() > 0) {
    google.maps.event.addDomListener(window, 'load', _this.initialize_location);
  }
},
initialize_location:function() {
  center1 = new google.maps.LatLng(lati, lang);
  var mapProp = {
    center: center1,
    zoom: 15,
    mapTypeId: google.maps.MapTypeId.TERRAIN
  };
  var map = new google.maps.Map(document.getElementById("gmap3"), mapProp);
  var marker = new google.maps.Marker({
    position: center1,
  });
  marker.setMap(map);
},
initRefferalOperations:function()
{

  $("body").on('click','#booking_button',function(){
    if($("#searchfilterform").valid())
    {

    }

  });

},
LoadMore:function(){
  var scanLoadMore = ($('.loadmore').size() > 0) ? $('.loadmore') : $('.scan-load-more');
  var page = scanLoadMore.attr("data-page");
  var loadmoreurl = scanLoadMore.attr("data-loadmoreurl");
  var loadmoreelm = scanLoadMore.attr("data-elm");
  var loadenable = scanLoadMore.attr("data-loadenable");
  var requesttype = scanLoadMore.attr("data-requesttype");
  requesttype = (requesttype != "") ? requesttype : "POST";
  var formdata = scanLoadMore.attr("data-form");
  formdata = (typeof formdata !=" undefined" && formdata != "") ? formdata : "";

  final_data = $('#'+formdata).serialize()+'&'+$.param({ 'page': page });

  if(String(loadenable)=="false"){
    return;
  }
  scansLoadMore_req = _this.ajax({
    type: requesttype,
    url: loadmoreurl,
    async:false,
    data:final_data,
    beforeSend:function(){
      /*App.blockUI({
        target: "#"+loadmoreelm,
        animate: !0,
      });*/
},
success: function (data){
  if(data.status == "success")
  {
   /* App.unblockUI("#"+loadmoreelm);*/
   $("#"+loadmoreelm).append(data.output);
   scanLoadMore.attr('data-page',data.page);
   scanLoadMore.attr('data-id','');
   if(data.last_page<data.page){
    scanLoadMore.attr('data-loadenable',false); 
    $(".loadmore").fadeOut();               
  }
  App.initAjax();
}
},
error: function () {    
  App.unblockUI("#"+loadmoreelm); 
},
dataType: 'json'
});
}
}



jQuery(document).ready(function() {
  if(typeof config != "undefined")
  {
    Appfd.init(config);
  }  
  $(".page-waiting").remove();
  $("body").fadeIn();

  if(!$("body").hasClass("nocookiebar"))
  {
   $.cookieBar();
 }
});


jQuery(window).load(function() {
 /* $(".page-waiting").remove();
 $("body").fadeIn();*/
});