<div class="row">

	<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">

		<div class="portlet light ">

			<div class="portlet-title">

				<div class="caption">

					<span class="caption-subject bold uppercase">View Booking</span>

				</div>

			</div>

			<div class="portlet-body">

				<div class="todo-tasklist">

					<?php 

					if(!empty($bookings)){

						foreach($bookings as $booking){

							$days = count_days($booking['pickup_date']." ".$booking['pickup_time'], $booking['dropoff_date']." ".$booking['dropoff_time']).' Days';

							$id =  $booking['id'];

							$booking_status = $booking['booking_status'];

							if($booking_status=='p'){

								$status = "pending";

								$class = "warning";

								$borderclass="yellow";

							}else if($booking_status=='a'){

								$status = "accepted";

								$class = "success";

								$borderclass="green";

							}

							else{

								$status = "cancelled";

								$class = "danger";

								$borderclass="red";

							}


							$pickup_time_ar = explode(":",$booking["pickup_time"]);
							if(count($pickup_time_ar) == 3)
							{
								array_pop($pickup_time_ar);
								$pickup_time_dis = implode(":",$pickup_time_ar);
							}

							$dropoff_time_ar = explode(":",$booking["dropoff_time"]);
							if(count($dropoff_time_ar) == 3)
							{
								array_pop($dropoff_time_ar);
								$dropoff_time_dis = implode(":",$dropoff_time_ar);
							}

							?>

							<div class="todo-tasklist-item todo-tasklist-item-border-<?php print $borderclass;?>">

								<a target="_blank" href="<?php echo base_url().'bookingdetail/'.$booking["id"]; ?>">

									<div class="todo-tasklist-item-title"><?php echo $booking['car_info']['name'];?> - (#<?php print $booking['booking_no'];?>)</div>

									<div class="todo-tasklist-controls">  

										<div class="col-md-6 col-sm-12 margin-bottom-5">

											<span class="todo-tasklist-date">

												<i class="fa fa-globe"></i><strong>Pickup Location</strong> <?php print $booking['pickup_location_ar']['location_name'];?>

											</span>

										</div>

										<div class="col-md-6 col-sm-12 margin-bottom-5">

											<span class="todo-tasklist-date">

												<i class="fa fa-globe"></i><strong>DropOff Location</strong> <?php print $booking['dropoff_location_ar']['location_name'];?>

											</span>

										</div>

									</div>

									<div class="todo-tasklist-controls">

										<div class="col-md-6 col-sm-12 margin-bottom-5">

											<span class="todo-tasklist-date">

												<i class="fa fa-calendar"></i><strong>Pickup Date</strong>

												<?php echo date('d-m-Y',strtotime($booking['pickup_date']));?>

											</span>

										</div>

										<div class="col-md-6 col-sm-12 margin-bottom-5">

											<span class="todo-tasklist-date">

												<i class="fa fa-calendar"></i><strong>DropOff Date</strong> <?php echo date('d-m-Y',strtotime($booking['dropoff_date']));?>

											</span>

										</div>

									</div>

									<div class="todo-tasklist-controls">

										<div class="col-md-6 col-sm-12 margin-bottom-5">

											<span class="todo-tasklist-date">

												<i class="fa fa-clock-o"></i><strong>Pickup Time</strong>

												<?php echo $pickup_time_dis;?>

											</span>

										</div>

										<div class="col-md-6 col-sm-12 margin-bottom-5">

											<span class="todo-tasklist-date">

												<i class="fa fa-clock-o"></i><strong>DropOff Time</strong> <?php echo $dropoff_time_dis;?>

											</span>

										</div>

									</div>

									<div class="todo-tasklist-controls">

										<div class="col-md-6 col-sm-12 margin-bottom-5">

											<span class="todo-tasklist-date">

												<i class="fa fa-hourglass"></i><strong>Rental Days</strong> <?php print $days;?>

											</span>

										</div>

										<div class="col-md-6 col-sm-12 margin-bottom-5">

											<span class="todo-tasklist-date">

												<i class="fa fa-eur"></i><strong>Booking Price</strong> 

												€<?php print $booking['booking_price']?>

											</span>

										</div>

									</div>

									<div class="todo-tasklist-controls margin-top-5">

										<span class="todo-tasklist-badge badge badge-<?php print $class;?> badge-roundless"><?php print $status;?></span>	

									</div>



								</a>



							</div>

							

							<?php }

						} else { ?>

						<div class="alert alert-warning ">

							No booking found. 

						</div>

						<?php } ?>

					</div>

				</div>

			</div>

		</div>

	</div>

