<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Special_offer_opposite_model extends My_Model
{
	public $primary_key = 'id';
	public $get_insurance_details = false;
	public $_table = 'special_offer_opposite';
	public $before_delete = array( 'before_delete');
	
	public $after_create = array( 'after_create' );
	public $before_update = array('before_update');
	public $after_get = array('after_get');

	public $allow_after_get = false;
	public $get_offers_location_data = false;
	public $allow_before_update = false;

	protected $CI;
	public $validate = array(
		/*'categoryId'  => array(
			'field' => 'categoryId',
			'label' => 'categoryId Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CAR_CATEGORY_REQUIRED',				
				),
	),*/
	'type'  => array(
		'field' => 'type',
		'label' => ' type',
		'rules' => 'trim|required|xss_clean',
		'error_msg' => array(
			'required'  => 'lang:SPECIAL_OFFER_OPPOSITE_TYPE_REQUIRED',
			
			),
		),
	'start_date'  => array(
		'field' => 'start_date',
		'label' => 'start_date Name',
		'rules' => 'trim|required|xss_clean',
		'error_msg' => array(
			'required'  => 'lang:START_DATE_REQUIRED',
			
			),
		),

	'end_date'  => array(
		'field' => 'end_date',
		'label' => 'end_date Name',
		'rules' => 'trim|required|xss_clean',
		'error_msg' => array(
			'required'  => 'lang:END_DATE_REQUIRED',
			
			),
		),


	);

	public function __construct()
	{

		parent::__construct();
		$this->CI=& get_instance();
	}

	public function price_check()
	{
		if($this->input->post("type") == "p")
		{
			$price = $this->input->post("price");
			if($price > 100 || $price < 0)
			{
				return false;
			}
		}
		return true;
	}

	public function alpha_dash_space($str)
	{
		return ( ! preg_match("/^([-a-z_ ])+$/i", $str)) ? FALSE : TRUE;
	} 

	

	public function before_delete($data)
	{
		if(!$this->current_session)
		{	
			$data['before_return']['msg']=lang(INVALID_REQUEST);				
		}
		return $data;
	}

	public function after_get($data)
	{
		if(!empty($data) && $this->allow_after_get == true)
		{
			$this->load->model("locations_model");
			$this->load->model("cars_model");
			$this->load->model("special_offer_opposite_car_details_model");
			$this->load->model("special_offer_opposite_location_details_model");

			$car_fields = "cars.id,special_offer_opposite_car_details.carId";
			$locations_fields = "locations.id";	

			$where = array('special_offer_opposite_car_details.offerId'=>$data["id"]);
			$this->cars_model->after_get_allow = false;
			$data["db_sel_cars"] = $this->cars_model->set_fields($car_fields)->join('special_offer_opposite_car_details', 'special_offer_opposite_car_details.carId = cars.id')->as_array()->get_many_by($where);
			$this->cars_model->after_get_allow = true;

			if($this->get_offers_location_data == true)
			{
				$where_char = array('special_offer_opposite_location_details.offerId'=>$data["id"]);
				$this->locations_model->after_get_allow = false;
				$data["db_sel_location"] = $this->locations_model->set_fields($locations_fields)->join('special_offer_opposite_location_details', 'special_offer_opposite_location_details.locationId = locations.id')->as_array()->get_many_by($where_char);
				$this->locations_model->after_get_allow = false;
			}
		}
		return $data;
	}

	public function after_create($offerId)
	{
		$this->insert_enimeties_data($offerId,"cars","carId","special_offer_opposite_car_details_model");
		$this->insert_enimeties_data($offerId,"locations","locationId","special_offer_opposite_location_details_model");
		return $offerId;
	}

	public function before_update($data)
	{
		if($this->allow_before_update == true)
		{
			$offerId = $data["id"];

			/*Insert Facilities*/
			$this->insert_enimeties_data($offerId,"cars","carId","special_offer_opposite_car_details_model",$data["db_sel_cars"]);
			/*Insert Facilities*/

			/*Characterisitcs insert*/
			$this->insert_enimeties_data($offerId,"locations","locationId","special_offer_opposite_location_details_model",$data["db_sel_location"]);
			/*Characterisitcs insert ends*/

			
		}
		unset($data["id"]);
		unset($data["db_sel_cars"]);		
		unset($data["db_sel_location"]);
		return $data;
	}


	public function insert_enimeties_data($offerId,$post_name,$field_name,$modal_name,$existing_items = array())
	{	
		$insert_batch_array = array();
		$post_data = $this->input->post($post_name);
		$i = 0;
		$this->load->model($modal_name);

		if(!empty($existing_items))
		{
			$item_string = null;
			foreach ($post_data as $key => $value) 
			{
				$item_string .= '"'.$value.'"'.",";	
			}
			$item_string = rtrim($item_string,",");
			$where[] = array("offerId = '".$offerId."'",null,false);
			$where[] = array("$field_name NOT IN (".$item_string.")",null,false);
			$this->{$modal_name}->delete_by($where);
			$post_data = array_diff($post_data,$existing_items);
		}	
		if(!empty($post_data))
		{
			foreach ($post_data as $key => $value) 
			{
				$insert_batch_array[$i]['offerId'] = $offerId;
				$insert_batch_array[$i][$field_name] = $value;				
				$insert_batch_array[$i]['createdDate'] = date('Y-m-d H:i:s');
				$i++;
			}
			if(!empty($insert_batch_array))
			{

				$status = $this->{$modal_name}->insert_many($insert_batch_array,true);
			}
		}
		return $status;
	}




}
