<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class slider_img_model extends My_Model

{

	public $primary_key = 'id';

	public $_table = 'slider_img';

	protected $CI;

	public $validate = array(

		'caption'  => array(

			'field' => 'caption',

			'label' => 'Caption',

			'rules' => 'trim|required|xss_clean',

			'error_msg' => array(

				'required'  => 'lang:SLIDER_CAPTION_REQUIRED'

				),

			),

		'link'  => array(

			'field' => 'link',

			'label' => 'link',

			'rules' => 'trim|valid_url_format',

			'error_msg' => array(

				'valid_url_format'  => 'lang:SLIDER_VALID_URL',

				),

			),



		);

	public $before_delete = array('before_delete');

	public $before_create = array('before_create');

	public $before_update = array('before_update');

	public $after_get = array('after_get');

	public $is_image_uploaded;



	public function __construct()

	{

		

		parent::__construct();

		$this->current_login_type=$this->current_login_type;

		$this->is_image_uploaded = true;

		$this->CI=& get_instance();

	}



	



	public function after_get($data)

	{

		if(!empty($data))

		{

			$data["path"] = base_url()."assets/nova/slider/".$data["image"];

		}

		

		return $data;

	}



	public function before_update($data){

		if($this->is_image_uploaded == true && $this->current_session)
		{
			$image_data = $this->get($data["id"]);

			if($_FILES['image'] && $_FILES['image']['error']==UPLOAD_ERR_OK)
			{

				$update_new_image_ar = $this->upload_image();

				if($update_new_image_ar["status"] == "success")

				{

					$exist_check_path = FCPATH."assets/nova/slider/".$image_data["image"];	

					if(file_exists($exist_check_path) && $exist_check_path!=''){

						unlink($exist_check_path);

					}

					if($update_new_image_ar["is_video"] == true)

					{

						$data['type'] = 'v';

					}

					$data['image'] = $update_new_image_ar['image'];			

				}

				else{

					$data['before_return']['msg']=lang(INVALID_REQUEST);	

				}
			}
		}
		return $data;

	}



	public function before_create($data){

		/*printr($_FILES);*/

		if($_FILES['image'])

		{

			$status_ar = $this->upload_image();

			/*dump($status_ar);*/

			if($status_ar["status"] == "success")

			{

				if($status_ar["is_video"] == true)

				{

					$data['type'] = 'v';

				}

				$data['image'] = $status_ar['image'];			

			}

			else{

				$data['before_return']['msg'] = $status_ar['msg'];	

			}		

		}		

		return $data;

	}



	public function upload_image()

	{

		$upload_dir = FCPATH.'assets/nova/slider/';

		$data = array('status'=>'success');

		if($_FILES['image']['error']==UPLOAD_ERR_OK){

			$this->load->library('image_lib');

			$name = $_FILES['image']['name'];

			$size = $_FILES['image']['size'];

			$ext = substr($name, strrpos($name, ".") + 1);

			$maxSize = 100*1024*1024;



			if ($size < ($maxSize)) {

				if(!file_exists($upload_dir)){

					mkdir($upload_dir,0777);

				}			

				$th_arr=array();	

				$config['upload_path'] = $upload_dir;

				$config['file_name'] =md5(date("Y-m-d H:i:s").rand());

				$config['allowed_types'] = 'gif|jpg|png|jpeg|JPG|jpe|mp4|mpeg|flv';

				$this->load->library('upload', $config);

				$this->upload->initialize($config);

				$field_name = "image";

				if ( ! $this->upload->do_upload($field_name))

				{

					$this->form_validation->set_message('insert',$this->upload->display_errors());

					$data["status"] = "error";

					$data["msg"] = $this->upload->display_errors();					

				}

				else

				{

					if(preg_match('/video\/*/',$_FILES['image']['type'])){

						$data["is_video"] = true; 

					}

					else{

						$data["is_image"] = true;           

					}

					

					$fileUpd = array('upload_data' => $this->upload->data());

					/*printr($fileUpd);*/

					$data["status"] = "success";

					$data['image'] = $fileUpd['upload_data']['file_name'] ;

				}

			}

			else{

				$this->session->set_flashdata('message','Image size is too large.maximum image size is '.$maxSize);

				$data["status"] = 'error';

				$data["msg"] ='Image size is too large.maximum image size is '.$maxSize;				

			}	

		}

		else{

			$this->session->set_flashdata('message','Please upload Image');

			$data["status"] = 'error';

			$data["msg"] ='Please upload Image';

		}

		return $data;

	}





	public function before_delete($data){



		if($this->current_session)

		{

			$image_data = $this->get($data);

			$exist_check_path = FCPATH."assets/nova/slider/".$image_data["image"];			

			if(file_exists($exist_check_path) && $exist_check_path!=''){

				unlink($exist_check_path);

			}

		}else{

			$data['before_return']['msg']=lang(INVALID_REQUEST);					

		}

		return $data;

	}

}

