<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class locations_fee_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'locations_fee';
	protected $CI;
	public $is_image_uploaded;
	public $validate = array(
		'location_from'  => array(
			'field' => 'location_from',
			'label' => 'location From',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:LOCATION_FEE_FROM_REQUIRED',
				),
			),	

		'location_to'  => array(
			'field' => 'location_to',
			'label' => 'location To',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:LOCATION_FEE_TO_REQUIRED',
				),
			),	

		'minimum_days'  => array(
			'field' => 'minimum_days',
			'label' => 'minimum days',
			'rules' => 'trim|required|xss_clean|numeric',
			'error_msg' => array(
				'required'  => 'lang:LOCATION_FEE_MINIMUM_DAYS_REQUIRED',
				'numeric' => 'lang:NUMERIC_REQUIRED'
				),
			),	
		'price'  => array(
			'field' => 'price',
			'label' => 'Price',
			'rules' => 'trim|required|xss_clean|numeric',
			'error_msg' => array(
				'required'  => 'lang:LOCATION_FEE_PRICE_REQUIRED',
				'numeric' => 'lang:NUMERIC_REQUIRED'
				),
			),
		);

	public $before_delete = array('before_delete');
	public $before_update = array('before_update');
	public $before_create = array('before_create');
	/*public $after_create = array('after_create');*/

	public function __construct()
	{
		
		parent::__construct();
		$this->current_session=$this->current_session;
		$this->current_login_type=$this->current_login_type;
		$this->CI=& get_instance();
		$this->is_image_uploaded = true;
	}

	public function before_create($data){
		/*$data['before_return']['msg']=lang(INVALID_REQUEST);*/
		$where_ar = array('fromId'=>$data["fromId"],'toId'=>$data["toId"]);
		$exist_check = $this->get_by($where_ar);
		if(!empty($exist_check))
		{
			$data['before_return']['msg']=lang(MSG_REC_EXISTS);
		}
		if($this->input->post('is_reversible'))
		{	
			$ar = array( 'field' => 'reversible_price','label' => 'Reversible Price','rules' => 'trim|required|numeric');
			array_push($this->validate,$ar);
		}
		return $data;
	}

	public function before_update($data){
		$this->validate = array(
			array( 'field' => 'minimum_days','label' => 'Days','rules' => 'trim|required'),
			array( 'field' => 'price','label' => 'Price','rules' => 'trim|required')
			);

		if($this->input->post('is_reversible'))
		{	
			$ar = array( 'field' => 'reversible_price','label' => 'Reversible Price','rules' => 'trim|required|numeric');
			array_push($this->validate,$ar);
		}
		return $data;
	}


	public function reversible_manage($update_flag = false){
		if($this->input->post('is_reversible'))
		{	
			$location_from    = $this->input->post('location_from');
			$location_to    = $this->input->post('location_to');
			$minimum_days     = $this->input->post('minimum_days');
			$price        = $this->input->post('reversible_price');
			$reversible_price = $this->input->post('reversible_price');
			$insert_new = ($update_flag == false) ? true : false;
			$where_ar = array('fromId'=>$location_to,'toId'=>$location_from);
			$exist_check = $this->get_by($where_ar);
			if(empty($exist_check))
			{
				if($update_flag == false)
				{
					$insert_new = true;
				}
				else if($update_flag == true){
					$insert_new = true;
				}
			}
			if($insert_new == true || $update_flag = false)
			{
				$data = array(
					'fromId' =>  $location_to,
					'toId' =>  $location_from,
					'minimum_days'=>  $minimum_days,
					'price'   =>  $price
					);
				$status = $this->insert($data);
			}
			else{
				$data = array(
					'minimum_days'=>  $minimum_days,
					'price'   =>  $price
					);
				$status = $this->update($exist_check["id"],$data);
			}
		}
		return $status;
	}

	public function before_delete($data){
		if(!$this->current_session)
		{
			$data['before_return']['msg']=lang(INVALID_REQUEST);	
		}
		return $data;
	}

}
