<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Currencies_model extends My_Model
{
	public $primary_key = 'id';
	public $get_insurance_details = false;
	public $_table = 'currencies';
	protected $CI;
	public $validate = array(
		'currency_code'  => array(
			'field' => 'currency_code',
			'label' => 'Facility Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CURRENCY_CODE_REQUIRED',
				
				),
			),
		'currency_symbol'  => array(
			'field' => 'currency_symbol',
			'label' => 'currency_symbol Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CURRENCY_SYMBOL_REQUIRED'				
				),
			),
		);
	
	public function alpha_dash_space($str)
	{
		return ( ! preg_match("/^([-a-z_ ])+$/i", $str)) ? FALSE : TRUE;
	} 

	public function __construct()
	{
		
		parent::__construct();
		$this->CI=& get_instance();
	}

	public function before_delete($data){

		if(!$this->current_session)
		{
			$data['before_return']['msg']=lang(INVALID_REQUEST);				
		}
		return $data;
	}

	
	
	

}
