<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class conversation_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'conversation';
	protected $CI;
	public $is_image_uploaded;
	public $validate = array(
		'location_from'  => array(
			'field' => 'location_from',
			'label' => 'location From',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:LOCATION_FEE_FROM_REQUIRED',
				),
			),	

		'location_to'  => array(
			'field' => 'location_to',
			'label' => 'location To',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:LOCATION_FEE_TO_REQUIRED',
				),
			),	

		'minimum_days'  => array(
			'field' => 'minimum_days',
			'label' => 'minimum days',
			'rules' => 'trim|required|xss_clean|numeric',
			'error_msg' => array(
				'required'  => 'lang:LOCATION_FEE_MINIMUM_DAYS_REQUIRED',
				'numeric' => 'lang:NUMERIC_REQUIRED'
				),
			),	
		'price'  => array(
			'field' => 'price',
			'label' => 'Price',
			'rules' => 'trim|required|xss_clean|numeric',
			'error_msg' => array(
				'required'  => 'lang:LOCATION_FEE_PRICE_REQUIRED',
				'numeric' => 'lang:NUMERIC_REQUIRED'
				),
			),
		);

	public $before_delete = array('before_delete');
	public $before_create = array('before_create');
	public $after_get = array('after_get');


	public function __construct()
	{
		
		parent::__construct();
		$this->current_session=$this->current_session;
		$this->current_login_type=$this->current_login_type;
		$this->CI=& get_instance();
		$this->is_image_uploaded = true;
		$this->rec_to_dis = 25;
		$this->start_limit;
		$this->page = 1;
		$this->load->model("messages_model");
	}

	public function before_create($data){
		$data["updatedDate"] = date('Y-m-d H:i:s');
		return $data;
	}

	public function after_get($data){
		if(!empty($data))
		{
			if($data["image"] != "")
			{
				$data["image_path"] = base_url()."image/profile/".$data["fromId"]."/46/46/".$data["image"];
			}
			else{
				$data["image_path"] = base_url()."image/default/46/46/no_available_image.gif";
			}
			if($this->admin_id == $data["fromId"])
			{
				$data["message_type"] = " in";
			}else{
				$data["message_type"] = " out";
			}
			$where_array_n[]=array("conversationId = '".$data["id"]."' AND isRead = 'n' AND senderType = 'u'",null,false);
			$data["unread_count"] = $this->messages_model->count_by($where_array_n);
		}
		return $data;
	}
	
	public function before_delete($data){
		if(!$this->current_session)
		{
			$data['before_return']['msg']=lang(INVALID_REQUEST);	
		}
		return $data;
	}

	public function get_conversation($data = array(),$where_array = null){

		if($where_array == null)
		{
			$where_array[] = array("fromId = '".$this->admin_id."' OR toId='".$this->admin_id."'",null,false);
		}

		if($this->page != "" && $this->page > 0)
		{
			$total_records = $this->as_array()->count_by($where_array);	
			$this->start_limit = (($this->page - 1)*$this->rec_to_dis);
			$this->last_page = ceil($total_records/$this->rec_to_dis);
		}
		$conversations = $this->set_fields("conversation.*,users.firstname,users.lastname,users.email,users.image")->as_array()->join("users","users.id = conversation.fromId")->limit($this->rec_to_dis,$this->start_limit)->order_by("id","DESC")->get_many_by($where_array);
		if(!empty($conversations)){
			$this->page += 1;
			$this->response = $conversations;
		}
		return $this->response;
	}


	public function get_conversation_detail($conversationid,$where_array = null)
	{	
		$this->load->model('messages_model');
		if($where_array == null)
		{
			$where_array[] = array("conversationId = '".$conversationid."'",null,false);	
		}
		/*$messages = $this->set_fields("messages.*,users.firstname,users.lastname,users.email,users.image,conversation.fromId,conversation.toId")->messages_model->join("users","users.id = messages.fromId")->join("conversation","conversation.id=messages.conversationId")->get_many_by($where_array);*/
		$messages = $this->messages_model->get_many_by($where_array);
		if(!empty($messages))
		{
			$messages["toId"] = $messages[0]["toId"];
			$messages["fromId"] = $messages[0]["fromId"];
			return $messages;
		}
		return false;
	}
}
