<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class content_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'content';
	protected $CI;
	public $before_delete = array('before_delete');
	public $after_get = array('after_get');
	public $validate = array(
		'page_title'  => array(
			'field' => 'page_title',
			'label' => 'Page Title',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CONTENT_PAGE_TITLE_REQUIRED'
				),
			),
		'sort_order'  => array(
			'field' => 'sort_order',
			'label' => 'Sort Order',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CONTENT_SORT_ORDER_REQUIRED'
				),
			),
		'display_position'  => array(
			'field' => 'display_position',
			'label' => 'Display Position',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CONTENT_DISPLAY_POSITION_REQUIRED'
				),
			),
		'meta_keyword'  => array(
			'field' => 'meta_keyword',
			'label' => 'Meta Keyword',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CONTENT_META_KEYWORD_REQUIRED'
				),
			),
		'meta_description'  => array(
			'field' => 'meta_description',
			'label' => 'Meta Description',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CONTENT_META_DESCRIPTION_REQUIRED'
				),
			),
		'page_description'  => array(
			'field' => 'page_description',
			'label' => 'Page Description',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CONTENT_PAGE_DESCRIPTION_REQUIRED'
				),
			),	
		);
public function __construct()
{
	
	parent::__construct();
	$this->current_session=$this->current_session;
	$this->current_login_type=$this->current_login_type;
	$this->CI=& get_instance();
}

public function after_get($data)
{
	if(!empty($data))
	{
		if($data["page_type"] == "e")
		{
			$data["detail_link"] = $data["external_link"];
		}else{
			$data["detail_link"] = base_url()."pages/".$data["id"];
		}
	}
	return $data;
}

public function before_delete($data){
	if(!$this->current_session)
	{
		$data['before_return']['msg']=lang(INVALID_REQUEST);	
	}
	return $data;
}

public function get_footer_links()
{
	$this->load->model("footer_category_model");
	$where = array("footer_category.status"=>'y');
	$data = $this->footer_category_model->set_fields("footer_category.id as fcid,footer_category.name,content.*")->join('content', 'footer_category.id = content.footer_category')->order_by("sort_order")->get_many_by($where);
	$return_array = array();

	if(!empty($data))
	{
		foreach ($data as $key => $value) 
		{	
			if(!is_array($return_array[$value["fcid"]]))
			{
				$return_array[$value["fcid"]]["name"] = $value["name"];
			}

			if($value["footer_category"] > 0)
			{
				$tempfcid = $value["fcid"];
				unset($value["fcid"]);
				unset($value["name"]);
				$return_array[$tempfcid]["sublinks"][] = $value;
			}
		}
	}
	return $return_array;
}


function cmsPageArray($position=NULL,$page_nm=NULL,$single_page = false,$sub_menu = false) {
	$arr = array();
	$condition = NULL;
	$tmp  = array();

	$where_ar[] = array('status = "y"',null,false);
	if($position != NULL)
	{
		$where_ar[] = array("page_parent=0 AND (page_position='bt' or page_position = '".$position."')",null,false);
	}

	if($page_nm != NULL && $single_page == true)
	{
		$where_ar[] = array("page_url = '".$page_nm."'",null,false);
	}

	if($single_page == true)
	{
		$row_ar = $this->as_array()->order_by('order_number')->get_many_by($where_ar);
	}else{
		$row_ar = $this->set_fields("id,page_name,page_title,page_url")->as_array()->order_by('order_number')->get_many_by($where_ar);
	}

	if(!empty($row_ar))
	{
		foreach ($row_ar as $key => $row) {
			$tmp["id"] 			= dispContent($row["id"]);
			$tmp["name"] 		= dispContent($row["page_name"]);
			$tmp["title"] 		= dispContent($row["page_title"]);
			$tmp["mkeyword"] 	= dispContent($row["page_metakeywords"]);
			$tmp["mdesc"] 		= dispContent($row["page_metadesc"]);
			$tmp["mdesc"] 		= dispContent($row["page_metadesc"]);
			$tmp["url"] 		= dispContent($row["page_url"]);
			$tmp["desc"] 		= dispContent($row["page_desc"]);
			$tmp["status"] 		= dispContent($row["status"]);
			$tmp["class"] = "";									

			if($sub_menu == true)
			{
				$where_ar2 = array('page_parent'=>$row["id"],'status'=>'y');
				$sub_links_ar = $this->set_fields("id,page_name,page_title,page_url")->get_many_by($where_ar2);

				/*printr($sub_links_ar);*/
				$sub_links = array();
				if(!empty($sub_links_ar))
				{
					foreach ($sub_links_ar as $key => $value2) 
					{
						if($page_nm == $value2["page_url"])
						{
							$tmp["class"] = "active";									
							$value2["class"] = "active";
						}
						else{

							$value2["class"] = "";	
						}
						$sub_links[] = $value2;
					}
				}
				$tmp["sub_links"] = $sub_links;
			}


			if($page_nm != NULL && $single_page == true){
				$arr = $tmp;
			}
			else {
				$arr[] = $tmp;
			}
		}
	}
	return $arr;
}
}
