<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class content_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'content';
	protected $CI;
	public $before_delete = array('before_delete');
	public $after_get = array('after_get');
	public $after_create = array( 'after_create' );
	public $before_update = array( 'before_update' );
	public $before_update_allowed = true;	
	public $xml_convert = false;	

	public $validate = array(
		'page_title'  => array(
			'field' => 'page_title',
			'label' => 'Page Title',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CONTENT_PAGE_TITLE_REQUIRED'
				),
			),
		'sort_order'  => array(
			'field' => 'sort_order',
			'label' => 'Sort Order',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CONTENT_SORT_ORDER_REQUIRED'
				),
			),
		'display_position'  => array(
			'field' => 'display_position',
			'label' => 'Display Position',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CONTENT_DISPLAY_POSITION_REQUIRED'
				),
			),
		'meta_keyword'  => array(
			'field' => 'meta_keyword',
			'label' => 'Meta Keyword',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CONTENT_META_KEYWORD_REQUIRED'
				),
			),
		'meta_description'  => array(
			'field' => 'meta_description',
			'label' => 'Meta Description',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CONTENT_META_DESCRIPTION_REQUIRED'
				),
			),
		'page_description'  => array(
			'field' => 'page_description',
			'label' => 'Page Description',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CONTENT_PAGE_DESCRIPTION_REQUIRED'
				),
			),	
		);
public function __construct()
{
	
	parent::__construct();
	$this->current_session=$this->current_session;
	$this->current_login_type=$this->current_login_type;
	$this->CI=& get_instance();
}

public function after_get($data)
{
	if(!empty($data))
	{
		if($data["page_type"] == "e")
		{
			$data["detail_link"] = $data["external_link"];
		}
		else
		{
			$data["detail_link"] = base_url().CMS_KEYWORD."/".$data["slug"];
		}

		if($data["booking_form_image"] != '' && $data["booking_form_image"] != null)
		{
			$data["booking_form_url"] = base_url()."image/content/".$data["id"]."/250/250/".$data["booking_form_image"];	
			$data["general_booking_form_url"] = base_url()."image/content/".$data["id"]."/800/800/".$data["booking_form_image"];
		}

		if($this->xml_convert == true)
		{
			$this->load->helper('xml');	
			$data["page_description_xml"] = xml_convert($data["page_description"]);
		}
	}
	return $data;
}

public function before_delete($data){
	if(!$this->current_session)
	{
		$data['before_return']['msg']=lang(INVALID_REQUEST);	
	}
	return $data;
}

public function get_footer_links()
{
	$this->load->model("footer_category_model");
	$where = array("footer_category.status"=>'y');
	$data = $this->footer_category_model->set_fields("footer_category.id as fcid,footer_category.name,content.*")->join('content', 'footer_category.id = content.footer_category')->order_by("sort_order")->get_many_by($where);
	$return_array = array();

	if(!empty($data))
	{
		foreach ($data as $key => $value) 
		{	
			if(!is_array($return_array[$value["fcid"]]))
			{
				$return_array[$value["fcid"]]["name"] = $value["name"];
			}

			if($value["footer_category"] > 0)
			{
				$tempfcid = $value["fcid"];
				unset($value["fcid"]);
				unset($value["name"]);
				$return_array[$tempfcid]["sublinks"][] = $value;
			}
		}
	}
	return $return_array;
}


public function cmsPageArray($position=NULL,$page_nm=NULL,$single_page = false,$sub_menu = false) {
	$arr = array();
	$condition = NULL;
	$tmp  = array();

	$where_ar[] = array('status = "y"',null,false);
	if($position != NULL)
	{
		$where_ar[] = array("page_parent=0 AND (page_position='bt' or page_position = '".$position."')",null,false);
	}

	if($page_nm != NULL && $single_page == true)
	{
		$where_ar[] = array("page_url = '".$page_nm."'",null,false);
	}

	if($single_page == true)
	{
		$row_ar = $this->as_array()->order_by('order_number')->get_many_by($where_ar);
	}else{
		$row_ar = $this->set_fields("id,page_name,page_title,page_url")->as_array()->order_by('order_number')->get_many_by($where_ar);
	}

	if(!empty($row_ar))
	{
		foreach ($row_ar as $key => $row) {
			$tmp["id"] 			= dispContent($row["id"]);
			$tmp["name"] 		= dispContent($row["page_name"]);
			$tmp["title"] 		= dispContent($row["page_title"]);
			$tmp["mkeyword"] 	= dispContent($row["page_metakeywords"]);
			$tmp["mdesc"] 		= dispContent($row["page_metadesc"]);
			$tmp["mdesc"] 		= dispContent($row["page_metadesc"]);
			$tmp["url"] 		= dispContent($row["page_url"]);
			$tmp["desc"] 		= dispContent($row["page_desc"]);
			$tmp["status"] 		= dispContent($row["status"]);
			$tmp["class"] = "";									

			if($sub_menu == true)
			{
				$where_ar2 = array('page_parent'=>$row["id"],'status'=>'y');
				$sub_links_ar = $this->set_fields("id,page_name,page_title,page_url")->get_many_by($where_ar2);

				/*printr($sub_links_ar);*/
				$sub_links = array();
				if(!empty($sub_links_ar))
				{
					foreach ($sub_links_ar as $key => $value2) 
					{
						if($page_nm == $value2["page_url"])
						{
							$tmp["class"] = "active";									
							$value2["class"] = "active";
						}
						else{

							$value2["class"] = "";	
						}
						$sub_links[] = $value2;
					}
				}
				$tmp["sub_links"] = $sub_links;
			}


			if($page_nm != NULL && $single_page == true){
				$arr = $tmp;
			}
			else {
				$arr[] = $tmp;
			}
		}
	}
	return $arr;
}

public function before_update($data)
{	
	if($this->before_update_allowed == true)
	{
		$pageid = $data["id"];
		$image_data = $this->get($pageid);
		if($_FILES['booking_form_image']["name"] != "" && $_FILES['booking_form_image']['error']==UPLOAD_ERR_OK)
		{	
			$update_new_image_ar = $this->upload_image($pageid);
			if($update_new_image_ar["status"] == "success")
			{
				if($update_new_image_ar["status"] == "success")
				{
					$exist_check_path = FCPATH."assets/upload/content/".$pageid."/".$image_data["booking_form_image"];	
					if(file_exists($exist_check_path) && $exist_check_path!="")
					{
						unlink($exist_check_path);
					}
				}
				$data['booking_form_image'] = $update_new_image_ar['file_name'];
			}
			else{
				$data['before_return']['msg']=lang("INVALID_REQUEST");	
			}
		}
		unset($data["id"]);		
	}
	return $data;
}


public function after_create($pageid,$data){
	
	if($_FILES['booking_form_image'] && $_FILES['booking_form_image']['error']==UPLOAD_ERR_OK)
	{
		$status_ar = $this->upload_image($pageid);
		if($status_ar["status"] == "success")
		{
			$data = array();
			$data['booking_form_image'] = $status_ar['file_name'];	
			$this->before_update_allowed = false;
			$this->update($pageid,$data,true);
			$this->before_update_allowed = true;
		}
		else{
			$data['before_return']['msg']=lang(INVALID_REQUEST);	
		}	
	}
	return $data;
}



public function upload_image($id)
{
	$asset_upload_dir = FCPATH.'assets/upload/'; 
	$asset_locations_dir = FCPATH.'assets/upload/content/'; 
	$upload_dir = FCPATH.'assets/upload/content/'.$id.'/'; 

	if(!file_exists($asset_upload_dir)){

		mkdir($asset_upload_dir,0777);
		chmod($asset_upload_dir,0777);
	}

	if(!file_exists($asset_locations_dir)){
		mkdir($asset_locations_dir,0777);
		chmod($asset_locations_dir,0777);
	}

	if(!file_exists($upload_dir)){
		mkdir($upload_dir,0777);
		chmod($upload_dir,0777);
	}	

	$data = array('status'=>'error');
	$maxSize = IMAGE_UPLOAD_MAX_SIZE;

	if($_FILES['booking_form_image']['error']==UPLOAD_ERR_OK){
		$this->load->library('image_lib');
		$name = $_FILES['booking_form_image']['name'];
		$size = $_FILES['booking_form_image']['size'];
		$ext = substr($name, strrpos($name, ".") + 1);

		if ($size < ($maxSize)) {

			$th_arr=array();	
			$config['upload_path'] = $upload_dir;
			$config['file_name'] =md5(date("Y-m-d H:i:s").rand());
			$config['allowed_types'] = 'gif|jpg|png|jpeg|JPG|jpe';
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			$field_name = "booking_form_image";
			if ( ! $this->upload->do_upload($field_name))
			{
				$this->form_validation->set_message('insert',$this->upload->display_errors());
				$data["status"] = "error";
				$data["msg"] = $this->upload->display_errors();					
			}
			else
			{
				$fileUpd = array('upload_data' => $this->upload->data());
				$data["status"] = "success";
				$data['file_name'] = $fileUpd['upload_data']['file_name'] ;
			}
		}
		else{
			$this->session->set_flashdata('message','Image size is too large.maximum image size is '.$maxSize);
			$data["status"] = 'error';
			$data["msg"] ='Image size is too large.maximum image size is '.$maxSize;				
		}	
	}
	return $data;
}

}
