<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Cities_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'cities';
	protected $CI;
	public $after_get = array( 'after_get' );
	public $after_get_location_allow = true;
	public $validate = array(
		'city_name'  => array(
			'field' => 'city_name',
			'label' => 'City Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CITY_NAME_REQUIRED'
				),
			),
		'state'  => array(
			'field' => 'state',
			'label' => 'state Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:STATE_NAME_REQUIRED'
				),
			),
		'country'  => array(
			'field' => 'country',
			'label' => 'Country Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:COUNTRY_NAME_REQUIRED'
				),
			),
		'description'  => array(
			'field' => 'description',
			'label' => 'Description Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:DESCRIPTION_REQUIRED'
				),
			),
		'latitude'  => array(
			'field' => 'latitude',
			'label' => 'Latitude',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:LATITUDE_REQUIRED'
				),
			),
		'longitude'  => array(
			'field' => 'longitude',
			'label' => 'Longitude',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:LONGITUDE_REQUIRED'
				),
			),	
		);



public function after_get($data)
{
	if(!empty($data))
	{
		$data["city_url"] = base_url()."car-hire-city/".$data["id"];
		if($this->after_get_location_allow == true)
		{
			$this->load->model("locations_model");
			$where_ar = array('city'=>$data["id"],'status'=>'y');		
			$this->locations_model->after_get_allow = false;
			$data["location_array"] = $this->locations_model->order_by("id")->get_many_by($where_ar);
			$this->locations_model->after_get_allow = true;
		}		
	}	
	return $data;
}

public function __construct()
{
	
	parent::__construct();
	$this->CI=& get_instance();
}
}
