<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Characteristics_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'characteristics';
	protected $CI;
	public $before_create = array('before_create');
	public $before_delete = array('before_delete');
	public $before_update = array('before_update');
	public $after_get = array('after_get');

	public $validate = array(
		'name'  => array(
			'field' => 'name',
			'label' => 'Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CHARACTERISTIC_NAME_REQUIRED'
				),
			),
		'group_id'  => array(
			'field' => 'group_id',
			'label' => 'Group Id',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CHARACTERISTIC_GROUP_REQUIRED'
				),
			)
		);
	
	public function alpha_dash_space($str)
	{
		return ( ! preg_match("/^([-a-z_ ])+$/i", $str)) ? FALSE : TRUE;
	} 

	public function __construct()
	{
		
		parent::__construct();
		$this->CI=& get_instance();
	}

	public function after_get($data)
	{
		if(!empty($data))
		{
			$default_image = false;
			if($data["image"] != '' && $data["image"] != null)
			{
				$image_path_check = FCPATH."assets/upload/characteristics/".$data["image"];
				if(file_exists($image_path_check))
				{
					$data["image_path"] = base_url()."image/characteristics/26/26/".$data["image"];
					$data["search_characteristic_image"] = base_url()."image/characteristics/30/30/".$data["image"];
				}
				else{
					$default_image = true;
				}
			}
			else
			{
				$default_image = true;
				
			}
			
			if($default_image == true)
			{
				$data["image_path"] = base_url()."image/default/26/26/no_available_image.gif";
				$data["search_characteristic_image"] = base_url()."image/default/30/30/no_available_image.gif";
			}

			
		}
		return $data;
	}

	public function before_update($data)
	{
		if($_FILES['image'] && $_FILES['image']['error']==UPLOAD_ERR_OK){
			$image_data = $this->get($data["id"]);
			$update_new_image_ar = $this->upload_image();
			if($update_new_image_ar["status"] == "success")
			{
				$exist_check_path = FCPATH."assets/upload/characteristics/".$image_data["image"];	
				if(file_exists($exist_check_path) && $exist_check_path!=""){
					unlink($exist_check_path);
				}
				$data['image'] = $update_new_image_ar['image'];			
			}
			else{
				$data['before_return']['msg']=lang(INVALID_REQUEST);	
			}
		}
		unset($data["id"]);
		return $data;
	}

	public function before_create($data){
		$data["created"] = date('Y-m-d H:i:s');
		if($_FILES['image'] && $_FILES['image']['error']==UPLOAD_ERR_OK){
			$status_ar = $this->upload_image();
			if($status_ar["status"] == "success")
			{
				$data['image'] = $status_ar['image'];			
			}
			else{
				$data['before_return']['msg']=lang(INVALID_REQUEST);	
			}		
		}
		return $data;
	}


	public function before_delete($data){

		if($this->current_session)
		{
			$image_data = $this->get($data);
			$exist_check_path = FCPATH."assets/upload/characteristics/".$image_data["image"];			
			if(file_exists($exist_check_path) && $exist_check_path!=""){
				unlink($exist_check_path);
			}
		}else{
			$data['before_return']['msg']=lang(INVALID_REQUEST);					
		}
		return $data;
	}


	public function upload_image()
	{
		$upload_dir = FCPATH.'assets/upload/characteristics/';
		$data = array('status'=>'error');

		if($_FILES['image']['error']==UPLOAD_ERR_OK){
			$this->load->library('image_lib');
			$name = $_FILES['image']['name'];
			$size = $_FILES['image']['size'];
			$ext = substr($name, strrpos($name, ".") + 1);
			$maxSize = 100*1024*1024;

			if ($size < ($maxSize)) {
				if(!file_exists($upload_dir)){
					mkdir($upload_dir,0777);
				}			
				$th_arr=array();	
				$config['upload_path'] = $upload_dir;
				$config['file_name'] =md5(date("Y-m-d H:i:s").rand());
				$config['allowed_types'] = 'gif|jpg|png|jpeg|JPG|jpe|mp4|mpeg|flv';
				$this->load->library('upload', $config);
				$this->upload->initialize($config);
				$field_name = "image";
				if ( ! $this->upload->do_upload($field_name))
				{
					$this->form_validation->set_message('insert',$this->upload->display_errors());
					$data["status"] = "error";
					$data["msg"] = $this->upload->display_errors();					
				}
				else
				{
					$fileUpd = array('upload_data' => $this->upload->data());
					$data["status"] = "success";
					$data['image'] = $fileUpd['upload_data']['file_name'] ;
				}
			}
			else{
				$this->session->set_flashdata('message','Image size is too large.maximum image size is '.$maxSize);
				$data["status"] = 'error';
				$data["msg"] ='Image size is too large.maximum image size is '.$maxSize;				
			}	
		}

		return $data;
	}
	

}
