<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Car_facilities_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'car_facilities';
	protected $CI;
	public $before_create = array('before_create');
	public $before_update = array('before_update');
	public $after_get = array('after_get');
	public $after_get_allow = true;
	public $before_delete = array('before_delete');
	public $pickup_date = '';
	public $dropoff_date = '';
	public $car_id = '';

	public $validate = array(
		'facility_name'  => array(
			'field' => 'facility_name',
			'label' => 'Facility Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CAR_FACILITY_NAME_REQUIRED',
				'alpha' => 'lang:ALPHA_DASH_REQUIRED'
				),
			),

		'description'  => array(
			'field' => 'description',
			'label' => 'Description',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CAR_FACILITY_DESCRIPTION_REQUIRED'
				),
			),

		'price'  => array(
			'field' => 'price',
			'label' => 'price',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CAR_FACILITY_PRICE_REQUIRED'
				),
			),

		'daily_cost'  => array(
			'field' => 'daily_cost',
			'label' => 'Daily Cost',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CAR_FACILITY_DAILY_COST_REQUIRED'
				),
			)
		);
	
	public function __construct()
	{
		parent::__construct();
		$this->CI=& get_instance();
	}


	public function before_update($data)
	{
		if($_FILES['image'] && $_FILES['image']['error']==UPLOAD_ERR_OK)
		{
			$image_data = $this->get($data["id"]);
			$update_new_image_ar = $this->upload_image();
			if($update_new_image_ar["status"] == "success")
			{
				$exist_check_path = FCPATH."assets/upload/facilities/".$image_data["image"];	
				if(file_exists($exist_check_path) && $exist_check_path!=""){
					unlink($exist_check_path);
				}
				$data['image'] = $update_new_image_ar['image'];			
			}
			else
			{
				$data['before_return']['msg']=lang("INVALID_REQUEST");	
			}
		}
		unset($data["id"]);
		return $data;
	}

	public function after_get($data)
	{
		if(!empty($data))
		{
			if($data["id"] > 0 && $this->after_get_allow == true)
			{
				$this->load->model("facilities_promo_code_model");
				$this->load->model("facilities_promo_code_car_details_model");
				$today_date = date('Y-m-d');

				if($this->pickup_date != '')
				{
					$where[] = array("facilities_promo_code.facilityId = '".$data["id"]."' AND (('".$this->pickup_date."' BETWEEN facilities_promo_code.start_date AND facilities_promo_code.end_date) OR ('".$this->dropoff_date."' BETWEEN facilities_promo_code.start_date AND facilities_promo_code.end_date) OR  start_date > '".$this->pickup_date."')",null,false); 
					$this->facilities_promo_code_model->promo_car_id = $this->car_id;
					$record_exist_check = $this->facilities_promo_code_model->get_by($where);
				}

				if(!empty($record_exist_check))
				{
					$is_promo_data_return = false;
					if($record_exist_check["all_cars"] == "0")
					{
						
						$car_id = ($data["carId"] > 0) ? $data["carId"] : $this->car_id ;
						$where_1[] = array("facilitypromoId = '".$record_exist_check["id"]."' AND carId='".$car_id."'",null,false); 
						$record_exist_check1 = $this->facilities_promo_code_car_details_model->get_by($where_1);
						if(!empty($record_exist_check1))
						{
							$is_promo_data_return = true;
						}					
					}
					else
					{
						$is_promo_data_return = true;
					}

					if($is_promo_data_return == true)
					{
						$data["promo_code_price"] = $record_exist_check["amount"];
						$data["promo_code_type"] = $record_exist_check["type"];
						$data["promo_code_default_selected"] = $record_exist_check["default_selected"];
						$data["is_promo_code"] = "yes";
						/*printr($data);exit();*/
					}

				}
			}			
			if($data["image"] == "" || $data["image"] == null)
			{
				$data["image"] = "no_image.png";	
			}
			$data["image_path"] = base_url()."image/facilities/117/118/".$data["image"];	
		}
		return $data;
	}

	public function before_create($data){
		if($_FILES['image']){
			$status_ar = $this->upload_image();
			if($status_ar["status"] == "success")
			{
				$data['image'] = $status_ar['image'];			
			}
			else{
				/*$data['before_return']['msg']=lang(INVALID_REQUEST);	*/
			}		
		}
		return $data;
	}

	public function before_delete($data){
		if(!$this->current_session)
		{
			$data['before_return']['msg']=lang("INVALID_REQUEST");				
		}
		$image_data = $this->get($data);
		$exist_check_path = FCPATH."assets/upload/facilities/".$image_data["image"];	
		if(file_exists($exist_check_path) && $exist_check_path!=""){
			unlink($exist_check_path);
		}
		return $data;
	}

	public function upload_image()
	{
		$upload_dir = FCPATH.'assets/upload/facilities/';
		$data = array('status'=>'error');

		if($_FILES['image']['error']==UPLOAD_ERR_OK){
			$this->load->library('image_lib');
			$name = $_FILES['image']['name'];
			$size = $_FILES['image']['size'];
			$ext = substr($name, strrpos($name, ".") + 1);
			$maxSize = 100*1024*1024;

			if ($size < ($maxSize)) {
				if(!file_exists($upload_dir)){
					mkdir($upload_dir,0777);
				}			
				$th_arr=array();	
				$config['upload_path'] = $upload_dir;
				$config['file_name'] =md5(date("Y-m-d H:i:s").rand());
				$config['allowed_types'] = 'gif|jpg|png|jpeg|JPG|jpe|mp4|mpeg|flv';
				$this->load->library('upload', $config);
				$this->upload->initialize($config);
				$field_name = "image";
				if ( ! $this->upload->do_upload($field_name))
				{
					$this->form_validation->set_message('insert',$this->upload->display_errors());
					$data["status"] = "error";
					$data["msg"] = $this->upload->display_errors();					
				}
				else
				{
					$fileUpd = array('upload_data' => $this->upload->data());
					$data["status"] = "success";
					$data['image'] = $fileUpd['upload_data']['file_name'] ;
				}
			}
			else{
				$this->session->set_flashdata('message','Image size is too large.maximum image size is '.$maxSize);
				$data["status"] = 'error';
				$data["msg"] ='Image size is too large.maximum image size is '.$maxSize;				
			}	
		}

		return $data;
	}

}
