<?php
class currency_convertor {

	/*========================================================================================================================================================*/

	// You can change this value
	public $tablename = "currencies";
	/*========================================================================================================================================================*/

	/*public $url = "http://www.ecb.int/stats/eurofxref/eurofxref-daily.xml";*/
	public $url = "http://www.ecb.europa.eu/stats/eurofxref/eurofxref-daily.xml";


	public function __construct(){
		$this->CI = &get_instance();		 
		$this->CI->load->model("currencies_model");
	}

	function update_rates() {
		$this->check_url();
		
	}
	/* URL response header checking */    
	function check_url() 
	{
		$curl = curl_init($this->url);       
		curl_setopt($curl, CURLOPT_NOBODY, true);   
		$result = curl_exec($curl);
		$statusCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);          
		curl_close($curl);
		if($statusCode == 200) { 
			$this->parse_ecb();
		} else {
			echo "Unable to parse ECB URL";
		}
	}   
	/* Load the data from the ECB into an array. */   

	function parse_ecb() {          
		$xml = simplexml_load_file($this->url);
		foreach($xml->Cube->Cube->Cube as $rate) { 
			$ecb[] = array(
				"rate" => (float)$rate['rate'],
				"currency" => (string)$rate['currency']
				);		

		} 
		$this->make_rates($ecb);	
	}



	function make_rates($ecb) 
	{
		foreach($ecb as $row) {		
			$this->update_table($row['currency'], $row['rate']);
		}
		$this->update_table('EUR', 1);
		echo "Rates Updated";	
	}


	function update_table($currency, $rate) {
		$exist_check = array('code'=>$currency);
		$record = $this->CI->currencies_model->get_by($exist_check);
		if(!empty($record))
		{
			$update_ar = array('rate'=>$rate);
			$this->CI->currencies_model->update($record["id"],$update_ar,true);
		}else{
			$insert_ar = array('code'=>$currency,'rate'=>$rate);
			$this->CI->currencies_model->insert($insert_ar,true);	
		}
	}

	function convert($cost, $origin_currency, $destination_currency) 
	{
		$where_ar[] = array('code="'.$origin_currency.'" OR code = "'.$destination_currency.'"',null,false); 
		$records = $this->CI->currencies_model->limit(2,0)->set_fields("code,rate")->get_many_by($where_ar);
		if(!empty($records))
		{
			foreach ($records as $key => $row) {

				if($row['code'] == $origin_currency)
					$origin_rate = $row['rate'];

				if($row['code'] == $destination_currency)
					$destination_rate = $row['rate'];	

			}

			if($origin_currency == $destination_currency) { 
				/*No conversion required*/
				return $this->get_currency_details($destination_currency, 1) . $this->format_number($cost);
			}

			if($origin_currency == 'EUR') { 
				return $this->get_currency_details($destination_currency, 1) . $this->format_number(($cost * $destination_rate));
			}

			if($origin_currency != 'EUR') { 

				$p = $cost / $origin_rate;
				$p = $p * $destination_rate;
				return $this->get_currency_details($destination_currency, 1) . $this->format_number($p);
			}
		}
	}


	function convert_multiple($cost, $origin_currency, $destination_currency) {

		$currency_code = explode('|', $destination_currency);

		$txt = "	
		<span id='cost'>" . $this->get_currency_details($origin_currency, 1) . $cost . "</span>		

		<select id='target'>
			<option value='default'>Select Currency</option>";

			foreach($currency_code as $row) {
				$txt .= "<option value='" . $origin_currency . "|" . $row . "|" . $cost . "'>" . $this->get_currency_details($row, 0) . " (" . $row . ")</option>\r\n";
			}

			$txt .= "
			<option value='" . $origin_currency . "|" . $origin_currency . "|" . $cost . "'>
				Convert back to " . $origin_currency . "</option></select>"; 

				return $txt;

			}


			function format_number($n) {

				$n = number_format($n, 2);
				//$n = preg_replace('/\..*/', '', $n); 
				return $n;

			}


			/* Get the currency symbol for the currency  */  	
			function get_currency_details($currency_code, $split) {

				switch($currency_code) {

					case('AUD'):
					$cur = "Australian Dollar|&#36;";
					break;

					case('BGN'):
					$cur = "Bulgaria Lev|&#1083;&#1074;";
					break;

					case('BRL'):
					$cur = "Brazil Real|R&#36;";
					break;

					case('CAD'):
					$cur = "Canada Dollar|C&#36;";
					break;

					case('CHF'):
					$cur = "Switzerland Franc|&#165;";
					break;

					case('CZK'):
					$cur = "Czech Republic Koruna|K&#269;";
					break;

					case('DKK'):
					$cur = "Denmark Krone|kr";
					break;

					case('EUR'):
					$cur = "Euro|&#8364;";
					break;

					case('GBP'):
					$cur = "Pound|&#163;";
					break;

					case('HKD'):
					$cur = "Hong Kong Dollar|&#36;";
					break;

					case('HRK'):
					$cur = "Croatia Kuna|kn";
					break;

					case('HUF'):
					$cur = "Hungary Forint|Ft";
					break;

					case('IDR'):
					$cur = "Indonesia Rupiah|Rp";
					break;

					case('ILS'):
					$cur = "Israel Shekel|&#8362;";
					break;

					case('INR'):
					$cur = "India Rupee|&#8377;";
					break;

					case('JPY'):
					$cur = "Japan Yen|&#165;";
					break;

					case('KRW'):
					$cur = "Korea (South) Won|&#8361;";
					break;

					case('LTL'):
					$cur = "Lithuania Litas|Lt";
					break;

					case('LVL'):
					$cur = "Latvia Lat|Ls";
					break;

					case('MXN'):
					$cur = "Mexico Peso|&#36;";
					break;

					case('MYR'):
					$cur = "Malaysia Ringgit|RM";
					break;

					case('NOK'):
					$cur = "Norway Krone|kr";
					break;

					case('NZD'):
					$cur = "New Zealand Dollar|&#36;";
					break;

					case('PHP'):
					$cur = "Philippines Peso|&#8369;";
					break;

					case('PLN'):
					$cur = "Poland Zloty|&#122;&#322;";
					break;

					case('RON'):
					$cur = "Romania New Leu|&#108;&#101;&#105;";
					break;

					case('RUB'):
					$cur = "Russia Ruble|&#1088;&#1091;&#1073;";
					break;

					case('SEK'):
					$cur = "Sweden Krona|kr";
					break;

					case('SGD'):
					$cur = "Singapore Dollar|&#36;";
					break;

					case('THB'):
					$cur = "Thailand Baht|&#3647;";
					break;

					case('TRY'):
					$cur = "Turkey Lira|&#8356;";
					break;

					case('USD'):
					$cur = "United States Dollar|&#36;";
					break;		

					case('ZAR'):
					$cur = "South Africa Rand|R";
					break;

				}

		if($split == 0) { // Return just the Currency Name (United States Dollar)
			return substr($cur, 0, strpos($cur, '|'));
		}

		if($split == 1) { // Return just the Currency Symbol ($)

			$symbol = substr($cur, strpos($cur, '|') + 1);		
			return $symbol;
		}

	}


} // Close Class


?>