<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Signup extends MY_Controller {

	function __construct()
	{	
		$this->login_type	='both';
		$this->layout		='default';
		$this->access      ='nologin';
		parent::__construct();
		$this->_init();		
	}

	private function _init()
	{
		
		$this->sections['section_header'] = 'sections/header';
		$this->sections['section_footer'] = 'sections/footer';
		$this->sections['section_form']="signup/index";
		if($this->isAjax){
			$this->sections['section_popup'] = 'sections/popup/modal';
		}
		else{
			$this->sections['section_popup'] = 'sections/popup/page';
		}

	}

	public function index()
	{
		if($this->input->post())
		{
			$this->load->model("user_model");
			$insert_array = array(
				'firstname'=> $this->input->post("firstname"),
				'lastname'=> $this->input->post("lastname"),
				'email'=> $this->input->post("email"),
				'password'=> $this->input->post("password"),
				'created' => date('Y-m-d H:i:s'),
				'activation_code'=>md5(time().mt_rand())
				);
			$insert_id = $this->user_model->insert($insert_array);
			if($insert_id > 0)
			{
				$this->session->set_flashdata('success',lang("MSG_SUCC_REGISTER"));
				redirect(base_url()."signin");
			}
			else{
				$msg = (validation_errors()) ? validation_errors() : "";
				$this->session->set_flashdata('error',$msg);
				redirect(base_url()."signup");
			}
		}
		if(!$this->input->post())
		{
			if($this->isAjax){
				$this->layout=false;
				
			}
			$this->output->set_title(lang(SIGNUP_TEXT));	
			$this->body_class = "modal-inline";
			$this->view="general/popup_page";
			$this->page_title=lang(SIGNUP_TEXT);
		}
		
		/*$this->load->start_inline_scripting();
		echo "$('.signin_link').click();";
		$this->load->end_inline_scripting(false,false);*/
	}
}
