<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once("common_methods.php");
class detail extends Common_methods {

	function __construct()
	{	
		$this->login_type	='';
		$this->layout		='default';
		$this->access      ='';
		parent::__construct();
		$this->_init();
		$this->load->helper('text');
	}

	private function _init()
	{
		$this->sections['section_header'] = 'sections/header';
		$this->sections['section_connect_with_us'] = 'sections/connect_with_us';
		$this->sections['section_footer'] = 'sections/footer';
	}

	public function index($id)
	{
		$this->load->model("cars_model");
		$this->load->model("locations_model");
		$this->load->model("site_settings_model");

		$this->cars_model->offers_model_after_allow_overrite = true;
		$car_details = $this->cars_model->get($id);
		$this->cars_model->offers_model_after_allow_overrite = false;
		
		$default_location_ar = $this->site_settings_model->get_by('constant','LOCATION');

		$this->locations_model->after_get_allow = false;
		$default_location_array = $this->locations_model->set_fields("id,location_name,working_from,working_to")->get($default_location_ar["value"]);
		$this->locations_model->after_get_allow = true;

		$this->data["default_location_id"] = $default_location_ar["value"];
		$this->data["pickup_location"] = ($this->session->userdata("pickup_location") > 0) ? $this->session->userdata("pickup_location") : (($this->input->get("pickup_location") > 0) ?  $this->input->get("pickup_location") : $default_location_ar["value"]);
		$this->data["dropoff_location"] = ($this->session->userdata("dropoff_location") > 0) ? $this->session->userdata("dropoff_location") : (($this->input->get("dropoff_location")) ?  $this->input->get("dropoff_location") : $default_location_ar["value"]);
		$this->data["pickup_date"] = ($this->session->userdata("pickup_date") != '') ? $this->session->userdata("pickup_date") : (($this->input->get("pickup_date")) ?  $this->input->get("pickup_date") :'');
		$this->data["dropoff_date"] = ($this->session->userdata("dropoff_date") != "") ? $this->session->userdata("dropoff_date") : (($this->input->get("dropoff_date")) ?  $this->input->get("dropoff_date") :'');
		$this->data["pickup_time"] = ($this->session->userdata("pickup_time") != '') ? $this->session->userdata("pickup_time") : (($this->input->get("pickup_time")) ?  $this->input->get("pickup_time") :'');
		$this->data["dropoff_time"] = ($this->session->userdata("dropoff_time") != '') ? $this->session->userdata("dropoff_time") : (($this->input->get("dropoff_time")) ?  $this->input->get("dropoff_time") :'');


		$this->data["selected_pickup_location"] = $this->data["selected_dropoff_location"] = $default_location_array["location_name"];

		$this->data["working_from"] = $this->data["working_to"] = date('H:i', strtotime($default_location_array["working_from"]));
		
		$this->data["pickup_location_time"] = $this->get_opening_time_from_location($this->data["pickup_location"]);
		$this->data["dropoff_location_time"] = $this->get_opening_time_from_location($this->data["dropoff_location"]);
		
		$this->load->start_inline_scripting();
		echo "Appfd.init_home_operations();";
		$this->load->end_inline_scripting(false,false);		

		if(!empty($car_details))
		{
			$this->output->set_title(lang("Car detail - ".$car_details["name"]));
			$this->data["locations"] = $this->locations_model->get_many_by("status",'y');
			$this->data["car_details"] = $car_details;

			$related_car_where[] = array("id != $id AND groupId = '".$car_details["groupId"]."'",null,false); 
			$this->data["related_cars"] = $this->cars_model->limit(3,0)->get_many_by($related_car_where);
		}
		else{
			$this->session->set_flashdata("error","");
			redirect(base_url(),"refresh");
		}
	}
}
