<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Dashboard extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'user';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->current_url = base_url()."dashboard/";

	}
	private function _init()
	{
		$this->sections['section_header'] = 'sections/header';
		$this->sections['section_footer'] = 'sections/footer';
		$this->sections['section_menu'] = 'sections/dashboard_menu';
		$this->load->model("bookings_model");
		$total_booking_count = array('user_id'=>$this->current_session["id"]);
		$this->data["total_booking"] = $this->bookings_model->count_by($total_booking_count);
		
		$total_active_booking_count = array('user_id'=>$this->current_session["id"],'booking_status'=>'a');
		$this->data["active_booking"] = $this->bookings_model->count_by($total_active_booking_count);
		
		$total_cancelled_booking_count = array('user_id'=>$this->current_session["id"],'booking_status'=>'c');
		$this->data["cancelled_booking"] = $this->bookings_model->count_by($total_cancelled_booking_count);		

	}
	public function index()
	{
		$this->page_title = lang("Dashboard");
		$this->load->model("bookings_model");

		$bookings=$this->bookings_model->set_fields("c.name as car_name,l.location_name")->join('cars as c','c.id = bookings.car_id')->join('locations as l','l.id = bookings.pickup_location')->order_by("bookings.id","desc")->limit(5)->get_many_by('user_id',$this->current_session["id"]);

		$this->data['bookings']=$bookings;

		$notifications=$this->bookings_model->set_fields("c.name as car_name,pickup_date,booking_status")->join('cars as c','c.id = bookings.car_id')->join('locations as l','l.id = bookings.pickup_location')->order_by("bookings.id","desc")->limit(10)->get_many_by('user_id',$this->current_session["id"]);

		$this->data['notifications']=$notifications;

		$this->output->set_title($this->page_title);

	}

	public function viewbooking()
	{
		$this->load->model("bookings_model");
		$where_ar = array("user_id"=>$this->current_session["id"]);
		$this->bookings_model->after_get_user_info_allow = false;
		$this->data["bookings"] = $this->bookings_model->get_many_by($where_ar);
		$this->page_title = lang("View Booking");
		$this->output->set_title($this->page_title);

	}

	public function mybooking()
	{
		$this->page_title = lang("My Booking");
		$this->load->js('js/jquery.blockui.min.js');

		$this->output->set_title($this->page_title);
		$this->grid_resorces();
		$this->load->js('plugins/datatables/jquery.dataTables.min.js');
		$this->data['page_url']	=	'dashboard/mybooking';
		$this->data['tbl_id']		=	'tblmng_mybooking_list';
		$this->load->start_inline_scripting();
		echo "Appfd.init_mybooking_list();";
		$this->load->end_inline_scripting(false,false);
		$editurl = base_url()."booking/edit";
		$cancelurl = base_url()."booking/cancel";
		$array = array('edit'=>$editurl,'cancel'=>$cancelurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');		
		$this->datatables->select('b.id,b.booking_status,c.name,b.pickup_date,b.dropoff_date,b.booking_price',false)
		->join('cars as c','c.id = b.car_id')
		/*->add_column('operation',get_operation_btn('$1',$array),'id')*/
		->add_column('operation',get_my_booking_operation_btn('$1','$2',$array),'id,booking_status')	
		->edit_column('booking_status', '$1', 'get_booking_status(booking_status,id,"")')		
		->where('b.user_id',$this->current_session["id"])	
		->from('bookings as b');
		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];




	}

	public function notifications()
	{
		$this->page_title = lang("Notifications");
		$notifications=$this->bookings_model->set_fields("bookings.id,c.name as car_name,pickup_date,booking_status")->join('cars as c','c.id = bookings.car_id')->join('locations as l','l.id = bookings.pickup_location')->order_by("bookings.id","desc")->get_many_by('user_id',$this->current_session["id"]);

		$this->data['notifications'] = $notifications;

		$this->output->set_title($this->page_title);

	}


	public function changepassword()
	{
		if($this->input->post())
		{
			$this->load->model("user_model");
			$this->user_model->validate = array(
				'old'  => array(
					'field' => 'old',
					'label' => 'Name',
					'rules' => 'trim|required|xss_clean',
					'error_msg' => array(
						'required'  => 'lang:CURRENT_PASSWORD_REQUIRED'
						),
					),
				'new'  => array(
					'field' => 'new',
					'label' => 'Password',
					'rules' => 'required|min_length[4]|matches[new_confirm]',
					'error_msg' => array(
						'required'  => "lang:PASSWORD_REQUIRED",
						'min_length' => "lang:PASSWORD_MINIMUM_LENGTH",
						'matches' => "lang:MSG_PASSWORD_NOTMATCH"
						),
					),
				'new_confirm'  => array(
					'field' => 'new_confirm',
					'label' => 'Confirm Password',
					'rules' => 'required',
					'error_msg' => array(
						'required'  => "lang:PASSWORD_REQUIRED"						
						),
					)
				);
			$password = md5($this->input->post("new"));
			$old = md5($this->input->post("old"));


			$update_array = array('password'=>$password,"old"=>$old,"change_password"=>true);
			$upd_status = $this->user_model->update($this->current_session["id"],$update_array);
			if(parseBool($upd_status) == true)
			{			
				$success=true;
				$msg=lang(MSG_SUCC_CHANGEPASS);
			}
			else{				
				$success=false;
				$msg=(validation_errors()) ? validation_errors() : $upd_status["msg"];
			}

			if($success==true)
			{
				$this->session->set_flashdata('success',$msg);
				redirect($this->current_url);
			}
			else{
				$this->session->set_flashdata('error',$msg);
				redirect($this->current_url."changepassword");	
			}
		}

		if(!$this->input->post())
		{
			if($this->isAjax){
				$this->layout=false;				
			}
			$this->data["form_url"] = base_url()."dashboard/changepassword";
			$this->output->set_title(lang("Change Password"));	
			$this->body_class = "modal-inline";
			$this->page_title=lang("Change Password");			
		}	
	}

	public function editprofile()
	{
		if($this->input->post())
		{
			$this->load->model("user_model");
			$this->user_model->validate = array(
				'firstname'  => array(
					'field' => 'firstname',
					'label' => 'First Name',
					'rules' => 'trim|required|xss_clean',
					'error_msg' => array(
						'required'  => 'lang:FIRSTNAME_REQUIRED'
						),
					),
				'lastname'  => array(
					'field' => 'lastname',
					'label' => 'Password',
					'rules' => 'required',
					'error_msg' => array(
						'required'  => "lang:LASTNAME_REQUIRED"						
						),
					),
				'address'  => array(
					'field' => 'address',
					'label' => 'address',
					'rules' => 'required',
					'error_msg' => array(
						'required'  => "lang:ADDRESS_REQUIRED"						
						),
					),
				'city_name'  => array(
					'field' => 'city_name',
					'label' => 'City Name',
					'rules' => 'required',
					'error_msg' => array(
						'required'  => "lang:CITY_REQUIRED"						
						),
					),
				'country'  => array(
					'field' => 'country',
					'label' => 'Country',
					'rules' => 'required',
					'error_msg' => array(
						'required'  => "lang:COUNTRY_REQUIRED"						
						),
					),
				'contactNo'  => array(
					'field' => 'contactNo',
					'label' => 'Contact Number',
					'rules' => 'required',
					'error_msg' => array(
						'required'  => "lang:CONTACT_REQUIRED"						
						),
					),
				'drivinglicence_no'  => array(
					'field' => 'drivinglicence_no',
					'label' => 'Licence Number',
					'rules' => 'required',
					'error_msg' => array(
						'required'  => "lang:LICENCE_REQUIRED"						
						),
					),
				);

$firstname = ($this->input->post("firstname") != "") ? $this->input->post("firstname") : "";
$lastname = ($this->input->post("lastname")!= "") ? $this->input->post("lastname") : "";
$city = ($this->input->post("city") != "")  ? $this->input->post("city") : "" ;
$country = ($this->input->post("country") != "") ? $this->input->post("country") : "";
$aboutme = ($this->input->post("aboutMe") != "") ? $this->input->post("aboutMe") : "";
$address = ($this->input->post("address") != "") ? $this->input->post("address") : "";
$drivinglicence_no = ($this->input->post("drivinglicence_no") != "") ? $this->input->post("drivinglicence_no") : "";
$contactNo = ($this->input->post("contactNo") != "") ? $this->input->post("contactNo") : "";

$update_array = array(
	"id"=>$this->current_session["id"],
	'firstname'=>$firstname,
	"lastname"=>$lastname,
	"city"=>$city,
	"country"=>$country,				
	"aboutMe"=>$aboutme,
	"address"=>$address,
	"country"=>$country,
	"drivinglicence_no"=>$drivinglicence_no
	);

if($contactNo != '' && $contactNo != null)
{
	$update_array["contactNo"] = $contactNo;
}

$upd_status = $this->user_model->update($this->current_session["id"],$update_array);

if(parseBool($upd_status) == true)
{			
	$success=true;
	$msg=lang(PROFILE_UPDATED_SUCCESS);
}
else{				
	$success=false;
	$msg=(validation_errors()) ? validation_errors() : $upd_status["msg"];
}

if($success==true)
{
	$this->session->set_flashdata('success',$msg);
	redirect($this->current_url);
}
else{
	$this->session->set_flashdata('error',$msg);
	redirect($this->current_url."editprofile");	
}
}

if(!$this->input->post())
{
	if($this->isAjax){
		$this->layout=false;				
	}
	$this->load->css("plugins/icheck/skins/line/red.css");	
	//$this->load->js("plugins/intl-tel-input-master/build/js/utils.js");
	$this->load->js("plugins/intl-tel-input-master/build/js/intlTelInput.js");
	/*$this->load->js("plugins/intl-tel-input-master/build/js/countrySync.js");*/
	
	$this->load->css("plugins/intl-tel-input-master/build/css/intlTelInput.css");

	$this->load->start_inline_scripting();
	echo "Appfd.init_editprofile();";
	echo "Appfd.initChangePhoneCountry();";
	$this->load->end_inline_scripting(false,false);

	$this->data["form_url"] = base_url()."dashboard/editprofile";
	$this->load->model("countries_model");
	$this->data["countries"] = $this->countries_model->get_many_by("status",'y');	

	$this->output->set_title(lang("Edit Profile"));	
	$this->body_class = "modal-inline";
	$this->page_title=lang("Edit Profile");

}	
}


}
