<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once("common_methods.php");
class booking extends Common_methods 
{
	function __construct()
	{	
		if(!isset($this->from_admin))
		{
			$this->login_type = '';
			$this->layout  = 'default';
			$this->access  = '';
		}		
		parent::__construct();
		$this->_init();
	}
	
	private function _init()
	{
		$this->sections['section_header'] = 'sections/header';
		$this->sections['section_footer'] = 'sections/footer';
		$this->load->helper('text');
		$this->load->helper('string');
		$this->load->model("cars_model");
		$this->load->model("pricing_model");		
		$this->load->model("car_facilities_detail_model");
		$this->load->model("car_pickup_location_detail_model");
		$this->load->model("bookings_model");
		$this->load->model("locations_model");
		$this->load->model("characteristics_groups_model");
		$this->load->model("characteristics_model");
		$this->load->model("high_period_notification_model");
		$this->load->model("insurance_group_items_model");
		$this->load->model("insurance_group_model");
		$this->load->model("insurance_detail_model");
		$this->load->model("category_insurance_price_model");
		$this->load->model("minimum_rental_days_model");
		$this->load->model("stop_sale_period_model");
		$this->load->model("countries_model");
		$this->load->model("content_model");
		$this->load->model("locations_fee_model");
		$this->load->model("car_facilities_model");

	}

	public function index($id,$type = null)
	{	
		$this->load->css("plugins/icheck/skins/line/red.css");	
		$this->load->js("plugins/intl-tel-input-master/build/js/intlTelInput.js");
		/*$this->load->js("plugins/intl-tel-input-master/build/js/countrySync.js");
		$this->load->js("plugins/intl-tel-input-master/build/js/utils.js");*/
		$this->load->css("plugins/intl-tel-input-master/build/css/intlTelInput.css");

		if($this->input->post("pickup_location") && $this->input->post("pickup_location") > 0)
		{
			$this->session->set_userdata("pickup_location",$this->input->post("pickup_location"));
		}

		if($this->input->post("dropoff_location") && $this->input->post("dropoff_location") > 0)
		{
			$this->session->set_userdata("dropoff_location",$this->input->post("dropoff_location"));
		}

		if($this->input->post("pickup_date") && $this->input->post("pickup_date") != '')
		{
			$this->session->set_userdata("pickup_date",$this->input->post("pickup_date"));
		}

		if($this->input->post("dropoff_date") && $this->input->post("dropoff_date") != '')
		{
			$this->session->set_userdata("dropoff_date",$this->input->post("dropoff_date"));
		}

		if($this->input->post("pickup_time") && $this->input->post("pickup_time") != '')
		{
			$this->session->set_userdata("pickup_time",$this->input->post("pickup_time"));
		}

		if($this->input->post("dropoff_time") && $this->input->post("dropoff_time") != '')
		{
			$this->session->set_userdata("dropoff_time",$this->input->post("dropoff_time"));
		}

		$car_id = ($this->input->post("car_id") > 0) ? $this->input->post("car_id") : $id;
		$this->data["coupon_response"] = $this->check_coupon_exist($car_id);


		$booking_id = $this->input->post("booking_id");
		$booking_db_data = array();
		if($booking_id  > 0)
		{
			$booking_db_data = $this->bookings_model->get($booking_id);
		}

		if($booking_id > 0 && !empty($booking_db_data))
		{
			$pickup_location = $booking_db_data["pickup_location"];
			$dropoff_location = $booking_db_data["dropoff_location"]; 
			$pickup_date =  $booking_db_data["pickup_date"]; 
			$dropoff_date =  $booking_db_data["dropoff_date"]; 
			$pickup_time =  $booking_db_data["pickup_time"];
			$dropoff_time = $booking_db_data["dropoff_time"];
			$driveragenumber = "";
		}
		else
		{
			$pickup_location = ($this->session->userdata("pickup_location") > 0) ? $this->session->userdata("pickup_location") : 0;
			$dropoff_location = ($this->session->userdata("dropoff_location") > 0) ? $this->session->userdata("dropoff_location") : 0;
			$pickup_date = ($this->session->userdata("pickup_date") != '') ? $this->session->userdata("pickup_date") : '';
			$dropoff_date = ($this->session->userdata("dropoff_date") != "") ? $this->session->userdata("dropoff_date") : '';
			$pickup_time = ($this->session->userdata("pickup_time") != '') ? $this->session->userdata("pickup_time") : '';
			$dropoff_time = ($this->session->userdata("dropoff_time") != '') ? $this->session->userdata("dropoff_time") : '';
			$driveragenumber =  ($this->session->userdata("driveragenumber") != '') ? $this->session->userdata("driveragenumber") : DRIVER_MINIMUM_AGE." - ".DRIVER_MAXIMUM_AGE;
		}

		$date_of_birth = ($this->input->post("date_of_birth") != '') ? $this->input->post("date_of_birth") : '';
		$age = (date('Y') - date('Y',strtotime($date_of_birth)));
		if($age > 0)
		{
			$driveragenumber = $age;	
		}

		$type = ($this->input->post('type') != "") ? $this->input->post('type') : "";
		$offer_id = ($this->input->post('offer_id') != "") ? $this->input->post('offer_id') : "";
		$facilities = ($this->input->post('car_facilities') != "") ? $this->input->post('car_facilities') : "";
		$facility_post = array();
		if(!empty($facilities))
		{
			foreach ($facilities as $key => $value) 
			{
				if($value > 0)
				{
					$facility_post[] = $key;	
				}
			}
		}


		$insuranceGroupId = ($this->input->post('insuranceGroupId') > 0) ? $this->input->post('insuranceGroupId') : "";


		if(($age < DRIVER_MINIMUM_AGE || $age > DRIVER_MAXIMUM_AGE) && $age >= USER_MINIMUM_AGE)
		{
			$insuranceGroupId = DEFAULT_INSURANCE;
			$this->data["lock_id"] = DEFAULT_INSURANCE;
		}
		else
		{
			$this->data["lock_id"] = "";	
		}


		$this->cars_model->after_get_locations_allow = false;

		/*Custom */
		//$this->cars_model->after_get_facilities_allow = false;
		/*Custom */

		$car_data_where = array("id"=>$id,"status"=>'y');
		$this->cars_model->facility_pickup_date = $pickup_date;
		$this->cars_model->facility_dropoff_date = $dropoff_date;
		$car_data = $this->cars_model->get_by($car_data_where);	
		$this->cars_model->after_get_locations_allow = true;

		/*Custom */
		//$this->cars_model->after_get_facilities_allow = true;
		/*Custom */

		$pickup_time_ar = explode(":",$pickup_time);
		$start_date = (count($pickup_time_ar) == 3) ? $pickup_date." ".$pickup_time : $pickup_date." ".$pickup_time.":00";

		$dropoff_time_ar = explode(":",$dropoff_time);	
		$end_date = (count($dropoff_time_ar) == 3) ? $dropoff_date." ".$dropoff_time : $dropoff_date." ".$dropoff_time.":00";
		
		$booking_days =  date_difference($start_date,$end_date);

		/*printr($this->session->all_userdata());
		exit();*/

		if($id > 0 && $pickup_location > 0 && $dropoff_location > 0 && $pickup_time != "" && $dropoff_time != "" && $pickup_date != "" && $dropoff_date != "" && !empty($car_data))
		{
			$this->data["booking_msg"] = "";
			$two_month_status = $this->booking_check_maximum_two_month($pickup_date);
			if($two_month_status === false)
			{
				$this->data["booking_msg"] = lang("MAXIMUM_TWO_MONTH_BOOKING_ALLOWED");
				$this->data["booking_msg_classnm"] = "danger";
				$this->data["booking_btn_disabled"] = true;
			}
			/*Check for booking lies in upcoming two months*/

			/*Check for stop sale period change*/
			$stop_sale_records = $this->stop_sale_period_check($pickup_date,$dropoff_date,$pickup_location,$car_data['id']);
			if(!empty($stop_sale_records))
			{
				$this->data["booking_msg"] = lang("STOP_SALE_PERIOD_NOW")." between ".$stop_sale_records[0]["start_date"]." to ".$stop_sale_records[0]["end_date"].".";
				$this->data["booking_msg_classnm"] = "danger";
				$this->data["booking_btn_disabled"] = true;
			}
			/*Check for stop sale period change*/

			/*check for minimum rental days check*/
			$minimum_rental_records = $this->minimum_rental_check($pickup_date,$dropoff_date,$pickup_location,$booking_days,$dropoff_location);
			if(!empty($minimum_rental_records))
			{
				$this->data["booking_msg"] = lang("PLEASE_SELECT_MINIMUM").$minimum_rental_records["minimum_days"]." ".lang("RENTAL_DAYS");
				$this->data["booking_msg_classnm"] = "danger";
				$this->data["booking_btn_disabled"] = true;
			}
			/*check for minimum rental days check*/
			$this->pickup_date_js = $pickup_date;
			$this->dropoff_date_js = $dropoff_date;
			$this->load->start_inline_scripting();
			echo "Appfd.initBookingOperation();";
			echo "Appfd.initChangePhoneCountry();";
			/*echo "Appfd.initCarSearchFormCommon();";	*/		
			$this->load->end_inline_scripting(false,false);
			$this->data["pickup_location"] = $pickup_location;
			$this->data["dropoff_location"] = $dropoff_location;
			$pickup_location_ar = $this->locations_model->get($pickup_location);
			$dropoff_location_ar = $this->locations_model->get($dropoff_location);

			$this->data["selected_pickup_location"] = $pickup_location_ar["location_name"];
			$this->data["selected_dropoff_location"] = $dropoff_location_ar["location_name"];

			$this->data["pickup_location_nm"] = $pickup_location_ar["location_name"];
			$this->data["pickup_location_type"] = $pickup_location_ar["location_type"];
			$this->data["dropoff_location_nm"] = $dropoff_location_ar["location_name"];
			$this->data["dropoff_location_type"] = $dropoff_location_ar["location_type"];
			$this->data["pickup_date"] = $pickup_date;
			$this->data["dropoff_date"] = $dropoff_date;
			$this->data["pickup_time"] = $pickup_time;
			$this->data["dropoff_time"] = $dropoff_time;
			$this->data["car_data"] = $car_data;
			$this->data["first_name"] = ($this->current_session["firstname"] != '') ? $this->current_session["firstname"] : '';
			$this->data["last_name"] = ($this->current_session["lastname"] != '') ? $this->current_session["lastname"] : '';
			$this->data["driving_licence"] = ($this->current_session["drivinglicence_no"] != '') ? $this->current_session["drivinglicence_no"] : '';

			$this->data["email"] = ($this->current_session["email"] != '') ? $this->current_session["email"] : '';
			
			$this->data["contact_number"] = ($this->current_session["contactNo"] != '' && strlen($this->current_session["contactNo"]) > 1) ? $this->current_session["contactNo"] : '';
			
			$this->data["country"] = ($this->current_session["country"] != '') ? $this->current_session["country"]   : '';
			$this->data["address"] = ($this->current_session["address"] != '') ? $this->current_session["address"]   : '';

			$discount_coupon_val = (isset($booking_db_data) && $booking_db_data["discount_coupon"] != '') ? $booking_db_data["discount_coupon"] : 0;
			$pricingDetails_val = (isset($booking_db_data) && $booking_db_data["pricingDetails"] != '') ? $booking_db_data["pricingDetails"] : array();

			if($booking_id > 0 && !empty($booking_db_data))
			{
				$pricingDetails_val = json_decode($pricingDetails_val,true);
				$this->pricing_ar_set($car_data,$pickup_date,$pickup_time,$dropoff_date,$dropoff_time,$facility_post,$insuranceGroupId,$pickup_location,$dropoff_location,$discount_coupon_val,$pricingDetails_val,$driveragenumber,false,true,$booking_db_data);
			}
			else
			{
				$this->pricing_ar_set($car_data,$pickup_date,$pickup_time,$dropoff_date,$dropoff_time,$facility_post,$insuranceGroupId,$pickup_location,$dropoff_location,$discount_coupon_val,$pricingDetails_val,$driveragenumber,true);
			}
			
			
			$this->data["pickup_location_time"] = $this->get_opening_time_from_location($pickup_location);
			$this->data["dropoff_location_time"] = $this->get_opening_time_from_location($dropoff_location);
			/*insurance_group_items*/
			$this->data["type"] = "add";
			$this->data["formurl"] = base_url().'booking/booking_confirm/'.$car_data["id"];
			/*facilities_price_render*/	
			$this->facility_price_render($facility_post,$booking_days,$this->data["pickup_date"],$this->data["dropoff_date"],$car_data["id"],$booking_db_data);		
			
			$this->data["tandc_ar"] = $this->content_model->get_by("page_title","Terms and Conditions");

			/*category_insurance_price*/
			if($this->isAjax)
			{
				$this->view = false;
				$this->layout = false;
				$this->json = true;

				/*printr($this->data["booking_pricing"]);*/
			}
			else{
				$this->locations_model->after_get_allow = false;
				$this->data["locations"] = $this->locations_model->set_fields("id,location_name")->get_many_by("status",'y');
				$this->locations_model->after_get_allow = true;
				$this->data["countries"] = $this->countries_model->set_fields("id,country_name,iso")->order_by("country_name")->get_many_by("status",'y');
				
				/*insurance_group_items*/
				$this->get_insurance_items_data();
				/*insurance_group_items*/
				
				/*Get insurance groups*/
				$this->get_insurance_groups_data($car_data,$booking_days,$this->data["data_insurance_group_items"]);
				/*Get insurance groups*/
				$this->output->set_title(lang("Book a car &nbsp;".$car_data["name"]));	


				$this->load->library('user_agent');
				$this->data["mobile"] = $this->agent->is_mobile();
				

			}
			$this->data["price_view_render"] = $this->load->view("booking/price_detail",$this->data,true);
			/*printr($this->data);
			exit();*/
		}
		else{
			$this->session->set_flashdata("error",lang("INVALID_BOOKING_ID"));
			redirect(base_url(),"refresh");
		}
	}


	public function edit($id)
	{
		if(empty($this->current_session))
		{
			$this->session->set_flashdata("error",lang("INVALID_BOOKING_ID"));
			redirect(base_url()."dashboard","redirect");
		}
		else
		{
			$where = array('id'=>$id,'user_id'=>$this->current_session["id"]);
			$booking_data = $this->bookings_model->get_by($where);
			if(!empty($booking_data) && $booking_data["user_id"] == $this->current_session["id"])
			{
				if($booking_data["booking_status"] == "a")
				{
					$this->session->set_flashdata("error",lang("ACCEPTED_BOOKING_NOT_EDITABLE"));
					redirect(base_url()."dashboard/mybooking","refresh");
					exit();
				}
				else{

					$this->load->css("plugins/icheck/skins/line/red.css");	
					$this->load->js("plugins/intl-tel-input-master/build/js/intlTelInput.js");
					$this->load->css("plugins/intl-tel-input-master/build/css/intlTelInput.css");

					$this->cars_model->facility_pickup_date = $booking_data["pickup_date"];
					$this->cars_model->facility_dropoff_date = $booking_data["dropoff_date"];
					$car_data = $this->cars_model->get($booking_data["car_id"]);

					$this->load->start_inline_scripting();
					echo "Appfd.initBookingOperation();";
					echo "Appfd.initCarSearchFormCommon();";			
					$this->load->end_inline_scripting(false,false);

					$facility_post = array();
					if(!empty($booking_data["booking_selected_facilities"]))
					{
						foreach ($booking_data["booking_selected_facilities"] as $key => $value) 
						{
							if($value > 0)
							{
								$facility_post[] = $key;	
							}
						}
					}

					$start_date = $booking_data["pickup_date"]." ".$booking_data["pickup_time"];
					$end_date = $booking_data["dropoff_date"]." ".$booking_data["dropoff_time"];

					$booking_days =  date_difference($start_date,$end_date);

					$this->data["formurl"] = base_url().'booking/booking_confirm/'.$car_data["id"];
					$this->data["pickup_location"] = $booking_data["pickup_location"];
					$this->data["dropoff_location"] = $booking_data["dropoff_location"];
					$pickup_location_ar = $this->locations_model->get($booking_data["pickup_location"]);
					$dropoff_location_ar = $this->locations_model->get($booking_data["dropoff_location"]);
					$this->data["pickup_location_type"] = $pickup_location_ar["location_type"];
					$this->data["selected_pickup_location"] = $this->data["pickup_location_nm"] = $pickup_location_ar["location_name"];
					
					$this->data["selected_dropoff_location"] = $this->data["dropoff_location_nm"] = $dropoff_location_ar["location_name"];

					$this->data["pickup_date"] = $booking_data["pickup_date"];
					$this->data["dropoff_date"] = $booking_data["dropoff_date"];
					$this->data["pickup_time"] = $booking_data["pickup_time"];
					$this->data["dropoff_time"] = $booking_data["dropoff_time"];
					$this->data["car_data"] = $car_data;
					$this->data["first_name"] = ($booking_data["firstname"] != ''  && $booking_data["firstname"] != null) ? $booking_data["firstname"] : $this->current_session["firstname"];
					$this->data["last_name"] = ($booking_data["lastname"] != ''  && $booking_data["lastname"] != null) ? $booking_data["lastname"] : $this->current_session["lastname"];
					$this->data["driving_licence"] = ($this->current_session["drivinglicence_no"] != '') ? $this->current_session["drivinglicence_no"] : '';
					$this->data["email"] = ($this->current_session["email"] != '') ? $this->current_session["email"] : '';
					$this->data["contact_number"] = ($this->current_session["contactNo"] != '') ? $this->current_session["contactNo"] : '';
					$this->data["insuranceGroupId"] = ($booking_data["insurance"] > 0) ? $booking_data["insurance"] : 0;
					$this->data["booking_selected_facilities"] = (!empty($booking_data["booking_selected_facilities"])) ? $booking_data["booking_selected_facilities"] : '';
					$this->data["country"] = ($this->current_session["country"] > 0) ? $this->current_session["country"] : 0;
					$this->pricing_ar_set($car_data,$booking_data["pickup_date"],$booking_data["pickup_time"],$booking_data["dropoff_date"],$booking_data["dropoff_time"],$facility_post,$booking_data["insuranceGroupId"],$booking_data["pickup_location"],$booking_data["dropoff_location"],$booking_data["discount_coupon"],$booking_data["pricingDetails"],$booking_data["driverage"],true);
					$this->data["pickup_location_time"] = $this->get_opening_time_from_location($booking_data["pickup_location"]);
					$this->data["dropoff_location_time"] = $this->get_opening_time_from_location($booking_data["dropoff_location"]);
					$this->data["booking_id"] = $booking_data["id"];
					$this->data["user_note"] = $booking_data["note"];
					$this->data["date_of_birth"] = $booking_data["date_of_birth"];
					$this->data["address"] = $booking_data["address"];
					$this->data["flight_number"] = $booking_data["flight_no"];

					/*insurance_group_items*/

					/*facilities_price_render*/			
					$this->facility_price_render($facility_post,$booking_days,$this->data["pickup_date"],$this->data["dropoff_date"],$this->data["car_data"]["id"]);
					
					$this->data["locations"] = $this->locations_model->set_fields("id,location_name")->get_many_by("status",'y');
					$this->data["countries"] = $this->countries_model->set_fields("id,country_name")->get_many_by("status",'y');
					$this->get_insurance_items_data();

					/*insurance_group_items*/
					$this->get_insurance_groups_data($car_data,$booking_days,$this->data["data_insurance_group_items"]);
					$this->data["tandc_ar"] = $this->content_model->get_by("page_title","Terms and Conditions");
					/*Get insurance groups*/
					$this->output->set_title(lang("Book a car".$car_data["name"]));	
					$this->data["price_view_render"] = $this->load->view("booking/price_detail",$this->data,true);
					$this->data["type"] = "edit";
					$this->view = "booking/index";
				}
			}
			else
			{
				$this->session->set_flashdata("error",lang("INVALID_BOOKING_ID"));
				redirect(base_url()."dashboard","redirect");
			}
		}
	}

	public function cancel($id)
	{
		if($this->isAjax)
		{
			$this->view = false;
			$this->layout = false;
			$this->json = true;

			if(empty($this->current_session))
			{
				$this->session->set_flashdata("error",lang("INVALID_BOOKING_ID"));
				redirect(base_url(),"redirect");
			}
			else
			{
				$where = array('id'=>$id,'user_id'=>$this->current_session["id"]);
				$booking_data = $this->bookings_model->get_by($where);
				if(!empty($booking_data))
				{
					$this->bookings_model->usercancel_by_admin = true;
					$update_ar = array('booking_status'=>'c');
					$update_status = $this->bookings_model->update($id,$update_ar,true);
					$this->bookings_model->usercancel_by_admin = false;
					if($update_status == true)
					{
						$this->data["status"] = "success";
						$this->data["msg"] = lang("MSG_BOOKING_CANCELLED_SUCCESSFULLY");
					}
					else{
						$this->data["status"] = "error";
						$this->data["msg"] = lang("BOOKING_CANCELLED_UNSUCCESSFULLY");					
					}
				}
				else
				{
					$this->session->set_flashdata("error",lang("INVLID_BOOKING_ID"));
					redirect(base_url()."bookings","refresh");
				}
			}
		}
		else
		{

		}
	}

	public function facility_price_render($facility_post,$booking_days,$pickup_date,$dropoff_date = '',$car_id = '',$booking_db_data = array())
	{
		if(!empty($facility_post))
		{
			
			$this->car_facilities_model->pickup_date = $pickup_date;
			$this->car_facilities_model->dropoff_date = $dropoff_date;
			$this->car_facilities_model->car_id = $car_id;

			$facilities_where[] = array('car_facilities.id IN ('.implode(",",$facility_post).')',null,false);
			$get_facilities_data = $this->car_facilities_model->set_fields("car_facilities.*")->get_many_by($facilities_where);
			foreach ($get_facilities_data as $key => $value) 
			{
				$temp_text = '';
				if(isset($value["is_promo_code"]) && $value["is_promo_code"] == "yes")
				{
					if($value["promo_code_type"] == 'a')
					{
						$price_dis =  $booking_days * $value["promo_code_price"];
					}
					else
					{
						$price_dis = 0;
					}
				}
				else
				{
					if($value["type"] == "m")
					{
						$post_value_check_quantity = $this->input->post("car_facilities")[$value['id']];
						if($value["daily_cost"] == 0)
						{
							$price_dis  = ($post_value_check_quantity * $value["price"]);
						}	
						else{
							$all_days_facilities_price = $booking_days*($post_value_check_quantity * $value["price"]);
							if($all_days_facilities_price > $value['maximum_cost']){
								$price_dis = $value['maximum_cost'];
							}
							else{
								$price_dis = $all_days_facilities_price;
							}
						}
						$temp_text = $post_value_check_quantity;
					}
					else
					{
						if($value["daily_cost"] == 0)
						{
							$price_dis = $value["price"];
						}	
						else{
							$all_days_facilities_price = $booking_days*$value["price"];
							if($all_days_facilities_price > $value['maximum_cost']){
								$price_dis = $value['maximum_cost'];
							}
							else{
								$price_dis =  $all_days_facilities_price;
							}
						}	
					}
				}

				if(array_key_exists($value["id"], $booking_db_data["booking_selected_facilities_price"]))
				{
					$price_dis = $booking_db_data["booking_selected_facilities_price"][$value["id"]];
				}

				$fac_name = $value["facility_name"];
				if(isset($temp_text) && $temp_text != '')
				{
					$fac_name .= " X ".$temp_text."  ";
				}

				$this->data["facilities_price_render"][$fac_name] =  number_format($price_dis, 2);
			}
		}
		return true;
	}

	public function get_insurance_items_data()
	{
		$insurance_group_items = $this->insurance_group_items_model->get_all();
		if(!empty($insurance_group_items))
		{
			$data_insurance_group_items = array();
			$data_insurance_group_items[0]["id"] = 0;
			$data_insurance_group_items[0]["name"] = 'Excess Amount';
			$tempkey = 1;
			
			foreach ($insurance_group_items as $key => $value) 
			{
				$data_insurance_group_items[] = $value;
				if(count($insurance_group_items) == $tempkey)
				{
					$last_key = $value["id"];
				}
				$tempkey++;	

			}

			$data_insurance_group_items[$tempkey]["id"] = ($last_key > 0) ?  $last_key + 1 : $tempkey + 1;
			$data_insurance_group_items[$tempkey]["name"] = 'Price';
			$this->data["data_insurance_group_items"] = $data_insurance_group_items;			
		}
		return true;
	}


	public function get_insurance_groups_data($car_data,$booking_days,$insurance_group_items)
	{
		array_pop($insurance_group_items);
		$insurance_groups = $this->insurance_group_model->get_all();
		if(!empty($insurance_groups))
		{
			$data_insurance_group = array();
			$tempkey = 1;
			foreach ($insurance_groups as $key => $group) 
			{
				$where_ar = array('groupId'=>$group["id"],'categoryId'=>$car_data["categoryId"]);
				$var_ar = $this->category_insurance_price_model->set_fields("price,deposit,max_price")->get_by($where_ar);
				$temp1[0]["name"] = 'Deposit';
				$temp1[0]['text'] = display_decimal_price($var_ar["deposit"]);;
				$temp1[0]['type'] = "text";
				$temp1[0]['check'] = false;
				if(!empty($insurance_group_items))
				{
					foreach ($insurance_group_items as $key => $value_n) 
					{
						$exist_check_where = array('groupId'=>$group["id"],'itemId'=>$value_n["id"]);
						$exist_check = $this->insurance_detail_model->get_by($exist_check_where);
						$response[$value_n["id"]] = (!empty($exist_check)) ? true  : false;
					}
				}
				$temp2 = $response;
				$k = $temp1+$temp2;

				/*printr($k);*/


				$total_insurance_price = $var_ar["price"] * $booking_days;
				if($total_insurance_price > $var_ar["max_price"])
				{
					$total_insurance_price = $var_ar["max_price"];
				}
				$temp_k['name'] = 'Price';
				$temp_k['text'] = display_decimal_price($total_insurance_price);
				$temp_k['type'] = "text";
				$temp_k['check'] = false;
				array_push($k,$temp_k);
				$group["items"] = $k;
				$data_insurance_group[] = $group;
			}
		}
		$this->data["data_insurance_group"] = $data_insurance_group;
		/*printr($data_insurance_group);
		exit();*/
		return true;
	}

	public function pricing_ar_set($car_data,$pickup_date,$pickup_time,$dropoff_date,$dropoff_time,$facility_post,$insuranceGroupId,$pickup_location,$dropoff_location,$discount_coupon = 0,$pricingDetails = array(),$driveragenumber = '',$price_changed_flag = false,$price_change_flag = false,$booking_db_data = array())
	{

		if($driveragenumber == '')
		{
			$driveragenumber = DRIVER_MINIMUM_AGE." - ".DRIVER_MAXIMUM_AGE;
		}

		if($price_changed_flag === true && !empty($pricingDetails))
		{
			$price_ar = json_decode($pricingDetails,true);
		}
		else 
		{
			$this->pricing_model->car_category = $car_data["categoryId"];
			$this->pricing_model->pickup_date = $pickup_date;
			$this->pricing_model->pickup_time = $pickup_time;
			$this->pricing_model->dropoff_date = $dropoff_date;
			$this->pricing_model->dropoff_time = $dropoff_time;
			$this->pricing_model->car_id = $car_data["id"];
			$this->pricing_model->booking_selected_facilities = $facility_post;
			$this->pricing_model->insuranceGroupId = $insuranceGroupId;
			$this->pricing_model->pickup_location = $pickup_location;
			$this->pricing_model->dropoff_location = $dropoff_location;
			$this->pricing_model->booking_user_driveragenumber = $driveragenumber;
			$price_ar = $this->pricing_model->get_car_price($car_data,$discount_coupon,$pricingDetails,$price_change_flag,$booking_db_data);
		}
		

		if(!empty($car_data["bigger_car_data"]))
		{
			$this->pricing_model->car_id = $car_data["bigger_car_data"]["id"];
			$bigger_car_data_price_ar = $this->pricing_model->get_car_price();
			$this->data["car_data"]["bigger_car_data"]["bigger_car_per_day_price"] = 	$bigger_car_data_price_ar["per_day_price"] - $price_ar["per_day_price"];
		}

		if(!empty($price_ar))
		{
			$this->data["booking_pricing"]["original_price"] = $price_ar["original_price"];
			$this->data["booking_pricing"]["advanced_price"] = $price_ar["advanced_price"];
			$this->data["booking_pricing"]["basic_price"] = $price_ar["basic_price"];
			$this->data["booking_pricing"]["dropoff_price"] = $price_ar["dropoff_price"];
			$this->data["booking_pricing"]["per_day_price"] = $price_ar["per_day_price"];
			$this->data["booking_pricing"]["total"] = $price_ar["total"];
			$this->data["booking_pricing"]["special_offer_price"] = $price_ar["special_offer_price"];
			$this->data["booking_pricing"]["coupon_applied_price"] = $price_ar["coupon_applied_price"];
			$this->data["booking_pricing"]["booking_total_days"] = $price_ar["booking_total_days"];
			$this->data["booking_pricing"]["driver_age_price"] = $price_ar["driver_age_price"];
			$this->data["booking_pricing"]["from_time_surcharge_price"] = isset($price_ar["from_time_surcharge_price"]) ? $price_ar["from_time_surcharge_price"] : 0;
			$this->data["booking_pricing"]["to_time_surcharge_price"] = isset($price_ar["to_time_surcharge_price"]) ? $price_ar["to_time_surcharge_price"] : 0;
			$this->data["booking_pricing"]["insurance_price"] = isset($price_ar["insurance_price"]) ? $price_ar["insurance_price"] : 0;		
			$this->data["booking_pricing"]["driver_age_price_default"] = $price_ar["driver_age_price_default"];
			$this->data["booking_pricing"]["time_surcharge_price"] = $price_ar["time_surcharge_price"];
			$this->data["booking_pricing"]["insurance_text"] = $price_ar["insurance_text"];
		}
		return true;
	}


	public function booking_confirm($car_id)
	{


		$first_name = ($this->input->post('first_name') != '') ? $this->input->post('first_name') : '';
		$last_name = ($this->input->post('last_name') != '') ? $this->input->post('last_name') : '';
		$driving_licence = ($this->input->post('driving_licence') != '') ? $this->input->post('driving_licence') : '';
		$email = ($this->current_session["email"] != '') ? $this->current_session["email"] : (($this->input->post('email') != '') ? $this->input->post('email') : "");
		$contact_number = ($this->input->post('contact_number') != '') ? $this->input->post('contact_number') : '';
		$country = ($this->input->post('country') > 0) ? $this->input->post('country') : 0;
		$note = ($this->input->post('note') != '') ? $this->input->post('note') : '';
		$address = ($this->input->post('address') != '') ? $this->input->post('address') : '';
		$pickup_location = ($this->session->userdata("pickup_location") > 0) ? $this->session->userdata("pickup_location") : (($this->input->post("pickup_location") > 0) ?  $this->input->post("pickup_location") : 0);
		$dropoff_location = ($this->session->userdata("dropoff_location") > 0) ? $this->session->userdata("dropoff_location") : (($this->input->post("dropoff_location") > 0) ?  $this->input->post("dropoff_location") : 0);
		$pickup_date =  ($this->session->userdata("pickup_date") > 0) ? $this->session->userdata("pickup_date") : (($this->input->post("pickup_date") > 0) ?  $this->input->post("pickup_date") : 0);
		$dropoff_date = ($this->session->userdata("dropoff_date") > 0) ? $this->session->userdata("dropoff_date") : (($this->input->post("dropoff_date") > 0) ?  $this->input->post("dropoff_date") : 0);
		$pickup_time = ($this->session->userdata("pickup_time") > 0) ? $this->session->userdata("pickup_time") : (($this->input->post("pickup_time") > 0) ?  $this->input->post("pickup_time") : 0);
		$dropoff_time = ($this->session->userdata("dropoff_time") > 0) ? $this->session->userdata("dropoff_time") : (($this->input->post("dropoff_time") > 0) ?  $this->input->post("dropoff_time") : 0);
		$type = ($this->input->post('type') != "") ? $this->input->post('type') : "";
		$offer_id = ($this->input->post('offer_id') != "") ? $this->input->post('offer_id') : "";
		$facilities = ($this->input->post('car_facilities') != "") ? $this->input->post('car_facilities') : "";
		$insuranceGroupId = ($this->input->post('insuranceGroupId') > 0) ? $this->input->post('insuranceGroupId') : "";
		$flight_no = ($this->input->post('flight_number') != '') ? $this->input->post('flight_number') : "";
		/*$user_note = ($this->input->post('user_note') != '') ? $this->input->post('user_note') : "";*/
		$car_where = array("id"=>$car_id,"status"=>'y');
		$car_data = $this->cars_model->get_by($car_where);

		$date_diff_pickup_date = $pickup_date." ".$pickup_time.":00";
		$date_diff_dropoff_date = $dropoff_date." ".$dropoff_time.":00";
		$booking_days = date_difference($date_diff_pickup_date,$date_diff_dropoff_date);
		$booking_id = ($this->input->post("booking_id") > 0) ? $this->input->post("booking_id") : 0;
		$booking_status = ($this->input->post("booking_status") != '') ? $this->input->post("booking_status") : 'p';
		
		$accept_terms = ($this->input->post("accept_terms") != '') ? $this->input->post("accept_terms") : '';
		$receive_newsletter = ($this->input->post("receive_newsletter") != '') ? $this->input->post("receive_newsletter") : '';
		$phone_extension = ($this->input->post("phone_extension") != '') ? $this->input->post("phone_extension") : '';
		
		$date_of_birth = ($this->input->post("date_of_birth") != '') ? $this->input->post("date_of_birth") : '';
		if($date_of_birth == '0000-00-00' || $date_of_birth == '0001-11-30')
		{	
			$this->session->set_flashdata("error","Invalid date of birth.Please select date of birth by click.");
			redirect(base_url()."search");
			exit();
		}
		
		$date_of_birth_year = date('Y',strtotime($date_of_birth));
		$date_of_birth_month = date('m',strtotime($date_of_birth));
		$date_of_birth_day = date('d',strtotime($date_of_birth));

		$age = count_age($date_of_birth_day,$date_of_birth_month,$date_of_birth_year);
		
		if($age < USER_MINIMUM_AGE)
		{
			$this->session->set_flashdata("error","You must elder then ".USER_MINIMUM_AGE."to book car");
			redirect(base_url()."search");
			exit();
		}
		
		$driveragenumber =  ($this->session->userdata("driveragenumber") != '') ? $this->session->userdata("driveragenumber") : DRIVER_MINIMUM_AGE." - ".DRIVER_MAXIMUM_AGE;

		$driveragenumber = $age;


		if(($age < DRIVER_MINIMUM_AGE || $age > DRIVER_MAXIMUM_AGE) && $age >= USER_MINIMUM_AGE)
		{
			$insuranceGroupId = DEFAULT_INSURANCE;			
		}
		
		if($car_id > 0 && $pickup_location > 0 && $dropoff_location > 0 && $pickup_time != "" && $dropoff_time != "" && $pickup_date != "" && $dropoff_date != "" && !empty($car_data))
		{
			$two_month_status = $this->booking_check_maximum_two_month($pickup_date);
			$stop_sale_status = false;
			$stop_sale_records = $this->stop_sale_period_check($pickup_date,$dropoff_date,$pickup_location,$car_data['id']);

			if(!empty($stop_sale_records))
			{
				$stop_sale_status = true;
			}
			/*Check for stop sale period change*/

			/*check for minimum rental days check*/
			$minimum_rental_records = $this->minimum_rental_check($pickup_date,$dropoff_date,$pickup_location,$booking_days);
			$minimum_rental_check_status = false;
			if(!empty($minimum_rental_records))
			{
				$minimum_rental_check_status = true;
			}
			/*check for minimum rental days check*/

			if($stop_sale_status == true || $two_month_status == false || $minimum_rental_check_status == true)
			{
				$this->index($id);
			}
			else
			{
				$facility_post = array();
				if(!empty($facilities))
				{
					foreach ($facilities as $key => $value) 
					{
						if($value > 0)
						{
							$facility_post[] = $key;	
						}
					}
				}

				if($booking_id > 0)
				{
					$booking_data = $this->bookings_model->get($booking_id);
				}

				$this->pricing_model->car_category = $car_data["categoryId"];
				$this->pricing_model->pickup_location = $pickup_location;
				$this->pricing_model->dropoff_location = $dropoff_location;
				$this->pricing_model->pickup_date = $pickup_date;
				$this->pricing_model->pickup_time = $pickup_time;
				$this->pricing_model->dropoff_date = $dropoff_date;
				$this->pricing_model->dropoff_time = $dropoff_time;
				$this->pricing_model->car_id = $car_data["id"];
				$this->pricing_model->booking_selected_facilities = $facility_post;
				$this->pricing_model->insuranceGroupId = $insuranceGroupId;
				$this->pricing_model->booking_user_driveragenumber = $driveragenumber;

				if($booking_id > 0)
				{
					$pricingDetailsArray = json_decode($booking_data["pricingDetails"],true); 
					$price_ar = $this->pricing_model->get_car_price($car_data,0,$pricingDetailsArray,true,$booking_data);					
				}
				else
				{
					$price_ar = $this->pricing_model->get_car_price($car_data);
				}

				/*printr($this->input->post());
				printr($this->session->all_userdata());
				exit();*/

				/*$new_booking_id 	= date("dmYHis").random_string('nozero',6);*/
				
				$coupon_id = $this->session->userdata("coupon_id");
				$booking_insert_ar = array(
					'pickup_location' => $pickup_location,
					'dropoff_location' => $dropoff_location,
					'pickup_date' => $pickup_date,
					'dropoff_date' => $dropoff_date,
					'pickup_time' => $pickup_time,
					'dropoff_time' => $dropoff_time,					
					'car_category' => $car_data["categoryId"],
					'discount_coupon' => $coupon_id,
					'insurance' => $insuranceGroupId,
					'special_offer' => '',
					'note' => $user_note,
					'sub_total' => $price_ar["original_price"],
					'booking_price' => $price_ar["total"],
					'currency_code' => '',
					'flight_no' => $flight_no,
					'api_reservation_id' => '',
					'email' => $email,
					'contactNo' => $contact_number,
					'country' => $country,
					'note' => $note,
					"pricingDetails" => json_encode($price_ar),
					'booking_status'=>$booking_status,
					'address'=>$address,					
					'date_of_birth' => $date_of_birth
					);

				$booking_insert_ar["driving_licence"] = $driving_licence;	
				if($booking_id > 0)
				{
					$booking_data = $this->bookings_model->get($booking_id);
					$booking_insert_ar["user_id"] = $booking_data["user_id"];
					$booking_insert_ar["booking_id"] = $booking_data["id"];
					$update_status = $this->bookings_model->update($booking_id,$booking_insert_ar,true);
					$this->session->set_flashdata("success",lang("MSG_SUCC_EDIT_BOOKING"));
					redirect(base_url()."dashboard","refresh");
				}
				else
				{

					$booking_insert_ar["accept_terms"] = $accept_terms;
					$booking_insert_ar["receive_newsletter"] = $receive_newsletter;

					$booking_insert_ar["car_id"] = $car_id;
					$booking_insert_ar["firstname"] = $first_name;
					$booking_insert_ar["lastname"] = $last_name;
					/*$booking_insert_ar["booking_no"] = $new_booking_id;*/
					$booking_insert_ar["booking_no"] = '';
					$booking_insert_ar["ip_address"] = $this->input->ip_address();
					$booking_insert_ar["booking_date"] = date('Y-m-d');
					/*$driveragenumber  = $this->session->userdata("driveragenumber");*/
					if(isset($driveragenumber) && $driveragenumber != '')
					{
						$booking_insert_ar["driverage"] = $driveragenumber;						
						$this->session->unset_userdata("driveragenumber");
					}
					$booking_id = $this->bookings_model->insert($booking_insert_ar);
					if($booking_id > 0)
					{
						$this->session->unset_userdata("pickup_location");
						$this->session->unset_userdata("dropoff_location");
						$this->session->unset_userdata("pickup_date");
						$this->session->unset_userdata("dropoff_date");
						$this->session->unset_userdata("pickup_time");
						$this->session->unset_userdata("dropoff_time");
						$this->session->unset_userdata("coupon_id");
						$this->session->set_flashdata("success",lang("MSG_SUCC_CONF_BOOKING"));
						
						/*Session name*/
						$this->session->set_flashdata("booking_user_name",$first_name.' '.$last_name);
						$this->session->set_flashdata("booking_user_email",$email);
						
						redirect(base_url()."thankyou","refresh");
						exit();
					}
					else
					{
						
					}					
				}
			}
		}
		else{
			$this->session->set_flashdata("error",lang("SOMETHING_WENT_WRONG"));
			redirect(base_url(),"refresh");
		}
	}


	public function booking_check_maximum_two_month($pickup_date)
	{	
		/*Check for booking lies in upcoming two months*/
		$booking_max_date = date('Y-m-d', strtotime('+'.ADVANCED_BOOKING_PERIOD.' months'));
		$booking_max_date_timespan = strtotime($booking_max_date);
		$bookingdate_timespan = strtotime($pickup_date);
		if($booking_max_date_timespan < $bookingdate_timespan)
		{
			return false;
		}
		/*Check for booking lies in upcoming two months*/
		return true;
	}

	public function stop_sale_period_check($pickup_date,$dropoff_date,$pickup_location,$car_id)
	{
		/*$where_ar[] = array("(('".$pickup_date."' BETWEEN start_date AND end_date) OR ('".$dropoff_date."' BETWEEN start_date AND end_date)) AND status='y' AND locationId = '".$pickup_location."' AND categoryId = '".$categoryId."'",null,false);
		$stop_sale_records = $this->stop_sale_period_model->set_fields("categoryId,start_date,end_date")->get_many_by($where_ar);*/


		$where_ar[] = array("(('".$pickup_date."' BETWEEN stop_sale_period.start_date AND stop_sale_period.end_date) OR ('".$dropoff_date."' BETWEEN stop_sale_period.start_date AND stop_sale_period.end_date)) ",null,false);

		$stop_sale_records = $this->stop_sale_period_model
		->join("stop_sale_period_location_detail as ss_ld","ss_ld.stopsaleId = stop_sale_period.id AND ss_ld.locationId = '".$pickup_location."'")
		->join("stop_sale_period_cars_detail as ss_cd","ss_cd.stopsaleId = stop_sale_period.id AND ss_cd.carId = '".$car_id."'")
		->set_fields("stop_sale_period.id,ss_cd.carId,ss_ld.locationId")
		->get_many_by($where_ar);





		return $stop_sale_records;
	}	

	public function minimum_rental_check($pickup_date,$dropoff_date,$pickup_location,$booking_days,$dropoff_location)
	{
		
		$where_ar_rental_days[] = array("(('".$pickup_date."' BETWEEN start_date AND end_date) OR ('".$dropoff_date."' BETWEEN start_date AND end_date)) AND locationId = '".$pickup_location."' AND days > '".$booking_days."'",null,false);
		$minimum_rental_records = $this->minimum_rental_days_model->get_by($where_ar_rental_days);
		if(empty($minimum_rental_records))
		{	
			/* check for location fee */
			$location_fee_where = array("fromId"=>$pickup_location,"toId"=>$dropoff_location);
			$records = $this->locations_fee_model->get_by($location_fee_where);
			if(!empty($records))
			{
				if($records["minimum_days"] > $booking_days)	
				{
					$minimum_rental_records = $records;
				}	
			}
			/* check for location fee ends */
		}
		else if(!empty($minimum_rental_records))
		{
			$minimum_rental_records["minimum_days"] = $minimum_rental_records["days"];
		}
		return $minimum_rental_records;
	}
}
