<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_subadmin extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->load->model("admin_model");
		$this->page ='admin/manage_subadmin/';
		$this->current_url = base_url()."admin/manage_subadmin/";
	}
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}

	public function index()
	{
		$this->grid_resorces();
		$this->output->set_title(lang("Manage Sub Admin"));
		$this->page_name = lang("Manage Sub Admin");
		$this->data['page_url']	=	'manage_subadmin';
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->data['tbl_id']		=	'tblmng_subadmin';
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_subadmin();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$array = array('edit'=>$editurl,'delete'=>$deleteurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		$this->datatables->select('id,username,email,status',false)
		->edit_column('status', '$1', 'get_status(status,id,"manage_subadmin/change_user_status")')
		->add_column('operation',get_operation_btn('$1',$array),'id')	
		->from('admin')
		->where('adminType','g');
		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}

	public function add()
	{
		$data = array();
		if($this->input->post())
		{
			$this->load->helper('string');
			$data = array(
				'username' => $this->input->post('username'),
				'password' => md5($this->input->post('password')),
				'email' => $this->input->post('email'),
				'createdDate'	=>date("Y-m-d h:i:s"),
				'status'=>'y',				
				'last_ip' => $this->input->ip_address()
				);
			$status = $this->admin_model->insert($data);
			if($status)
			{
				$this->session->set_flashdata('success',lang(MSG_REC_ADD));
				redirect($this->current_url);				
			}else{
				$this->session->set_flashdata('error',lang(validation_errors()));
				redirect($this->current_url."add");	
			}
		}
		if(!$this->input->post())
		{
			$this->page_type = 'add';
			$text = "Add Sub Admin";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."add";
			$this->load->model("adminsection_model");
			$this->data["roles_ar"] = $this->adminsection_model->subadmin_roles();
			$this->data["existing_roles_ar"] = array();
			$this->view = $this->page."add_edit";
		}
	}


	public function edit($id=NULL){

		if($id != NULL && $id > 0){
			$this->load->model("admin/subadmin_roles_model");
			$data = array();
			$where_ar = array('adminId'=>$id);
			$existing_roleid_ar = $this->subadmin_roles_model->set_fields("roleId")->get_many_by($where_ar);
			if(!empty($existing_roleid_ar))
			{
				$existing_roles = array();
				$this->data["existing_roles_ar"] = array();
				foreach ($existing_roleid_ar as $key => $value) 
				{
					$existing_roles[] = $value["roleId"];
				}
			}

			if($this->input->post())
			{
				$roles = $this->input->post('roles');
				if(!empty($roles))
				{
					$update_status = $this->subadmin_roles_model->update_roles($id,$roles,$existing_roles);
					if(!empty($update_status)) 
					{
						$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
						redirect($this->current_url,"refresh");
					}else{
						$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));
						redirect($this->current_url.'edit/'.$id,"refresh");
					}
				}
			}
			else if(!$this->input->post()){
				$this->data["user_data"] = $this->admin_model->as_array()->get($id);
				if($this->data["user_data"])
				{
					$text = "Edit user - ".$this->data["user_data"]["email"];
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->load->model("adminsection_model");
					$this->data["roles_ar"] = $this->adminsection_model->subadmin_roles();
					$this->data["existing_roles_ar"] = $existing_roles;
					$this->data["form_url"] = $this->current_url.'edit/'.$id;	
					$this->data["action"] = "edit";
					$this->view = $this->page."add_edit";
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}


	

	public function change_status()
	{

		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$user_id = $this->input->post('user_id');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			if($user_id > 0){
				$this->users_data = $this->admin_model->set_fields("id,status")->as_array()->get($user_id);
				if(!empty($this->users_data))
				{
					if($this->users_data['status'] == 'n'){
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$response = $this->admin_model->update($user_id,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}
		}
	}


	
	public function delete($id){
		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->admin_model->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = "tblmng_subadmin";
			}
		}
	}
}
