<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_out_of_hours_fee extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->modal_name = "out_of_hours_fee_model";
		$this->load->model($this->modal_name);
		$this->page ='admin/manage_out_of_hours_fee/';
		$this->current_url = base_url()."admin/manage_out_of_hours_fee/";
		$this->table_id = "tblmng_outofhoursfee";
	}
	
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}

	public function index()
	{
		$this->grid_resorces();
		$text = "Manage out of hours fee";
		$this->output->set_title(lang($text));
		$this->page_name = lang($text);
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->data['tbl_id']		=	$this->table_id;

		$this->load->model("locations_model");
		$this->locations_model->after_get_allow = false;
		$this->data["locations"] = $this->locations_model->get_many_by('status','y');
		$this->locations_model->after_get_allow = true;
		
		$this->data["out_of_hours_page"] = true;
		
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_out_of_hours_fee();";
		$this->load->end_inline_scripting(false,false);
		
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$array = array('edit'=>$editurl,'delete'=>$deleteurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		$this->datatables->select('oohf.id,l.location_name as from_location,oohf.start_date,oohf.end_date,oohf.from_time,oohf.to_time,oohf.out_of_hour_fee,oohf.status',false)
		->join("locations as l","l.id = oohf.locationId","left")
		/*->edit_column('locations', '$1', 'get_stop_sale_locations(id,"out_of_hours_fee")')*/
		->edit_column('from_time', '$1', 'get_time_out_of_hour_fee(from_time)')
		->edit_column('to_time', '$1', 'get_time_out_of_hour_fee(to_time)')
		->edit_column('status', '$1', 'get_status(status,id,"")')
		->add_column('operation',get_operation_btn('$1',$array),'id')
		->from('out_of_hours_fee as oohf');

		$location = $this->input->get("location");
		if($location > 0){
			$this->datatables->where('oohf.locationId =', $location);
		}

		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}

	public function add()
	{
		$data = array();
		if($this->input->post())
		{
			$type = $this->input->post('type');
			$locationId = $this->input->post('locationId');
			$insert_status_msg = array();
			$start_date = $this->input->post("start_date");
			$end_date = $this->input->post("end_date");
			$from_time = $this->input->post("from_time");
			$to_time = $this->input->post("to_time");
			$out_of_hour_fee = $this->input->post("out_of_hour_fee");

			if(!empty($start_date))
			{
				foreach ($start_date as $key => $value) 
				{
					$start_date_currect = $value[0];
					$end_date_currect = $end_date[$key][0];
					$from_time_currect = $from_time[$key][0];
					$to_time_current = $to_time[$key][0];
					$out_of_hour_fee_current = $out_of_hour_fee[$key][0];

					$where_ar[] = array("(('".$start_date_currect."' BETWEEN start_date AND end_date) OR ('".$end_date_currect."' BETWEEN start_date AND end_date)) AND from_time = '".$from_time_currect."' AND to_time = '".$to_time_current."' AND locationId = '".$locationId."'",null,false);
					$exist_check = $this->{$this->modal_name}->get_by($where_ar);
					if(!empty($exist_check))
					{
						/*$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
						redirect($this->current_url."add");	*/
						$insert_status_msg[] = $start_date_currect." ".$end_date_currect." Record already exist.";
					}
					else
					{
						$data = array(
							'locationId' => $locationId,
							'start_date' => $start_date_currect,
							'end_date' => $end_date_currect,
							'from_time' => $from_time_currect,
							'to_time' => $to_time_current,
							'out_of_hour_fee' => $out_of_hour_fee_current,					
							'created_date' => date('Y-m-d H:i:s')					
							);
						$status = $this->{$this->modal_name}->insert($data);
					}
				}
			}

			if(empty($insert_status_msg))
			{
				$this->session->set_flashdata('success',lang(MSG_REC_ADD));
				redirect($this->current_url);	
				exit();
			}

			

		}
		if(!$this->input->post())
		{
			$this->load->model("locations_model");
			$this->load->js('js/components-date-time-pickers.js');
			$this->page_type = 'add';
			$text = "Add out of hour fee";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."add";
			$this->locations_model->after_get_allow = false;
			$this->data["locations"] = $this->locations_model->get_many_by('status','y');
			$this->locations_model->after_get_allow = true;

			$this->locations_model->after_get_allow = false;
			$default_location_array = $this->locations_model->set_fields("id,location_name,working_from,working_to")->get($default_location_ar["value"]);
			$this->locations_model->after_get_allow = true;

			$working_from_ar = explode(":",$default_location_array["working_from"]);
			array_pop($working_from_ar);
			$this->data["working_from"] = implode(":",$working_from_ar);

			$this->data["working_to"] = $this->data["working_from"];	

			$this->data["selected_pickup_location"] = $this->data["selected_dropoff_location"] = $default_location_array["location_name"];
			$this->data["default_location"] = $default_location_ar["value"];
			$this->data["location_time_ar"] = self::get_opening_time_from_location($default_location_ar["value"]);


			$this->load->start_inline_scripting();
			echo "Appad.init_mng_out_of_hours_fee_operations();";
			$this->load->end_inline_scripting(false,false);

			$this->view = $this->page."add_edit";
		}
	}

	public function edit($id=NULL)
	{
		if($id != NULL && $id > 0)
		{
			$this->load->model("locations_model");
			$data = array();
			$this->data["out_of_hour_data"] = $this->{$this->modal_name}->as_array()->get($id);
			if($this->input->post())
			{
				$locationId = $this->input->post('locationId');
				$insert_status_msg = array();

				$start_date = $this->input->post("start_date");
				$end_date = $this->input->post("end_date");
				$from_time = $this->input->post("from_time");
				$to_time = $this->input->post("to_time");
				$out_of_hour_fee = $this->input->post("out_of_hour_fee");
				$db_exist_id = $this->input->post("db_exist_id");

				if(!empty($start_date))
				{
					foreach ($start_date as $key => $value) 
					{
						$start_date_currect = $value[0];
						$end_date_currect = $end_date[$key][0];
						$from_time_currect = $from_time[$key][0];
						$to_time_current = $to_time[$key][0];
						$out_of_hour_fee_current = $out_of_hour_fee[$key][0];
						$db_exist_id_current = $db_exist_id[$key][0];
						$where_ar = array();
						if($db_exist_id_current > 0)
						{
							$where_ar[] = array("(('".$start_date_currect."' BETWEEN start_date AND end_date) OR ('".$end_date_currect."' BETWEEN start_date AND end_date)) AND from_time = '".$from_time_currect."' AND to_time = '".$to_time_current."' AND locationId = '".$locationId."'",null,false);
							$where_ar[] = array("out_of_hours_fee.id != '".$db_exist_id_current."'",null,false);
						}
						else
						{
							$where_ar[] = array("(('".$start_date_currect."' BETWEEN start_date AND end_date) OR ('".$end_date_currect."' BETWEEN start_date AND end_date)) AND from_time = '".$from_time_currect."' AND to_time = '".$to_time_current."' AND locationId = '".$locationId."'",null,false);							
						}

						$exist_check = $this->{$this->modal_name}->get_by($where_ar);
						if(empty($exist_check))
						{
							$data = array(
								'start_date' => $start_date_currect,
								'end_date' => $end_date_currect,
								'from_time' => $from_time_currect,
								'to_time' => $to_time_current,
								'out_of_hour_fee' => $out_of_hour_fee_current			
								);

							if($db_exist_id_current > 0)
							{
								$operation_status = $this->{$this->modal_name}->update($db_exist_id_current,$data,true);
							}
							else
							{
								$data["locationId"] = $locationId;
								$data["created_date"] = date('Y-m-d H:i:s');
								$operation_status = $this->{$this->modal_name}->insert($data,true);
							}
						}
						else
						{
							$insert_status_msg[] = $start_date_currect." ".$end_date_currect." Record already exist.";
						}
					}
				}

				if(empty($insert_status_msg))
				{
					$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
					redirect($this->current_url);	
					exit();
				}

				

			}
			else if(!$this->input->post())
			{
				$this->load->js('js/components-date-time-pickers.js');
				if(!empty($this->data["out_of_hour_data"]))
				{
					$this->locations_model->after_get_allow = false;
					$this->data["locations"] = $this->locations_model->get_many_by('status','y');
					$this->locations_model->after_get_allow = true;

					$this->locations_model->after_get_allow = false;
					$default_location_array = $this->locations_model->set_fields("id,location_name,working_from,working_to")->get($this->data["out_of_hour_data"]["locationId"]);
					$this->locations_model->after_get_allow = true;

					$working_from_ar = explode(":",$default_location_array["working_from"]);
					array_pop($working_from_ar);
					$this->data["working_from"] = implode(":",$working_from_ar);

					$this->data["working_to"] = $this->data["working_from"];	

					$this->data["selected_pickup_location"] = $this->data["selected_dropoff_location"] = $default_location_array["location_name"];
					$this->data["default_location"] = $default_location_ar["value"];
					$this->data["location_time_ar"] = self::get_opening_time_from_location($default_location_ar["value"]);

					$this->load->start_inline_scripting();
					echo "Appad.init_mng_out_of_hours_fee_operations();";
					$this->load->end_inline_scripting(false,false);

					$this->data["get_location_fee_records"] = $this->{$this->modal_name}->get_many_by("locationId",$this->data["out_of_hour_data"]["locationId"]);

					$text = "Edit out of hours fee";
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->data["form_url"] = $this->current_url.'edit/'.$id;	
					$this->data["action"] = "edit";
					$this->view = $this->page."add_edit";
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}

	public function change_status()
	{
		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$offer_id = $this->input->post('offer_id');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			if($offer_id > 0){
				$this->status_data = $this->{$this->modal_name}->set_fields("id,status")->as_array()->get($offer_id);
				if(!empty($this->status_data))
				{
					if($this->status_data['status'] == 'n'){
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$response = $this->{$this->modal_name}->update($offer_id,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}
		}
	}

	public function delete($id)
	{
		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->{$this->modal_name}->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = $this->table_id;
			}
		}
	}


	public function get_html()
	{
		if($this->isAjax)
		{
			$location_id = $this->input->post("location_id");
			$this->data["timestamp"] = $this->input->post("timestamp");

			$this->data["status"] = "";
			$this->data["msg"] = "Please try again.";
			$this->view = false;
			$this->layout = false;
			$this->json = true;

			$time_array = array();
			$default_array = array();
			$this->load->model("locations_model");
			$type = ($this->input->post('type') != '') ? $this->input->post('type') : $type;
			$open=0;
			$close=0;

			$start=strtotime('00:00');
			$end=strtotime('23:30');		
			for ($halfhour=$start;$halfhour<=$end;$halfhour=$halfhour+30*60) {
				$temp = date('H:i',$halfhour);
				$default_array[$temp]=$temp;
			}
			$this->locations_model->after_get_allow = false;
			$data = $this->locations_model->get($location_id);
			$this->locations_model->after_get_allow = true;

			if($data and $data['opening_from'] != "" and $data['opening_to'] != "")
			{
				$open=strtotime($data['opening_from']);
				$close=strtotime($data['opening_to']);
			}

			if($open != "" && $close != "" && $close > $open)
			{		
				for ($halfhour=$open;$halfhour<=$close;$halfhour=$halfhour+30*60) 
				{
					$temp = date('H:i',$halfhour);
					$time_array[$temp]=$temp;
				}
			}
			else{
				$time_array=$default_array;
			}

			$working_from_ar = explode(":",$data["working_from"]);
			array_pop($working_from_ar);
			$working_from = implode(":",$working_from_ar);

			$working_to_ar = explode(":",$data["working_to"]);
			array_pop($working_to_ar);
			$working_to = implode(":",$working_to_ar);

			$this->data["location_time_ar"] = $time_array;

			$this->data["feehtml"] = $this->load->view("admin/manage_out_of_hours_fee/fee_detail",$this->data,true);




		}

	}

	public function get_opening_time_from_location($location_id = 0,$type = '')
	{
		$time_array=array();
		$default_array = array();
		$this->load->model("locations_model");
		$location_id = (int)($this->input->post('location_id') > 0) ? (int)$this->input->post('location_id') : $location_id;
		$type = ($this->input->post('type') != '') ? $this->input->post('type') : $type;
		$open=0;
		$close=0;

		$start=strtotime('00:00');
		$end=strtotime('23:30');		
		for ($halfhour=$start;$halfhour<=$end;$halfhour=$halfhour+30*60) {
			$temp = date('H:i',$halfhour);
			$default_array[$temp]=$temp;
		}
		$this->locations_model->after_get_allow = false;
		$data = $this->locations_model->get($location_id);
		$this->locations_model->after_get_allow = true;

		if($data and $data['opening_from'] != "" and $data['opening_to'] != "")
		{
			$open=strtotime($data['opening_from']);
			$close=strtotime($data['opening_to']);
		}

		if($open != "" && $close != "" && $close > $open)
		{		
			for ($halfhour=$open;$halfhour<=$close;$halfhour=$halfhour+30*60) 
			{
				$temp = date('H:i',$halfhour);
				$time_array[$temp]=$temp;
			}
		}
		else{
			$time_array=$default_array;
		}

		$working_from_ar = explode(":",$data["working_from"]);
		array_pop($working_from_ar);
		$working_from = implode(":",$working_from_ar);


		$working_to_ar = explode(":",$data["working_to"]);
		array_pop($working_to_ar);
		$working_to = implode(":",$working_to_ar);

		if($this->isAjax)
		{
			$this->layout = false;
			$this->view = false;
			$this->json = true;

			if(!empty($type))
			{
				$name = ($type=='pickup_location') ? 'pickup_time' : 'dropoff_time';
				$compare_var = $working_from;

				$content .= "<select name='".$name."' id='".$name."' class='form-control time custfield'>";
				foreach ($time_array as $key => $value) 
				{
					if($value == $compare_var)
					{
						$selected = 'selected';
					}
					else
					{
						$selected = ''; 
					}
					$content .= "<option ".$selected." value='".$value."'>".$value."</option>";
				} 			
				$content .= "</select>";
				$this->data['time_data'] = $content;
			}	
		}
		else{
			return $time_array;
		}
	}
}
