<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_coupons extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->modal_name = "coupons_model";
		$this->load->model($this->modal_name);
		$this->page ='admin/manage_coupons/';
		$this->current_url = base_url()."admin/manage_coupons/";
		$this->table_id = "tblmng_coupons";
	}
	
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}

	public function index()
	{
		$this->grid_resorces();
		$text = "Manage Coupons";
		$this->output->set_title(lang($text));
		$this->page_name = lang($text);
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->data['tbl_id']		=	$this->table_id;
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_coupons();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$array = array('edit'=>$editurl,'delete'=>$deleteurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		$this->datatables->select('id,code,type,value,all_cars,max_usage,start_date,end_date,minimum_total,status',false)
		->edit_column('status', '$1', 'get_status(status,id,"")')
		->edit_column('type', '$1', 'get_discount_type(type,id,"")')
		->edit_column('all_cars', '$1', 'get_all_cars_text(all_cars,id,"")')
		->add_column('operation',get_operation_btn('$1',$array),'id')			
		->from('coupons');
		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}

	public function add()
	{

		$data = array();
		if($this->input->post())
		{
			$code_post = $this->input->post('code');
			$type = $this->input->post('type');
			$value = $this->input->post('value');
			$all_cars = $this->input->post('all_cars');
			$max_usage = $this->input->post('max_usage');
			$minimum_total = $this->input->post('minimum_total');
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			
			$exist_check = $this->{$this->modal_name}->get_by("code",$code_post);
			if(!empty($exist_check))
			{
				$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
				redirect($this->current_url."add");	
			}
			else{
				$data = array(
					'code' => $code_post,
					'type' => $type,
					'value' => $value,
					'all_cars' => $all_cars,
					'max_usage' => $max_usage,
					'start_date' => $start_date,
					'end_date' => $end_date,
					'minimum_total' => $minimum_total,
					'created' => date('Y-m-d H:i:s')					
					);
				$status = $this->{$this->modal_name}->insert($data);
				/*printr($status);
				exit();*/
				if($status)
				{
					$this->session->set_flashdata('success',lang(MSG_REC_ADD));
					redirect($this->current_url);				
				}else{
					$this->session->set_flashdata('error',lang(validation_errors()));
					redirect($this->current_url."add");	
				}				
			}
		}
		if(!$this->input->post())
		{
			$this->load->js('js/components-date-time-pickers.js');
			$this->page_type = 'add';
			$text = "Add Coupon";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."add";
			$this->load->model("cars_model");
			$this->load->start_inline_scripting();
			echo "Appad.init_coupon_oprations();";
			$this->load->end_inline_scripting(false,false);
			$this->data["cars"] = $this->cars_model->set_fields("id,name")->get_many_by('status','y');
			$this->view = $this->page."add_edit";
		}
	}

	public function edit($id=NULL){
		if($id != NULL && $id > 0){
			$data = array();


			$animeties_array = array("db_sel_cars");
			$this->data["coupon_data"] = $this->{$this->modal_name}->as_array()->get($id);
			if(!empty($animeties_array))
			{
				foreach ($animeties_array as $key => $value) {
					if(!empty($this->data["coupon_data"][$value]))
					{
						$this->data["coupon_data"][$value."_ids"] = array();
						foreach ($this->data["coupon_data"][$value] as $key => $value1) {
							$this->data["coupon_data"][$value."_ids"][] = $value1["carId"];
						}
						unset($this->data["coupon_data"][$value]);
					}	
				}
			}

			/*printr($this->data);
			exit();*/

			if($this->input->post())
			{
				$code_post = $this->input->post('code');
				$type = $this->input->post('type');
				$value = $this->input->post('value');
				$all_cars = $this->input->post('all_cars');
				$max_usage = $this->input->post('max_usage');
				$minimum_total = $this->input->post('minimum_total');
				$start_date = $this->input->post('start_date');
				$end_date = $this->input->post('end_date');

				$where_ar[] = array("code = '".$code_post."'",null,false);
				$where_ar[] = array("id != '".$id."'",null,false);
				$exist_check = $this->{$this->modal_name}->get_by($where_ar);
				if(!empty($exist_check))
				{
					$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
					redirect($this->current_url."edit/".$id);	
				}
				else{				

					$data = array(
						'code' => $code_post,
						'type' => $type,
						'value' => $value,
						'all_cars' => $all_cars,
						'max_usage' => $max_usage,
						'start_date' => $start_date,
						'end_date' => $end_date,
						'minimum_total' => $minimum_total,
						"id"=>$id,
						"db_sel_cars"=>	$this->data["coupon_data"]["db_sel_cars_ids"]		
						);
					if(!empty($data))
					{
						$update_status = $this->{$this->modal_name}->update($id,$data);
						if(!empty($update_status)) 
						{
							$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
							redirect($this->current_url,"refresh");
						}else{
							$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));
							redirect($this->current_url.'edit/'.$id,"refresh");
						}
					}					
				}
			}
			else if(!$this->input->post())
			{
				$this->load->js('js/components-date-time-pickers.js');
				if($this->data["coupon_data"])
				{
					$text = "Edit Coupon";
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->data["form_url"] = $this->current_url.'edit/'.$id;	
					$this->data["action"] = "edit";
					$this->load->model("cars_model");
					$this->data["cars"] = $this->cars_model->set_fields("id,name")->get_many_by('status','y');

					if($this->data["coupon_data"]["all_cars"] == "1")
					{
						$this->data["checked"] = true;						
					}


					$this->view = $this->page."add_edit";
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}

	public function change_status()
	{

		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$stop_sale_id = $this->input->post('stop_sale_id');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			if($stop_sale_id > 0){
				$this->status_data = $this->{$this->modal_name}->set_fields("id,status")->as_array()->get($stop_sale_id);
				if(!empty($this->status_data))
				{
					if($this->status_data['status'] == 'n'){
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$response = $this->{$this->modal_name}->update($stop_sale_id,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}
		}
	}

	public function delete($id){

		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->{$this->modal_name}->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = $this->table_id;
			}
		}
	}
}
