<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_contents extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->load->model("content_model");
		$this->page ='admin/manage_contents/';
		$this->current_url = base_url()."admin/manage_contents/";
	}
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';
	}
	public function index()
	{	
		$this->grid_resorces();
		$this->page_name = lang("Manage Content");
		$this->output->set_title(lang("Manage Content"));
		$this->load->js('plugins/datatables/jquery.dataTables.min.js');
		$this->data['page_url']	=	'manage_content_list';
		$this->data['tbl_id']		=	'tblmng_content_list';
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_content_list();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$array = array('edit'=>$editurl,'delete'=>$deleteurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		$this->datatables->select('id,page_title,display_position,status,sort_order',false)
		->edit_column('status', '$1', 'get_status(status,id,"manage_contents/change_user_status")')
		->add_column('operation',get_operation_btn('$1',$array),'id')	
		->from('content');
		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}
	
	public function change_status(){
		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$content_id = $this->input->post('content_id');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			$this->load->model("content_model");
			if($content_id > 0){
				$this->User_data = $this->content_model->set_fields("id,status")->as_array()->get($content_id);

				if(!empty($this->User_data))
				{
					if($this->User_data['status'] == 'n'){
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$response = $this->content_model->update($content_id,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}

		}
	}


	public function add()
	{
		if($this->input->post())
		{

			if($this->input->post('page_type') == "e")
			{
				$this->content_model->validate = array(
					'page_title'  => array(
						'field' => 'page_title',
						'label' => 'Page Title',
						'rules' => 'trim|required|xss_clean',
						'error_msg' => array(
							'required'  => 'lang:CONTENT_PAGE_TITLE_REQUIRED'
							),
						),					
					'footer_category'  => array(
						'field' => 'footer_category',
						'label' => 'Footer Category',
						'rules' => 'trim|required|xss_clean',
						'error_msg' => array(
							'required'  => 'lang:CONTENT_FOOTER_CATEGORY_REQUIRED'
							),
						),
					'page_type'  => array(
						'field' => 'page_type',
						'label' => 'Page Type',
						'rules' => 'trim|required|xss_clean',
						'error_msg' => array(
							'required'  => 'lang:CONTENT_PAGE_TYPE_REQUIRED'
							),
						),
					'external_link'  => array(
						'field' => 'external_link',
						'label' => 'Link',
						'rules' => 'trim|required|xss_clean',
						'error_msg' => array(
							'required'  => 'lang:CONTENT_EXTERNAL_LINK_REQUIRED'
							),
						),	
					);
			}
			$data = array(
				'page_title' => $this->input->post('page_title'),
				'sort_order' =>  $this->input->post('sort_order'),
				'display_position' => $this->input->post('display_position'),
				'meta_keyword' =>  $this->input->post('meta_keyword'),
				'meta_description' =>  $this->input->post('meta_description'),
				'page_description' =>  $this->input->post('page_description'),
				'page_type' =>  $this->input->post('page_type'),
				'external_link' =>  $this->input->post('external_link'),
				'footer_category' =>  $this->input->post('footer_category'),
				'created_date' => date('Y-m-d H:i:s')				
				);

			if($this->input->post('booking_form_title') != '')
			{
				$data["booking_form_title"] = $this->input->post('booking_form_title');
			}

			if($this->input->post('allow_booking_form') != '')
			{
				$data["allow_booking_form"] = $this->input->post('allow_booking_form');
			}

			$slug = $this->input->post("slug");
			$config = array(
				'field' => 'slug',
				'title' => 'page_title',
				'table' => 'content',
				'id' => 'id',
				);
			$this->load->library('slug', $config);
			$slug = $this->slug->_check_uri($slug);	
			$data["slug"] = $slug;
			$id = $this->content_model->insert($data);
			if($id > 0) 
			{
				$this->session->set_flashdata('success',lang(MSG_REC_ADD));
				redirect('/admin/manage_contents',"refresh");
			}else{
				$msg_t = (validation_errors()) ? validation_errors() : lang(MSG_FILL_ALL_FIELDS);
				$this->session->set_flashdata('error',$msg_t);
				redirect('/admin/manage_contents/add',"refresh");
			}
		}
		else
		{
			/*$random = mt_rand();*/
			$this->load->helper(array('url','language'));
			/*$this->load->js("plugins/ckeditor/ckeditor.js?timestamp=$random");*/
			$this->load->js("plugins/ckeditor/ckeditor.js");
			$this->page_type = 'add';
			$this->page_name = lang("Add Content");
			$this->output->set_title(lang("Add Content"));
			$this->load->model("footer_category_model");
			$this->data['footer_categories'] =	$this->footer_category_model->get_many_by('status','y');
			$this->data['page_url']				=	'manage_contents/add';
			$this->data['form_url']	= $this->current_url.'add';	
			$this->data["dispAllfield"] = true;
			$this->load->start_inline_scripting();
			echo "Appad.init_mng_content_operations();";
			$this->load->end_inline_scripting(false,false);
			$this->view = $this->page."add_edit";
		}
	}

	public function edit($id=NULL){
		$this->data["content_data"] = $this->content_model->as_array()->get($id);
		if($this->data["content_data"])
		{
			if($id != NULL && $id > 0){
				if($this->input->post()){

					if($this->data["content_data"]["display_type"] == "page")
					{
						$data = array(
							'page_title' => $this->input->post('page_title'),
							'sort_order' =>  $this->input->post('sort_order'),
							'display_position' => $this->input->post('display_position'),
							'meta_keyword' =>  $this->input->post('meta_keyword'),
							'meta_description' =>  $this->input->post('meta_description'),
							'page_description' =>  $this->input->post('page_description'),
							'page_type' =>  $this->input->post('page_type'),
							'external_link' =>  $this->input->post('external_link'),
							'footer_category' =>  $this->input->post('footer_category'),
							);
					}
					else{
						$data = array(
							'page_title' => $this->input->post('page_title'),
							'sort_order' =>  $this->input->post('sort_order'),
							'page_description' =>  $this->input->post('page_description'),
							'page_type' =>  $this->input->post('page_type'),
							'external_link' =>  $this->input->post('external_link'),
							'footer_category' =>  $this->input->post('footer_category'),
							);						
						$this->content_model->validate = array(
							'page_title'  => array(
								'field' => 'page_title',
								'label' => 'Page Title',
								'rules' => 'trim|required|xss_clean',
								'error_msg' => array(
									'required'  => 'lang:CONTENT_PAGE_TITLE_REQUIRED'
									),
								),
							'sort_order'  => array(
								'field' => 'sort_order',
								'label' => 'Sort Order',
								'rules' => 'trim|required|xss_clean',
								'error_msg' => array(
									'required'  => 'lang:CONTENT_SORT_ORDER_REQUIRED'
									),
								),
							'page_description'  => array(
								'field' => 'page_description',
								'label' => 'Page Description',
								'rules' => 'trim|required|xss_clean',
								'error_msg' => array(
									'required'  => 'lang:CONTENT_PAGE_DESCRIPTION_REQUIRED'
									),
								),	
							);
					}
					$data["id"] = $id;

					if($this->input->post('booking_form_title') != '')
					{
						$data["booking_form_title"] = $this->input->post('booking_form_title');
					}

					
					if($this->input->post('allow_booking_form') != '')
					{
						$data["allow_booking_form"] = $this->input->post('allow_booking_form');
					}

					$config = array(
						'field' => 'slug',
						'title' => 'page_title',
						'table' => 'content',
						'id' => 'id',
						);
					$this->load->library('slug', $config);

					$slug_create_data = array(
						'page_title' => $this->input->post('page_title'),
						);
					$data['slug'] = $this->slug->create_uri($slug_create_data, $id);
					$update_status = $this->content_model->update($id,$data);
					if($update_status) 
					{
						$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
						redirect('/admin/manage_contents',"refresh");
					}else{
						$msg_t = (validation_errors()) ? validation_errors() : lang(MSG_FILL_ALL_FIELDS);
						$this->session->set_flashdata('error',$msg_t);
						redirect('/admin/manage_contents/edit/'.$id,"refresh");
					}

				}else if(!$this->input->post()){
					/*$random = mt_rand();*/
					$this->load->helper(array('url','language'));
					/*$this->load->js("plugins/ckeditor/ckeditor.js?timestamp=$random");*/
					$this->load->js("plugins/ckeditor/ckeditor.js");
					$this->page_type = 'edit';
					$this->data["dispAllfield"] = true;
					if(isset($this->data["content_data"]["display_type"]) && $this->data["content_data"]["display_type"] == 'section'){
						$this->data["dispAllfield"] = false;
					}

					$text = "Edit Content - ".$this->data["content_data"]["page_title"];
					$this->load->model("footer_category_model");
					$this->data['footer_categories'] =	$this->footer_category_model->get_many_by('status','y');
					
					$this->data['edit_option'] = true;
					$this->data['edit_option_title'] =	$this->data["content_data"]["page_title"];
					$this->data['display_position'] =	$this->data["content_data"]["display_position"];

					
					$this->load->start_inline_scripting();
					echo "Appad.init_mng_content_operations();";
					$this->load->end_inline_scripting(false,false);
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->data['form_url']	=	$this->current_url.'edit/'.$id;
					$this->data["action"] = "edit";
					$this->view = $this->page."add_edit";
				}
			}
		}
		else{
			$this->session->set_flashdata('error',lang(INVALID_REQUEST));
			redirect($this->current_url);
		}

	}


	/* end of the add edit user code */

	public function imageupload()
	{
		$this->view = false;
		$this->layout = false;
		
		$asset_upload_dir = FCPATH.'assets/upload/'; 
		$asset_locations_dir = FCPATH.'assets/upload/home_sections/'; 


		if(!file_exists($asset_upload_dir)){
			mkdir($asset_upload_dir,777);
		}

		if(!file_exists($asset_locations_dir)){
			mkdir($asset_locations_dir,777);
		}
		/*echo "ZCF";*/

		$config['upload_path'] =  FCPATH.'assets/upload/home_sections/';
		$config['allowed_types'] = 'gif|jpg|jpeg|png|bmp|jpe';
		$config['overwrite'] = FALSE;
		$this->load->library('upload');
		$funcNum = $this->input->get('CKEditorFuncNum'); 
		$this->upload->initialize($config);
		
		if (!$this->upload->do_upload('upload')){ 
			$this->data["message"] = "Upload failed on blog manager server.";
			$url = '';

		}
		else{ 
			$upload_result = base_url() . 'assets/upload/home_sections/'. $this->upload->data()['file_name'];
			$url = base_url() . 'assets/upload/home_sections/'. $this->upload->data()['file_name'];
			$upload_name = $this->upload->data()['file_name'];
			/*$this->data["url"] = $this->BlogModel->UploadImage($blogID, $upload_result, $upload_name); */
			$message = 'Upload success!';;
		}
		echo "<script type='text/javascript'>window.parent.CKEDITOR.tools.callFunction($funcNum, '$url', '$message');</script>";
		/*}*/
	}

	/* delete user code start */

	public function delete($id){
		$this->load->model("content_model");
		$this->data["status"] = "fail";
		$this->data["msg"] = lang(PLEASE_TRY_AGAIN);
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0)
		{
			$del_status = $this->content_model->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = "tblmng_content_list";
			}
		}
	}
	/* end of the delete user code */

	public function get_slug()
	{
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($this->isAjax)
		{
			$page_title = $this->input->post("page_title");
			$config = array(
				'field' => 'slug',
				'title' => 'page_title',
				'table' => 'content',
				'id' => 'id',
				);
			$this->load->library('slug', $config);
			$slug = $this->slug->create_uri($page_title);
			if($slug != '')
			{
				$this->data["status"] = "success";
				$this->data["slug"] = $slug;
			}
		}
	}
}
