<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_abuse_list extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->modal_name = "abuse_model";
		$this->load->model($this->modal_name);
		$this->page ='admin/manage_abuse_list/';
		$this->current_url = base_url()."admin/manage_abuse_list/";
	}
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';
		redirect(base_url()."admin/dashboard");		
		exit();
	}
	public function index()
	{
		$this->grid_resorces();
		$this->page_name = lang("Manage Abuse Words");
		$this->output->set_title(lang("Manage Abuse Words"));
		$this->data['page_url']	=	'manage_abuse_words';
		$this->data['tbl_id']		=	'tblmng_abuse_word';
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_abuse_word();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$array = array('edit'=>$editurl,'delete'=>$deleteurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		$this->datatables->select('id,abuseKeyword,status',false)
		->edit_column('status', '$1', 'get_status(status,id)')
		->add_column('operation',get_operation_btn('$1',$array),'id')
		
		->from('abuse');
		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}

	public function add()
	{
		if($this->input->post())
		{
			$data = array();
			$data['abuseKeyword'] = $this->input->post('abusekeyword');
			$data['createdDate'] = date('Y-m-d H:i:s');
			$status = $this->abuse_model->insert($data);
			if($status)
			{
				$this->session->set_flashdata('success',lang(MSG_REC_ADD));
				redirect($this->current_url);				
			}
			else{
				$msg_t = (validation_errors()) ? validation_errors() : lang(MSG_FILL_ALL_FIELDS);
				$this->session->set_flashdata('error',$msg_t);
				redirect($this->current_url."add");	
			}
		}
		if(!$this->input->post())
		{
			$this->page_type = 'add';
			$text = "Add Abuse Keyword";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."add";
			$this->view = $this->page."add_edit_abuse";
		}
	}


	public function edit($id=NULL){
		if($id != NULL && $id > 0){
			if($this->input->post())
			{
				$data = array();

				$where_ar[] = array("abuseKeyword = '".$this->input->post('abusekeyword')."'",null,false);
				$where_ar[] = array("id != '".$id."'",null,false);
				$exist_check = $this->{$this->modal_name}->get_by($where_ar);

				if(!empty($exist_check))
				{
					$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
					redirect($this->current_url."add");	
				}
				else{
					$data['abuseKeyword'] = $this->input->post('abusekeyword');
					$update_status = $this->abuse_model->update($id,$data);
					if($update_status) 
					{
						$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
						redirect($this->current_url,"refresh");
					}
					else{
						$msg_t = (validation_errors()) ? validation_errors() : lang(MSG_FILL_ALL_FIELDS);
						$this->session->set_flashdata('error',$msg_t);
						redirect($this->current_url.'edit/'.$id,"refresh");
					}
				}				
			}
			else if(!$this->input->post()){
				$this->data["keyword_data"] = $this->abuse_model->as_array()->get($id);
				if($this->data["keyword_data"])
				{
					$text = "Edit Abuse Keyword - ".$this->data["keyword_data"]["abuseKeyword"];
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->data["form_url"] = $this->current_url.'edit/'.$id;	
					$this->data["action"] = "edit";
					$this->view = $this->page."add_edit_abuse";
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}

	public function change_status()
	{
		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$keyword_id = $this->input->post('keyword_id');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			
			if($keyword_id > 0){
				$this->slider_data = $this->abuse_model->set_fields("id,status")->as_array()->get($keyword_id);
				if(!empty($this->slider_data))
				{
					if($this->slider_data['status'] == 'n'){
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$response = $this->abuse_model->update($keyword_id,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}
		}
	}

	public function delete($id){
		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->abuse_model->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = "tblmng_abuse_word";
			}
		}
	}
}
