<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class login extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'nologin';
		parent::__construct();
		$this->_init();
	}
	private function _init()
	{
		$this->layout 	= 'admin/login_default';
	}
	public function index()
	{
		$this->output->set_title(lang("Login"));
		if(!$this->input->post()){
			$this->body_class = 'login';
			$this->load->css('nova/css/login-3.css');
			$this->forgot_url 	=   base_url().'admin/forgotpassword';
			$this->register_url 	=   base_url().'register';
			$this->sections['section_header']='sections/admin/login_section/header';
			$this->sections['section_footer']='sections/admin/login_section/footer';
			$action_url=base_url()."admin/login";
			$this->data['action_url']=$action_url;
			
			$this->view = "admin/login/index";
		}

		if($this->input->post()){
			$this->load->model("admin_model");
			$result = $this->admin_model->check_login();
			
			if($result["status"] == "success")
			{
				$this->session->set_flashdata('success',$result["msg"]);
				$redirect_sess_url = $this->session->userdata("redirect_sess_url");
				if($redirect_sess_url != "")
				{	
					$this->session->unset_userdata("redirect_sess_url");
					redirect($redirect_sess_url,"refresh");
				}
				else
				{
					redirect(base_url()."admin/dashboard");
				}				
			}
			else{
				$this->session->set_flashdata('error',$result["msg"]);
				redirect(base_url()."admin/login");
			}
		}
	}
}
