<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class site_settings_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'site_settings';
	protected $CI;
	public $before_delete = array( 'before_delete' );
	public $validate = array(
		'SITE_NM'  => array(
			'field' => 'SITE_NM',
			'label' => 'SITE Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:SITE_SETTINGS_SITE_NAME'
				),
			),	
		'ADMIN_EMAIL'  => array(
			'field' => 'ADMIN_EMAIL',
			'label' => 'Admin Email',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:SITE_SETTINGS_ADMIN_EMAIL'
				),
			),
		'CONTACT_EMAIL'  => array(
			'field' => 'CONTACT_EMAIL',
			'label' => 'Contact Email',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:SITE_SETTINGS_CONTACT_EMAIL'
				),
			),
		'LOCATION'  => array(
			'field' => 'LOCATION',
			'label' => 'Location',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:SITE_SETTINGS_LOCATION_REQUIRED'
				),
			)
		);
	public $after_get = array( 'after_scan_get' );	
	public function __construct()
	{
		
		parent::__construct();
		$this->current_session=$this->current_session;
		$this->current_login_type=$this->current_login_type;
		$this->CI=& get_instance();
	}

	public function before_delete($data)
	{
		if(!$this->current_session)
		{	
			$data['before_return']['msg']=lang(INVALID_REQUEST);				
		}

		$setings_data = $this->get($data);
		if($setings_data["constant"] == "SITE_LOGO")
		{
			$exist_check_path = FCPATH."assets/nova/img/site_setting/".$setings_data["image"];			
			if(file_exists($exist_check_path) && $exist_check_path!='')
			{
				unlink($exist_check_path);
			}
		}

		
		return $data;
	}

	public function after_scan_get($data)
	{

		if(!empty($data))
		{
			if(!defined($data["constant"]))
			{
				define($data["constant"],$data["value"]);	
			}
		}
		return $data;
	}
}
