<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Search_model extends My_Model
{
	public $primary_key = 'id';
	public $get_insurance_details = false;
	public $_table = 'cars';
	protected $CI;
	public $is_fleet_guide = false;
	public $pickup_location = 0;
	public $dropoff_location = 0;
	public $booking_user_driveragenumber = 0;	
	public $transmission_sort_id = 0;	
	public $pickup_date;
	public $dropoff_date;
	public $pickup_time;
	public $dropoff_time;
	public $group;
	public $category;
	public $specific_car;	
	public $min_price;
	public $max_price;
	public $facilities;
	public $characteristics;
	public $search_where = array();
	public $counter;
	public $rec_to_dis;
	public $page;
	public $start_limit;
	public $limit;
	public $last_page;
	public $orderbycolumn;
	public $orderbytype;
	public $booking_total_days;
	public $booking_user_age;
	public $limit_allow = true;
	public $validate = array();


	public function __construct()
	{
		
		parent::__construct();
		$this->CI=& get_instance();
		$this->rec_to_dis = 12;	
		$this->page = 0;
		$this->start_limit = 0;
		$this->limit = 0;
		$this->last_page = 0;
	}
	
	public function search_results()
	{	
		$this->search_where=array();
		$this->search_where[] = array('cars.status = "y" AND cat.status = "y"',null,false);
		$this->load->model("pricing_model");
		$this->load->model("cars_model");
		$this->load->model("stop_sale_period_model");	
		$this->load->model("locations_fee_model");	
		$this->load->model("car_facilities_model");	
		$this->load->model("characteristics_model");	
		$this->load->model("characteristics_groups_model");	

		$final_response = array();
		$this->dropoff_location=isset($this->dropoff_location)?$this->dropoff_location:$this->pickup_location;
		if($this->pickup_date != "")
		{
			/*Stop sale period check*/
			/*$where_ar[] = array("(('".$this->pickup_date."' BETWEEN start_date AND end_date) OR ('".$this->dropoff_date."' BETWEEN start_date AND end_date)) AND locationId = '".$this->pickup_location."'",null,false);*/

			/*$where_ar[] = array("(('".$this->pickup_date."' BETWEEN start_date AND end_date) OR ('".$this->dropoff_date."' BETWEEN start_date AND end_date)) ",null,false);*/

			/*$where_ar[] = array(" ((start_date > '".$this->pickup_date."' AND end_date < '".$this->dropoff_date."') OR (end_date > '".$this->pickup_date."' AND end_date < '".$this->dropoff_date."'))",null,false);*/
			
			$where_ar[] = array(" (end_date >= '".$this->pickup_date."' AND start_date <= '".$this->dropoff_date."') AND ss_ld.locationId = '".$this->pickup_location."'",null,false);

			$stop_sale_records = $this->stop_sale_period_model
			->join("stop_sale_period_location_detail as ss_ld","ss_ld.stopsaleId = stop_sale_period.id","left")
			->join("stop_sale_period_cars_detail as ss_cd","ss_cd.stopsaleId = stop_sale_period.id","left")
			->set_fields("stop_sale_period.id,ss_cd.carId,ss_ld.locationId")
			->get_many_by($where_ar);
			

			/*printr($stop_sale_records);
			exit();*/

			if(!empty($stop_sale_records))
			{
				$stop_sale_records_car_ids = array();
				$stop_sale_records_location_ids = array();
				foreach ($stop_sale_records as $key => $value) 
				{
					/*$stop_sale_records_ids[] = $value["categoryId"];*/
					$stop_sale_records_car_ids[] = $value["carId"];
					$stop_sale_records_location_ids[] = $value["locationId"];
				}

				if(is_array($stop_sale_records_car_ids) && in_array($this->pickup_location, $stop_sale_records_location_ids))
				{
					$this->search_where[] = array("cars.id NOT IN(".implode(",",$stop_sale_records_car_ids).")",null,false);
				}
				
			}
			/*Stop sale period check ends*/			
		}


		if(!empty($this->group))
		{
			$this->search_where[] = array("cars.groupId = '".$this->group."'",null,false);
		}



		if($this->category > 0)
		{
			$this->search_where[] = array('cars.categoryId = "'.$this->category.'"',null,false);
		}

		if(!empty($this->specific_car))
		{
			$this->search_where[] = array("cars.id = '".$this->specific_car."'",null,false);
		}

		$characteristics_having = '';

		if(!empty($this->characteristics) && is_array($this->characteristics))
		{
			$temp = ' AND (';
			foreach ($this->characteristics as $group_id => $char_value) 
			{
				if(!empty($char_value))
				{
					$temp .= '(';
					foreach ($char_value as $char_key => $charvalue) 
					{
						$temp .= "(FIND_IN_SET('".$charvalue."',characteristicIds)) OR ";
					}
					$temp = rtrim($temp," OR ");
					$temp .= ')';
				}	
				$temp .= " AND ";
				
			}
			$temp = rtrim($temp," AND ");
			$temp .= ')';
			$characteristics_having = $temp;
			
		}
		if(!empty($this->facilities))
		{
			//$this->search_wheree[] = array('c.categoryId = "'.$this->facilities.'"',null,false);
		}

		/*minimum rental check*/
		$hpn_field='';
		if($this->pickup_date != "" || $this->pickup_date != null)
		{
			$this->load->model("bookings_model");
			$total_booking_check_where[] = array("timestamp('". $this->pickup_date."','". $this->pickup_time."') >= timestamp(pickup_date, pickup_time ) AND timestamp('". $this->pickup_date."','". $this->pickup_time."') <= timestamp( dropoff_date, dropoff_time) 
				and booking_status in ('p','a')",null,false);

			$this->bookings_model->after_get_allow = false;
			$booking_counter_ar = $this->bookings_model->set_fields("count(car_id) as total_booked_car")->get_by($total_booking_check_where);
			$this->bookings_model->after_get_allow = true;

			/*$booking_counter_num = count($booking_counter_ar);	*/
			$booking_counter_num = $booking_counter_ar["total_booked_car"];
			$this->search_where[] = array('cars.quantity > "'.$booking_counter_num.'"',null,false);


			$date_diff_pickup_date = $this->pickup_date." ".$this->pickup_time.":00";
			$date_diff_dropoff_date = $this->dropoff_date." ".$this->dropoff_time.":00";
			$this->booking_total_days = date_difference($date_diff_pickup_date,$date_diff_dropoff_date);
			
			$this->load->model("minimum_rental_days_model");
			$where_ar_rental_days[] = array("(('".$this->pickup_date."' BETWEEN start_date AND end_date) OR ('".$this->dropoff_date."' BETWEEN start_date AND end_date)) AND locationId = '".$this->pickup_location."'  AND status = 'y' AND days > '".$this->booking_total_days."'",null,false);
			$minimum_rental_records_ar = $this->minimum_rental_days_model->set_fields("categoryId")->get_many_by($where_ar_rental_days);


			if(!empty($minimum_rental_records_ar))
			{
				$minimum_rental_records = array(); 
				foreach ($minimum_rental_records_ar as $key => $value)
				{
					$minimum_rental_records[] = $value["categoryId"];
				}
			}

			if(!empty($minimum_rental_records))
			{
				$this->search_where[] = array("cars.categoryId NOT IN(".implode(",",$minimum_rental_records).")",null,false);	
			}
			$hpn_field.=' AND (("'.$this->pickup_date.'" BETWEEN hpn.start_date AND hpn.end_date) OR ("'.$this->dropoff_date.'" BETWEEN hpn.start_date AND hpn.end_date)) ';		
		}
		if($this->pickup_location!='' && $this->pickup_location>0){
			$this->search_where[] = array('cpld.locationId = "'. $this->pickup_location.'"',null,false);
			$hpn_field .= ' AND hpn.locationId = "'.$this->pickup_location.'"';
			/*$this->search_where[] = array("'".$this->booking_total_days."' >= minimum_days",null,false);*/

		}
		/*minimum rental check ends*/
		if($this->limit_allow == true)
		{	
			if($this->is_fleet_guide == true)
			{
				$search_records = $this->set_fields("distinct(cars.id),cars.*,cat.category,car_g.group_name")
				->join('categories as cat','cars.categoryId = cat.id','left')
				->join('car_groups as car_g','cars.groupId = car_g.id','left')
				->join('car_pickup_location_detail as cpld','cars.id = cpld.carId','left')
				->join('car_characteristics_detail as ccd','ccd.carId = cars.id','left')
				->order_by($this->orderbycolumn,$this->orderbytype)
				->limit($this->rec_to_dis,$this->start_limit)
				->get_many_by($this->search_where);
			}
			else
			{
				$where_ar = array(
					"status"=>"y",
					"search_default"=>"y"
					);
				$search_header_criteria = $this->characteristics_groups_model->get_by($where_ar);
				if(!empty($search_header_criteria["characteristics"] ))
				{
					foreach ($search_header_criteria["characteristics"] as $key => $value) 
					{
						$characteristics_in_ids .= $value["id"].",";
					}
					$characteristics_in_ids = rtrim($characteristics_in_ids,",");
				}
				
				$search_records = $this->set_fields("GROUP_CONCAT(ccd.characteristicId) as characteristicIds,cars.*,hpn.message as high_notification_msg,hpn.type as high_notification_type,IF(locations_fee.minimum_days > 1,locations_fee.minimum_days,1) AS minimum_days,(SELECT COUNT(*) FROM pricing where categoryId = cars.categoryId AND type = 'b') AS total_basic_pricing,cat.category,car_g.group_name,IF((SELECT COUNT(id) FROM car_characteristics_detail as ccd where ccd.carId = cars.id AND characteristicId IN(".$characteristics_in_ids."))=1,(SELECT characteristicId FROM car_characteristics_detail as ccd1 where ccd1.carId = cars.id AND characteristicId IN(".$characteristics_in_ids.")),".$this->transmission_sort_id.") AS characteristics_order_id")
				->join('categories as cat','cars.categoryId = cat.id','left')
				->join('car_groups as car_g','cars.groupId = car_g.id','left')
				->join('car_pickup_location_detail as cpld','cars.id = cpld.carId','left')
				->join('high_period_notification as hpn','hpn.locationId = cpld.locationId  AND  hpn.status="y" '.$hpn_field,'left')
				->join('locations_fee','locations_fee.fromId="'.$this->pickup_location.'" AND locations_fee.toId = "'.$this->dropoff_location.'"','left',false)
				->join('car_characteristics_detail as ccd','ccd.carId = cars.id','left')
				->order_by($this->orderbycolumn,$this->orderbytype)
				->order_by("cars.created","desc")
				->group_by("cars.id")
				->having("minimum_days <= '".$this->booking_total_days."' AND total_basic_pricing > 0".$characteristics_having)
				->limit($this->rec_to_dis,$this->start_limit)
				->get_many_by($this->search_where);
			}			
		}
		else
		{
			if($this->is_fleet_guide == true)
			{
				$search_records = $this->set_fields("distinct(cars.id),cars.*,cat.category,car_g.group_name")
				->join('categories as cat','cars.categoryId = cat.id','left')
				->join('car_groups as car_g','cars.groupId = car_g.id','left')
				->join('car_pickup_location_detail as cpld','cars.id = cpld.carId','left')
				->join('car_characteristics_detail as ccd','ccd.carId = cars.id','left')
				->get_many_by($this->search_where);
			}
			else
			{
				$search_records = $this->set_fields("GROUP_CONCAT(ccd.characteristicId) as characteristicIds,cars.*,hpn.message as high_notification_msg,hpn.type as high_notification_type,IF(locations_fee.minimum_days > 1,locations_fee.minimum_days,1) AS minimum_days,(SELECT COUNT(*) FROM pricing where categoryId = cars.categoryId AND type = 'b') AS total_basic_pricing,cat.category,car_g.group_name")
				->join('categories as cat','cars.categoryId = cat.id','left')
				->join('car_groups as car_g','cars.groupId = car_g.id','left')
				->join('car_pickup_location_detail as cpld','cars.id = cpld.carId','left')
				->join('high_period_notification as hpn','hpn.locationId = cpld.locationId  AND  hpn.status="y" '.$hpn_field,'left')
				->join('car_characteristics_detail as ccd','ccd.carId = cars.id','left')
				->join("locations_fee","locations_fee.fromId = '".$this->pickup_location."' AND locations_fee.toId = '".$this->dropoff_location."'","left",false)
				->having("minimum_days <= '".$this->booking_total_days."' AND total_basic_pricing > 0".$characteristics_having)
				->order_by("cars.created","desc")
				->group_by("cars.id")
				->get_many_by($this->search_where);
			}			
		}

		if($this->counter == true)
		{
			return count($search_records);
		}

		

		if(!empty($search_records))
		{
			foreach ($search_records as $key => $car_row) 
			{
				$car_row["minimum_days"] = ($car_row["minimum_days"] > 1) ? $car_row["minimum_days"] : 1;
				if((isset($car_row["minimum_days"]) &&  $this->booking_total_days >= $car_row["minimum_days"]) || $this->is_fleet_guide == true)
				{
					

					$car_detail = array();
					
					/*$this->cars_model->after_get_locations_allow = false;
					$car_detail = $this->cars_model->get($car_row["id"]);*/

					/** Custom code modified **/

					$car_row["group"] = $car_row["group_name"];
					$car_row["detail_link"] = base_url()."car/".$car_row["id"];
					

					if($car_row["image"] != '' && $car_row["image"] != NULL)
					{
						$car_row["image_path"] = base_url()."image/car/".$car_row["id"]."/500/283/".$car_row["image"];

						$car_row["search_image_path"] = base_url()."image/car/".$car_row["id"]."/264/184/".$car_row["image"];

						$car_row["related_image_path"] = base_url()."image/car/".$car_row["id"]."/263/185/".$car_row["image"];
					}
					else
					{
						$car_row["image_path"] = base_url()."image/default/500/283/no_available_image.gif";
						$car_row["search_image_path"] = base_url()."image/default/264/184/no_available_image.gif";
						$car_row["related_image_path"] = base_url()."image/default/263/185/no_available_image.gif";
					}

					

					/*Facility*/

					$faclility_fields = "car_facilities_detail.carId,car_facilities.id,car_facilities.type,car_facilities.facility_name,car_facilities.price,car_facilities.daily_cost,car_facilities.maximum_cost,car_facilities.popup_title,car_facilities.popup_desc,car_facilities.image,car_facilities.multiple_maximum";	
					$where = array('car_facilities_detail.carId'=>$car_row["id"]);


					$this->car_facilities_model->pickup_date = $this->pickup_date;
					$this->car_facilities_model->dropoff_date = $this->dropoff_date;
					$this->car_facilities_model->car_id = $this->car_id;

					$db_sel_facilities = $this->car_facilities_model->set_fields($faclility_fields)->join('car_facilities_detail', 'car_facilities_detail.facilityId = car_facilities.id')->as_array()->get_many_by($where);

					if(!empty($db_sel_facilities))
					{
						foreach ($db_sel_facilities as $key => $value_facility) 
						{
							if($value_facility["is_promo_code"] == "yes" && $value_facility["promo_code_type"] == 'f')
							{
								$car_row["free_facility_avail"] = "yes";
							}	
							$car_row["db_sel_facilities"][] = $value_facility;
						}
					}

					/*Facility ends*/

					/*characteristics*/
					$where_char = array('car_characteristics_detail.carId'=>$car_row["id"]);
					$car_row["db_sel_characteristics"] = $this->characteristics_model->set_fields("characteristics.*")->join('car_characteristics_detail', 'car_characteristics_detail.characteristicId = characteristics.id')->as_array()->get_many_by($where_char);

					/*characteristics*/

					/** Custom code modified ends **/

					/*$price = getPrice($c_id,$pickup_date,$dropoff_date,$pickup_time,$dropoff_time,$pickup_location,$dropoff_location);*/					

					$this->pricing_model->car_category = $car_row["categoryId"];

					$this->pricing_model->pickup_location = $this->pickup_location;
					$this->pricing_model->dropoff_location = $this->dropoff_location;

					$this->pricing_model->pickup_date = $this->pickup_date;
					$this->pricing_model->pickup_time = $this->pickup_time;
					$this->pricing_model->dropoff_date = $this->dropoff_date;
					$this->pricing_model->dropoff_time = $this->dropoff_time;
					$this->pricing_model->car_id = $car_row["id"];				
					$this->pricing_model->booking_user_age = $this->booking_user_age;
					$this->pricing_model->booking_user_driveragenumber = $this->booking_user_driveragenumber;

					$price_ar = $this->pricing_model->get_car_price($car_row);

					if(!empty($price_ar) && $price_ar["total"] > 0)
					{
						$car_row["original_price"] = $price_ar["original_price"];
						$car_row["advanced_price"] = $price_ar["advanced_price"];
						$car_row["basic_price"] = $price_ar["basic_price"];
						$car_row["per_day_price"] = $price_ar["per_day_price"];
						$car_row["total"] = $price_ar["total"];
						$car_row["special_offer_price"] = $price_ar["special_offer_price"];
						$car_row["special_offer_opposite_price"] = $price_ar["special_offer_opposite_price"];
						$car_row["is_special_offer"] = $price_ar["is_special_offer"];
						$car_row["per_day_special_offer_price"] = $price_ar["per_day_special_offer_price"];
						$car_row["special_offer_display_label"] = $price_ar["special_offer_display_label"];
						

						$car_row["dropoff_price"] = $price_ar["dropoff_price"];
						$car_row["coupon_applied_price"] = $price_ar["coupon_applied_price"];
						$car_row["booking_total_days"] = $price_ar["booking_total_days"];
						$car_row["driver_age_price"] = $price_ar["driver_age_price"];
						$car_row["driver_age_price_default"] = $price_ar["driver_age_price_default"];
						$car_row["time_surcharge_price"] = $price_ar["time_surcharge_price"];
						$car_row["from_time_surcharge_price"] = isset($price_ar["from_time_surcharge_price"]) ? $price_ar["from_time_surcharge_price"] : 0;
						$car_row["to_time_surcharge_price"] = isset($price_ar["to_time_surcharge_price"]) ? $price_ar["to_time_surcharge_price"] : 0;

						$car_row["high_notification_msg"] = $car_row["high_notification_msg"];
						$car_row["high_notification_type"] = $car_row["high_notification_type"];
						if($this->min_price > 0 and $this->max_price > 0)
						{
							if(!($car_row["total"] >= $this->min_price and $car_row["total"] <= $this->max_price)){
								continue;
							}
						}
						$final_response[] = $car_row;					
					}
				}
			}
		}
		return $final_response;
	}
}
