<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class out_of_hours_fee_model extends My_Model
{
	public $primary_key = 'id';
	public $get_insurance_details = false;
	public $_table = 'out_of_hours_fee';
	public $after_create = array( 'after_create' );
	public $before_update = array('before_update');
	public $allow_before_update = false;
	/*public $after_get = array( 'after_get' );*/
	public $allow_after_get = false;
	public $get_offers_location_data = false;
	protected $CI;
	public $validate = array(
		'locationId'  => array(
			'field' => 'locationId',
			'label' => ' Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:LOCATION_REQUIRED'
				),
			),

		'start_date'  => array(
			'field' => 'start_date',
			'label' => 'start_date Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:START_DATE_REQUIRED',
				
				),
			),

		'end_date'  => array(
			'field' => 'end_date',
			'label' => 'end_date Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:END_DATE_REQUIRED',
				
				),
			),

		'from_time'  => array(
			'field' => 'from_time',
			'label' => 'From Time',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:FROM_TIME_REQUIRED',				
				),
			),
		'to_time'  => array(
			'field' => 'to_time',
			'label' => 'To Time',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:TO_TIME_REQUIRED',				
				),
			),
		'out_of_hour_fee'  => array(
			'field' => 'out_of_hour_fee',
			'label' => 'Out of hours fee',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:TO_TIME_REQUIRED',				
				),
			)		
		);

public function __construct()
{
	parent::__construct();
	$this->CI=& get_instance();
}

public function before_delete($data){

	if(!$this->current_session)
	{
		$data['before_return']['msg']=lang(INVALID_REQUEST);				
	}
	return $data;
}


public function after_create($locationFeeId)
{
	/*$this->insert_enimeties_data($locationFeeId,"locations","locationId","out_of_hours_fee_location_details_model");*/
	return $locationFeeId;
}


public function before_update($data)
{
	if($this->allow_before_update == true)
	{
		/*$HighPeriodId = $data["id"];*/

		/*Characterisitcs insert*/
		/*$this->insert_enimeties_data($HighPeriodId,"locations","locationId","out_of_hours_fee_location_details_model",$data["db_sel_location"]);*/
		/*Characterisitcs insert ends*/

		
	}
	unset($data["id"]);
	/*unset($data["db_sel_location"]);*/
	return $data;
}


public function after_get($data)
{
	if(!empty($data) && $this->allow_after_get == true)
	{
		$this->load->model("locations_model");
		$this->load->model("out_of_hours_fee_location_details_model");
		$locations_fields = "locations.*";	
		if($this->get_offers_location_data == true)
		{
			$where_char = array('out_of_hours_fee_location_details.locationFeeId'=>$data["id"]);
			$data["db_sel_location"] = $this->locations_model->set_fields($locations_fields)->join('out_of_hours_fee_location_details', 'out_of_hours_fee_location_details.locationId = locations.id')->as_array()->get_many_by($where_char);
		}
	}
	return $data;
}

public function insert_enimeties_data($locationFeeId,$post_name,$field_name,$modal_name,$existing_items = array())
{	
	$insert_batch_array = array();
	$post_data = $this->input->post($post_name);
	$i = 0;
	$this->load->model($modal_name);
	if(!empty($existing_items))
	{
		$item_string = null;
		foreach ($post_data as $key => $value) 
		{
			$item_string .= '"'.$value.'"'.",";	
		}
		$item_string = rtrim($item_string,",");
		$where[] = array("locationFeeId = '".$locationFeeId."'",null,false);
		$where[] = array("$field_name NOT IN (".$item_string.")",null,false);
		$this->{$modal_name}->delete_by($where);
		$post_data = array_diff($post_data,$existing_items);
	}	
	if(!empty($post_data))
	{
		foreach ($post_data as $key => $value) 
		{
			$insert_batch_array[$i]['locationFeeId'] = $locationFeeId;
			$insert_batch_array[$i][$field_name] = $value;				
			$insert_batch_array[$i]['createdDate'] = date('Y-m-d H:i:s');
			$i++;
		}
		if(!empty($insert_batch_array))
		{

			$status = $this->{$modal_name}->insert_many($insert_batch_array,true);
		}
	}
	return $status;
}
}
