<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class notification_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'notification';
	public $after_get = array( 'after_notification_get' );
	public function __construct()
	{
		
		parent::__construct();
		$this->response = array();
	}
	public function after_notification_get($data)
	{
		
		$this->load->model("user_sites_model");
		$data['sub_text']='';
		if($data['notification_type']=='c'){
			$data['status_text']="Completed";
			$data['status_class']="success";
		}
		else if($data['notification_type']=='a'){
			$data['status_text']="Added";
			$data['status_class']="warning";
		}
		if($data['type']=='sp'){
			$this->load->model("simplyportscan_scans_model");
			$scan_read=$this->simplyportscan_scans_model->set_fields('is_read')->as_array()->get($data['detailId']);
			$data['url']=base_url().SIMPLY_PORT_SCAN."/detail/".$data['detailId'];
			$data['type_text']="SimplyPortScan";
			$data['type_class']="bg-purple-plum font-white";
		}
		else if($data['type']=='wpt'){
			$this->load->model("simplywebpagetest_scans_model");
			$scan_read=$this->simplywebpagetest_scans_model->set_fields('is_read')->as_array()->get($data['detailId']);
			
			$data['url']=base_url().WEBPAGE_TEST."/detail/".$data['detailId'];
			$data['type_text']="SimplyWebPageTestScan";
			$data['type_class']="bg-blue-hoki font-white";

		}
		else if($data['type']=='sv'){

			$this->load->model("simplyvulnerabilityscan_scans_model");
			$scan_read=$this->simplyvulnerabilityscan_scans_model->set_fields('is_read')->as_array()->get($data['detailId']);
			
			$data['url']=base_url().SIMPLY_VULNERABILITY_SCAN."/detail/".$data['detailId'];
			$data['type_text']="SimplyVulnerabilityScan";
			$data['type_class']="bg-green-meadow font-white";
			if($data['notification_type']=='s'){
				$data['status_text']="Started";
				$data['status_class']="primary";
			} else if($data['notification_type']=='p'){
				$data['status_text']="Paused";
				$data['status_class']="info";
			}
			else if($data['notification_type']=='st'){
				$data['status_text']="Stopped";
				$data['status_class']="danger";
			}
			else if($data['notification_type']=='r'){
				$data['status_text']="Resumed";
				$data['status_class']="primary";
			}

		}
		else if($data['type']=='sm')
		{
			$this->load->model("simplymonitorscan_scans_model");
			$scan_read=$this->simplymonitorscan_scans_model->set_fields('is_read')->as_array()->get($data['detailId']);

			$data['url']=base_url().SIMPLY_MONITOR_SCAN."/detail/".$data['detailId'];
			$data['type_text']="SimplyMonitorScan";
			$data['type_class']="bg-blue-madison font-white";
			if($data['notification_type']=='u'){
				$data['status_text']="Up";
				$data['status_class']="success";
			}
			else if($data['notification_type']=='un'){
				$data['status_text']="Unknown";
				$data['status_class']="default";
			}
			else if($data['notification_type']=='d'){
				$data['status_text']="Down";
				$data['status_class']="danger";
			}
			else if($data['notification_type']=='c'){
				$data['status_text']="Critical";
				$data['status_class']="danger";
			}
			if(isset($data['scantype']) && $data['scantype']=='s' && $data['subdetailId']>0){
				$this->load->model("simplymonitorscan_scan_services_model");
				$service_details=$this->simplymonitorscan_scan_services_model->on()->as_array()->get($data['subdetailId']);
				if(!empty($service_details)){
					$data['sub_text']=$service_details['service_alias'];
				}
			}
		}

		$site=$this->user_sites_model->as_array()->get($data['user_site_id']);
		$data['scan_read']=$scan_read['is_read'];
		$data['alias']=$site['alias'];

		
		
		return $data;
	}
	
}
