<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Minimum_rental_days_model extends My_Model
{
	public $primary_key = 'id';
	public $get_insurance_details = false;
	public $_table = 'minimum_rental_days';
	protected $CI;
	public $validate = array(
		'name'  => array(
			'field' => 'name',
			'label' => 'Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:MINIMUM_RENTAL_DAY_NAME_REQUIRED'
				),
			),
		'start_date'  => array(
			'field' => 'start_date',
			'label' => 'start_date Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:START_DATE_REQUIRED',
				
				),
			),
		'end_date'  => array(
			'field' => 'end_date',
			'label' => 'end_date Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:END_DATE_REQUIRED',
				
				),
			),
		'locationId'  => array(
			'field' => 'locationId',
			'label' => 'locationId Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CAR_LOCATION_REQUIRED',				
				),
			),
		'categoryId'  => array(
			'field' => 'categoryId',
			'label' => 'categoryId Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CAR_CATEGORY_REQUIRED',				
				),
			),
		'days'  => array(
			'field' => 'days',
			'label' => 'Days',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:RENTAL_DAYS_REQUIRED',				
				),
			),
		);

public function alpha_dash_space($str)
{
	return ( ! preg_match("/^([-a-z_ ])+$/i", $str)) ? FALSE : TRUE;
} 

public function __construct()
{
	
	parent::__construct();
	$this->CI=& get_instance();
}

public function before_delete($data){

	if(!$this->current_session)
	{
		$data['before_return']['msg']=lang(INVALID_REQUEST);				
	}
	return $data;
}

}
