<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Facilities_promo_code_model extends My_Model
{
	public $primary_key = 'id';
	public $get_insurance_details = false;
	public $_table = 'facilities_promo_code';
	public $before_delete = array( 'before_delete');
	public $after_create = array( 'after_create' );
	public $after_get = array( 'after_get' );
	public $before_update = array( 'before_update' );
	/*public $promo_car_id = 0;*/
	
	protected $CI;
	public $validate = array(
		'facilityId'  => array(
			'field' => 'facilityId',
			'label' => 'Facility Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CAR_FACILITY_REQUIRED',				
				),
			),

		'type'  => array(
			'field' => 'type',
			'label' => ' type',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:FACILITY_TYPE_REQUIRED',
				
				),
			),

		'start_date'  => array(
			'field' => 'start_date',
			'label' => 'start_date Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:START_DATE_REQUIRED',
				
				),
			),

		'end_date'  => array(
			'field' => 'end_date',
			'label' => 'end_date Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:END_DATE_REQUIRED',				
				),
			),


		);
	public function __construct()
	{
		
		parent::__construct();
		$this->CI=& get_instance();
	}



	public function after_get($data)
	{
		/*echo " <br /><br /><br /><br /> ".$this->db->last_query();*/
		if(!empty($data))
		{
			$this->load->model("facilities_promo_code_car_details_model");
			$this->load->model("cars_model");
			$coupon_fields = "facilities_promo_code_car_details.*,cars.name";

			if($data["all_cars"] == "0")
			{
				$where[] = array('facilities_promo_code_car_details.facilitypromoId = "'.$data["id"].'"',null,false);
				/*if($this->promo_car_id > 0)
				{
					$where[] = array('facilities_promo_code_car_details.carId = "'.$this->promo_car_id.'"',null,false);
				}*/
				$data["db_sel_cars"] = $this->facilities_promo_code_car_details_model->set_fields($coupon_fields)->join('cars', 'cars.id = facilities_promo_code_car_details.carId')->get_many_by($where);
			}
			else
			{
				$where = array('status'=>'y');
				$this->cars_model->after_get_allow = false;
				$this->cars_model->after_get_category_name_allow = false;
				$this->cars_model->after_get_group_name_allow = false;

				$data["db_sel_cars"] = $this->cars_model->set_fields("cars.name,cars.id as carId")->get_many_by($where);

				$this->cars_model->after_get_allow = true;
				$this->cars_model->after_get_category_name_allow = true;
				$this->cars_model->after_get_group_name_allow = true;

			}
		}
		return $data;
	} 

	public function after_create($facilitypromoId)
	{
		if($this->input->post("all_cars") != "1")
		{
			$this->insert_enimeties_data($facilitypromoId,"cars","carId","facilities_promo_code_car_details_model");
		}		
		return $facilitypromoId;
	}


	public function before_update($data)
	{
		$facilitypromoId = $data["id"];
		if($this->input->post("all_cars") != "1")
		{
			$this->insert_enimeties_data($facilitypromoId,"cars","carId","facilities_promo_code_car_details_model",$data["db_sel_cars"]);		
		}
		unset($data["id"]);
		unset($data["db_sel_cars"]);		
		return $data;
	}


	public function insert_enimeties_data($facilitypromoId,$post_name,$field_name,$modal_name,$existing_items = array())
	{	
		$insert_batch_array = array();
		$post_data = $this->input->post($post_name);
		$i = 0;
		$this->load->model($modal_name);

		if(!empty($existing_items))
		{
			$item_string = null;
			foreach ($post_data as $key => $value) {
				$item_string .= '"'.$value.'"'.",";	
			}
			$item_string = rtrim($item_string,",");
			$where[] = array("facilitypromoId = '".$facilitypromoId."'",null,false);
			$where[] = array("$field_name NOT IN (".$item_string.")",null,false);
			$this->{$modal_name}->delete_by($where);
			$post_data = array_diff($post_data,$existing_items);
		}	


		if(!empty($post_data))
		{
			foreach ($post_data as $key => $value) {
				$insert_batch_array[$i]['facilitypromoId'] = $facilitypromoId;
				$insert_batch_array[$i][$field_name] = $value;				
				$insert_batch_array[$i]['createdDate'] = date('Y-m-d H:i:s');
				$i++;
			}
			if(!empty($insert_batch_array))
			{
				$status = $this->{$modal_name}->insert_many($insert_batch_array,true);
			}
		}
		return $status;
	}


	public function before_delete($data)
	{
		if(!$this->current_session)
		{	
			$data['before_return']['msg']=lang(INVALID_REQUEST);				
		}
		return $data;
	}
}
