<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Categories_model extends My_Model
{
	public $primary_key = 'id';
	public $get_insurance_details = false;
	public $_table = 'categories';
	public $after_create = array( 'after_create' );
	public $after_get = array( 'after_get' );
	public $after_update = array( 'after_update' );
	protected $CI;
	public $validate = array(
		'category'  => array(
			'field' => 'category',
			'label' => 'Category Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CATEGORY_NAME_REQUIRED'				
				),
			),
		'groupId'  => array(
			'field' => 'groupId',
			'label' => 'Group Id',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CATEGORY_GROUPID_REQUIRED'
				),
			)
		);
	
	public function __construct()
	{
		
		parent::__construct();
		$this->CI=& get_instance();
	}

	public function before_delete($data){

		if(!$this->current_session)
		{
			$data['before_return']['msg']=lang("INVALID_REQUEST");				
		}
		return $data;
	}

	public function after_get($data)
	{
		if(!empty($data))
		{
			if($this->get_insurance_details == true)
			{
				$this->load->model("category_insurance_price_model");
				$where = array('category_insurance_price.categoryId'=>$data["id"]);
				$data["insurance_group"] = $this->category_insurance_price_model->set_fields("category_insurance_price.groupId,category_insurance_price.price,category_insurance_price.deposit,category_insurance_price.max_price,insurance_group.name,insurance_group.id")->join('insurance_group', 'insurance_group.id = category_insurance_price.groupId')->get_many_by($where);
			}
		}		
		return $data;
	}


	public function after_create($categoryId){
		$insert_batch_array = array();
		$this->load->model("insurance_group_model");
		$insurance_group = $this->insurance_group_model->get_all();
		$i = 0;
		if(!empty($insurance_group))
		{
			foreach ($insurance_group as $key => $value) {
				$price_val 		=	$this->input->post("price_".$value["id"]);
				$deposit_val	=	$this->input->post("deposit_".$value["id"]);
				$max_price	=	$this->input->post("max_price_".$value["id"]);
				$insert_batch_array[$i]['groupId'] = $value["id"];
				$insert_batch_array[$i]['categoryId'] = $categoryId;
				$insert_batch_array[$i]['price'] = $price_val;
				$insert_batch_array[$i]['deposit'] = $deposit_val;
				$insert_batch_array[$i]['max_price'] = $max_price;
				$i++;
			}
			if(!empty($insert_batch_array))
			{
				$this->load->model("category_insurance_price_model");	
				$this->category_insurance_price_model->insert_many($insert_batch_array);
			}
		}
		return $categoryId;
	}

	public function after_update($data,$categoryId)
	{
		$insert_batch_array = array();
		$this->load->model("insurance_group_model");
		$this->load->model("category_insurance_price_model");		
		$insurance_group = $this->insurance_group_model->get_all();

		if(!empty($insurance_group))
		{
			foreach ($insurance_group as $key => $value) 
			{
				$price_val 		=	$this->input->post("price_".$value["id"]);
				$deposit_val	=	$this->input->post("deposit_".$value["id"]);
				$max_price	=	$this->input->post("max_price_".$value["id"]);
				if($price_val != '' && $deposit_val != '' && $max_price != '')
				{
					$check_if_exist_where = array(
						"groupId"=>$value["id"],
						"categoryId"=>$categoryId
						);
					$check_if_exist  = $this->category_insurance_price_model->get_by($check_if_exist_where);
					$data_array = array(
						'price'=>$price_val,
						'deposit'=>$deposit_val,
						'max_price'=>$max_price
						);
					if(!empty($check_if_exist))
					{
						$where_ar = array(
							'groupId'=>$value["id"],
							'categoryId'=>$categoryId
							);

						$update_status = $this->category_insurance_price_model->update_by($where_ar,$data_array);
					}
					else
					{
						$data_array["groupId"] = $value["id"];
						$data_array["categoryId"] = $categoryId;

						$insert_status = $this->category_insurance_price_model->insert($data_array);
					}
				}				
			}
		}
		return $categoryId;
	}

}
