<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Car_groups_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'car_groups';
	protected $CI;
	public $before_create = array('before_create');
	public $before_update = array('before_update');
	public $before_delete = array('before_delete');

	public $after_get = array( 'after_get' );
	public $validate = array(
		'group_name'  => array(
			'field' => 'group_name',
			'label' => 'Group Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:GROUP_NAME_REQUIRED'
				),
			)
		);
	

	public function __construct()
	{
		
		parent::__construct();
		$this->CI=& get_instance();
	}

	public function after_get($data)
	{
		if(!empty($data))
		{
			if($data["image"] != "" || $data["image"] != null){
				$data["search_avail_image_path"] = base_url()."image/cargroup/110/77/".$data["image"];	
			}else{
				$data["search_avail_image_path"] = base_url()."image/default/110/77/";	
			}			
		}		
		return $data;
	}
	public function before_create($data){
		if($_FILES['image'] && $_FILES['image']['error']==UPLOAD_ERR_OK){
			$status_ar = $this->upload_image();
			if($status_ar["status"] == "success")
			{
				$data['image'] = $status_ar['file_name'];					
			}
			else{
				$data['before_return']['msg']=lang(INVALID_REQUEST);	
			}	
		}
		return $data;
	}

	public function before_update($data)
	{
		$carid = $data["id"];
		$image_data = $this->get($data["id"]);
		if($_FILES['image']["name"] != "")
		{	
			$update_new_image_ar = $this->upload_image();
			if($update_new_image_ar["status"] == "success")
			{
				if($update_new_image_ar["status"] == "success")
				{
					$exist_check_path = FCPATH."assets/upload/car_groups/".$image_data["image"];	
					if(file_exists($exist_check_path) && $exist_check_path!=""){
						unlink($exist_check_path);
					}
				}
				$data['image'] = $update_new_image_ar['file_name'];
			}
			else{
				$data['before_return']['msg']=lang(INVALID_REQUEST);	
			}
		}
		unset($data["id"]);
		return $data;
	}

	public function before_delete($data){
		if(!$this->current_session)
		{
			$data['before_return']['msg']=lang(INVALID_REQUEST);				
		}
		$image_data = $this->get($data);
		$exist_check_path = FCPATH."assets/upload/car/car_groups/".$image_data["image"];			
		if(file_exists($exist_check_path) && $exist_check_path!=""){
			unlink($exist_check_path);
		}
		return $data;
	}

	public function upload_image()
	{
		$asset_upload_dir = FCPATH.'assets/upload/'; 
		$asset_locations_dir = FCPATH.'assets/upload/car_groups/'; 
		$upload_dir = FCPATH.'assets/upload/car_groups/'; 

		if(!file_exists($asset_upload_dir)){
			mkdir($asset_upload_dir,777);
		}

		if(!file_exists($asset_locations_dir)){
			mkdir($asset_locations_dir,777);
		}

		if(!file_exists($upload_dir)){
			mkdir($upload_dir,0777);
		}	

		$data = array('status'=>'error');
		$maxSize = IMAGE_UPLOAD_MAX_SIZE;

		if($_FILES['image']['error']==UPLOAD_ERR_OK){
			$this->load->library('image_lib');
			$name = $_FILES['image']['name'];
			$size = $_FILES['image']['size'];
			$ext = substr($name, strrpos($name, ".") + 1);

			if ($size < ($maxSize)) {

				$th_arr=array();	
				$config['upload_path'] = $upload_dir;
				$config['file_name'] =md5(date("Y-m-d H:i:s").rand());
				$config['allowed_types'] = 'gif|jpg|png|jpeg|JPG|jpe';
				$this->load->library('upload', $config);
				$this->upload->initialize($config);
				$field_name = "image";
				if ( ! $this->upload->do_upload($field_name))
				{
					$this->form_validation->set_message('insert',$this->upload->display_errors());
					$data["status"] = "error";
					$data["msg"] = $this->upload->display_errors();								
				}
				else
				{
					$fileUpd = array('upload_data' => $this->upload->data());
					$data["status"] = "success";
					$data['file_name'] = $fileUpd['upload_data']['file_name'] ;
				}
			}
			else{
				$this->session->set_flashdata('message','Image size is too large.maximum image size is '.$maxSize);
				$data["status"] = 'error';
				$data["msg"] ='Image size is too large.maximum image size is '.$maxSize;				
			}	
		}
		return $data;
	}



}
