<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class users_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'users';
	protected $CI;
	public $after_create = array( 'after_register' );
	public $before_update = array( 'before_update' );
	public $validate = array(
		'first_name'  => array(
			'field' => 'first_name',
			'label' => 'First Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:USER_FIRST_NAME_REQUIRED'
				),
			),
		'last_name'  => array(
			'field' => 'last_name',
			'label' => 'Last Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:USER_LAST_NAME_REQUIRED'
				),
			),
		'email'  => array(
			'field' => 'email',
			'label' => 'Email',
			'rules' => 'trim|required|xss_clean|valid_email|is_unique[users.email]',
			'error_msg' => array(
				'required'  => 'lang:EMAIL_REQUIRED',
				'valid_email' => 'lang:MSG_VALID_EMAIL',
				'is_unique'=>'lang:USER_ALREADY_EXIST'
				),
			),	
		'address'  => array(
			'field' => 'address',
			'label' => 'Address',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:ADDRESS_REQUIRED'
				),
			),	
		'contactno'  => array(
			'field' => 'contactno',
			'label' => 'Contactno',
			'rules' => 'trim|required|xss_clean|numeric',
			'error_msg' => array(
				'required'  => 'lang:CONTACTNO_REQUIRED'
				),
			),
		);

public function __construct()
{

	parent::__construct();
	$this->CI=& get_instance();
}

public function before_update($data)
{
	if(isset($data["password"]) && $data["password"] != "")
	{
		$data["password"] = md5($data["password"]);			
	}	
	return $data;
}

protected function after_register($id)
{
	$user_detail = $this->as_array()->get($id);

	$data_mail = array(
		'name'		=>	$user_details["full_name"],
		'email'	=>	$user_detail["email"],
		'password' => $user_detail["password"]			
		);	
	$abc = $this->template->load('/mail/email_template','/mail/social_user_registration',$data_mail,TRUE); 
	send_mail(ADMIN_EMAIL,$user_detail["email"],"Successfull registration :".SITE_NM,$abc);


	$update_array = array('password'=>($user_detail["password"]));
	$this->update($user_detail["id"],$update_array,true);
	return $id;
}


}
