<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
if ( ! function_exists('char_limit'))
{
    function char_limit($string,$length)
    {
        if(strlen($string)>$length){
            $string=substr($string,0,$length)."..";
        }
        return $string;
    }
}

if ( ! function_exists('parseBool'))
{
    function parseBool($value){
        return filter_var($value, FILTER_VALIDATE_BOOLEAN);
    }
}
if ( ! function_exists('site_name'))
{
    function site_name()
    {
        $CI = & get_instance();
        if(defined("SITE_NM"))
        {
            $site_name = SITE_NM;
        }else{
            $site_name = $CI ->config->item('site_name');;
        }
        return $site_name;
    }
}
if ( ! function_exists('user_url'))
{
    function user_url($only_admin=false)
    {
        $CI = & get_instance();
        $type=($CI->current_login_type)?$CI->current_login_type."/":'';
        if($only_admin==true && $CI->current_login_type!="admin"){
            $type="";
        }
        if($only_admin == true && admin_url())
        {
            $type = "admin/";
        }
        return base_url().$type;
    }
}

if ( ! function_exists('reverse_geocode'))
{   
    function reverse_geocode($array,$field=NULL) {
        $address='';
        if(isset($array['address']) && $array['address']!=''){
            $address = str_replace(" ", "+", $array['address']);
            $url = "http://maps.google.com/maps/api/geocode/json?address=$address&sensor=false";
        }
        elseif (isset($array['latlng']) && $array['latlng']!='') {
            $latlng=$array['latlng'];
            $url = "http://maps.google.com/maps/api/geocode/json?latlng=$latlng&sensor=false";
        }
        $result = file_get_contents("$url");
        $json = json_decode($result);
        $address_final["street"]="";
        $address_final["route"]="";
        $types = "";
        $city = "";
        $state = "";
        $postal_code = "";
        $country = "";
        $lat = "";$lon = "";
        $country_short_name = "";
        $city_short_name = "";
        $state_short_name = "";
        $final_adrs = '';
        $response = array();
        $res = array();
        $address1_arr = array("street_number","sublocality_level_2","sublocality_level_1","sublocality");
        $address2_arr = array("route","point_of_interest","establishment");
        $city_arr = array("locality");
        $state_arr = array("administrative_area_level_1","administrative_area_level_2");
        $postal_arr = array("postal_code");
        $country_arr = array("country");
        $result=$json->results[0];
        $geometry = $result->geometry;
        $latitude = $geometry->location->lat;
        $longitude = $geometry->location->lng;
        foreach($result->address_components as $addressPart) {
            $types = $addressPart->types; 
            if (in_array($types[0],$city_arr)){
                $city = $addressPart->long_name;
                $city_short_name=$addressPart->short_name;
            }
            else if (in_array($types[0],$state_arr)){
                $state = $addressPart->long_name;
                $state_short_name=$addressPart->short_name;
            }
            else if (in_array($types[0],$postal_arr)){
                $postal_code = $addressPart->long_name;
            }
            else if (in_array($types[0],$country_arr)){
                $country = $addressPart->long_name;
                $country_short_name = $addressPart->short_name;
            }
        }
        $response["city"] = $city;
        $response["city_short_name"] = $city_short_name;
        $response["state_short_name"] = $state_short_name;
        $response["state"] = $state;
        $response["postal_code"] = $postal_code;
        $response["country"] = $country;
        $response["country_short_name"] = $country_short_name;
        $response["lat"] = $latitude;
        $response["lng"] = $longitude;
        if($response['postal_code']==''){
            $latlng=$latitude.",".$longitude;
            $postal_code = reverse_geocode(array("latlng"=>$latlng),"postal_code");
            $response["postal_code"]=$postal_code;
        }
        if($address!=''){
            if(!empty($response)){
                foreach ($response as $key => $value) {
                    array_push($res,$value);
                }
            }
            $adrs_arr=explode(",",$array['address']);
            foreach ($adrs_arr as $key => $value) {
                $value=trim($value);
                if(!in_array($value,$res)){
                    $final_adrs.=",".$value;
                }
            }
            $final_adrs=trim($final_adrs,",");
        } 
        $response["address"]=$final_adrs;
        if($field!=NULL){
            return $response[$field];
        }
        return $response;
    }
}


function admin_url(){
    $CI = & get_instance();
    $curl_arr=$CI->uri->segment_array();
    $curl_arr=array_filter($curl_arr);

    if(!empty($curl_arr))
    {
        if(in_array("admin",$curl_arr)){
            return true;
        } 
    }
    return false;
}

function agency_url(){
    $CI = & get_instance();
    $curl_arr=$CI->uri->segment_array();
    $curl_arr=array_filter($curl_arr);
    if(!empty($curl_arr))
    {
        if(in_array("agency",$curl_arr)){
            return true;
        } 
    }
    return false;
}

if ( ! function_exists('check_session'))
{   
    function check_session($flag = false) {
        $CI = & get_instance();

        if($CI->login_type != false)
        {   
            $function_name = $CI->login_type."_loggedin";
            $response = call_user_func(array($CI,$function_name));

            if($flag == true)
            {
                return $response;
            }     

            if($response == true && $CI->router->fetch_class() == 'login')
            {
                if($CI->access == "nologin")
                {
                    redirect(user_url(true)."dashboard","refresh");
                }
            }
            else if($response == true &&  $CI->access == "nologin") {
                redirect(user_url(true)."dashboard","refresh");
            }
            else if($response == false &&  $CI->access == "login")
            {
               $CI->session->set_flashdata("error",lang("LOGINTOACCESSPAGE"));
               $url=($CI->isadminurl)?"admin/login":"signin";

               /*set current url in database*/
               $CI->session->set_userdata("redirect_sess_url",current_url());
               /*set current url in database*/



               redirect($url,"refresh");
           }
       }

   }
}

if ( ! function_exists('addScheme'))
{  
    function addScheme($url, $scheme = 'http://')
    {
        return parse_url($url, PHP_URL_SCHEME) === null ?
        $scheme . $url : $url;
    }

}


if ( ! function_exists('addwww'))
{  
    function addwww($url)
    {
        if (false === strpos($url, 'www')) {
            $url = 'www.' . $url;
        }
    }
}



if(! function_exists('chkDataIsExits')){
    function chkDataIsExits($select_fields='id',$tbl_name,$compare_field,$compare_field_value,$compare_field_1,$compare_field_value_1,$totalCompareField = 2,$return='ret'){
//echo $tbl_name;
//echo $select_fields;
        $CI =& get_instance();
        $CI -> db -> select($select_fields);
        $CI->db-> from($tbl_name);  
        if($totalCompareField == 2){
            $CI -> db -> where($compare_field,$compare_field_value);
            $CI -> db -> where($compare_field_1, $compare_field_value_1);
        }elseif($totalCompareField == 1){
            $CI -> db -> where($compare_field,$compare_field_value);
        }
        $CI -> db -> limit(1);
        $query = $CI -> db -> get();
        if($query -> num_rows() == 1){
            if($return == 'ret'){
                return true;
            }elseif($return == 'val'){
                return $query->row_array();
            }
        }else {
            return false;
        }
    }
}


if(! function_exists('get_element_array')){
    function get_element_array($array,$key,$value)
    {

        if(!empty($array))
        {
            foreach($array as $arr)
            {

                if($arr[$key]==$value)
                {
                    return $arr;
                }
            }
        }
        return array();
    }
}


if(! function_exists('check_ip')){
    function check_ip($checkme,$MULTIPLE_HOSTS) {
        $checkme = strtolower($checkme);
        if ($MULTIPLE_HOSTS) {
            $hostregex = '/^(([0-9*-]{1,7}\.){3}[0-9*-]{1,7}|([0-9a-z_-]+\.)*([0-9a-z_-][0-9a-z_-]{0,61})?[0-9a-z]\.[a-z]{2,6})$/';
        } else {
            $hostregex = '/^(([0-9]{1,3}\.){3}[0-9]{1,3}|([0-9a-z_-]+\.)*([0-9a-z_-][0-9a-z_-]{0,61})?[0-9a-z]\.[a-z]{2,6})$/';
        }
        if (preg_match("$hostregex", $checkme) OR $checkme == "localhost") {
            return 1; 
        } else { 
            return 0;
        }
    }
}


if(! function_exists('check_portrange')){
    function check_portrange($checkme,$DEBUG = NULL) {
        $portrangeregex ='/^(T\:|U\:){0,1}[TU\:0-9-\,]+$/';
        if (preg_match("$portrangeregex",$checkme)) {
            return 1;
        } else {
            return 0;
        }
    }
}

if(! function_exists('check_randomhosts')){
    function check_randomhosts($checkme,$DEBUG = NULL) {
        $randomhostsregex = '/^([0-9])+$/';
        if (preg_match("$randomhostsregex",$checkme)) {
            return 1;
        } else {
            return 0;
        }
    }
}


if(! function_exists('check_decoys')){
    function check_decoys($checkme,$DEBUG) {
        $decoyregex = '/^((([0-9]{1,3}\.){3}[0-9]{1,3}|([0-9a-z_-]+\.)*([0-9a-z_-][0-9a-z_-]{0,61})?[0-9a-z]\.[a-z]{2,6}),)*$/';
        if (preg_match("$decoyregex",$checkme)) {
            return 1;
        } else {
            if ($DEBUG) echo "<BR><B>Error: check_decoy() failed.</B><BR>";
            return 0;
        }
    }
}


if(! function_exists('check_idlescan')){
    function check_idlescan($checkme, $DEBUG) {
        $idlescanregex = '/^((([0-9]{1,3}\.){3}[0-9]{1,3}|([0-9a-z_-]+\.)*([0-9a-z_-][0-9a-z_-]{0,61})?[0-9a-z]\.[a-z]{2,6}),)*(:[0-9])*$/';
        if (preg_match("$idlescanregex",$checkme)) {
            return 1;
        } else {
            if ($DEBUG) echo "<BR><B>Error: check_idlescan() failed.</B>";
            return 0;
        }
    }
}

if(! function_exists('timeAgo')){
    function timeAgo($time_ago)
    {
        $time_ago = strtotime($time_ago);
        $cur_time   = time();
        $time_elapsed   = $cur_time - $time_ago;
        $seconds    = $time_elapsed ;
        $minutes    = round($time_elapsed / 60 );
        $hours      = round($time_elapsed / 3600);
        $days       = round($time_elapsed / 86400 );
        $weeks      = round($time_elapsed / 604800);
        $months     = round($time_elapsed / 2600640 );
        $years      = round($time_elapsed / 31207680 );
        /*Seconds*/
        if($seconds <= 60){
            return "Just now";
        }
        /*Minutes*/
        else if($minutes <=60){
            if($minutes==1){
                return "1 minute ago";
            }
            else{
                return "$minutes minutes ago";
            }
        }
        /*Hours*/
        else if($hours <=24){
            if($hours==1){
                return "1 hour ago";
            }else{
                return "$hours hrs ago";
            }
        }
        /*Days*/
        else if($days <= 7){
            if($days==1){
                return "yesterday";
            }else{
                return "$days days ago";
            }
        }
        /* Weeks*/
        else if($weeks <= 4.3){
            if($weeks==1){
                return "1 week ago";
            }else{
                return "$weeks weeks ago";
            }
        }
        /*Months*/
        else if($months <=12){
            if($months==1){
                return "1 month ago";
            }else{
                return "$months months ago";
            }
        }
        /* Years*/
        else{
            if($years==1){
                return "1 year ago";
            }else{
                return "$years years ago";
            }
        }
    }
}
if(!function_exists('get_timezones')){
    function get_timezones(){
        $timezones=array();
        $timezones['-12:00']='UM12';
        $timezones['-11:00']='UM11';
        $timezones['-10:00']='UM10';
        $timezones['-09:00']='UM9';
        $timezones['-08:00']='UM8';
        $timezones['-07:00']='UM7';
        $timezones['-06:00']='UM6';
        $timezones['-05:00']='UM5';
        $timezones['-04:00']='UM4';
        $timezones['-03:30']='UM25';
        $timezones['-03:00']='UM3';
        $timezones['-02:00']='UM2';
        $timezones['-01:00']='UM1';
        $timezones['-00:00']='UTC';
        $timezones['+00:00']='UTC';
        $timezones['+01:00']='UP1';
        $timezones['+02:00']='UP2';
        $timezones['+03:00']='UP3';
        $timezones['+03:30']='UP25';
        $timezones['+04:00']='UP4';
        $timezones['+04:30']='UP35';
        $timezones['+05:00']='UP5';
        $timezones['+05:30']='UP45';
        $timezones['+06:00']='UP6';
        $timezones['+07:00']='UP7';
        $timezones['+08:00']='UP8';
        $timezones['+09:00']='UP9';
        $timezones['+09:30']='UP85';
        $timezones['+10:00']='UP10';
        $timezones['+11:00']='UP11';
        $timezones['+12:00']='UP12';
        return $timezones;
    }
}
if (!function_exists('set_timezone')) {
    function set_timezone($data,$cookie_name='tm') {
        $data=json_decode($data);
        if(strtoupper($data->statusCode)=="OK"){
            $CI =& get_instance();
            $timezone=$data->timeZone;
            $timezone = preg_replace('/\s+/', '', $timezone);
            $ci_timezones=get_timezones();
            $ci_timezone='UTC';

            if(isset($ci_timezones[$timezone])){
                $ci_timezone=$ci_timezones[$timezone];
            }
            set_cookie($cookie_name,$ci_timezone,3600);
        }

    }
}
if (!function_exists('get_date')) {
    function get_date($date,$format="Y-m-d H:i:s",$daylight_saving = true) {
        $CI =& get_instance();
        $timestamp=strtotime($date);
        if($CI->timezone){
            $timestamp=gmt_to_local($timestamp, $CI->timezone, $daylight_saving);
        }
        return date($format,$timestamp);
    }
}



if (!function_exists('print_nice_date')) {
    function print_nice_date($date) {
        $current = strtotime(date("Y-m-d"));
        $date    = strtotime(date($date));
        $datediff = $date - $current;
        $difference = floor($datediff/(60*60*24));
        if($difference==0)
        {
            return 'Today';
        }
        else if($difference > 1 || $difference > 0 || $difference < -1)
        {
            return date('jS M,Y',$date);  
        }
        else
        {
            return 'Yesterday';
        }         
    }
}

if (!function_exists('objectToArray')) {

    function objectToArray( $object )
    {
        if( !is_object( $object ) && !is_array( $object ) )
        {
            return $object;
        }
        if( is_object( $object ) )
        {
            $object = get_object_vars( $object );
        }
        return array_map( 'objectToArray', $object );
    }

}

if (!function_exists('dispContent')) {
    function dispContent($val){
        $content = trim(stripslashes($val));
        return $content;
    }
}
if (!function_exists('getDifference')) {
    function getDifference($startDate,$endDate,$format = 3)
    {
        list($date,$time) = explode(' ',$endDate);
        $startdate = explode("-",$date);
        $starttime = explode(":",$time);

        list($date,$time) = explode(' ',$startDate);
        $enddate = explode("-",$date);
        $endtime = explode(":",$time);

        $secondsDifference = mktime($endtime[0],$endtime[1],$endtime[2],
            $enddate[1],$enddate[2],$enddate[0]) - mktime($starttime[0],
            $starttime[1],$starttime[2],$startdate[1],$startdate[2],$startdate[0]);

            switch($format)
            {
                case 1: 
                return floor($secondsDifference/60);

                case 2:
                return floor($secondsDifference/60/60);

                case 3:
                return floor($secondsDifference/60/60/24);

                case 4:
                return floor($secondsDifference/60/60/24/7);

                case 5:
                return floor($secondsDifference/60/60/24/7/4);

                default:
                return floor($secondsDifference/365/60/60/24);
            }                
        }
    }
    if (!function_exists('url_to_domain')) {
        function url_to_domain($url)
        {
            /*https://gist.github.com/davejamesmiller/1965937*/
            $host = @parse_url($url, PHP_URL_HOST);
/* If the URL can't be parsed, use the original URL
Change to "return false" if you don't want that*/
if (!$host)
    $host = $url;
/*The "www." prefix isn't really needed if you're just using
this to display the domain to the user*/
if (substr($host, 0, 4) == "www.")
    $host = substr($host, 4);
/* You might also want to limit the length if screen space is limited*/
if (strlen($host) > 50)
    $host = substr($host, 0, 47) . '...';
return $host;
}
}

if ( ! function_exists('parseBool'))
{
    function parseBool($value){
        return filter_var($value, FILTER_VALIDATE_BOOLEAN);
    }
}

if(!function_exists('generate_thumb_from_img')){
    function generate_thumb_from_img($data,$height,$width,$th_name,$upload_dir){
        $CI =& get_instance();
        $CI->load->library('image_lib');
        $config1['image_library'] = 'gd2';
        $config1['source_image'] = $data['upload_data']['full_path'];
        $config1['create_thumb'] = TRUE;
        $config1['maintain_ratio'] = TRUE;
        $config1['width']     = $width;
        $config1['height']   = $height;
        $config1['thumb_marker']='';
        $config1['new_image']   =  $upload_dir."/".$th_name.$data['upload_data']['file_name'];
        $CI->image_lib->initialize($config1);
        $CI->image_lib->resize();
        $CI->image_lib->clear();
    }
}


if(!function_exists('count_hours')){
    function count_hours($startDate,$endDate,$startTime='',$endTime=''){
        $hour1 = 0; $hour2 = 0;
        $date1 = $startDate." ".$startTime;
        $date2 = $endDate." ".$endTime;
        $datetimeObj1 = new DateTime($date1);
        $datetimeObj2 = new DateTime($date2);
        $interval = $datetimeObj1->diff($datetimeObj2);

        if($interval->format('%a') > 0)
        {
            $hour1 = $interval->format('%a')*24;
        }
        if($interval->format('%h') > 0){
            $hour2 = $interval->format('%h');
        }
        $final_hours = $hour1+$hour2;
        return $final_hours;
    }
}
if(!function_exists('count_days')){
    function count_days($from,$to){
        $from_date = new DateTime($from);
        $to_date = new DateTime($to);
        return $from_date->diff($to_date)->days;
        /*return $from_date->diff($to_date)->h;
       return $from_date->diff($to_date)->i;
       return $from_date->diff($to_date)->s;
       return $from_date->diff($to_date)->invert;
       return $from_date->diff($to_date)->d;
       return $from_date->diff($to_date)->m;
        return $from_date->diff($to_date)->y;
        DateInterval Object ( [y] => 0 [m] => 0 [d] => 26 [h] => 0 [i] => 0 [s] => 0 [invert] => 0 [days] => 26 )*/
    }
}


if(!function_exists('date_difference')){
    function date_difference($startDate,$endDate){

        $days_count_start = strtotime($startDate);
        $days_count_end = strtotime($endDate);
        $difference = ceil(abs($days_count_end - $days_count_start) / 86400);
        $difference = ($difference > 0) ? $difference : 1; 
        return $difference;
    }
}


if(! function_exists('timeAgo')){
    function timeAgo($time_ago)
    {
        $time_ago = strtotime($time_ago);
        $cur_time   = time();
        $time_elapsed   = $cur_time - $time_ago;
        $seconds    = $time_elapsed ;
        $minutes    = round($time_elapsed / 60 );
        $hours      = round($time_elapsed / 3600);
        $days       = round($time_elapsed / 86400 );
        $weeks      = round($time_elapsed / 604800);
        $months     = round($time_elapsed / 2600640 );
        $years      = round($time_elapsed / 31207680 );
        /*Seconds*/
        if($seconds <= 60){
            return "Just now";
        }
        /*Minutes*/
        else if($minutes <=60){
            if($minutes==1){
                return "1 minute ago";
            }
            else{
                return "$minutes minutes ago";
            }
        }
        /*Hours*/
        else if($hours <=24){
            if($hours==1){
                return "1 hour ago";
            }else{
                return "$hours hrs ago";
            }
        }
        /*Days*/
        else if($days <= 7){
            if($days==1){
                return "yesterday";
            }else{
                return "$days days ago";
            }
        }
        /* Weeks*/
        else if($weeks <= 4.3){
            if($weeks==1){
                return "1 week ago";
            }else{
                return "$weeks weeks ago";
            }
        }
        /*Months*/
        else if($months <=12){
            if($months==1){
                return "1 month ago";
            }else{
                return "$months months ago";
            }
        }
        /* Years*/
        else{
            if($years==1){
                return "1 year ago";
            }else{
                return "$years years ago";
            }
        }
    }
}



if(!function_exists('array_sort_by_column')){
    function array_sort_by_column($arr, $col, $dir = SORT_ASC)
    {
        $sort_col = array();
        foreach ($arr as $key=> $row)
        {
            $sort_col[$key] = $row[$col];
        }
        array_multisort($sort_col, $dir, $arr);
        return $arr;
    }
}

if(!function_exists('check_in_range')){
    function check_in_range($start_date, $end_date, $test_date)
    {
        $year = DEFAULT_YEAR;
        $start_ts = strtotime($year.'-'.$start_date);
        $end_ts = strtotime($year.'-'.$end_date);
        $test_ts = strtotime($year.'-'.$test_date);
        if ($start_ts > $end_ts) 
        {
            $year -= 1;
            $start_ts = strtotime($year.'-'.$start_date);
        }
        return (($test_ts >= $start_ts) && ($test_ts <= $end_ts));
    }
}



if(!function_exists('currencyConvert'))
{
    function currencyConvert($price_dis = null,$currency_code = null,$default_currency = null)
    {
        $price_dis = display_decimal_price($price_dis);
        return $price_dis;
    }
}

if (!function_exists('array_column')) 
{
    function array_column($array,$column) 
    {
        $col = array();
        foreach ($array as $k => $v) {
            $col[]=$v[$column];
        }
        return $col;
    }
}



if (!function_exists('display_decimal_price')) 
{
    function display_decimal_price($price) 
    {
        $price = number_format($price, 2, '.', '');
        return $price;
    }
}


if (!function_exists('count_age')) 
{
    function count_age($day = '', $month = '', $year = '') 
    {
        if($day != '' && $month != '' && $year != '')
        {
            $year_diff  = date("Y") - $year;
            $month_diff = date("m") - $month;
            $day_diff   = date("d") - $day;
            if ($day_diff < 0 && $month_diff==0) $year_diff--;
            if ($day_diff < 0 && $month_diff < 0) $year_diff--;
        }
        return $year_diff; 
    }
}