<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Specialoffers extends MY_Controller
{
	function __construct()
	{	
		$this->login_type	='';
		$this->layout		='default';
		$this->access      ='';
		parent::__construct();
		$this->_init();
	}

	private function _init()
	{
		$this->sections['section_header'] = 'sections/header';
		$this->sections['section_footer'] = 'sections/footer';
		$this->load->model("offers_model");
		$this->load->model("content_model");
	}

	public function index()
	{
		$this->output->set_title(lang("Special offers"));


		$this->load->model("content_model");
		$where_ar[] = array("display_position='special_offer'",null,false);
		$this->data["special_offer_content"] = $this->content_model->set_fields("page_title,page_description,meta_keyword,meta_description")->get_by($where_ar);

		if($this->data["special_offer_content"]["meta_keyword"] != '' && $this->data["special_offer_content"]["meta_keyword"] != null)
		{
			$this->meta_keyword = $this->data["special_offer_content"]["meta_keyword"];		
		}

		if($this->data["special_offer_content"]["meta_description"] != '' && $this->data["special_offer_content"]["meta_description"] != null)
		{
			$this->meta_description = $this->data["special_offer_content"]["meta_description"];
		}

		$today_date = date('Y-m-d');
		$where[] = array("('".$today_date."' BETWEEN offers.start_date AND offers.end_date OR start_date > '".$today_date."')",null,false); 
		$this->data["special_offers"] = $this->offers_model->set_fields("offers.*,cg.group_name")
		->join('car_groups as cg','cg.id = offers.groupId')
		->join('offers_cars_detail', 'offers_cars_detail.offerId = offers.id')
		->group_by("offers_cars_detail.offerId")->get_many_by($where);	

		$this->load->start_inline_scripting();
		echo "Appfd.init_special_offer_operations();";
		$this->load->end_inline_scripting(false,false);	


		$this->load->model("facilities_promo_code_model");
		$this->load->model("facilities_promo_code_car_details_model");
		$today_date = date('Y-m-d');

		$facilities_promo_where = array();
		$facilities_promo_where[] = array("all_cars = '1' AND (('".$today_date."' BETWEEN facilities_promo_code.start_date AND facilities_promo_code.end_date) OR ('".$today_date."' BETWEEN facilities_promo_code.start_date AND facilities_promo_code.end_date) OR  facilities_promo_code.start_date > '".$today_date."')",null,false); 

		$facility_promo_code = $this->facilities_promo_code_model
		->set_fields("cs.*")
		->join("car_facilities as cs","cs.id = facilities_promo_code.facilityId","left")	
		->get_many_by($facilities_promo_where);

		$this->data["facility_promo_code"] = $facility_promo_code;


		$this->data["output"] = $this->load->view("specialoffers/search_row",$this->data,true);;


		/*printr($this->data["special_offers"]);*/
	}
}
