<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Social extends MY_Controller {



	public function __construct() {

		parent::__construct();

		$this->load->helper('form');

		$this->load->helper('cookie');

		$this->load->library('session');

		$this->load->library('OAuth2');

		$this->load->library('Template');		

	}



	public function session($provider) 

	{ 

		if($provider == 'facebook') {

			$app_id = FB_APP_ID;

			$app_secret = FB_APP_SECRET;

			$provider	= $this->oauth2->provider($provider, array(

				'id' => $app_id,

				'secret' => $app_secret

				));			

		}

		else if($provider == 'google'){

			$app_id       = GOOGLE_APP_ID;

			$app_secret   = GOOGLE_APP_SECRET; 



			$provider 		= $this->oauth2->provider($provider, array(

				'id' => $app_id,

				'secret' => $app_secret,

				)); 			

		}

		if ( ! $this->input->get('code'))

		{  

			if($this->input->get('error')!=''){

				$err=ucwords(str_replace("_"," ",$this->input->get('error')));

				$this->session->set_flashdata('error',$err);

				redirect(base_url().'signin');

				exit();

			}

			else{

				$provider->authorize();

			}

		}

		else

		{

			try

			{

				$success = false;

				$facebook_id="";

				$google_id="";

				$reg_type = "";

				$msg = lang("Something went wrong.Please try again.");



				$uriData = $this->uri->segment_array();

				$token = $provider->access($_GET['code']);

				$user = $provider->get_user_info($token);

				$this->load->model('user_model','',TRUE);

				if($uriData [2] == 'google'){

					$reg_type = "g";

					$google_id = $user["uid"]; 

					$success = true;

				}

				else if($uriData [2] == 'facebook'){

					$reg_type = "f";

					$facebook_id = $user["uid"];

					$success = true;

				}



				if($user["email"]!='' && $success == true){

					$isAlreadyLogedIn = $this->user_model->as_array()->get_by("email",$user["email"]);



					if(!empty($isAlreadyLogedIn))

					{

						$array = array(

							'id'=>$isAlreadyLogedIn['id'],

							'session_update'=>true,

							'skip_validation'=>true

							);

						$userLoginData = $this->user_model->check_login($array);



						if($userLoginData['status'] == 'success')

						{

							$social_loged_in = array('name'=>'social_loged_in',

								'value'=>base_url());

							$this->input->set_cookie($social_loged_in);

							$success = true;

						}

						else if($userLoginData["status"] == "fail"){

							$msg = $userLoginData['msg'];

						}

					}

					else{



						$password = mt_rand();

						$data = array(

							'firstname'=>$user["first_name"],

							'lastname'=>$user["last_name"],

							'email'=>$user["email"],

							'reg_type'=>$reg_type,

							'fb_id'=>$facebook_id,

							'google_id'=>$google_id,

							'status'=>'a',

							'status'=>'y',

							'created'=>date('Y-m-d H:i:s'),

							'password'=>$password

							);

						$user_id = $this->user_model->insert($data,true);

						$array = array('id'=>$user_id,'session_update'=>true,'skip_validation'=>true);

						$this->user_model->check_login($array);

						$success = true;

					}

				}

				else{

					$success =false;

				}

				if($success == true)

				{

					redirect(base_url()."dashboard");

					exit();

				}else

				{

					$this->session->set_flashdata('error',$msg);

					redirect(base_url().'signin');

					exit();

				}



			}

			catch (OAuth2_Exception $e)

			{

				

				$this->session->set_flashdata('error',$e);

				redirect(base_url().'signin');

				exit();

			}

		}

	}



	public function success(){

		$this->session->keep_flashdata('success');

		redirect(base_url()."dashboard");

		exit;

	}



	public function error(){

		$this->session->keep_flashdata('error');

		redirect(base_url()."signin");

	}



}?>