<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once("common_methods.php");
class Home extends Common_methods 
{
	function __construct()
	{	
		$this->login_type	='';
		$this->layout		='home';
		$this->access      ='';
		parent::__construct();
		$this->_init();
	}

	private function _init()
	{
		$this->sections['section_header'] = 'sections/header';
		$this->sections['section_footer'] = 'sections/footer';
		$this->sections['section_connect_with_us'] = 'sections/connect_with_us';
	}

	public function index()
	{
		$this->load->model("slider_img_model");
		$this->load->model("locations_model");
		$this->load->model("site_settings_model");
		$this->load->model("content_model");
		$this->load->model("faq_sections_model");
		$this->load->model("faq_model");

		$this->load->js('plugins/mediaelements/build/mediaelement-and-player.js');
		$this->load->css('plugins/mediaelements/build/mediaelementplayer.css');
		
		

		/*$this->load->js('js/jquery-ui.min.js');*/
		/*	$this->load->css('css/jquery-ui.min.css');*/


		$this->output->set_title(HOME_HEAD_TITLE);	

		
		$this->body_class = "home_js";
		$this->pg_home = true;
		$this->header_class = true;
		$slider_where[] = array("type='v' AND status = 'y'",null,false);
		$exist_check = $this->slider_img_model->set_fields("id,image,type,caption,link,status")->limit(1,0)->order_by("id","desc")->get_by($slider_where);
		if(!empty($exist_check))
		{
			$this->data["slider_data"][] = $exist_check;
		}else{
			$this->data["slider_data"] = $this->slider_img_model->get_many_by("status",'y');
		}
		
		/*$this->locations_model->after_get_allow = false;
		$this->data["locations"] = $this->locations_model->set_fields("id,location_name")->get_many_by("status",'y');
		$this->locations_model->after_get_allow = true;*/

		$this->load->start_inline_scripting();
		echo "Appfd.init_home_operations();";
		$this->load->end_inline_scripting(false,false);
		
		$this->meta_keyword = HOME_META_KEY;
		$this->meta_description = HOME_META_DESC;
		
		$default_location_ar = $this->site_settings_model->get_by('constant','LOCATION');
		$this->data["default_location_id"] = $default_location_ar["value"];

		$this->locations_model->after_get_allow = false;
		$default_location_array = $this->locations_model->set_fields("id,location_name,working_from,working_to")->get($default_location_ar["value"]);
		$this->locations_model->after_get_allow = true;

		$check_working_time = $this->locations_model->get_working_time($default_location_array["id"],date("Y-m-d"));
		if($check_working_time["status"] == "success")
		{	
			$working_from_ar = explode(":",$check_working_time["working_from"]);
			array_pop($working_from_ar);
			$this->data["working_from"] = implode(":",$working_from_ar);
			
			$working_to_ar = explode(":",$check_working_time["working_to"]);
			array_pop($working_to_ar);
			$this->data["working_to"] = implode(":",$working_to_ar);
		}
		else
		{
			$working_from_ar = explode(":",$default_location_array["working_from"]);
			array_pop($working_from_ar);
			$this->data["working_from"] = implode(":",$working_from_ar);
			$this->data["working_to"] = $this->data["working_from"];
		}


		/*$working_to_ar = explode(":",$default_location_array["working_to"]);
		array_pop($working_to_ar);
		$this->data["working_to"] = implode(":",$working_to_ar);*/

		
		$this->data["selected_pickup_location"] = $this->data["selected_dropoff_location"] = $default_location_array["location_name"];
		$this->data["pickup_location"] = $this->data["dropoff_location"] = $default_location_ar["value"];
		
		$this->data["location_time_ar"] = $this->get_opening_time_from_location($default_location_ar["value"]);
		/*$faq_section_ar = $this->faq_sections_model->get_by("name",'Home');
		$this->data["faqs"] = $this->faq_model
		->set_fields("faq.*,fc.id as cat_id,fc.name as category_name")
		->join("faq_category as fc","fc.id = faq.categoryId","left")
		->get_many_by("faq.sectionId",$faq_section_ar["id"]);

		if(!empty($this->data["faqs"]))
		{
			$faqs = array();
			foreach ($this->data["faqs"] as $key => $value) 
			{
				$faqs[$value["category_name"]][] = $value;
			}	
			$this->data["faqs"] = $faqs;
		}*/
		
		$pages_where[] = array("display_position IN('home_top_left','home_top_right','home_nova_wifi_section','home_faq_beside_right_section','home_community_section','home_middle_image_section','home_car_section_title','home_car_section_top','home_car_section_middle','home_car_section_bottom','home_location_section_bottom')",null,false);

		$pages_records = $this->content_model->set_fields("id,display_position,page_description")->get_many_by($pages_where);
		if(!empty($pages_records))
		{
			foreach ($pages_records as $key => $value) {
				$this->data[$value["display_position"]] = $value["page_description"];
			}
		}
		
	}

	public function check_coupon_exist($car_id = 0)
	{
		if($this->isAjax)
		{
			$this->view = false;
			$this->layout = false;
			$this->json = true;
		}
		
		$this->load->model("coupons_model");
		$coupon_code = $this->input->post("coupon_code");
		$pickup_location = ($this->session->userdata("pickup_location") > 0) ? $this->session->userdata("pickup_location") : 0;
		$dropoff_location = ($this->session->userdata("dropoff_location") > 0) ? $this->session->userdata("dropoff_location") : 0;
		$pickup_date = ($this->session->userdata("pickup_date") != '') ? $this->session->userdata("pickup_date") : '';
		$dropoff_date = ($this->session->userdata("dropoff_date") != "") ? $this->session->userdata("dropoff_date") : '';
		$pickup_time = ($this->session->userdata("pickup_time") != '') ? $this->session->userdata("pickup_time") : '';
		$dropoff_time = ($this->session->userdata("dropoff_time") != '') ? $this->session->userdata("dropoff_time") : '';

		$this->data["status"] = "success";
		$this->data["msg"] = "";
		$exist_where_ar[] = array("('".$pickup_date."' BETWEEN start_date AND end_date) AND code = '".$coupon_code."'",null,false);
		$coupon_exist_ar = $this->coupons_model->get_by($exist_where_ar);

		if(!empty($coupon_exist_ar))
		{
			if($coupon_exist_ar["used"] < $coupon_exist_ar["max_usage"])
			{
				$this->load->model("cars_model");
				$this->load->model("pricing_model");

				$type = ($this->input->post('type') != "") ? $this->input->post('type') : "";
				$offer_id = ($this->input->post('offer_id') != "") ? $this->input->post('offer_id') : "";
				$facilities = ($this->input->post('car_facilities') != "") ? $this->input->post('car_facilities') : "";
				$facility_post = array();
				if(!empty($facilities))
				{
					foreach ($facilities as $key => $value) 
					{
						if($value > 0)
						{
							$facility_post[] = $key;	
						}
					}
				}
				$insuranceGroupId = ($this->input->post('insuranceGroupId') > 0) ? $this->input->post('insuranceGroupId') : "";

				$this->cars_model->after_get_locations_allow = false;
				$car_data = $this->cars_model->get($car_id);	
				$this->cars_model->after_get_locations_allow = true;

				$this->pricing_model->car_category = $car_data["categoryId"];
				$this->pricing_model->pickup_date = $pickup_date;
				$this->pricing_model->pickup_time = $pickup_time;
				$this->pricing_model->dropoff_date = $dropoff_date;
				$this->pricing_model->dropoff_time = $dropoff_time;
				$this->pricing_model->car_id = $car_data["id"];
				$this->pricing_model->booking_selected_facilities = $facility_post;
				$this->pricing_model->insuranceGroupId = $insuranceGroupId;
				$this->pricing_model->pickup_location = $pickup_location;
				$this->pricing_model->dropoff_location = $dropoff_location;
				$price_ar = $this->pricing_model->get_car_price($car_data);
				if($price_ar["total"] >= $coupon_exist_ar["minimum_total"])
				{
					$this->session->set_userdata("coupon_id",$coupon_exist_ar["id"]);
					$this->data["msg"] = lang("COUPON_APPLIED_SUCCESSFULLY");
				}
				else
				{
					$this->session->unset_userdata("coupon_id");
					$this->data["status"] = "error";
					$this->data["msg"] = lang("COUPON_CODE_MINIMUM_AMOUNT")." ".$coupon_exist_ar["minimum_total"];	
				}
			}
			else{
				$this->session->unset_userdata("coupon_id");
				$this->data["status"] = "error";
				$this->data["msg"] = lang("COUPON_CODE_MAXIMUM_LIMIT_REACHED");	
			}
		}
		else
		{
			$this->session->unset_userdata("coupon_id");
			$this->data["status"] = "error";
			$this->data["msg"] = lang("INVALID_COUPON_CODE");
		}
	}
}
