<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Cron extends MY_Controller {
	function __construct()
	{
		$this->login_type	= '';
		$this->access   = '';
		$this->permission_check   = false;
		parent::__construct();	
		$this->_init();	
	}


	private function _init()
	{
		$this->view = false;
		$this->layout = false;		
	}


	public function index()
	{
		$this->load->model("user_model");		
		$this->load->model("countries_model");
		$this->load->model("refferal_list_model");
		$this->load->model("bookings_model");
		$date = date("Y-m-d H:i:s", strtotime("+1 day"));

		$date1 = date("Y-m-d", strtotime($date));
		$date2 = date("H:i", strtotime($date)).":00";;

		$where[] = array("pickup_date = '".$date1."' AND pickup_time <= '".$date2."' AND reminder_sent = 'n' AND booking_status = 'a'",null,false);
		$this->bookings_model->after_get_user_info_allow = true;
		$all_bookings = $this->bookings_model->get_many_by($where);
		$this->bookings_model->after_get_user_info_allow = false;
		$this->load->model("car_facilities_model");
        
		if(!empty($all_bookings))
		{
			foreach ($all_bookings as $key => $value) 
			{
			    $extras = '';
				$booking_info = $value;
				$booking_price_ar = (array)json_decode($booking_info["pricingDetails"]);
				$sitename =SITE_NM;
				$username = $booking_info["user_info"]["firstname"]." ".$booking_info["user_info"]["lastname"];
				$useremail = $booking_info["user_info"]["email"];
				$userphone = $booking_info["contactNo"];
				$userlicence = $booking_info["user_info"]["drivinglicence_no"];
				$user_country_name_ar = $this->countries_model->set_fields("country_name")->get($booking_info["user_info"]["country"]);;
				$user_country_name = $user_country_name_ar["country_name"];
				$flight_no = $booking_info["flight_no"];
				$user_note = $booking_info["note"];
				$booking_no = $booking_info["booking_no"];
				$car_name = $booking_info["car_info"]['name'];

				$car_image_path = base_url()."image/car/".$booking_info["car_info"]["id"]."/264/184/".$booking_info["car_info"]["image"];

				$car_image = "<img style='margin: 0 auto;' src='".$car_image_path."' />";

				if(!empty($booking_info["booking_selected_facilities_price"]))
				{
					$facility_comma_sep = '';
					foreach ($booking_info["booking_selected_facilities_price"] as $key => $value1) 
					{
						$facility_comma_sep .= $key.",";
					}
					$facility_comma_sep = rtrim($facility_comma_sep,",");
				}

				if($facility_comma_sep != '')
				{
					$facilities_where[] = array('id IN ('.$facility_comma_sep.')',null,false);
					$get_facilities_data = $this->car_facilities_model->set_fields("car_facilities.*")->get_many_by($facilities_where);
					foreach ($get_facilities_data as $key => $value2) 
					{
						$extras .= $value2["facility_name"]." - ".display_decimal_price($booking_info["booking_selected_facilities_price"][$value2["id"]])." EUR <br />";
					}	
				}

				$car_category_name = $booking_info["car_info"]['category'];
				$car_group_name = $booking_info["car_info"]['group'];
				$sub_total = $booking_info["sub_total"];
				$dropoff_fee = $booking_price_ar["dropoff_price"];
				$total =  $booking_price_ar["total"];
				$pickup_location_name = $booking_info["pickup_location_ar"]["location_name"];
				$dropoff_location_name = $booking_info["dropoff_location_ar"]["location_name"];
				$pickup_date = $booking_info["pickup_date"];
				$pickup_time = $booking_info["pickup_time"];
				$pick_loc_address = $booking_info["pickup_location_ar"]["address"];
				$pick_loc_city = $booking_info["pickup_location_ar"]["city_name"];
				$pick_loc_zip =$booking_info["pickup_location_ar"]["zip_code"];
				$pick_loc_phone = $booking_info["pickup_location_ar"]["phone"];
				$pick_loc_opening_days =  $booking_info["pickup_location_ar"]["opening_days"];
				$pick_loc_opening_time = $booking_info["pickup_location_ar"]["opening_from"];


				$pickup_location_manager = strip_tags($booking_info["pickup_location_ar"]["location_manager"]);
				$pickup_direction_desk = strip_tags($booking_info["pickup_location_ar"]["direction_desk"]);
				$pickup_location_note = strip_tags($booking_info["pickup_location_ar"]["location_note"]);

				$pickup_working_time = date('H:i', strtotime($booking_info["pickup_location_ar"]["working_from"]))." - ".date('H:i', strtotime($booking_info["pickup_location_ar"]["working_to"]));


				$dropoff_date = $booking_info["dropoff_date"];
				$dropoff_time = $booking_info["dropoff_time"];

				$drop_loc_address = $booking_info["dropoff_location_ar"]["address"];;
				$drop_loc_city = $booking_info["dropoff_location_ar"]["city_name"];;
				$drop_loc_zip = $booking_info["dropoff_location_ar"]["zip_code"];
				$drop_loc_phone = $booking_info["dropoff_location_ar"]["phone"];
				$drop_loc_opening_days = $booking_info["dropoff_location_ar"]["opening_days"];
				$drop_loc_opening_time = $booking_info["dropoff_location_ar"]["opening_from"];

				$dropoff_location_manager = strip_tags($booking_info["dropoff_location_ar"]["location_manager"]);
				$dropoff_direction_desk = strip_tags($booking_info["dropoff_location_ar"]["direction_desk"]);
				$dropoff_location_note = strip_tags($booking_info["dropoff_location_ar"]["location_note"]);

				$dropoff_working_time = date('H:i', strtotime($booking_info["dropoff_location_ar"]["working_from"]))." - ".date('H:i', strtotime($booking_info["dropoff_location_ar"]["working_to"]));

				$insurance_price = $booking_price_ar["insurance_price"];
				$insuraince_type_name =  $booking_info["insurance_name"];
				$deposit = display_decimal_price($booking_info["insurance_deposit"]); 


				$coupon_discount = ($booking_price_ar["coupon_applied_price"] > 0) ? $booking_price_ar["coupon_applied_price"] : 0;

				$driver_fee = ($booking_price_ar["driver_age_price"] > 0) ? display_decimal_price($booking_price_ar["driver_age_price"]) : 0;
				
				$from_time_surcharge_price = ($booking_price_ar["from_time_surcharge_price"] > 0) ? display_decimal_price($booking_price_ar["from_time_surcharge_price"]) : 0;

				$to_time_surcharge_price = ($booking_price_ar["to_time_surcharge_price"] > 0) ? $booking_price_ar["to_time_surcharge_price"] : 0;

				

				$car_characteristics = '';
				if(!empty($booking_info["car_info"]["db_sel_characteristics"]))
				{
					$characteristics = array_column($booking_info["car_info"]["db_sel_characteristics"], 'name');
					$characteristics = implode(",",$characteristics);
				}

				if($booking_info["date_of_birth"] != '' || $booking_info["driverage"] != '')
				{
					$user_age = (date('Y') - date('Y',strtotime($booking_info["date_of_birth"])));
					$user_age = ($user_age > 0) ? $user_age : 	$booking_info["driverage"];	
				}
				else
				{
					$user_age = 'N/A';	
				}
				

				

				$key = array("{SITE_NAME}","{USERNAME}","{USER_EMAIL}","{USER_PHONE}","{USER_LICENSE}","{USER_COUNTRY}","(FLIGHT_NUMBER}","{USER_NOTE}","{BOOKING_ID}","{CAR_NAME}","{CAR_GROUP}","{CAR_CATEGORY}","{SUB_TOTAL}","{DROPOFF_PRICE}","{EXTRAS_PRICE}","{TOTAL_PRICE}","{PICKUP_LOCATION}","{PICKUP_DATE}","{PICKUP_TIME}","{PICKUP_LOCA_ADDRESS}","{PICKUP_CITY}","{PICKUP_ZIP}","{PICKUP_LOCA_PHONE}","{PICK_DAYS}","{PICK_TIME}","{DROPOFF_LOCATION}","{DROPOFF_DATE}","{DROPOFF_TIME}","{DROPOFF_LOCA_ADDRESS}","{DROPOFF_CITY}","{DROPOFF_ZIP}","{DROPOFF_LOCA_PHONE}","{DROP_DAYS}","{DROP_TIME}","{INSURANCE_NM}","{INSURANCE}","{DEPOSIT}","{CAR_IMAGE}","{PICKUP_LOCATIONMANAGER}","{PICKUP_DIRECTIONDESK}","{DROPOFF_DIRECTIONDESK}","{DROPOFF_LOCATIONMANAGER}","{PICKUP_LOCATIONNOTE}","{DROPOFF_LOCATIONNOTE}","{FROM_TIME_SURCHRGE}","{TO_TIME_SURCHRGE}","{COUPON_DISCOUNT}","{CAR_CHARACTERISTICS}","{USER_AGE}","{PICKUP_WORKING_TIME}","{DROPOFF_WORKING_TIME}","{DRIVER_FEE}","{FROM_TIME_SURCHARGE_FEE}","{TO_TIME_SURCHARGE_FEE}");

					$val = array(
						$sitename,
						$username,
						$useremail,
						$booking_info["contactNo"],
						$userlicence,
						$user_country_name,
						$flight_no,
						$booking_info["note"],
						$booking_info["booking_no"],
						$car_name,
						$car_group_name,
						$car_category_name,
						$sub_total,
						$dropoff_fee,
						$extras,
						$total,
						$pickup_location_name,
						$pickup_date,
						$pickup_time,
						$pick_loc_address,
						$pick_loc_city,
						$pick_loc_zip,
						$pick_loc_phone,
						$pick_loc_opening_days,
						$pick_loc_opening_time,
						$dropoff_location_name,
						$dropoff_date,
						$dropoff_time,
						$drop_loc_address,
						$drop_loc_city,
						$drop_loc_zip,
						$drop_loc_phone,
						$drop_loc_opening_days,
						$drop_loc_opening_time,
						$insuraince_type_name,
						$insurance_price,
						$deposit,
						$car_image,
						$pickup_location_manager,
						$pickup_direction_desk,
						$dropoff_direction_desk,
						$dropoff_location_manager,
						$pickup_location_note,
						$dropoff_location_note,
						$booking_price_ar["from_time_surcharge_price"],
						$booking_price_ar["to_time_surcharge_price"],
						$coupon_discount,
						$characteristics,
						$user_age,  
						$pickup_working_time,
						$dropoff_working_time,
						$driver_fee,
						$from_time_surcharge_price,
						$to_time_surcharge_price
						);

send_mail('Reminder Booking Mail',$key,$val,$value["user_info"]["email"]);


$this->bookings_model->after_update_allow = false;
$this->bookings_model->before_update_allow = false;
$update_ar = array("reminder_sent"=>'y');
$this->bookings_model->update($booking_info["id"],$update_ar,true);
$this->bookings_model->after_update_allow = true;
$this->bookings_model->before_update_allow = true; 
}
}
}

public function update_currency_rates(){
	$this->load->library("currency_convertor");
	$this->currency_convertor->update_rates();
}

public function slug_generate()
{
	$config = array(
		'field' => 'slug',
		'title' => 'page_title',
		'table' => 'content',
		'id' => 'id',
		);
	
	$this->load->library('slug', $config);
	$this->load->model("content_model");
	$get_records = $this->content_model->get_all();
	if(!empty($get_records))
	{
		foreach ($get_records as $key => $value) 
		{
			$id = $value["id"];
			$data = array(
				'page_title' => $value["page_title"],
				);
			$data['slug'] = $this->slug->create_uri($data, $id);
			$this->db->where('id', $id);
			$this->db->update('content', $data);
		}
	}
}

public function birthday_reminder()
	{
		$this->load->model("user_model");		
		$date = date("m-d");
		$current_year = date("Y");	
		$where[] = array("DATE_FORMAT(date_of_birth, '%m-%d') = '".$date."' AND ((last_birthday_reminder_year IS NULL) OR (last_birthday_reminder_year != '' AND last_birthday_reminder_year != '".$current_year."'))",null,false);
		
		$this->user_model->after_get_country_allow = false;
		$all_users = $this->user_model->get_many_by($where);
		$this->user_model->after_get_country_allow = true;
		
		if(!empty($all_users))
		{
			foreach ($all_users as $key => $value) 
			{
			    
			  	$key = array("{SITE_NM}","{FULL_NAME}","{USER_EMAIL}");
			  	$val = array(
					SITE_NM,
					$value["firstname"]." ".$value["lastname"],
					$value["email"]
				);
				$mail_send_status = send_mail('User Birthday',$key,$val,$value["email"]);

				if($mail_send_status)
				{
					$update_array = array(
						"last_birthday_reminder_year"=>date("Y")
					);
					$this->user_model->update($value["id"],$update_array,true);
				}
			}
		}
	}
}
