<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once("common_methods.php");
class Content extends Common_methods {

	function __construct()
	{	
		$this->login_type	='';
		$this->layout		='default';
		$this->access      ='';
		parent::__construct();
		$this->_init();		
	}

	private function _init()
	{
		$this->sections['section_header'] = 'sections/header';
		$this->sections['section_footer'] = 'sections/footer';
		$this->sections['section_og_meta'] = 'sections/og_meta';
	}

	public function index($slug = '')
	{
		if(!$this->input->post())
		{
			$this->load->model("content_model");
			$this->load->model("locations_model");
			$this->load->model("site_settings_model");


			$logo_data = $this->site_settings_model->set_fields("value")->get_by('constant','SITE_LOGO');
			if(!empty($logo_data))
			{
				$logo_img = base_url()."assets/nova/img/site_setting/".$logo_data["value"];
			}
			else{
				$logo_img = asset_url().'images/logo.png';
			}

			$content_data = $this->content_model->get_by('slug',$slug);
			$redirect_flag = false;
			if(!empty($content_data))
			{
				$this->output->set_title(lang($content_data["page_title"]));				
				$this->meta_keyword = ($content_data["meta_keyword"] != '') ? $content_data["meta_keyword"] : '';
				$this->meta_description = ($content_data["meta_description"] != '') ? $content_data["meta_description"] : '';

				$this->social_meta = array(
					"type"=>array("property"=>"type","content"=>"website"),
					"url"=>array("property"=>"url","content"=>base_url().'pages/'.$content_data["id"]),
					"title"=>array("property"=>"title","content"=>$content_data["page_title"]),
					"description"=>array("property"=>"description","content"=>$content_data["meta_description"]),
					"image"=>array("property"=>"image","content"=>$logo_img)
					);

				if(!empty($content_data) && $content_data["status"] == 'y')
				{

					$this->data["locations"] = $this->locations_model->get_many_by("status",'y');
					$default_location_ar = $this->site_settings_model->get_by('constant','LOCATION');
					$this->data["default_location_id"] = $default_location_ar["value"];
					$this->data["dropoff_location_time"] = $this->get_opening_time_from_location($default_location_ar["value"]);
					$this->data["pickup_location_time"] = $this->get_opening_time_from_location($default_location_ar["value"]);
					$this->data["content_data"] = $content_data;


					$this->locations_model->after_get_allow = false;
					$default_location_array = $this->locations_model->set_fields("id,location_name,working_from,working_to")->get($default_location_ar["value"]);
					$this->locations_model->after_get_allow = true;

					$working_from_ar = explode(":",$default_location_array["working_from"]);
					array_pop($working_from_ar);
					$this->data["working_from"] = implode(":",$working_from_ar);

					$this->data["working_to"] = $this->data["working_from"];	

					$this->data["selected_pickup_location"] = $this->data["selected_dropoff_location"] = $default_location_array["location_name"];

					$this->data["pickup_location"] = $this->data["dropoff_location"] = $default_location_ar["value"];


					if($content_data["allow_booking_form"] == 'y')
					{
						$this->load->css('css/refferal_booking.css');

						$this->load->start_inline_scripting();
						echo "Appfd.initContentOperations();";
						$this->load->end_inline_scripting(false,false);


						$this->data["booking_form_view"] = $this->load->view("content/booking_form",$this->data,true);
					}
					




				}
				else
				{
					$redirect_flag = true;
				}
			}
			else
			{
				$redirect_flag = true;
			}

			if($redirect_flag == true)
			{
				$this->session->set_flashdata("error",lang(INVALID_LINK));
				redirect(base_url());
			}
		}
	}

	public function rss_feed($id)
	{
		$this->load->model("content_model");
		$content_data = $this->content_model->get($id);
		if(!empty($content_data))
		{
			$this->load->helper('xml');
			$this->layout = false;
			$this->data['encoding'] = 'utf-8';
			$this->data['feed_name'] = site_name();
			$this->data['feed_url'] = base_url();
			$this->data['page_description'] = 'Welcome to '.site_name().' feed url page';
			$this->data['page_language'] = 'en-ca';
			$this->data['creator_email'] = ADMIN_EMAIL;
			$this->data['content_data'] = $content_data;
			$processed_output = $content_data["page_description"];
			$this->data["processed_output"] = xml_convert($processed_output);
			header("Content-Type: application/rss+xml");						
		}	
		else
		{
			$this->session->set_flashdata("error",INVALID_LINK);
			redirect(base_url(),"refresh");
			exit();
		}

	}
}
