<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Contact extends MY_Controller {

	function __construct()
	{	
		$this->login_type	='';
		$this->layout		='default';
		$this->access      ='';
		parent::__construct();
		$this->_init();		
	}

	private function _init()
	{
		$this->sections['section_header'] = 'sections/header';
		$this->sections['section_footer'] = 'sections/footer';
	}

	public function index()
	{
		if($this->input->post())
		{	
			$this->form_validation->set_rules('visitor_name', 'lang:NAME_REQUIRED', 'required',array('required' => 'lang:NAME_REQUIRED'));
			$this->form_validation->set_rules('visitor_email', 'lang:EMAIL_REQUIRED', 'required|valid_email',array('required' => 'lang:EMAIL_REQUIRED','valid_email'=>'lang:VALID_EMAIL'));
			$this->form_validation->set_rules('msg_sub', 'lang:SUBJECT_REQUIRED', 'required',array('required' => 'lang:SUBJECT_REQUIRED'));
			$this->form_validation->set_rules('message', 'lang:MESSAGE_REQUIRED', 'required',array('required' => 'lang:MESSAGE_REQUIRED'));
			if($this->form_validation->run() == false)
			{
				$this->session->set_flashdata('error',lang(validation_errors()));
				redirect(base_url()."contact");
			}
			else
			{	
				$admin = "ADMIN";
				$visitor_name = $this->input->post('visitor_name');
				$visitor_email = $this->input->post('visitor_email');
				$msg_sub = $this->input->post('msg_sub');
				$message = $this->input->post('message');

				if(isset($email) and $email != "")
				{
					$contact_email = $email;
				}else{
					$contact_email = CONTACT_EMAIL;			
				}
				$admin = "ADMIN";
				$key = array('{USER_EMAIL}','{USERNAME}','{USER_SUB}','{USER_MSG}','{ADMIN}', '{MSG_EXT}');
				$val = array($visitor_email,$visitor_name,$msg_sub,$message,$admin,'');
				$mail_status = send_mail('User contact',$key,$val,$contact_email);				
				if($mail_status)
				{
					$this->session->set_flashdata("success",lang("CONTACT_REQUEST_SUBMITTED_SUCCESSFULLY"));
				}
				else
				{
					$this->session->set_flashdata("success",lang("SOMETHING_WENT_WRONG"));
				}
				redirect(base_url()."contact");
			}

		}

		if(!$this->input->post())
		{
			$this->output->set_title(lang("Contact Us"));	
			$this->load->model("content_model");
			/*$content_where = array('page_title'=>'Contact Us','display_type'=>'page','status'=>'y');*/
			$content_where[] = array("display_position = 'contact_us' AND display_type = 'page' AND status = 'y'",null,false);
			$content_data = $this->content_model->get_by($content_where);
			if(!empty($content_data))
			{
				$this->data["title"] = $content_data["page_title"];
				$this->data["description"] = $content_data["page_description"];
				$this->data["meta_title"] = $content_data["page_title"];
				
				$this->meta_keyword = $content_data["meta_keyword"];
				$this->meta_description = $content_data["meta_description"];
			}
		}
	}
}
