<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class common_methods extends MY_Controller {
	function __construct()
	{
		$this->login_type	='';
		$this->access      ='';
		parent::__construct();		
	}
	public function get_states()
	{
		if($this->isAjax)
		{
			$this->view = false;
			$this->layout = false;
			$this->json = true;

			$this->data = array('status'=>'success','msg'=>'');
			$country_id = $this->input->post('country_id');
			$this->data["html"] = '<option value="">Please select states</option>';
			if($country_id>0)
			{
				$this->load->model("states_model");
				$states_where = array('country'=>$country_id,"status"=>"y");
				$states = $this->states_model->get_many_by($states_where);
				if(!empty($states))
				{
					foreach ($states as $key => $value) {
						$this->data["html"] .= '<option value="'.$value["id"].'">'.$value["state_name"].'</option>';			
					}
				}
			}
		}else{
			$this->session->set_flashdata('error',lang("Invalid Request."));
			redirect($redirect_url,"refresh");
			exit;
		}
	}

	public function get_cities()
	{
		if($this->isAjax)
		{
			$this->view = false;
			$this->layout = false;
			$this->json = true;

			$this->data = array('status'=>'success','msg'=>'');
			$state_id = $this->input->post('state_id');
			$this->data["html"] = '<option value="">Please select city</option>';
			if($state_id>0)
			{
				$this->load->model("cities_model");
				$cities = $this->cities_model->get_many_by('state',$state_id);
				if(!empty($cities))
				{
					foreach ($cities as $key => $value) {
						$this->data["html"] .= '<option value="'.$value["id"].'">'.$value["city_name"].'</option>';			
					}
				}
			}
		}else{
			$this->session->set_flashdata('error',lang("Invalid Request."));
			redirect($redirect_url,"refresh");
			exit;
		}
	}


	public function get_categories()
	{
		if($this->isAjax)
		{
			$this->view = false;
			$this->layout = false;
			$this->json = true;

			$this->data = array('status'=>'success','msg'=>'');
			$group_id = $this->input->post('group_id');
			$this->data["html"] = '<option>Select car category</option>';
			if($group_id>0)
			{
				$this->load->model("categories_model");
				$cities = $this->categories_model->set_fields("categories.*")->join('pricing','pricing.categoryId = categories.id AND pricing.type="b"')->get_many_by('categories.groupId',$group_id);
				if(!empty($cities))
				{
					foreach ($cities as $key => $value) {
						$this->data["html"] .= '<option value="'.$value["id"].'">'.$value["category"].'</option>';			
					}
				}
			}
		}else{
			$this->session->set_flashdata('error',lang("Invalid Request."));
			redirect($redirect_url,"refresh");
			exit;
		}
	}

	public function get_cars_from_groups()
	{
		if($this->isAjax)
		{
			$this->view = false;
			$this->layout = false;
			$this->json = true;

			$this->data = array('status'=>'success','msg'=>'');
			$group_id = $this->input->post('group_id');
			$this->data["html"] = '<option>Please select car</option>';
			if($group_id>0)
			{
				$this->load->model("cars_model");
				$cities = $this->cars_model->get_many_by('groupId',$group_id);
				if(!empty($cities))
				{
					foreach ($cities as $key => $value) {
						$this->data["html"] .= '<option value="'.$value["id"].'">'.$value["name"].'</option>';			
					}
				}
			}
		}else{
			$this->session->set_flashdata('error',lang("Invalid Request."));
			redirect($redirect_url,"refresh");
			exit;
		}
	}

	public function get_cars_from_location($location_id = 0)
	{
		$this->load->model("cars_model");
		$location_id = (int)($this->input->post('location_id') > 0) ? (int)$this->input->post('location_id') : $location_id;
		$where[] = array("car_pickup_location_detail.locationId = '".$location_id."' AND cars.status = 'y'",null,false);

		$this->cars_model->after_get_allow = false;
		$cars = $this->cars_model->set_fields("cars.name,cars.id")->join('car_pickup_location_detail', 'car_pickup_location_detail.carId = cars.id')->get_many_by($where);
		$this->cars_model->after_get_allow = true;

		if($this->isAjax)
		{
			$this->view = false;
			$this->layout = false;
			$this->json = true;
			$this->data = array('status'=>'success','msg'=>'');
			$this->data["html"] = '<option>Please select car</option>';
			if($location_id>0)
			{
				if(!empty($cars))
				{
					foreach ($cars as $key => $value) {
						$this->data["html"] .= '<option value="'.$value["id"].'">'.$value["name"].'</option>';			
					}
				}
			}
		}
		else{
			return $cars;
		}
	} 

	/**/
	public function get_opening_time_from_location($location_id = 0,$type = '')
	{
		$time_array=array();
		$default_array = array();
		$this->load->model("locations_model");
		$location_id = (int)($this->input->post('location_id') > 0) ? (int)$this->input->post('location_id') : $location_id;
		$type = ($this->input->post('type') != '') ? $this->input->post('type') : $type;
		$open=0;
		$close=0;
		
		/*for($i=0;$i<24;$i++){
			$temp=($i<10?'0'.$i:$i).':00';
			$default_array[$temp]=$temp;
		}*/

		$start=strtotime('00:00');
		$end=strtotime('23:30');		
		for ($halfhour=$start;$halfhour<=$end;$halfhour=$halfhour+30*60) {
			$temp = date('H:i',$halfhour);
			$default_array[$temp]=$temp;
		}
		$this->locations_model->after_get_allow = false;
		$data = $this->locations_model->get($location_id);
		$this->locations_model->after_get_allow = true;

		$check_working_time = $this->locations_model->get_working_time($location_id,date("Y-m-d"));
		
		if($check_working_time["status"] == "success")
		{
			$data['working_from'] = $check_working_time["working_from"];
			$data['working_to'] = $check_working_time["working_to"];
		}

		if($data and $data['opening_from'] != "" and $data['opening_to'] != ""){
			/*$open = (int)date("H",strtotime($data['opening_from']));					
			$close = (int)date("H",strtotime($data['opening_to']));*/

			$open=strtotime($data['opening_from']);
			$close=strtotime($data['opening_to']);


		}

		if($open != "" && $close != "" && $close > $open){		
			/*for($i=$open; $i <= $close;$i++){
				$temp=($i<10?'0'.$i:$i).':00';
				$time_array[$temp]=$temp;
			}*/
			for ($halfhour=$open;$halfhour<=$close;$halfhour=$halfhour+30*60) {
				//printf('<option value="%s">%s</option>',date('H:i',$halfhour),date('g:i a',$halfhour));
				$temp = date('H:i',$halfhour);
				$time_array[$temp]=$temp;
			}
		}
		else{
			$time_array=$default_array;
		}

		$working_from_ar = explode(":",$data["working_from"]);
		array_pop($working_from_ar);
		$working_from = implode(":",$working_from_ar);


		$working_to_ar = explode(":",$data["working_to"]);
		array_pop($working_to_ar);
		$working_to = implode(":",$working_to_ar);

		if($this->isAjax)
		{
			$this->layout = false;
			$this->view = false;
			$this->json = true;
			
			if(!empty($type))
			{
				$name = ($type=='pickup_location') ? 'pickup_time' : 'dropoff_time';

				/*$compare_var = ($type=='pickup_location') ? $working_from : $working_to;*/
				$compare_var = $working_from;
				
				$content .= "<select name='".$name."' id='".$name."' class='form-control time custfield'>";
				/*$content .= '<option>'.$display_name.'</option>';*/
				foreach ($time_array as $key => $value) 
				{
					if($value == $compare_var)
					{
						$selected = 'selected';
					}
					else{
						$selected = ''; 
					}

					$content .= "<option ".$selected." value='".$value."'>".$value."</option>";
				} 			
				$content .= "</select>";
				$this->data['time_data'] = $content;
				$this->data['working_from'] = $data['working_from'];
				$this->data['working_to'] = $data['working_to'];
			}	
		}
		else{
			return $time_array;
		}
	}

	public function subscribe_newsletter()
	{
		if($this->isAjax)
		{
			$this->view = false;
			$this->layout = false;
			$this->json = true;
			$this->data["status"] = "success";
			$this->data["msg"] = "";
			$email = $this->input->post("email");
			if($email != '' || $email != NULL)
			{
				$this->load->model("newsletter_model");	
				$exist_check = $this->newsletter_model->get_by("email",$email);
				if(!empty($exist_check))
				{
					$this->data["status"] = "error";
					$this->data["msg"] = lang("USER_ALREADY_SUBSCRIBED_TO_NEWSLETTER");
				}
				else
				{
					$insert_array = array('email'=>$email,'createdDate'=>date('Y-m-d H:i:s'));
					$insert_stauts = $this->newsletter_model->insert($insert_array);
					if($insert_stauts > 0)
					{
						$this->data["msg"] = $email." ".lang("SUBSCRIBED_TO_NEWSLETTER_SUCCESS");
					}else{
						$this->data["status"] = "error";
						$this->data["msg"] = validation_errors();
					}
				}
			}
			else{
				$this->data["status"] = "error";
				$this->data["msg"] = lang("EMAIL_REQUIRED");	
			}			
		}
		else{
			$this->session->set_flashdata('error',lang("Invalid Request."));
			redirect(base_url(),"refresh");
			exit;
		}
	}


	public function remove_coupon()
	{
		if($this->isAjax)
		{
			$this->view = false;
			$this->layout = false;
			$this->json = true;
		}
		$session_coupon_id = $this->session->userdata("coupon_id");
		if($session_coupon_id > 0)
		{
			$this->session->unset_userdata("coupon_id");
			
		}
		$this->data["status"] = "success";
		$this->data["msg"] = lang("COUPON_REMOVED_SUCCESSFULLY");
	}


	public function check_coupon_exist($car_id = 0)
	{
		$response = array("status"=>"error","msg"=>"error");

		if($this->isAjax)
		{
			$this->view = false;
			$this->layout = false;
			$this->json = true;
		}

		$this->load->model("coupons_model");

		$session_coupon_id = $this->session->userdata("coupon_id");
		$post_session_id = $this->input->post("coupon_code");
		$car_id = $this->input->post("car_id");

		if($session_coupon_id > 0)
		{
			$coupon_session_ar = $this->coupons_model->get($session_coupon_id);
			$coupon_code = $coupon_session_ar["code"];
		}
		else
		{
			$coupon_code = ($post_session_id != "") ? $post_session_id : '';
		}

		$pickup_location = ($this->session->userdata("pickup_location") > 0) ? $this->session->userdata("pickup_location") : 0;
		$dropoff_location = ($this->session->userdata("dropoff_location") > 0) ? $this->session->userdata("dropoff_location") : 0;
		$pickup_date = ($this->session->userdata("pickup_date") != '') ? $this->session->userdata("pickup_date") : '';
		$dropoff_date = ($this->session->userdata("dropoff_date") != "") ? $this->session->userdata("dropoff_date") : '';
		$pickup_time = ($this->session->userdata("pickup_time") != '') ? $this->session->userdata("pickup_time") : '';
		$dropoff_time = ($this->session->userdata("dropoff_time") != '') ? $this->session->userdata("dropoff_time") : '';

		$this->data["status"] = "success";
		$this->data["msg"] = "";
		$coupon_exist_ar = array();
		if($coupon_code != '')
		{
			$exist_where_ar[] = array("('".$pickup_date."' BETWEEN start_date AND end_date) AND code = '".$coupon_code."'",null,false);
			$coupon_exist_ar = $this->coupons_model->get_by($exist_where_ar);
		}

		if(!empty($coupon_exist_ar))
		{
			if(!empty($coupon_exist_ar["db_sel_cars"]))
			{
				$allowed_ids = array();
				foreach ($coupon_exist_ar["db_sel_cars"] as $key => $value) 
				{
					$allowed_ids[] = $value["carId"];
				}	
			}

			if(in_array($car_id, $allowed_ids))
			{
				if($coupon_exist_ar["used"] < $coupon_exist_ar["max_usage"])
				{
					$this->load->model("cars_model");
					$this->load->model("pricing_model");

					$type = ($this->input->post('type') != "") ? $this->input->post('type') : "";
					$offer_id = ($this->input->post('offer_id') != "") ? $this->input->post('offer_id') : "";
					$facilities = ($this->input->post('car_facilities') != "") ? $this->input->post('car_facilities') : "";
					$facility_post = array();
					if(!empty($facilities))
					{
						foreach ($facilities as $key => $value) 
						{
							if($value > 0)
							{
								$facility_post[] = $key;	
							}
						}
					}
					$insuranceGroupId = ($this->input->post('insuranceGroupId') > 0) ? $this->input->post('insuranceGroupId') : "";

					$this->cars_model->after_get_locations_allow = false;
					$car_data = $this->cars_model->get($car_id);	
					$this->cars_model->after_get_locations_allow = true;

					$this->pricing_model->car_category = $car_data["categoryId"];
					$this->pricing_model->pickup_date = $pickup_date;
					$this->pricing_model->pickup_time = $pickup_time;
					$this->pricing_model->dropoff_date = $dropoff_date;
					$this->pricing_model->dropoff_time = $dropoff_time;
					$this->pricing_model->car_id = $car_data["id"];
					$this->pricing_model->booking_selected_facilities = $facility_post;
					$this->pricing_model->insuranceGroupId = $insuranceGroupId;
					$this->pricing_model->pickup_location = $pickup_location;
					$this->pricing_model->dropoff_location = $dropoff_location;
					$price_ar = $this->pricing_model->get_car_price($car_data);

					if($price_ar["total"] >= $coupon_exist_ar["minimum_total"])
					{
						$response["status"] = "success";
						$response["msg"] = lang("COUPON_APPLIED_SUCCESSFULLY");
						$response["code"] = $coupon_exist_ar["code"];


						$this->session->set_userdata("coupon_id",$coupon_exist_ar["id"]);
						$this->data["msg"] = lang("COUPON_APPLIED_SUCCESSFULLY");
					}
					else
					{
						$this->session->unset_userdata("coupon_id");
						$this->data["status"] = "error";
						$this->data["msg"] = lang("COUPON_CODE_MINIMUM_AMOUNT")." ".$coupon_exist_ar["minimum_total"];	
					}
				}
				else{
					$this->session->unset_userdata("coupon_id");
					$this->data["status"] = "error";
					$this->data["msg"] = lang("COUPON_CODE_MAXIMUM_LIMIT_REACHED");	
				}
			}
			else
			{
				$this->session->unset_userdata("coupon_id");
				$this->data["status"] = "error";
				$this->data["msg"] = lang("INVALID_COUPON_CODE");
			}
		}
		else
		{
			$this->session->unset_userdata("coupon_id");
			$this->data["status"] = "error";
			$this->data["msg"] = lang("INVALID_COUPON_CODE");
		}
		return $response;
	}


	public function get_autosuggest_list()
	{

		if($this->isAjax)
		{
			$this->view = false;
			$this->layout = false;
			$this->json = true;

			$dropoff_location = $this->input->get("dropoff_location");
			$pickup_location = $this->input->get("pickup_location");
			$car_id = $this->input->get("car_id");
			$qry = $this->input->get("query");

			$this->load->model("locations_model");
			$where_ar = array();

			$where_ar[] = array("status = 'y'",null,false);
			if($car_id > 0)
			{
				/*$car_selected_pickup_location = $this->db->select('pickup_location')->get_where('tbl_cars', array('id' => $car_id))->row()->pickup_location;$car_sel_locations_q .= " AND l.id IN (".$car_selected_pickup_location.")";*/
			}

			if($qry != '')
			{
				$where_ar[] = array("((location_name  LIKE '%".$qry."%') OR (location_short_name LIKE '%".$qry."%'))",null,false);
			}

			$this->locations_model->after_get_allow = false;
			$locations = $this->locations_model->set_fields("id,location_name")->get_many_by($where_ar);
			$this->locations_model->after_get_allow = true;

			if(!empty($locations))
			{
				foreach ($locations as $row)
				{
					$temp = array(
						"label"=>$row["location_name"],
						"id"=>$row["id"]
						);
					$this->data["location_tags"][] = $temp;
				}
			}
		}
	}

}
