<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once("booking.php");
class Bookingdetail extends booking
{
	function __construct()
	{	
		$this->login_type	='';
		$this->layout		='default';
		$this->access      ='';
		parent::__construct();
		$this->_init();
	}

	private function _init()
	{
		$this->sections['section_header'] = 'sections/header';
		$this->sections['section_footer'] = 'sections/footer';
		$this->load->model("offers_model");
		$this->load->model("content_model");
		$this->load->model("locations_model");
		$this->load->model("countries_model");
	}

	public function index($id = null)
	{
		$this->output->set_title(lang(MY_BOOKING_HEAD_TITLE));

		$content_where = array('display_position'=>'my_booking','display_type'=>'page','status'=>'y');
		$content_data = $this->content_model->get_by($content_where);

		if($content_data["meta_keyword"] != '' && $content_data["meta_keyword"] != null)
		{
			$this->meta_keyword = $content_data["meta_keyword"];		
		}
		if($content_data["meta_description"] != '' && $content_data["meta_description"] != null)
		{
			$this->meta_description = $content_data["meta_description"];
		}

		$this->data["content_data"] = $content_data;

		if(!$this->input->post() && $id == null)
		{



		}

		if($this->input->post() || $id > 0)
		{
			$email = $this->input->post("email");
			$booking_no = $this->input->post("booking_no");
			if(($email != "" && $booking_no != "") || $id > 0)
			{
				$this->load->model("user_model");
				$this->load->model("bookings_model");
				$this->load->start_inline_scripting();
				echo "Appfd.initBookingDetail();";
				$this->load->end_inline_scripting(false,false);
				$user_info = $this->user_model->set_fields("id,username,email")->get_by("email",$email);
				if(!empty($user_info) || $id > 0)
				{	
					if($id > 0)
					{
						$where_ar = array("id"=>$id);
					}	
					else{
						$where_ar = array("user_id"=>$user_info["id"],"booking_no"=>$booking_no);
					}
					$this->bookings_model->after_get_user_info_allow = true;
					$booking_data = $this->bookings_model->get_by($where_ar);
					$start_date = $booking_data["pickup_date"]." ".$booking_data["pickup_time"];
					$end_date = $booking_data["dropoff_date"]." ".$booking_data["dropoff_time"];
					$booking_days =  date_difference($start_date,$end_date);
					if(!empty($booking_data))
					{
						$this->data["booking"] = $booking_data;
						$this->data["insuranceGroupId"] = ($booking_data["insurance"] > 0) ? $booking_data["insurance"] : 0;
						$this->data["booking_selected_facilities"] = (!empty($booking_data["booking_selected_facilities"])) ? $booking_data["booking_selected_facilities"] : '';
						
						$car_data = $booking_data["car_info"];						
						$this->data["car_data"] = $car_data;
						
						$this->data["first_name"] = $booking_data["user_info"]["firstname"];
						$this->data["last_name"] = $booking_data["user_info"]["lastname"];
						$this->data["driving_licence"] = $booking_data["user_info"]["drivinglicence_no"];
						$this->data["email"] = $booking_data["user_info"]["email"];
						$this->data["contact_number"] = $booking_data["user_info"]["contactNo"];
						$this->data["locations"] = $this->locations_model->set_fields("id,location_name")->get_many_by("status",'y');
						$this->data["country"] = $this->countries_model->set_fields("id,country_name")->get($booking_data["user_info"]["country"]);

						$this->data["booking_pricing"] = (array)json_decode($booking_data["pricingDetails"]);
						
						$facility_post = array();
						if(!empty($booking_data["booking_facilities_data"]))
						{
							$facilities_array = array();
							foreach ($booking_data["booking_facilities_data"] as $key => $value) 
							{
								if($value["facility_id"] > 0)
								{
									$facility_post[] = $value["facility_id"];	
								}
								$facilities_array[$value["facility_id"]] = $value;
							}
						}
						
						$facilities_where[] = array('car_facilities.id IN ('.implode(",",$facility_post).')',null,false);
						$get_facilities_data = $this->car_facilities_model->set_fields("car_facilities.facility_name,car_facilities.id")->get_many_by($facilities_where);
						foreach ($get_facilities_data as $key => $value) 
						{
							$temp_text = '';
							$fac_name = $value["facility_name"];
							if($facilities_array[$value["id"]]["multipleValue"] > 1)
							{
								$fac_name .= " X ".$facilities_array[$value["id"]]["multipleValue"]." ";
							}

							$this->data["facilities_price_render"][$fac_name] =  number_format($facilities_array[$value["id"]]["price"], 2);
						}


						$this->data["price_view_render"] = $this->load->view("bookingdetail/price_detail",$this->data,true);
						$this->get_insurance_items_data();
						self::insurance_groups_data($car_data,$booking_days,$this->data["data_insurance_group_items"],$this->data["insuranceGroupId"],$this->data["booking_pricing"]);
						$this->view="bookingdetail/bookingdetail.php";
					}
					else{
						$this->session->set_flashdata("error",lang("BOOKING_NO_INVALID"));
						redirect(base_url()."bookingdetail","refresh");
					}
				}	
				else
				{
					$this->session->set_flashdata("error",lang("BOOKING_NO_INVALID"));
					redirect(base_url()."bookingdetail","refresh");
				}
			}
			else
			{
			}
		}
	}

	public function insurance_groups_data($car_data,$booking_days,$insurance_group_items,$insuranceGroupId,$pricingDetails = array())
	{
		array_pop($insurance_group_items);
		$insurance_groups = $this->insurance_group_model->get_all();
		if(!empty($insurance_groups))
		{
			$data_insurance_group = array();
			$tempkey = 1;
			foreach ($insurance_groups as $key => $group) 
			{
				$where_ar = array('groupId'=>$group["id"],'categoryId'=>$car_data["categoryId"]);
				$var_ar = $this->category_insurance_price_model->set_fields("price,deposit,max_price")->get_by($where_ar);
				$temp1[0]["name"] = 'Deposit';
				$temp1[0]['text'] = display_decimal_price($var_ar["deposit"]);
				$temp1[0]['type'] = "text";
				$temp1[0]['check'] = false;
				if(!empty($insurance_group_items))
				{
					foreach ($insurance_group_items as $key => $value_n) 
					{
						$exist_check_where = array('groupId'=>$group["id"],'itemId'=>$value_n["id"]);
						$exist_check = $this->insurance_detail_model->get_by($exist_check_where);
						$response[$value_n["id"]] = (!empty($exist_check)) ? true  : false;
					}
				}
				$temp2 = $response;
				$k = $temp1+$temp2;

				$total_insurance_price = $var_ar["price"] * $booking_days;
				if($total_insurance_price > $var_ar["max_price"])
				{
					$total_insurance_price = $var_ar["max_price"];
				}
				
				if($group["id"] == $insuranceGroupId && $pricingDetails["insurance_price"] > 0 &&  $pricingDetails["insurance_price"] != $total_insurance_price)
				{
					$total_insurance_price = $pricingDetails["insurance_price"];
				}
				
				$temp_k['name'] = 'Price';
				$temp_k['text'] = display_decimal_price($total_insurance_price);
				$temp_k['type'] = "text";
				$temp_k['check'] = false;
				array_push($k,$temp_k);
				$group["items"] = $k;
				$data_insurance_group[] = $group;
			}
		}
		$this->data["data_insurance_group"] = $data_insurance_group;
		return true;
	}

}
