<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Update_price_tool extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->modal_name = "pricing_model";
		$this->load->model($this->modal_name);
		$this->page ='admin/update_price_tool/';
		$this->current_url = base_url()."admin/update_price_tool/";
		$this->table_id = "tblmng_pricing";
	}
	
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}

	public function index($type='',$id='')
	{
		if($this->input->post())
		{
			$categoryId = $this->input->post('categoryId');
			$seasonId = $this->input->post('seasonId');
			$amounttype = $this->input->post('amounttype');
			$type = $this->input->post('type');
			$pricevalue = $this->input->post('value');
			/*$amounttype = ($amounttype == "a") ? "amount" : "percentage";*/
			/*$type = ($type == "i") ? "increase" : "decrease";*/
			$new_price = 0;
			/*if($amounttype == "a")
			{
				$new_price += ($value > 0) ? $value : 0;
			}
			if($amounttype == "p")
			{
				$new_price += ($value > 0) ? $value / 100 : 0;
			}*/

			$where_ar[] = array("categoryId = '".$categoryId."'",null,false);
			$where_ar[] = array("seasonId = '".$seasonId."'",null,false);
			$where_ar[] = array("type = 'a'",null,false);

			$exist_check = $this->{$this->modal_name}->get_by($where_ar);

			if(empty($exist_check))
			{
				$this->session->set_flashdata('error',lang(ADVANCED_PRICE_NOT_EXIST));
				redirect($this->current_url);	
			}
			else{
				$this->load->model("day_price_model");
				$price_records = $this->day_price_model->get_many_by("pricingId",$exist_check["id"]);
				if(!empty($price_records))
				{
					$this->day_price_model->validate = array(
						array( 'field' => 'categoryId','label' => 'Category','rules' => 'trim|required'),
						array( 'field' => 'seasonId','label' => 'Season','rules' => 'trim|required'),
						array( 'field' => 'amounttype','label' => 'Amount Type','rules' => 'trim|required'),
						array( 'field' => 'type','label' => 'Type','rules' => 'trim|required'),
						array( 'field' => 'value','label' => 'Value','rules' => 'trim|required')
					);

					foreach ($price_records as $key => $value) {
						$old_price = $value["price"];

						if($amounttype == "a" && $type == "d")
						{
							$new_price = $old_price - $pricevalue;
						}
						else if($amounttype == "a" && $type == "i")
						{
							$new_price = $old_price + $pricevalue;
						}
						else if($amounttype == "p" && $type == "d"){
							$new_price = $old_price - ($old_price * ($pricevalue/100));
						}
						else if($amounttype == "p" && $type == "i"){
							$new_price = $old_price + ($old_price * ($pricevalue/100));
						}
						$update_array = array('price'=>$new_price);
						$update_status = $this->day_price_model->update($value["id"],$update_array);
					}	

					if($update_status)
					{
						$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
						redirect($this->current_url);	
					}
					else{
						$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));
						redirect($this->current_url);	
					}
				}
			}
		}


		if(!$this->input->post())
		{
			$this->load->model("categories_model");
			$this->load->model("season_model");
			$this->page_type = 'add';
			$text = "Update Advanced Pricing";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."update_price_tool";
			$this->data["categories"] = $this->categories_model->set_fields("id,category")->get_many_by('status','y');
			$this->data["seasons"] = $this->season_model->set_fields("id,season_name")->get_many_by('status','y');
			$this->view = $this->page."add";
		}
	}	
}
