<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_users extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->load->model("admin/users_model");
		$this->page ='admin/manage_users/';
		$this->current_url = base_url()."admin/manage_users/";
	}
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}
	public function index()
	{
		$this->grid_resorces();
		$this->output->set_title(lang("Manage Users"));
		$this->page_name = lang("Manage Users");
		$this->data['page_url']	=	'manage_users';
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->data['tbl_id']		=	'tblmng_users';
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_users();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$array = array('edit'=>$editurl,'delete'=>$deleteurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		
		$this->datatables->select('id,firstName,lastName,email,status',false)
		->edit_column('status', '$1', 'get_status(status,id,"manage_contents/change_user_status")')
		->add_column('operation',get_operation_btn('$1',$array),'id')	
		
		->from('users');
		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}

	public function add()
	{
		$data = array();
		if($this->input->post())
		{
			$this->load->helper('string');
			$data = array(
				'firstname' => $this->input->post('first_name'),
				'lastname' => $this->input->post('last_name'),
				'email' => $this->input->post('email'),
				'contactNo' => $this->input->post('contactno'),
				'aboutMe' => $this->input->post('about_me'),
				'address' => $this->input->post('address'),
				'created'	=>date("Y-m-d h:i:s"),
				'status'=>'y',
				'password' => random_string('alnum', 6),
				'ipAddress' => $this->input->ip_address()
				);
			$status = $this->users_model->insert($data);
			if($status)
			{
				$this->session->set_flashdata('message',lang(MSG_REC_ADD));
				redirect($this->current_url);				
			}else{
				$msg_t = (validation_errors()) ? validation_errors() : lang(MSG_FILL_ALL_FIELDS);
				$this->session->set_flashdata('error',$msg_t);
				redirect($this->current_url."add");	
			}
		}
		if(!$this->input->post())
		{
			$this->page_type = 'add';
			$text = "Add User";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."add";
			$this->view = $this->page."add_edit";
		}
	}


	public function edit($id=NULL)
	{
		if($id != NULL && $id > 0)
		{
			$data = array();
			if($this->input->post())
			{
				$email = $this->input->post('email');
				$data = array(
					'firstname' => $this->input->post('first_name'),
					'lastname' => $this->input->post('last_name'),
					'contactNo' => $this->input->post('contactno'),
					'aboutMe' => $this->input->post('about_me'),
					'address' => $this->input->post('address')					
					);

				$this->users_model->validate = array(
					'first_name'  => array(
						'field' => 'first_name',
						'label' => 'First Name',
						'rules' => 'trim|required|xss_clean',
						'error_msg' => array(
							'required'  => 'lang:USER_FIRST_NAME_REQUIRED'
							),
						),
					'last_name'  => array(
						'field' => 'last_name',
						'label' => 'Last Name',
						'rules' => 'trim|required|xss_clean',
						'error_msg' => array(
							'required'  => 'lang:USER_LAST_NAME_REQUIRED'
							),
						),
					'address'  => array(
						'field' => 'address',
						'label' => 'Address',
						'rules' => 'trim|required|xss_clean',
						'error_msg' => array(
							'required'  => 'lang:ADDRESS_REQUIRED'
							),
						),	
					'contactno'  => array(
						'field' => 'contactno',
						'label' => 'Contactno',
						'rules' => 'trim|required|xss_clean|numeric',
						'error_msg' => array(
							'required'  => 'lang:CONTACTNO_REQUIRED'
							),
						),
					);

				if($email != '')
				{
					$check_exist_where[] = array("email = '".$email."' AND id != '".$id."'",null,false);
					$user_array = $this->users_model->get_by($check_exist_where);

					if(!empty($user_array))
					{
						$this->session->set_flashdata('error',lang(MSG_VALID_EMAIL));
						redirect($this->current_url.'edit/'.$id,"refresh");
					}
					else
					{
						$data["email"] = $email;
						$update_status = $this->users_model->update($id,$data);
						if($update_status) 
						{
							$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
							redirect($this->current_url,"refresh");
						}else{
							$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));
							redirect($this->current_url.'edit/'.$id,"refresh");
						}
					}
				}
			}
			else if(!$this->input->post()){
				$this->data["user_data"] = $this->users_model->as_array()->get($id);
				if($this->data["user_data"])
				{
					$text = "Edit user - ".$this->data["user_data"]["email"];
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->data["form_url"] = $this->current_url.'edit/'.$id;	
					$this->data["action"] = "edit";
					$this->data["id"] = $id;
					$this->view = $this->page."add_edit";
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}




	public function change_status()
	{
		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$user_id = $this->input->post('user_id');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			if($user_id > 0){
				$this->users_data = $this->users_model->set_fields("id,status")->as_array()->get($user_id);
				if(!empty($this->users_data))
				{
					if($this->users_data['status'] == 'n'){
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$response = $this->users_model->update($user_id,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}
		}
	}



	public function delete($id){
		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->users_model->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = "tblmng_users";
			}
		}
	}

	public function check_email_exists($user_id = 0)
	{
		if($user_id > 0)
		{
			$this->view = false;
			$this->layout = false;

			$this->load->model("users_model");
			$email = $this->input->get("email");

			$check_exist_where[] = array("email = '".$email."' AND id != '".$user_id."'",null,false);
			$user_array = $this->users_model->get_by($check_exist_where);

			if(empty($user_array))
			{
				echo "true";
			}
			else
			{
				echo "false";	
			}
		}
	}
}
