<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_statistics extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->modal_name = "characteristics_groups_model";
		$this->load->model($this->modal_name);
		$this->page ='admin/manage_characteristics_groups/';
		$this->current_url = base_url()."admin/manage_characteristics_groups/";
		$this->dropoff_table_id = "tblmng_mng_statistics_dropoffs";
		$this->pickup_table_id = "tblmng_mng_statistics_pickup";


	}
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}

	public function today_drop_off()
	{
		$current_data 	= date('Y-m-d');
		$this->grid_resorces();
		$this->output->set_title(lang("Today Dropoff"));
		$this->page_name = lang("Today Dropoff");
		
		$this->data['tbl_id']		=	$this->dropoff_table_id;
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_today_drooffs();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		

		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');		
		$this->datatables->select('b.id,c.name,p.location_name as pickup_location_name,b.pickup_date,d.location_name as dropoff_location_name,concat(u.firstName," ",u.lastName) as traveller_name',false)
		->join('users as u','u.id = b.user_id')
		->join('cars as c','c.id = b.car_id')
		->join('locations as p','p.id = b.pickup_location')
		->join('locations as d','d.id = b.dropoff_location')					
		->from('bookings as b');
		$this->datatables->where('b.dropoff_date = ', $current_data);
		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}

	public function today_pick_ups()
	{
		$current_data 	= date('Y-m-d');
		$this->grid_resorces();
		$this->output->set_title(lang("Today Pickups"));
		$this->page_name = lang("Today Pickups");
		$this->data['tbl_id']		=	$this->pickup_table_id;
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_today_pickups();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		

		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');		
		$this->datatables->select('b.id,c.name,p.location_name as pickup_location_name,b.dropoff_date,d.location_name as dropoff_location_name,concat(u.firstName," ",u.lastName) as traveller_name',false)
		->join('users as u','u.id = b.user_id')
		->join('cars as c','c.id = b.car_id')
		->join('locations as p','p.id = b.pickup_location')
		->join('locations as d','d.id = b.dropoff_location')					
		->from('bookings as b');
		$this->datatables->where('b.pickup_date = ', $current_data);
		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}

	


	


	

	

	
}
